/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import oracle.ewt.access.AccessibleContextProxy;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeSimpleParent;

public class OiifmTreeItem
extends DTreeSimpleParent {
    protected Object m_ID;
    protected boolean m_enabled;
    private boolean m_bSimilarsSet;
    protected Image m_disabledIcon;
    private String m_sToolTip;
    private Color m_color;
    private boolean m_selectable;
    private Font m_font;
    private Vector m_vSimilars;
    private AccessibleContext m_accessibleContext;

    public OiifmTreeItem(String label, Image icon, Object id) {
        super(label, icon);
        this.m_ID = id;
        this.m_enabled = true;
        this.m_disabledIcon = null;
        this.m_bSimilarsSet = false;
        this.m_vSimilars = new Vector();
        this.m_selectable = false;
    }

    public Object getID() {
        return this.m_ID;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        this.getTree().repaint();
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setSimilars(Vector vSimilars) {
        this.m_vSimilars = vSimilars;
    }

    public Vector getSimilars() {
        return this.m_vSimilars;
    }

    public boolean isSimilarsSet() {
        return this.m_bSimilarsSet;
    }

    public void setSimilarsSet(boolean bSimilarsSet) {
        this.m_bSimilarsSet = bSimilarsSet;
    }

    public void setToolTipText(String sText) {
        this.m_sToolTip = new String(sText);
    }

    public String getToolTipText() {
        return this.m_sToolTip;
    }

    public void setForeground(Color newColor) {
        this.m_color = newColor;
        DTree theTree = this.getTree();
        if (theTree != null) {
            theTree.repaint();
        }
    }

    public Color getForeground() {
        return this.m_color;
    }

    public void setFont(Font newFont) {
        this.m_font = newFont;
        DTree theTree = this.getTree();
        if (theTree != null) {
            theTree.repaint();
        }
    }

    public Font getFont() {
        return this.m_font;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.m_accessibleContext == null) {
            this.m_accessibleContext = new AccessibleTreeItemProxy(super.getAccessibleContext());
        }
        return this.m_accessibleContext;
    }

    protected AccessibleContext accessAccessibleContext() {
        return this.m_accessibleContext;
    }

    public void setSelectable(boolean highlightSelection) {
        this.m_selectable = highlightSelection;
    }

    public void paint(Graphics g, boolean isSelected, boolean isFocused, int itemWidth, int itemHeight) {
        boolean selected = isSelected;
        if (!this.m_selectable) {
            selected = false;
        }
        Color old_color = g.getColor();
        if (!this.m_enabled) {
            g.setColor(Color.lightGray);
        } else if (this.m_color != null) {
            g.setColor(this.m_color);
        }
        Font old_font = g.getFont();
        if (this.m_font != null) {
            g.setFont(this.m_font);
        }
        super.paint(g, selected, isFocused, itemWidth, itemHeight);
        g.setColor(old_color);
        g.setFont(old_font);
    }

    public boolean equals(OiifmTreeItem item) {
        if (item != null) {
            return this.m_ID.equals(item.getID());
        }
        return false;
    }

    public void dispose() {
        this.m_ID = null;
        this.m_sToolTip = null;
        this.m_vSimilars = null;
        this.m_color = null;
        this.m_font = null;
    }

    private class AccessibleTreeItemProxy
    extends AccessibleContextProxy {
        AccessibleContext m_context;

        public AccessibleTreeItemProxy(AccessibleContext context) {
            this.m_context = context;
        }

        public String getAccessibleDescription() {
            return OiifmTreeItem.this.m_sToolTip;
        }

        protected AccessibleContext getAccessibleContext() {
            return this.m_context;
        }
    }
}

