/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.util.Vector;
import oracle.ewt.lwAWT.LWChoice;

public class OiifmToolTipChoice
extends LWChoice {
    private boolean m_showToolTip = false;
    private boolean m_caseSensitive = true;
    private Vector m_toolTips = new Vector();

    public OiifmToolTipChoice() {
    }

    public OiifmToolTipChoice(Vector items, Vector toolTips) {
        this();
        this.add(items, toolTips);
    }

    public boolean isShowToolTip() {
        return this.m_showToolTip;
    }

    public void setShowToolTip(boolean showToolTip) {
        this.m_showToolTip = showToolTip;
    }

    public boolean isCaseSensitive() {
        return this.m_caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.m_caseSensitive = caseSensitive;
    }

    public void add(Vector items, Vector toolTips) {
        int numItems = items.size();
        int numTips = toolTips.size();
        for (int i = 0; i < numItems; ++i) {
            if (i < numTips) {
                this.add((String)items.elementAt(i), (String)toolTips.elementAt(i));
                continue;
            }
            this.add((String)items.elementAt(i));
        }
    }

    public void add(String item, String toolTip) {
        if (item == null) {
            throw new NullPointerException("cannot add null item to LWChoice");
        }
        if (toolTip == null) {
            toolTip = item;
        }
        int newPosition = this.getItemCount();
        this.insert(item, toolTip, newPosition);
        if (newPosition == 0) {
            this.select(0);
        }
    }

    public void add(String item) {
        this.addItem(item);
    }

    public void addItem(String item) {
        this.add(item, item);
    }

    public void insert(String item, String toolTip, int index) {
        super.insert(item, index);
        this.m_toolTips.insertElementAt(toolTip, index);
    }

    public void insert(String item, int index) {
        this.insert(item, item, index);
    }

    public void remove(String item) {
        int index = this.indexOf(item, true);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        super.remove(index);
        this.m_toolTips.removeElementAt(index);
    }

    public void removeAll() {
        super.removeAll();
        this.m_toolTips.removeAllElements();
    }

    public void select(int pos) {
        super.select(pos);
        if (pos < this.m_toolTips.size() && this.m_showToolTip) {
            this.setToolTipValue((String)this.m_toolTips.elementAt(pos));
        }
    }

    public void select(String str) {
        int index = this.indexOf(str, true);
        if (index >= 0) {
            this.select(index);
        }
    }

    protected void selectToolTip(String str) {
        int index = this.indexOf(str, false);
        if (index >= 0) {
            this.select(index);
        }
    }

    public String getToolTip(int index) {
        return (String)this.m_toolTips.elementAt(index);
    }

    private int indexOf(String str, boolean disp) {
        int index = -1;
        int len = this.getItemCount();
        for (int i = 0; i < len; ++i) {
            String chkStr = disp ? this.getItem(i) : (String)this.m_toolTips.elementAt(i);
            boolean eq = this.isCaseSensitive() ? chkStr.equals(str) : chkStr.equalsIgnoreCase(str);
            if (!eq) continue;
            index = i;
            break;
        }
        return index;
    }
}

