/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Component;
import java.awt.Container;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.bali.share.nls.StringUtils;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.shuttle.MultiItemPicker;
import oracle.ewt.shuttle.Shuttle;
import oracle.ewt.shuttle.ToMultiItemPicker;
import oracle.ewt.tabBar.TabBar;
import oracle.ewt.tabBar.TabBarItem;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelPage;

public class OiifmMnemonicOps {
    public static void processMnemonic(Container container) {
        int nItems = container.getComponentCount();
        for (int i = 0; i < nItems; ++i) {
            OiifmMnemonicOps.processMnemonic(container.getComponent(i));
        }
    }

    private static void processMnemonic(Component component) {
        if (component instanceof JLabel) {
            OiifmMnemonicOps.processMnemonic((JLabel)component);
        } else if (component instanceof JButton || component instanceof JRadioButton) {
            OiifmMnemonicOps.processMnemonic((AbstractButton)component);
        } else if (component instanceof LWLabel) {
            OiifmMnemonicOps.processMnemonic((LWLabel)component);
        } else if (component instanceof LWCheckbox) {
            OiifmMnemonicOps.processMnemonic((LWCheckbox)component);
        } else if (component instanceof PushButton) {
            OiifmMnemonicOps.processMnemonic((PushButton)component);
        } else if (component instanceof Shuttle) {
            OiifmMnemonicOps.processMnemonic((Shuttle)component);
        } else if (component instanceof TabPanel) {
            OiifmMnemonicOps.processMnemonic((TabPanel)component);
        } else if (component instanceof TabBar) {
            OiifmMnemonicOps.processMnemonic((TabBar)component);
        } else if (component instanceof Container) {
            OiifmMnemonicOps.processMnemonic((Container)component);
        }
    }

    public static void processMnemonic(PushButton item) {
        String label = item.getLabel();
        if (label != null && OiifmMnemonicOps.processMnemonic((LWComponent)item, label)) {
            item.setLabel(StringUtils.stripMnemonic((String)label));
        }
    }

    public static void processMnemonic(LWCheckbox item) {
        String label = item.getLabel();
        if (label != null && OiifmMnemonicOps.processMnemonic((LWComponent)item, label)) {
            item.setLabel(StringUtils.stripMnemonic((String)label));
        }
    }

    public static void processMnemonic(LWLabel item) {
        String label = item.getText();
        if (label != null && OiifmMnemonicOps.processMnemonic((LWComponent)item, label)) {
            item.setText(StringUtils.stripMnemonic((String)label));
        }
    }

    public static void processMnemonic(TabBar item) {
        for (int i = 0; i < item.getItemCount(); ++i) {
            OiifmMnemonicOps.processMnemonic(item.getItem(i));
        }
    }

    public static void processMnemonic(TabBarItem item) {
        String label = item.getLabel();
        int index = StringUtils.getMnemonicIndex((String)label);
        if (item != null && index != -1) {
            item.setMnemonicIndex(index);
            item.setLabel(StringUtils.stripMnemonic((String)label));
        }
    }

    public static void processMnemonic(TabPanel item) {
        for (int i = 0; i < item.getPageCount(); ++i) {
            OiifmMnemonicOps.processMnemonic(item.getPage(i));
        }
    }

    public static void processMnemonic(TabPanelPage item) {
        String label = item.getLabel();
        int index = StringUtils.getMnemonicIndex((String)label);
        if (item != null && index != -1) {
            item.setMnemonicIndex(index);
            item.setLabel(StringUtils.stripMnemonic((String)label));
        }
        if (item.getContent() != null) {
            OiifmMnemonicOps.processMnemonic(item.getContent());
        }
    }

    public static void processMnemonic(Shuttle item) {
        MultiItemPicker fp = item.getFromPicker();
        LWComponent fromComponent = (LWComponent)fp.getComponent();
        LWLabel fromLabel = (LWLabel)item.getFromHeader();
        String fromLabelText = fromLabel.getText();
        if (fromLabelText != null) {
            OiifmMnemonicOps.processMnemonic(fromLabel);
            OiifmMnemonicOps.processMnemonic(fromComponent, fromLabelText);
        }
        ToMultiItemPicker tp = item.getToPicker();
        LWComponent toComponent = (LWComponent)tp.getComponent();
        LWLabel toLabel = (LWLabel)item.getToHeader();
        String toLabelText = toLabel.getText();
        if (toLabelText != null) {
            OiifmMnemonicOps.processMnemonic(toLabel);
            OiifmMnemonicOps.processMnemonic(toComponent, toLabelText);
        }
    }

    private static boolean processMnemonic(LWComponent item, String label) {
        int index;
        boolean changed = false;
        if (item != null && (index = StringUtils.getMnemonicIndex((String)label)) != -1) {
            item.setMnemonicIndex(index);
            changed = true;
        }
        return changed;
    }

    public static void processMnemonic(AbstractButton btn) {
        int iKeyCode = StringUtils.getMnemonicKeyCode((String)btn.getText());
        btn.setText(StringUtils.stripMnemonic((String)btn.getText()));
        btn.setMnemonic(iKeyCode);
    }

    public static void processMnemonic(JLabel lbl) {
        int iKeyCode = StringUtils.getMnemonicKeyCode((String)lbl.getText());
        lbl.setText(StringUtils.stripMnemonic((String)lbl.getText()));
        lbl.setDisplayedMnemonic(iKeyCode);
    }
}

