/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.ewt.graphics.ImageUtils;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class OiifmImage {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 128;
    private ResourceBundle m_bundle;
    private Container m_imgCont;
    private String m_package = "oracle.sysman.oii.oiir";
    private Locale m_locale = Locale.getDefault();
    private String m_facility;

    public OiifmImage(Container imgCont, String facility) {
        this(imgCont, Locale.getDefault(), facility);
    }

    public OiifmImage(Container imgCont, Locale locale, String facility) {
        this.m_imgCont = imgCont;
        if (locale != null) {
            this.m_locale = locale;
        }
        this.m_facility = facility;
    }

    public synchronized Image getImage(String key) {
        return this.getImage(key, false);
    }

    public synchronized Image getImage(String key, boolean bDefalut) {
        String imgStr = null;
        try {
            this.loadBundle(false);
            imgStr = this.m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
        return this.getImageFromString(imgStr, bDefalut);
    }

    private Image getImageFromString(String imgStr, boolean bDefault) {
        URL sLoc = this.getClass().getResource(imgStr);
        Image img = Toolkit.getDefaultToolkit().getImage(sLoc);
        if (img != null) {
            ImageUtils.loadImage((Image)img);
        }
        return img;
    }

    public synchronized String getPackage() {
        return this.m_package;
    }

    public synchronized void setPackage(String packageName) throws MissingResourceException {
        this.m_package = packageName;
        this.loadBundle(true);
    }

    private void loadBundle(boolean forceReload) {
        if (this.m_bundle == null || forceReload) {
            String resourceString = this.m_package + "." + this.m_facility + "Img";
            this.m_bundle = ResourceBundle.getBundle(resourceString, this.m_locale);
        }
    }

    public static Image getImageFromAbsolutePath(String imageName, boolean isAbsolutePath) {
        String imageLoc = imageName;
        if (!isAbsolutePath) {
            String propValue = System.getProperty("oracle.installer.oui_loc");
            imageLoc = OiixFunctionOps.concatPath("file:///", propValue);
            imageLoc = OiixFunctionOps.concatPath(imageLoc, "instImages");
            imageLoc = OiixFunctionOps.concatPath(imageLoc, imageName);
        }
        URL url = null;
        try {
            url = new URL(imageLoc);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return Toolkit.getDefaultToolkit().getImage(url);
    }
}

