/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.sysman.oii.oiif.oiifm.OiifmAbbrevChoice;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;
import oracle.sysman.oii.oiif.oiifm.OiifmDiskSpaceInterface;
import oracle.sysman.oii.oiif.oiifm.OiifmImagePanel;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifmDiskSpacePanel
extends LWContainer
implements ItemListener {
    private final int HGAP = 2;
    private final int VGAP = 0;
    private static final int DRIVE_NAME = 0;
    private static final int DRIVE_SPACE = 1;
    private GridBagLayout m_gridbag;
    private GridBagConstraints m_constraints;
    private boolean m_prevState;
    private Font font;
    private Font font_bold;
    private LWLabel m_reqDSLabel;
    private LWLabel m_availDSLabel;
    private LWLabel m_reqTSLabel;
    private LWLabel m_reqDSAmt;
    private LWLabel m_availDSAmt;
    private LWLabel m_reqTSAmt;
    private OiifmAbbrevChoice m_driveChoice;
    private LWCheckbox m_showAllCheck;
    private OiifmImagePanel m_stop;
    private OiifmImagePanel m_arrowReq;
    private Vector m_drives;
    private Vector[] m_targDrives;
    private Vector m_allDrives;
    private OiipgFileSystem m_OiipgFS;
    private OiisCompInstallation m_compInstall = null;
    private OiiodDepEngine m_depEngine;
    private boolean m_notEnoughDiskSpace = false;
    private Vector m_driveErrorInfo = new Vector();
    private Vector m_driveFreeSpace = null;
    OiifmDiskSpaceInterface m_spaceProvider;
    private Vector m_targetDrives;
    private int m_reqSpaceType = 1;
    private static final int CHANGE_WITH_DRIVE = 1;
    private static final int FIXED = 2;

    public OiifmDiskSpacePanel(OiiodDepEngine dEngine, OiifmDiskSpaceInterface dsIntf) {
        String curDriveCStr;
        this.m_depEngine = dEngine;
        this.m_OiipgFS = new OiipgFileSystem();
        this.font = new Font(OiixResourceBundle.getFont(), 0, 11);
        this.font_bold = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(1), 11);
        this.m_gridbag = new GridBagLayout();
        this.m_constraints = new GridBagConstraints();
        this.m_constraints.insets = new Insets(0, 2, 0, 2);
        this.m_constraints.weighty = 1.0;
        this.setLayout(this.m_gridbag);
        LWContainer available = this.createAvailList();
        this.m_constraints.gridx = 0;
        this.m_constraints.gridy = 0;
        this.m_constraints.weightx = 0.0;
        this.m_constraints.anchor = 16;
        this.m_gridbag.setConstraints((Component)available, this.m_constraints);
        this.add((Component)available);
        if (this.m_drives.size() > 1) {
            String curDriveXStr = this.m_driveChoice.getSelectedItemExpandedStr();
            curDriveCStr = this.m_driveChoice.getSelectedItemDisplayStr();
        } else {
            String curDriveXStr = (String)this.m_allDrives.elementAt(0);
            curDriveCStr = OiifmAbbrevChoice.getDisplayString(curDriveXStr, 10);
        }
        long availDS = 0L;
        String aStr = OiixPathOps.getDiskSpaceString(availDS, 2);
        this.m_availDSAmt = new LWLabel(aStr);
        this.m_availDSAmt.setFont(this.font);
        this.m_constraints.gridx = 1;
        this.m_constraints.gridy = 0;
        this.m_constraints.weightx = 1.0;
        this.m_constraints.anchor = 16;
        this.m_gridbag.setConstraints((Component)this.m_availDSAmt, this.m_constraints);
        this.add((Component)this.m_availDSAmt);
        String str = OiixResourceBundle.getString("S_REQ_DS_STATIC_LABEL");
        Object[] strarr = new String[]{curDriveCStr};
        str = MessageFormat.format(str, strarr);
        this.m_reqDSLabel = new LWLabel(str);
        this.m_reqDSLabel.setFont(this.font);
        this.m_constraints.gridx = 2;
        this.m_constraints.gridy = 0;
        this.m_constraints.weightx = 0.0;
        this.m_constraints.anchor = 16;
        this.m_gridbag.setConstraints((Component)this.m_reqDSLabel, this.m_constraints);
        this.add((Component)this.m_reqDSLabel);
        long reqDS = 0L;
        String rStr = OiixPathOps.getDiskSpaceString(reqDS, 1);
        this.m_reqDSAmt = new LWLabel(rStr);
        this.m_reqDSAmt.setFont(this.font);
        this.m_constraints.gridx = 3;
        this.m_constraints.gridy = 0;
        this.m_constraints.weightx = 0.0;
        this.m_constraints.anchor = 14;
        this.m_constraints.gridwidth = -1;
        this.m_gridbag.setConstraints((Component)this.m_reqDSAmt, this.m_constraints);
        this.add((Component)this.m_reqDSAmt);
        this.m_arrowReq = new OiifmImagePanel("5001");
        this.m_arrowReq.setVisible(false);
        this.m_constraints.gridx = 4;
        this.m_constraints.gridy = 0;
        this.m_constraints.anchor = 16;
        this.m_constraints.gridwidth = 0;
        this.m_gridbag.setConstraints((Component)((Object)this.m_arrowReq), this.m_constraints);
        this.add((Component)((Object)this.m_arrowReq));
        str = OiixResourceBundle.getString("S_SHOW_ALL_DRIVES");
        this.m_showAllCheck = new LWCheckbox(str);
        this.m_showAllCheck.setFont(this.font);
        this.m_showAllCheck.addItemListener((ItemListener)this);
        this.m_constraints.gridx = 0;
        this.m_constraints.gridy = 1;
        this.m_constraints.weightx = 1.0;
        this.m_constraints.anchor = 18;
        this.m_constraints.gridwidth = 2;
        this.m_gridbag.setConstraints((Component)this.m_showAllCheck, this.m_constraints);
        this.add((Component)this.m_showAllCheck);
        str = OiixResourceBundle.getString("S_TOTAL_REQ_LABEL");
        this.m_reqTSLabel = new LWLabel(str);
        this.m_reqTSLabel.setFont(this.font);
        this.m_constraints.gridx = 2;
        this.m_constraints.gridy = 1;
        this.m_constraints.weightx = 0.0;
        this.m_constraints.anchor = 18;
        this.m_constraints.gridwidth = 1;
        this.m_gridbag.setConstraints((Component)this.m_reqTSLabel, this.m_constraints);
        this.add((Component)this.m_reqTSLabel);
        long tDS = 0L;
        String tStr = OiixPathOps.getDiskSpaceString(tDS, 1);
        this.m_reqTSAmt = new LWLabel();
        this.m_reqTSAmt.setFont(this.font);
        this.m_constraints.gridx = 3;
        this.m_constraints.gridy = 1;
        this.m_constraints.weightx = 0.0;
        this.m_constraints.anchor = 12;
        this.m_constraints.gridwidth = -1;
        this.m_gridbag.setConstraints((Component)this.m_reqTSAmt, this.m_constraints);
        this.add((Component)this.m_reqTSAmt);
        this.m_stop = new OiifmImagePanel("5000");
        this.m_stop.setVisible(false);
        this.m_constraints.anchor = 18;
        this.m_constraints.gridx = 4;
        this.m_constraints.gridy = 1;
        this.m_constraints.anchor = 16;
        this.m_constraints.gridwidth = 0;
        this.m_gridbag.setConstraints((Component)((Object)this.m_stop), this.m_constraints);
        this.add((Component)((Object)this.m_stop));
        this.setSpaceProvider(dsIntf);
        this.initVolumeSpaceData();
        this.refreshPanel();
    }

    public void setPanelType(int type) {
        this.m_reqSpaceType = type;
    }

    public int getPanelType() {
        return this.m_reqSpaceType;
    }

    private void setSpaceProvider(OiifmDiskSpaceInterface provider) {
        this.m_spaceProvider = provider;
        this.m_targetDrives = this.m_spaceProvider.getDrivesToInstallInto();
        if (this.m_showAllCheck != null && this.m_driveChoice != null) {
            if (!this.m_showAllCheck.getState()) {
                this.m_drives = this.m_targetDrives;
            }
            this.m_driveChoice.add(this.m_targetDrives);
        }
    }

    private void getSpaceForDrivesInError() {
        int index;
        String curDrive = this.m_driveChoice.getSelectedItemExpandedStr();
        if (this.m_driveErrorInfo.indexOf(curDrive) != -1 && (index = this.m_allDrives.indexOf(curDrive)) != -1) {
            this.m_driveFreeSpace.setElementAt(new Long(this.m_OiipgFS.getVolumeFreeSpace(curDrive)), index);
        }
    }

    private void initVolumeSpaceData() {
        int numVols = this.m_allDrives.size();
        this.m_driveFreeSpace = new Vector(numVols, 4);
        this.m_driveFreeSpace.setSize(numVols);
    }

    public void setShowAllDrives(boolean showall) {
        if (this.m_showAllCheck != null && this.m_driveChoice != null) {
            this.m_showAllCheck.setState(showall);
        }
        this.onCheckStateChanged();
    }

    private LWContainer createAvailList() {
        LWContainer panel = new LWContainer();
        panel.setLayout((LayoutManager)new BorderLayout());
        this.initDriveList();
        this.m_availDSLabel = new LWLabel();
        int size = this.m_drives.size();
        this.m_driveChoice = new OiifmAbbrevChoice(this.m_drives);
        this.m_driveChoice.setShowToolTip(true);
        this.m_driveChoice.setFont(this.font);
        this.m_driveChoice.addItemListener(this);
        if (this.m_driveChoice.getItemCount() > 1) {
            this.m_driveChoice.select(0);
        }
        panel.add((Component)((Object)this.m_driveChoice), (Object)"East");
        String str = OiixResourceBundle.getString("S_AVAIL_DS_LABEL");
        this.m_availDSLabel.setText(str);
        this.m_availDSLabel.setFont(this.font);
        panel.add((Component)this.m_availDSLabel);
        return panel;
    }

    public void changeDrive(String driveName) {
        if (driveName != null) {
            this.displayNewDrives();
            this.m_driveChoice.select(driveName);
            this.refreshPanel();
        }
    }

    private void displayNewDrives() {
        this.m_targetDrives = this.m_spaceProvider.getDrivesToInstallInto();
        if (this.m_showAllCheck != null && this.m_driveChoice != null && !this.m_showAllCheck.getState()) {
            this.m_drives = this.m_targetDrives;
        }
        if (this.m_driveChoice != null) {
            String expDriveName = this.m_driveChoice.getSelectedItemExpandedStr();
            String displayDriveName = this.m_driveChoice.getSelectedItemDisplayStr();
            this.m_driveChoice.removeAll();
            this.m_driveChoice.add(this.m_drives);
            if (displayDriveName != null) {
                this.m_driveChoice.select(expDriveName);
            }
        }
    }

    public void refreshPanel() {
        String expDriveName = this.m_driveChoice.getSelectedItemExpandedStr();
        Object[] strarr = new String[]{this.m_driveChoice.getSelectedItemDisplayStr()};
        if (this.m_notEnoughDiskSpace) {
            this.getSpaceForDrivesInError();
        }
        long availDS = this.getAvailDiskSpace(expDriveName);
        String aStr = OiixPathOps.getDiskSpaceString(availDS, 2);
        this.m_availDSAmt.setText(aStr);
        String str = OiixResourceBundle.getString("S_REQ_DS_STATIC_LABEL");
        str = MessageFormat.format(str, strarr);
        this.m_reqDSLabel.setText(str);
        this.m_reqDSLabel.setToolTipValue(expDriveName);
        long reqDS = this.getReqDiskSpace(expDriveName);
        String rStr = OiixPathOps.getDiskSpaceString(reqDS, 1);
        this.m_reqDSAmt.setText(rStr);
        if (this.m_reqTSAmt != null) {
            long reqTS = this.getTotalReqDiskSpace();
            String tStr = OiixPathOps.getDiskSpaceString(reqTS, 1);
            this.m_reqTSAmt.setText(tStr);
        }
        this.validateDiskSpace();
        if (this.m_driveChoice == null) {
            this.m_availDSLabel.setToolTipValue(expDriveName);
        }
        this.validate();
    }

    private void validateDiskSpace() {
        if (this.m_driveErrorInfo.size() > 0) {
            this.m_driveErrorInfo.removeAllElements();
        }
        this.m_driveErrorInfo = new Vector();
        boolean showWarning = false;
        int itemCount = this.m_drives.size();
        for (int i = 0; i < itemCount; ++i) {
            String curDrive = (String)this.m_drives.elementAt(i);
            long reqDS = this.getReqDiskSpace(curDrive);
            long availDS = this.getAvailDiskSpace(curDrive);
            boolean onCurDrive = false;
            if (itemCount == 1) {
                onCurDrive = true;
            } else if (this.m_driveChoice.getSelectedIndex() == i) {
                onCurDrive = true;
            }
            if (reqDS > availDS && availDS >= 0L) {
                this.m_driveErrorInfo.addElement(curDrive);
                showWarning = true;
                if (!onCurDrive) continue;
                this.m_arrowReq.setVisible(true);
                this.m_reqDSAmt.setForeground(Color.red);
                continue;
            }
            if (!onCurDrive) continue;
            this.m_arrowReq.setVisible(false);
            this.m_reqDSAmt.setForeground(Color.black);
        }
        if (this.m_allDrives.size() >= 1) {
            if (showWarning) {
                this.m_notEnoughDiskSpace = true;
                this.m_reqTSAmt.setForeground(Color.red);
            } else {
                this.m_notEnoughDiskSpace = false;
                this.m_reqTSAmt.setForeground(Color.black);
            }
            this.m_stop.setVisible(showWarning);
        }
    }

    private void initDriveList() {
        this.m_allDrives = this.m_OiipgFS.getAllFixedOrRemoteVolumeNames();
        this.m_drives = new Vector();
        this.m_prevState = false;
    }

    private Vector[] getTargetDrives() {
        return this.m_depEngine.getRequiredSpace(this.m_compInstall);
    }

    public void addTargetDrive(String driveName, long reqSpace) {
        this.m_targDrives[0].addElement(driveName);
        this.m_targDrives[1].addElement(new Long(reqSpace));
        if (this.m_targDrives[0] == this.m_drives) {
            this.m_driveChoice.add(driveName);
        }
    }

    private long getAvailDiskSpace(String driveName) {
        if (this.m_driveFreeSpace == null) {
            return this.m_OiipgFS.getVolumeFreeSpace(driveName);
        }
        int index = -1;
        int size = this.m_allDrives.size();
        for (int i = 0; i < size; ++i) {
            String vol = (String)this.m_allDrives.elementAt(i);
            if (OiipgFileSystem.ignoreCaseInPath()) {
                vol = vol.toUpperCase();
                driveName = driveName.toUpperCase();
            }
            if (!vol.equals(driveName)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            this.m_allDrives.addElement(driveName);
            Long l = new Long(this.m_OiipgFS.getVolumeFreeSpace(driveName));
            this.m_driveFreeSpace.addElement(l);
            return l;
        }
        Long space = (Long)this.m_driveFreeSpace.elementAt(index);
        if (space == null) {
            space = new Long(this.m_OiipgFS.getVolumeFreeSpace(driveName));
            this.m_driveFreeSpace.setElementAt(space, index);
        }
        return space;
    }

    private long getReqDiskSpace(String driveName) {
        return this.m_spaceProvider.getRequiredDiskSpaceOnDrive(driveName);
    }

    private long getTotalReqDiskSpace() {
        return this.m_spaceProvider.getTotalRequiredDiskSpace();
    }

    private void onCheckStateChanged() {
        OiifmCursorUtil.setCursor(3, (Component)((Object)this));
        boolean newState = this.m_showAllCheck.getState();
        this.m_drives = newState ? this.m_allDrives : this.m_targetDrives;
        if (newState != this.m_prevState) {
            this.displayNewDrives();
            this.refreshPanel();
        }
        this.m_prevState = newState;
        OiifmCursorUtil.setCursor(0, (Component)((Object)this));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_driveChoice) {
            this.refreshPanel();
        } else if (e.getSource() == this.m_showAllCheck) {
            this.onCheckStateChanged();
        }
    }

    public void dispose() {
        this.m_compInstall = null;
        this.m_spaceProvider = null;
        this.m_depEngine = null;
        this.m_OiipgFS = null;
    }
}

