/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import oracle.ewt.access.AccessibleContextProxy;
import oracle.sysman.oii.oiif.oiifm.OiifmCheckListener;
import oracle.sysman.oii.oiif.oiifm.OiifmTreeItem;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifmCheckTreeItem
extends OiifmTreeItem {
    public static final int NONE = 0;
    public static final int OK = 1;
    public static final int ERROR = 2;
    public static final int DISABLED = 3;
    private int m_state;
    private Image[] m_icons;
    private int m_onState;
    private OiifmCheckListener m_listener;
    private AccessibleContext m_accessibleContext;

    public OiifmCheckTreeItem(String label, Image[] icons, Object id, int state) {
        super(label, icons[state], id);
        this.m_state = state;
        this.m_icons = icons;
        this.m_listener = null;
    }

    public void setCheckListener(OiifmCheckListener listener) {
        this.m_listener = listener;
    }

    public void setState(int state) {
        this.m_state = state;
        this.setIcon(this.m_icons[state]);
        this.getTree().repaint();
    }

    public int getState() {
        return this.m_state;
    }

    public void setOnState(int state) {
        this.m_onState = state;
    }

    public void toggleState() {
        if (this.m_state == 0) {
            this.setState(this.m_onState);
        } else {
            this.setState(0);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.m_accessibleContext == null) {
            this.m_accessibleContext = new AccessibleCheckTreeItemProxy(super.getAccessibleContext());
        }
        return this.m_accessibleContext;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_listener = null;
        this.m_icons = null;
    }

    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.processSelection();
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400 && evt.getKeyChar() == ' ') {
            this.processSelection();
        }
        super.processKeyEvent(evt);
    }

    protected void processSelection() {
        if (this.m_state == 3) {
            return;
        }
        if (this.isEnabled()) {
            boolean isOK = true;
            if (this.m_listener != null) {
                isOK = this.m_state == 0 ? this.m_listener.onCheckStateChanging(this, this.m_onState) : this.m_listener.onCheckStateChanging(this, 0);
            }
            if (isOK) {
                this.toggleState();
            }
        }
    }

    private class AccessibleCheckTreeItemProxy
    extends AccessibleContextProxy {
        private AccessibleContext m_context;

        public AccessibleCheckTreeItemProxy(AccessibleContext context) {
            this.m_context = context;
        }

        public String getAccessibleName() {
            String name = super.getAccessibleName();
            String sCheckStatus = null;
            switch (OiifmCheckTreeItem.this.m_state) {
                case 1: {
                    sCheckStatus = OiixResourceBundle.getString("S_ACCESS_BUTTON_CHECKED");
                    break;
                }
                case 0: {
                    sCheckStatus = OiixResourceBundle.getString("S_ACCESS_BUTTON_UNCHECKED");
                }
            }
            name = name + " " + sCheckStatus;
            return name;
        }

        protected AccessibleContext getAccessibleContext() {
            return this.m_context;
        }
    }
}

