/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifm;

import oracle.bali.share.nls.StringUtils;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifmAlert {
    public static final int WARNING = 10;
    public static final int ERROR = 20;
    public static final int TYPE_CAUTION = 30;
    public static final int TYPE_NOTE = 40;
    public static final int TYPE_STOP = 50;
    public static final int TYPE_MISC = 60;
    public static final int BUTTON_YES = 1;
    public static final int BUTTON_NO = 2;
    public static final int BUTTON_CANCEL = 4;
    public static final int BUTTON_HELP = 8;
    public static final int BUTTON_USER = 0;
    public static final String RESIDCONSTANT_MESSAGE_SEPARATOR = ":";
    private static OiicSessionInterfaceManager m_oInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();

    public static String formatAlertMessageForLog(int alertType, String sMsg) {
        String logPrefix = OiixResourceBundle.getString("S_LOG_ALERT_ERROR");
        if (alertType == 10) {
            logPrefix = OiixResourceBundle.getString("S_LOG_ALERT_WARNING");
        }
        String sFinalText = logPrefix + sMsg;
        return sFinalText;
    }

    private static String formatAlertResult(int result) {
        String resultStr = OiixResourceBundle.getString("S_LOG_USER_SEL");
        switch (result) {
            case 4: {
                resultStr = resultStr + OiixResourceBundle.getString("S_CANCEL_BUTTON");
                break;
            }
            case 2: {
                resultStr = resultStr + OiixResourceBundle.getString("S_NO_BUTTON");
                break;
            }
            case 1: {
                resultStr = resultStr + OiixResourceBundle.getString("S_YES_BUTTON");
                resultStr = resultStr + "/" + OiixResourceBundle.getString("S_OK_BUTTON");
                break;
            }
            case 8: {
                resultStr = resultStr + OiixResourceBundle.getString("S_HELP_BUTTON");
                break;
            }
            case 0: {
                resultStr = resultStr + OiixResourceBundle.getString("S_LOG_CUSTOM_BUTTON");
                break;
            }
            default: {
                resultStr = resultStr + OiixResourceBundle.getString("S_LOG_UNKNOWN");
            }
        }
        resultStr = StringUtils.stripMnemonic((String)resultStr);
        return resultStr;
    }

    public static int displayAlert(String title, String msg, int iconType, int buttonType, int defaultButton) {
        return OiifmAlert.displayAlert(title, msg, iconType, buttonType, defaultButton, 20);
    }

    public static int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity) {
        return OiifmAlert.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity, false);
    }

    public static int displayAlert(String title, String msg, String logMsg, int alertType, int userChoices, int defaultChoice, int severity) {
        return OiifmAlert.displayAlert(title, msg, logMsg, alertType, userChoices, defaultChoice, severity, false);
    }

    public static int displayAlert(String title, String msg, int alertType, int userChoices, int defaultChoice, int severity, boolean bSelectable) {
        return OiifmAlert.displayAlert(title, msg, null, alertType, userChoices, defaultChoice, severity, bSelectable);
    }

    public static int displayAlert(String title, String msg, String logMsg, int alertType, int userChoices, int defaultChoice, int severity, boolean bSelectable) {
        if (msg == null) {
            new Throwable().printStackTrace();
        }
        if (logMsg == null) {
            logMsg = msg;
        }
        if (severity == 10) {
            OiiolTextLogger.appendText(logMsg, OiiolTextLogger.LOG_WARNING);
        } else {
            OiiolTextLogger.appendText(logMsg, OiiolTextLogger.LOG_SEVERE);
        }
        int result = m_oInterfaceManager.displayAlert(title, msg, alertType, userChoices, defaultChoice, severity, bSelectable);
        String resultStr = OiifmAlert.formatAlertResult(result);
        OiiolTextLogger.appendText(resultStr + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
        return result;
    }

    public static int displayError(String msg) {
        return OiifmAlert.displayError(msg, OiixResourceBundle.getString("S_ERROR"));
    }

    public static int displayError(String msg, String title) {
        return OiifmAlert.displayAlert(title, msg, 50, 1, 1, 20);
    }

    public static int displayError(String msg, String title, String resIDNumber) {
        msg = resIDNumber + RESIDCONSTANT_MESSAGE_SEPARATOR + msg;
        return OiifmAlert.displayAlert(title, msg, 50, 1, 1, 20);
    }
}

