/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifj.OiifjProgressPanel;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressUIListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifjRemoveDlg
extends JDialog
implements ActionListener,
KeyListener,
OiifrProgressActionListener,
WindowListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    public static final int CANCEL = 1;
    private static final int INSETS = 5;
    private static final int WIDTH = 350;
    private static final int HEIGHT = 200;
    private OiifjProgressPanel m_progress;
    private JButton m_cancel;
    private OiifrProgressUIListener m_listener;
    private Dimension m_prefSize;

    public OiifjRemoveDlg(Frame f) {
        super(f, OiixResourceBundle.getString("S_REMOVE"), true);
        this.getContentPane().setBackground(new Color(204, 204, 204));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.m_listener = null;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel contents = new JPanel();
        contents.setLayout(new BorderLayout(5, 5));
        this.m_progress = new OiifjProgressPanel(1);
        contents.add((Component)this.m_progress, "Center");
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BorderLayout(5, 5));
        this.m_cancel = new JButton(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
        this.m_cancel.addActionListener(this);
        this.m_cancel.addKeyListener(this);
        this.m_cancel.setVisible(true);
        this.m_cancel.setEnabled(true);
        cPanel.add((Component)this.m_cancel, "West");
        contents.add((Component)cPanel, "South");
        mainPanel.add((Component)contents, "Center");
        this.m_prefSize = new Dimension(350, 200);
        OiifmMnemonicOps.processMnemonic(mainPanel);
        this.addWindowListener(this);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_cancel) {
            this.onCancel();
        }
    }

    private void onCancel() {
        if (this.m_listener != null) {
            this.m_listener.onCancel();
        }
        int result = OiifmAlert.displayAlert(OiixResourceBundle.getString("S_CONFIRMATION"), OiixResourceBundle.getString("S_CONF_REMOVE_CANCEL_PROMPT"), 30, 3, 4, 10);
        switch (result) {
            case 1: {
                if (this.m_listener != null) {
                    this.m_listener.onCancelConfirm(true);
                }
                this.m_progress.onDoneProgress();
                this.setVisible(false);
                break;
            }
            case 2: {
                if (this.m_listener == null) break;
                this.m_listener.onResume();
            }
        }
    }

    @Override
    public void onDoneProgress() {
        this.m_progress.onDoneProgress();
        this.setVisible(false);
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)WindowUtils.parentFrame((Component)this));
        this.m_progress.startProgressPainter();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        this.m_cancel.requestFocus();
        return 0;
    }

    @Override
    public boolean isNewProgressUsed() {
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    public void addProgressUIListener(OiifrProgressUIListener plistener) {
        this.m_listener = plistener;
    }

    public OiifrProgressActionListener getProgressActionListener() {
        return this;
    }

    @Override
    public void onCurrentComponent(String Comp) {
        this.m_progress.onCurrentComponent(Comp);
    }

    @Override
    public void addPercentage(int percent) {
        this.m_progress.addPercentage(percent);
    }

    @Override
    public void addBytes(int bytes) {
        this.m_progress.addBytes(bytes);
    }

    @Override
    public void onStartDeinstall() {
        this.m_progress.onStartDeinstall();
    }

    @Override
    public void onDoneDeinstall() {
        this.m_progress.onDoneDeinstall();
    }

    @Override
    public void onStartPhase(int phase) {
        this.m_progress.onStartPhase(phase);
    }

    @Override
    public void onDonePhase(int phase) {
        this.m_progress.onDonePhase(phase);
    }

    @Override
    public void onSuspend() {
        this.m_progress.onSuspend();
    }

    @Override
    public void onResume() {
        this.m_progress.onResume();
    }

    @Override
    public void setStatus(String status) {
        this.m_progress.setStatus(status);
    }

    @Override
    public void setTotalBytes(long bytes) {
        this.m_progress.setTotalBytes(bytes);
    }

    @Override
    public void removeBytes(int bytes) {
        this.m_progress.removeBytes(bytes);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 10: {
                if (event.getSource() != this.m_cancel) break;
                event.consume();
                this.onCancel();
                break;
            }
            case 27: {
                event.consume();
                this.onCancel();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.onCancel();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Testing");
        OiifjRemoveDlg dlg = new OiifjRemoveDlg(f);
        dlg.setDefaultCloseOperation(3);
        f.setDefaultCloseOperation(3);
        dlg.doModal();
    }
}

