/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifj.OiifjKeyActionConverter;
import oracle.sysman.oii.oiif.oiifj.OiifjWizLangsPanel;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifjLangsDlg
extends JDialog
implements ActionListener,
WindowListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int HELP = 2;
    private OiifjWizLangsPanel m_langPanel;
    private JButton m_ok;
    private JButton m_cancel;
    private JButton m_help;
    private int m_buttonPressed;
    private Dimension m_prefSize;
    private Frame m_frame;
    private OiicInstallSession m_instSession;
    private static final int WIDTH = 380;
    private static final int HEIGHT = 400;
    private static final int INSETS = 10;
    private static final int BUTTON_BUTTON_GAP = 10;
    private static final int SOUTH_MARGIN = 20;

    public OiifjLangsDlg(Frame f, OiicInstallSession session) {
        super(f, OiixResourceBundle.getString("S_LANG_SEL"), true);
        this.m_frame = f;
        this.m_instSession = session;
        this.getContentPane().setLayout(new BorderLayout());
        this.m_prefSize = new Dimension(380, 400);
        this.setBackground(Color.lightGray);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)centerPanel, "Center");
        this.m_langPanel = new OiifjWizLangsPanel(this.m_instSession);
        centerPanel.add((Component)this.m_langPanel, "Center");
        JPanel dummyPanel = new JPanel();
        dummyPanel.setLayout(new BorderLayout());
        dummyPanel.setBorder(new EmptyBorder(0, 0, 20, 0));
        centerPanel.add((Component)dummyPanel, "South");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 4, 10, 1));
        dummyPanel.add((Component)buttonPanel, "South");
        this.m_help = new JButton(OiixResourceBundle.getString("S_HELP_BUTTON"));
        this.m_help.addActionListener(this);
        buttonPanel.add(this.m_help);
        JPanel dummySpace = new JPanel();
        buttonPanel.add(dummySpace);
        this.m_ok = new JButton(OiixResourceBundle.getString("S_OK_BUTTON"));
        this.m_ok.addActionListener(this);
        buttonPanel.add(this.m_ok);
        this.m_cancel = new JButton(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
        this.m_cancel.addActionListener(this);
        buttonPanel.add(this.m_cancel);
        OiifjKeyActionConverter oka = new OiifjKeyActionConverter(this.m_cancel, this.m_help, this);
        OiifmMnemonicOps.processMnemonic(centerPanel);
        this.addWindowListener(this);
        this.addKeyListener(oka);
        this.validate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_ok) {
            if (this.setLanguages()) {
                this.setVisible(false);
                this.m_buttonPressed = 0;
                super.dispose();
            }
        } else if (source == this.m_cancel) {
            this.setVisible(false);
            this.m_buttonPressed = 1;
            super.dispose();
        } else if (source == this.m_help) {
            OiixHelp.displayInstHelp("OiifpLangsSelWCDE", this);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.m_buttonPressed = 1;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private boolean setLanguages() {
        Vector v = this.m_langPanel.getSelectedLangs();
        if (v.size() == 0) {
            String errString = OiixResourceBundle.getString("S_NUM_LANGS_ERR");
            OiifmAlert.displayError(errString);
            return false;
        }
        OiicSessionContext oContext = this.m_instSession.getSessionContext();
        OiisVariable oLangs = oContext.getVariable("SELECTED_LANGUAGES");
        try {
            if (!OiicPullSession.isLangAddonMode() && v.indexOf(OiixLanguage.ENGLISH) == -1) {
                v.addElement(OiixLanguage.ENGLISH);
            }
            String[] strList = OiixLanguage.getStringArray(v);
            oLangs.setValue(strList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)this.m_frame);
        this.m_langPanel.init();
        this.m_langPanel.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        this.dispose();
        return this.m_buttonPressed;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.m_prefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.m_prefSize;
    }
}

