/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;

public class OiifjKeyActionConverter
implements KeyListener {
    private JButton m_cancel = null;
    private JButton m_help = null;
    private ActionListener m_actionListener = null;
    private int m_iKeyPressed = 0;

    public OiifjKeyActionConverter() {
    }

    public OiifjKeyActionConverter(JButton cancel, JButton help, ActionListener al) {
        this.setHelpButton(help);
        this.setCancelButton(cancel);
        this.setActionListener(al);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        --this.m_iKeyPressed;
        if (0 > this.m_iKeyPressed) {
            this.m_iKeyPressed = 0;
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        this.m_iKeyPressed = 0;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        ++this.m_iKeyPressed;
        if (event.isConsumed() || this.m_iKeyPressed > 1) {
            return;
        }
        JButton pressedButton = null;
        switch (event.getKeyCode()) {
            case 112: 
            case 156: {
                pressedButton = this.m_help;
                this.m_iKeyPressed = 0;
                break;
            }
            case 27: {
                pressedButton = this.m_cancel;
                this.m_iKeyPressed = 0;
            }
        }
        if (pressedButton != null && pressedButton.isEnabled()) {
            event.consume();
            ActionEvent a = new ActionEvent(pressedButton, 1001, pressedButton.getLabel());
            this.m_actionListener.actionPerformed(a);
        }
    }

    public void setCancelButton(JButton cancel) {
        this.m_cancel = cancel;
    }

    public void setHelpButton(JButton help) {
        this.m_help = help;
    }

    public void setActionListener(ActionListener listener) {
        if (listener != null) {
            this.m_actionListener = listener;
            this.setActionListenerToContainer((Container)((Object)listener));
        }
    }

    public void setActionListenerToContainer(Container parent) {
        if (parent == null) {
            return;
        }
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = parent.getComponent(i);
            if (!child.isVisible()) continue;
            if (child.isFocusable()) {
                child.addKeyListener(this);
            }
            if (!(child instanceof Container)) continue;
            this.setActionListenerToContainer((Container)child);
        }
    }
}

