/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiif.oiifj.OiifjKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifjInstallCancelDlg
extends JDialog
implements ActionListener,
ItemListener,
WindowListener,
OiicInstallCancelHandler {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    private static final int INSETS = 10;
    private static final int CONTENT_GAP = 5;
    private int _buttonPressed;
    private boolean m_bExit;
    private JButton _help;
    private JButton _ok;
    private ButtonGroup _radioButtonGroup;
    private JRadioButton _allButton;
    private JRadioButton _thisButton;
    private JButton _cancel;
    private JLabel _allLabel;
    private String m_prompt;
    private int m_dlgType;
    private int m_flags;
    private JRadioButton _selectedButton;
    private OiifmGraphicInterfaceManager m_interfaceManager;
    private boolean m_bUseRadioButtons = true;

    public OiifjInstallCancelDlg(Frame frame, int flags, String msg, int type) {
        super(frame, StringUtils.stripMnemonic((String)OiixResourceBundle.getString("S_CANCEL_BUTTON")), true);
        this.setBackground(Color.lightGray);
        if (type == 1) {
            this.setTitle(OiixResourceBundle.getString("S_ERROR"));
        }
        this.m_dlgType = type;
        this.m_flags = flags;
        this.getContentPane().setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BorderLayout(1, 1));
        mainPanel.add((Component)centerPanel, "Center");
        this.m_prompt = msg != null ? msg : "";
        MultiLineLabel promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.m_prompt);
        centerPanel.add((Component)promptLabel, "North");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 0;
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(gridbag);
        centerPanel.add((Component)checkPanel, "Center");
        this._radioButtonGroup = new ButtonGroup();
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0) {
                this._allButton = new JRadioButton(OiixResourceBundle.getString("S_CANCEL_ALL"), true);
                gridbag.setConstraints(this._allButton, c);
                checkPanel.add(this._allButton);
                this._allButton.addItemListener(this);
                this._radioButtonGroup.add(this._allButton);
            } else {
                this._allLabel = new JLabel(OiixResourceBundle.getString("S_CANCEL_ALL_WARNING"));
                gridbag.setConstraints(this._allLabel, c);
                checkPanel.add(this._allLabel);
                this.m_bUseRadioButtons = false;
            }
        }
        if ((flags & 2) != 0) {
            this._thisButton = new JRadioButton(OiixResourceBundle.getString("S_CANCEL_THIS"), false);
            this._thisButton.setEnabled(true);
            gridbag.setConstraints(this._thisButton, c);
            checkPanel.add(this._thisButton);
            this._thisButton.addItemListener(this);
            this._radioButtonGroup.add(this._thisButton);
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)buttonPanel, "South");
        JPanel tmpPanel = new JPanel(new GridLayout(1, 2, 5, 0));
        buttonPanel.add((Component)tmpPanel, "East");
        this._help = new JButton(OiixResourceBundle.getString("S_HELP_BUTTON"));
        this._help.addActionListener(this);
        tmpPanel.add(this._help);
        this._ok = new JButton(OiixResourceBundle.getString("S_OK_BUTTON"));
        this._ok.addActionListener(this);
        tmpPanel.add(this._ok);
        if ((flags & 4) != 0 && type != 1) {
            this._cancel = new JButton(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
            this._cancel.addActionListener(this);
            tmpPanel.add(this._cancel);
        }
        this._selectedButton = this._allButton;
        this.m_bExit = false;
        OiifjKeyActionConverter keyActionConverter = new OiifjKeyActionConverter(this._cancel, this._help, this);
        this.addKeyListener(keyActionConverter);
        OiifmMnemonicOps.processMnemonic(mainPanel);
        this.validate();
        this.addWindowListener(this);
    }

    public OiifjInstallCancelDlg(OiifmGraphicInterfaceManager interfaceManager, int flags, String msg, int type) {
        this((Frame)((Object)interfaceManager.getMainFrame()), flags, msg, type);
        this.m_interfaceManager = interfaceManager;
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)this, (Component)WindowUtils.parentFrame((Component)this));
        this._help.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        return this._buttonPressed;
    }

    private void onExit() {
        String title = OiixResourceBundle.getString("S_EXIT_TITLE");
        String message = OiixResourceBundle.getString("S_CANCEL_ALL_EXIT_WARNING");
        int cancelVal = 1;
        cancelVal = OiifmAlert.displayAlert(title, message, 30, 3, 1, 10);
        switch (cancelVal) {
            case 1: {
                this._buttonPressed = 8;
                this.setVisible(false);
            }
            case 2: {
                break;
            }
        }
    }

    @Override
    public int doCancelOperation() {
        return this.doModal();
    }

    @Override
    public int doCancelOperation(boolean isExit) {
        this.m_bExit = isExit;
        return this.doModal();
    }

    @Override
    public int doCancelOperation(String sMsg) {
        return this.doModal();
    }

    private void beginLogDialog() {
        Object[] logArr = new String[]{this.getTitle(), this.m_prompt};
        String logTxt = OiixResourceBundle.getString("S_LOG_DIALOG");
        OiiolTextLogger.appendText(MessageFormat.format(logTxt, logArr));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        this.beginLogDialog();
        String resultStr = OiixResourceBundle.getString("S_LOG_USER_SEL");
        if (source == this._ok) {
            String selStr = "";
            JRadioButton selection = this._selectedButton;
            if (selection == this._allButton) {
                selStr = StringUtils.stripMnemonic((String)OiixResourceBundle.getString("S_CANCEL_ALL"));
                this._buttonPressed = 1;
            } else if (selection == this._thisButton) {
                OiicInstallTimeSession oSession;
                selStr = StringUtils.stripMnemonic((String)this._thisButton.getLabel());
                this._buttonPressed = 2;
                if (null != this.m_interfaceManager && (oSession = this.m_interfaceManager.getSession()) != null && oSession instanceof OiicInstallSession) {
                    ((OiicInstallSession)oSession).setSuccessfullInstallation(false);
                }
            } else {
                this._buttonPressed = -1;
            }
            if (this.m_bExit && (this._buttonPressed == -1 || this._buttonPressed == 1)) {
                this.onExit();
            } else {
                OiiolTextLogger.appendText(resultStr + selStr + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
                this.setVisible(false);
            }
        } else if (source == this._cancel) {
            this._buttonPressed = 4;
            OiiolTextLogger.appendText(resultStr + this._cancel.getLabel() + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
            this.setVisible(false);
        } else if (source == this._help) {
            OiixHelp.displayInstHelp("OiifdInstallCancelDlg", this);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getItem();
        this._selectedButton = (JRadioButton)source;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.beginLogDialog();
        String resultStr = OiixResourceBundle.getString("S_LOG_USER_SEL");
        if ((this.m_flags & 4) != 0 && this.m_dlgType != 1) {
            if (!this.m_bUseRadioButtons) {
                this._buttonPressed = -1;
                OiiolTextLogger.appendText(resultStr + OiixResourceBundle.getString("S_CANCEL_BUTTON") + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
                this.setVisible(false);
            } else {
                this.handleSelection();
            }
        } else {
            JRadioButton selection = this._selectedButton;
            this._buttonPressed = selection == this._allButton || selection == null ? 1 : (selection == this._thisButton ? 2 : -1);
            OiiolTextLogger.appendText(resultStr + selection.getText() + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
            this.setVisible(false);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void handleSelection() {
        String resultStr = OiixResourceBundle.getString("S_LOG_USER_SEL");
        JRadioButton selection = this._selectedButton;
        OiicInstallTimeSession oSession = null;
        if (null != this.m_interfaceManager) {
            oSession = this.m_interfaceManager.getSession();
        }
        if (selection == this._allButton || selection == null) {
            this._buttonPressed = 1;
            if (oSession != null && oSession instanceof OiicInstallSession) {
                ((OiicInstallSession)oSession).onBackIntoLocations();
            }
        } else if (selection == this._thisButton) {
            this._buttonPressed = 2;
            if (oSession != null && oSession instanceof OiicInstallSession) {
                ((OiicInstallSession)oSession).setSuccessfullInstallation(false);
            }
        } else {
            this._buttonPressed = -1;
        }
        String selStr = selection.getText();
        OiiolTextLogger.appendText(resultStr + selStr + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
        this.setVisible(false);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

