/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifj;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifjDetailsAlert
implements ActionListener {
    public static final int TYPE_CAUTION = 2;
    public static final int TYPE_STOP = 0;
    public static final int TYPE_MISC = 1;
    public static final int TYPE_NOTE = 1;
    public static final int BUTTON_OK = 0;
    public static final int BUTTON_CANCEL = 2;
    private JComponent m_BasePane;
    private JDialog m_AlertDlg;
    private Frame m_parentComp;
    private int m_iType;
    private String m_sTitle;
    private String m_sMessage;
    private String m_sDetailMessage;
    private Object[] m_Buttons = null;
    private String m_sShowDetailsStr = OiixResourceBundle.getString("S_SHOW_DETAILS");
    private String m_sHideDetailsStr = OiixResourceBundle.getString("S_HIDE_DETAILS");
    private JButton m_ok = new JButton(OiixResourceBundle.getString("S_OK_BUTTON"));
    private JButton m_cancel = new JButton(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
    private JButton m_details = new JButton(this.m_sShowDetailsStr);
    private boolean m_bDetailsShowing = false;
    private int m_iSelectedOption = 0;
    private MessagePanel m_messagePanel;

    public OiifjDetailsAlert(Frame parent, int type, String title, String msg, Vector details) {
        this.m_parentComp = parent;
        this.m_iType = type;
        this.m_sTitle = title;
        this.m_sMessage = msg;
        this.m_ok.addActionListener(this);
        this.m_details.addActionListener(this);
        this.m_cancel.addActionListener(this);
        OiifmMnemonicOps.processMnemonic(this.m_ok);
        OiifmMnemonicOps.processMnemonic(this.m_details);
        OiifmMnemonicOps.processMnemonic(this.m_cancel);
        this.m_Buttons = this.m_iType == 2 ? new Object[]{this.m_ok, this.m_details, this.m_cancel} : new Object[]{this.m_ok, this.m_details};
        StringBuffer sb = new StringBuffer();
        if (details != null) {
            int numLines = details.size();
            for (int i = 0; i < numLines; ++i) {
                sb.append((String)details.elementAt(i));
                sb.append("\n");
            }
            this.m_sDetailMessage = sb.toString();
        }
        this.m_messagePanel = new MessagePanel(this.m_sMessage, this.m_sDetailMessage);
        this.m_messagePanel.hideDetails();
        OiifmMnemonicOps.processMnemonic(this.m_messagePanel);
    }

    public int runDialog() {
        JOptionPane optPane = new JOptionPane(this.m_messagePanel, this.m_iType, -1, null, this.m_Buttons, this.m_Buttons[0]);
        this.m_AlertDlg = optPane.createDialog(this.m_parentComp, this.m_sTitle);
        this.m_AlertDlg.show();
        return this.m_iSelectedOption;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.m_ok)) {
            this.m_iSelectedOption = 0;
            this.m_AlertDlg.dispose();
        } else if (evt.getSource().equals(this.m_cancel)) {
            this.m_iSelectedOption = 2;
            this.m_AlertDlg.dispose();
        } else if (evt.getSource().equals(this.m_details)) {
            if (!this.m_bDetailsShowing) {
                this.m_details.setText(this.m_sHideDetailsStr);
                this.m_messagePanel.showDetails();
                this.m_bDetailsShowing = true;
            } else {
                this.m_details.setText(this.m_sShowDetailsStr);
                this.m_messagePanel.hideDetails();
                this.m_bDetailsShowing = false;
            }
            OiifmMnemonicOps.processMnemonic(this.m_details);
            this.m_AlertDlg.pack();
            this.m_AlertDlg.validate();
        }
    }

    public static int displayAlert(Frame f, int type, String title, String msg, Vector vDetails) {
        int iResult = -1;
        if (null != msg) {
            OiifjDetailsAlert alert = new OiifjDetailsAlert(f, type, title, msg, vDetails);
            iResult = alert.runDialog();
        }
        return iResult;
    }

    public static int displayError(Frame f, String title, String msg, Vector vDetails) {
        int iResult = -1;
        if (null != msg) {
            OiifjDetailsAlert alert = new OiifjDetailsAlert(f, 0, title, msg, vDetails);
            iResult = alert.runDialog();
        }
        return iResult;
    }

    public static void main(String[] args) {
        Frame f = new Frame("testing");
        Vector<String> v = new Vector<String>();
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        v.addElement("1");
        OiifjDetailsAlert.displayAlert(f, 2, "Title", "message", v);
    }

    class MessagePanel
    extends JPanel {
        BorderLayout borderLayout1 = new BorderLayout();
        JScrollPane messageScrollPane;
        JTextPane messageTextArea = new JTextPane();
        JTextField messageField = new JTextField();
        String message;
        String messageDetails;

        public MessagePanel(String message, String messageDetails) {
            this.message = message;
            this.messageDetails = messageDetails;
            try {
                this.init();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private MessagePanel() {
        }

        void init() throws Exception {
            this.setLayout(this.borderLayout1);
            this.messageField.setEditable(false);
            this.messageField.setText(this.message);
            this.messageField.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.add((Component)this.messageField, "North");
            this.messageTextArea.setEditable(false);
            this.messageTextArea.setText(this.messageDetails);
            this.messageTextArea.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.messageScrollPane = new JScrollPane(this.messageTextArea, 20, 30);
            this.messageField.setFont(new Font("SansSerif", 0, 10));
            this.messageTextArea.setFont(new Font("SansSerif", 0, 10));
            this.messageScrollPane.setPreferredSize(new Dimension(10, 50));
            this.add((Component)this.messageScrollPane, "Center");
        }

        public void hideDetails() {
            this.messageScrollPane.setVisible(false);
        }

        public void showDetails() {
            this.messageScrollPane.setVisible(true);
        }

        public void setText(String text) {
            this.message = text;
        }
    }
}

