/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.MessageFormat;
import javax.accessibility.AccessibleContext;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifb.OiifbStackLayout;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdTextFileDlg
extends BufferedDialog
implements ActionListener,
WindowListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    public static final int OK = 0;
    public static final int HELP = 2;
    protected static final int BUTTON_BUTTON_GAP = 5;
    protected static final int INSETS = 10;
    protected int m_buttonPressed;
    protected LWButton m_ok;
    protected LWContainer m_buttonPanel;
    protected OiifbStackLayout m_buttonLayout;
    protected LWTextArea m_textfile;
    private MultiLineLabel m_description;
    private ScrollBox m_scroll;
    protected File m_file;
    private Dimension m_prefSize;
    private static final int WIDTH = 450;
    private static final int HEIGHT = 400;

    public OiifdTextFileDlg(Frame f, File textfile, String label, String description) {
        super(f, label, true);
        this.m_file = textfile;
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.setResizable(true);
        LWContainer basePanel = new LWContainer();
        basePanel.setLayout((LayoutManager)new BorderLayout(5, 5));
        basePanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 0, 10));
        this.add((Component)basePanel, "Center");
        this.m_description = new MultiLineLabel(WordWrapper.getTextWrapper(), description);
        this.m_description.setPreferredAspectRatio(0.0f);
        basePanel.add((Component)this.m_description, (Object)"North");
        this.m_textfile = new LWTextArea();
        this.m_textfile.setToolTipValue(description);
        this.m_textfile.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_scroll = new ScrollBox((Component)this.m_textfile, 2, 0);
        basePanel.add((Component)this.m_scroll, (Object)"Center");
        LWContainer bottomPanel = new LWContainer();
        bottomPanel.setLayout((LayoutManager)new BorderLayout());
        basePanel.add((Component)bottomPanel, (Object)"South");
        this.m_buttonLayout = new OiifbStackLayout(0, 5);
        this.m_buttonPanel = new LWContainer();
        this.m_buttonPanel.setLayout((LayoutManager)this.m_buttonLayout);
        bottomPanel.add((Component)this.m_buttonPanel, (Object)"Center");
        this.m_ok = new LWButton(OiixResourceBundle.getString("S_OK_BUTTON"));
        this.m_buttonPanel.add("Top Right", (Component)this.m_ok);
        this.m_ok.addActionListener((ActionListener)this);
        this.m_prefSize = new Dimension(450, 400);
        this.loadTextFile();
        OiifmMnemonicOps.processMnemonic((Container)basePanel);
        this.addWindowListener(this);
    }

    public AccessibleContext getAccessibleContext() {
        AccessibleContext oAccessibleContext = super.getAccessibleContext();
        oAccessibleContext.setAccessibleDescription(this.m_description.getText());
        return oAccessibleContext;
    }

    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_ok) {
            this.setVisible(false);
            this.m_buttonPressed = 0;
        }
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)WindowUtils.parentFrame((Component)((Object)this)));
        Toolkit.getDefaultToolkit().beep();
        this.m_textfile.requestFocus();
        this.setVisible(true);
        return this.m_buttonPressed;
    }

    private void loadTextFile() {
        try {
            if (this.m_file == null) {
                Object[] arr = new String[]{this.getTitle()};
                String prompt = OiixResourceBundle.getString("S_ERR_LOAD_FILE");
                this.m_textfile.setText(MessageFormat.format(prompt, arr));
            } else {
                String str;
                StringBuffer sbuf = new StringBuffer();
                BufferedReader br = new BufferedReader(new FileReader(this.m_file));
                String linesep = System.getProperty("line.separator");
                while ((str = br.readLine()) != null) {
                    sbuf.append(str);
                    sbuf.append('\n');
                }
                this.m_textfile.setText(sbuf.toString());
                if (this.m_description.getText().equalsIgnoreCase("")) {
                    new LWLabel(sbuf.toString()).setLabelFor((Component)this.m_textfile);
                }
                this.m_textfile.setEditable(false);
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
        this.m_buttonPressed = 0;
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] argv) throws Exception {
        Frame f = new Frame();
        OiifdTextFileDlg tfd = new OiifdTextFileDlg(f, new File(argv[0]), "Test", "Test desrption");
        tfd.doModal();
        System.exit(0);
    }
}

