/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.tabPanel.TabPanel;
import oracle.ewt.tabPanel.TabPanelEvent;
import oracle.ewt.tabPanel.TabPanelListener;
import oracle.ewt.tabPanel.TabPanelPage;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifd.OiifdButtonPanel;
import oracle.sysman.oii.oiif.oiifd.OiifdPropertyPage;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;

public abstract class OiifdPropertySheet
extends LWContainer
implements TabPanelListener,
WindowListener,
ActionListener {
    static short MODAL = 0;
    static short MODELESS = 1;
    static short EMBEDDED = (short)2;
    private Frame m_parentFrame = null;
    private BufferedDialog m_dialog = null;
    private boolean m_modified = false;
    private boolean m_success = false;
    private short m_mode;
    private PushButton m_okBtn = null;
    private PushButton m_cancelBtn = null;
    private PushButton m_applyBtn = null;
    private PushButton revertButton = null;
    protected LWContainer clientPanel;
    private OiifdButtonPanel m_buttonPanel = null;
    private TabPanel m_tabPanel;
    private boolean m_okPressed;
    private ScrollBox m_scrollBox;

    public OiifdPropertySheet() {
        this.setLayout(new BorderLayout());
        this.m_buttonPanel = new OiifdButtonPanel();
        this.clientPanel = new LWContainer();
        EwtComponent tempPanel = new EwtComponent();
        EwtComponent mainContainer = new EwtComponent();
        mainContainer.setLayout((LayoutManager)new BorderLayout());
        this.m_tabPanel = new TabPanel();
        this.m_tabPanel.addTabPanelListener((TabPanelListener)this);
        mainContainer.add("Center", (Component)this.m_tabPanel);
        mainContainer.add("South", (Component)tempPanel);
        tempPanel.setLayout((LayoutManager)new BorderLayout());
        tempPanel.add("South", (Component)((Object)this.m_buttonPanel));
        tempPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 0, 0, 0));
        mainContainer.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        this.add("Center", (Component)mainContainer);
        this.setBackground(UIManager.getColor((Object)LookAndFeel.DARK_LOOK));
    }

    public TabPanel getTabPanel() {
        return this.m_tabPanel;
    }

    private void internalInit() {
        this.addButtons();
        this.addPages();
        this.enableButtons();
    }

    public void setDialogTitle(String title) {
        if (this.m_dialog != null) {
            this.m_dialog.setTitle(title);
        }
    }

    public String getDialogTitle() {
        if (this.m_dialog != null) {
            return this.m_dialog.getTitle();
        }
        return "";
    }

    public void toFront() {
        if (this.m_dialog != null) {
            this.m_dialog.toFront();
        }
    }

    private void createDialog(boolean modal, Frame parent) {
        this.m_parentFrame = parent;
        Dimension size = this.getPreferredPageSize();
        this.setSize(size);
        this.m_dialog = new BufferedDialog(this.m_parentFrame, this.getDefaultDialogTitle(), modal);
        this.m_dialog.setLayout((LayoutManager)new BorderLayout());
        this.m_scrollBox = new ScrollBox((Component)((Object)this), 0, 0);
        this.m_dialog.add((Component)this.m_scrollBox, (Object)"Center");
        this.m_dialog.setResizable(false);
        this.m_dialog.setSize(size);
        this.m_dialog.addWindowListener((WindowListener)this);
        WindowUtils.centerWindow((Window)this.m_dialog, (Component)parent);
        this.m_dialog.setVisible(true);
    }

    public void createModal(Frame parent) {
        OiifmCursorUtil.setCursor(3, (Component)parent);
        this.m_mode = MODAL;
        this.internalInit();
        this.createDialog(true, parent);
        OiifmCursorUtil.setCursor(0, (Component)parent);
    }

    public void createModeless(Frame parent) {
        OiifmCursorUtil.setCursor(3, (Component)parent);
        this.m_mode = MODELESS;
        this.internalInit();
        this.createDialog(false, parent);
        OiifmCursorUtil.setCursor(0, (Component)parent);
    }

    public Dimension getMinimumPageSize() {
        return new Dimension(0, 0);
    }

    public Dimension getMaximumPageSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private Dimension getAdjustedSize(int width, int height) {
        Dimension min = this.getMinimumPageSize();
        width = Math.max(width, min.width);
        height = Math.max(height, min.height);
        Dimension max = this.getMaximumPageSize();
        if (max.width > 0) {
            width = Math.min(width, max.width);
        }
        if (max.height > 0) {
            height = Math.min(height, max.height);
        }
        return new Dimension(width, height);
    }

    public void setSize(int width, int height) {
        Dimension dim = this.getAdjustedSize(width, height);
        super.setSize(dim.width, dim.height);
    }

    public void setSize(Dimension size) {
        super.setSize(this.getAdjustedSize(size.width, size.height));
    }

    public Dimension getPreferredPageSize() {
        return new Dimension(550, 430);
    }

    protected boolean isModified() {
        return this.m_modified;
    }

    int getDlgMode() {
        return this.m_mode;
    }

    protected void cleanup() {
        if (this.m_dialog != null) {
            this.m_dialog.dispose();
        }
        TabPanel tabPanel = this.getTabPanel();
        for (int i = 0; i < tabPanel.getPageCount(); ++i) {
            ((OiifdPropertyPage)((Object)tabPanel.getPage(i).getContent())).cleanup();
        }
        tabPanel.removeAllPages();
    }

    public void selectPage(OiifdPropertyPage page) {
        TabPanelPage tpPage = null;
        OiifdPropertyPage guiPage = null;
        int count = this.m_tabPanel.getPageCount();
        for (int i = 0; i < count; ++i) {
            tpPage = this.m_tabPanel.getPage(i);
            guiPage = (OiifdPropertyPage)((Object)tpPage.getContent());
            if (guiPage != page) continue;
            tpPage.setSelected(true);
            break;
        }
    }

    public int launchDialog(Component parent, boolean modal) {
        int result = 0;
        if (this.getNumPages() > 0) {
            if (modal) {
                this.createModal(WindowUtils.parentFrame((Component)parent));
            } else {
                this.createModeless(WindowUtils.parentFrame((Component)parent));
            }
        }
        return result;
    }

    public void onOK() {
        this.updateAndClose();
    }

    private void updateAndClose() {
        this.cleanup();
    }

    public void onCancel() {
        this.cleanup();
    }

    public void onApply() {
        this.updateAndDisplay();
    }

    private void updateAndDisplay() {
        for (int i = 0; i < this.m_tabPanel.getPageCount(); ++i) {
            OiifdPropertyPage page = (OiifdPropertyPage)((Object)this.m_tabPanel.getPage(i).getContent());
            if (!page.getReinitForApply()) continue;
            page.setInitNeed(true);
        }
        OiifdPropertyPage page = (OiifdPropertyPage)((Object)this.m_tabPanel.getSelectedPage().getContent());
        if (page.getReinitForApply()) {
            page.reinitializePage();
        }
        this.resetModified();
    }

    public void onRevert() {
        this.reinitPages();
        this.resetModified();
    }

    public void tabPanelSelectionChanging(TabPanelEvent event) {
        TabPanelPage tpPage = this.m_tabPanel.getSelectedPage();
        if (tpPage == null) {
            return;
        }
        OiifdPropertyPage page = (OiifdPropertyPage)((Object)tpPage.getContent());
        OiifdPropertyPage c = this.m_mode != EMBEDDED ? this.m_dialog : page;
        OiifmCursorUtil.setCursor(3, (Component)((Object)c));
    }

    public void tabPanelSelectionChanged(TabPanelEvent event) {
        TabPanelPage tpPage = this.m_tabPanel.getSelectedPage();
        if (tpPage == null) {
            return;
        }
        OiifdPropertyPage page = (OiifdPropertyPage)((Object)tpPage.getContent());
        if (!page.isDisplayed()) {
            page.onCreatePage();
            page.setDisplayed(true);
        }
        page.onSetActive();
        OiifdPropertyPage c = this.m_mode != EMBEDDED ? this.m_dialog : page;
        OiifmCursorUtil.setCursor(0, (Component)((Object)c));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_okBtn) {
            this.onOK();
        } else if (event.getSource() == this.m_cancelBtn) {
            this.onCancel();
        } else if (event.getSource() == this.m_applyBtn) {
            this.onApply();
        } else if (event.getSource() == this.revertButton) {
            this.onRevert();
        }
    }

    protected void addPage(OiifdPropertyPage page) {
        this.m_tabPanel.addPage(page.getTitle(), (Component)((Object)page));
    }

    private void addPages() {
        int num = this.getNumPages();
        for (int i = 0; i < num; ++i) {
            OiifdPropertyPage page = this.createPageAt(i);
            this.addPage(page);
        }
    }

    public abstract OiifdPropertyPage createPageAt(int var1);

    public int getNumPages() {
        return 0;
    }

    protected String getFullDisplayName() {
        return null;
    }

    public abstract String getDisplayName();

    private String getDefaultDialogTitle() {
        String title = "";
        if (this.getFullDisplayName() != null) {
            title = this.getFullDisplayName();
        } else {
            Object[] msgArgs = new Object[]{this.getDisplayName()};
            title = "HI";
        }
        return title;
    }

    private void reinitPages() {
        int numPage = this.m_tabPanel.getPageCount();
        for (int i = 0; i < numPage; ++i) {
            OiifdPropertyPage oiifdPropertyPage = (OiifdPropertyPage)((Object)this.m_tabPanel.getPage(i).getContent());
        }
        OiifdPropertyPage page = (OiifdPropertyPage)((Object)this.m_tabPanel.getSelectedPage().getContent());
        page.onSetActive();
    }

    private void replacePages() {
        int oldPageCount = this.m_tabPanel.getPageCount();
        this.m_tabPanel.freezeRepaints();
        for (int i = oldPageCount - 1; i >= 0; --i) {
            this.m_tabPanel.removePage(this.m_tabPanel.getPage(i));
        }
        this.m_tabPanel.unfreezeRepaints();
        this.addPages();
        OiifdPropertyPage page = (OiifdPropertyPage)((Object)this.m_tabPanel.getPage(0).getContent());
        page.onSetActive();
    }

    protected PushButton addButton(String caption) {
        PushButton newButton = this.m_buttonPanel.addButton(caption);
        newButton.addActionListener((ActionListener)this);
        return newButton;
    }

    protected PushButton addOKButton() {
        this.m_okBtn = this.addButton("OK");
        return this.m_okBtn;
    }

    protected PushButton addOKButton(String label) {
        this.m_okBtn = this.addButton(label);
        return this.m_okBtn;
    }

    protected PushButton addCancelButton() {
        this.m_cancelBtn = this.addButton("Cancel");
        return this.m_cancelBtn;
    }

    protected PushButton addCancelButton(String label) {
        this.m_cancelBtn = this.addButton(label);
        return this.m_cancelBtn;
    }

    protected PushButton addApplyButton() {
        this.m_applyBtn = this.addButton("Apply");
        return this.m_applyBtn;
    }

    protected PushButton addApplyButton(String label) {
        this.m_applyBtn = this.addButton(label);
        return this.m_applyBtn;
    }

    protected PushButton addRevertButton() {
        this.revertButton = this.addButton("Revert");
        return this.revertButton;
    }

    protected PushButton addRevertButton(String label) {
        this.revertButton = this.addButton(label);
        return this.revertButton;
    }

    protected void addHelpButton() {
    }

    protected void addButtons() {
        this.m_cancelBtn = this.addButton("Close");
        this.addHelpButton();
    }

    private void removeButtons() {
        this.m_buttonPanel.removeAll();
    }

    void updateModifiedPage() {
        this.m_modified = false;
        for (int i = 0; i < this.getTabPanel().getPageCount(); ++i) {
            OiifdPropertyPage page = (OiifdPropertyPage)((Object)this.getTabPanel().getPage(i).getContent());
            this.m_modified |= page.isModified();
        }
        this.enableButtons();
    }

    protected void resetModified() {
        this.m_modified = false;
        for (int i = 0; i < this.m_tabPanel.getPageCount(); ++i) {
            OiifdPropertyPage page = (OiifdPropertyPage)((Object)this.m_tabPanel.getPage(i).getContent());
            page.setModified(false);
        }
        this.enableButtons();
    }

    protected void enableButtons() {
        if (this.m_applyBtn != null) {
            this.m_applyBtn.setEnabled(this.m_modified);
        }
        if (this.revertButton != null) {
            this.revertButton.setEnabled(this.m_modified);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cleanup();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

