/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import oracle.ewt.EwtContainer;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifd.OiifdPropertySheet;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;

public abstract class OiifdPropertyPage
extends EwtContainer {
    protected GridBagLayout m_layout = new GridBagLayout();
    private boolean m_initNeeded = true;
    private boolean modified = false;
    private boolean displayed = false;
    private boolean reinitOnApply = false;
    private String m_title;
    private OiifdPropertySheet m_ps = null;

    public OiifdPropertyPage(String title) {
        this.setLayout(this.m_layout);
        this.m_title = title;
    }

    protected abstract void initializePage();

    public boolean validateControls() {
        return false;
    }

    protected void onSetActive() {
        if (this.m_initNeeded) {
            this.initializePage();
            this.m_initNeeded = false;
            this.checkPS();
        }
        if (this.m_ps != null) {
            this.m_ps.setHelpBook(this.getHelpBook());
            this.m_ps.setHelpTopic(this.getHelpTopic());
        }
    }

    protected abstract void onCreatePage();

    public void reinitializePage() {
        this.onSetActive();
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String t) {
        this.m_title = t;
    }

    private void checkPS() {
        if (this.m_ps == null) {
            Object c = this;
            while ((c = ((Component)c).getParent()) != null) {
                if (!(c instanceof OiifdPropertySheet)) continue;
                this.m_ps = (OiifdPropertySheet)c;
                return;
            }
        }
    }

    protected int showAlert(String title, String message) {
        Frame frame = WindowUtils.parentFrame((Component)((Object)this));
        if (frame != null) {
            return OiifmAlert.displayAlert(title, message, 30, 3, 4);
        }
        return 4;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
        this.checkPS();
        if (this.m_ps != null) {
            this.m_ps.updateModifiedPage();
        }
    }

    protected boolean isModified() {
        return this.modified;
    }

    void setInitNeed(boolean needed) {
        this.m_initNeeded = needed;
    }

    boolean isInitNeed() {
        return this.m_initNeeded;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean disp) {
        this.displayed = disp;
    }

    boolean setReinitForApply(boolean reinitFlag) {
        this.reinitOnApply = reinitFlag;
        return this.reinitOnApply;
    }

    boolean getReinitForApply() {
        return this.reinitOnApply;
    }

    protected void cleanup() {
    }

    protected OiifdPropertySheet getPropSheet() {
        this.checkPS();
        return this.m_ps;
    }

    protected void add(Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right, int padx, int pady) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        if (top + bottom + left + right > 0) {
            c.insets = new Insets(top, left, bottom, right);
        }
        c.ipadx = padx;
        c.ipady = pady;
        this.m_layout.setConstraints(component, c);
        this.add(component);
    }

    protected void add(EwtContainer container, Component component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right, int padx, int pady) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        if (top + bottom + left + right > 0) {
            c.insets = new Insets(top, left, bottom, right);
        }
        c.ipadx = padx;
        c.ipady = pady;
        GridBagLayout gbLayout = (GridBagLayout)container.getLayout();
        gbLayout.setConstraints(component, c);
        container.add(component);
    }
}

