/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPanel;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressUIListener;
import oracle.sysman.oii.oiix.OiixProgressUpdator;

public class OiifdNextSessionSetupProgressDlg
extends BufferedDialog
implements WindowListener,
OiifrProgressActionListener {
    private static final int INSETS = 5;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 110;
    private OiifrProgressPanel m_progress;
    private Dimension m_prefSize;
    private OiifrProgressUIListener m_listener;
    private OiicSessionContext m_sessionContext = null;
    private OiixProgressUpdator m_progressUpdator = null;

    public OiifdNextSessionSetupProgressDlg(Frame f, OiicSessionContext oContext) {
        super(f, false);
        this.m_sessionContext = oContext;
        this.m_listener = null;
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(Color.lightGray);
        String sTitle = (String)this.m_sessionContext.getVarValue("NEXT_SESSION_PROGRESS_TITLE");
        if (sTitle == null) {
            this.setTitle("");
        } else {
            this.setTitle(sTitle);
        }
        this.m_prefSize = new Dimension(400, 110);
        this.setSize(this.m_prefSize);
        LWContainer mainPanel = new LWContainer();
        mainPanel.setLayout((LayoutManager)new BorderLayout());
        mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(5, 5, 5, 5));
        this.add((Component)mainPanel, "Center");
        this.m_progress = new OiifrProgressPanel(0);
        mainPanel.add((Component)((Object)this.m_progress), (Object)"Center");
        String sText = (String)this.m_sessionContext.getVarValue("NEXT_SESSION_PROGRESS_TEXT");
        if (sText == null) {
            this.setStatus("");
        } else {
            this.setStatus(sText);
        }
        int maxWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        if (f != null) {
            maxWidth = f.getSize().width;
            maxHeight = f.getSize().height;
        }
        this.setLocation(maxWidth / 2 - 400, maxHeight / 2 - 110);
        this.setLocationRelativeTo(f);
        OiifmMnemonicOps.processMnemonic((Container)mainPanel);
        this.addWindowListener(this);
        this.validate();
    }

    public void onStartProgress() {
    }

    public void onStartProgress(OiixProgressUpdator updater) {
        this.m_progressUpdator = updater;
        if (this.m_progressUpdator != null) {
            this.m_progressUpdator.start();
        }
    }

    @Override
    public void onDoneProgress() {
        if (this.m_progressUpdator != null) {
            this.m_progressUpdator.stop();
        }
        this.m_progress.onDoneProgress();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setVisible(false);
    }

    public void onAbort() {
        this.setVisible(false);
        if (this.m_progressUpdator != null) {
            this.m_progressUpdator.stop();
        }
    }

    @Override
    public void onSuspend() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void setStatus(String status) {
        this.m_progress.setStatusText(status);
    }

    @Override
    public void setTotalBytes(long bytes) {
        this.m_progress.setTotalBytes(bytes);
    }

    @Override
    public void removeBytes(int bytes) {
        this.m_progress.removeBytes(bytes);
    }

    @Override
    public boolean isNewProgressUsed() {
        return true;
    }

    public Dimension getPreferredSize() {
        return this.m_prefSize;
    }

    public OiifrProgressActionListener getProgressActionListener() {
        return this;
    }

    @Override
    public void onCurrentComponent(String Comp) {
    }

    @Override
    public void addPercentage(int percent) {
        this.m_progress.addPercentage(percent);
    }

    @Override
    public void addBytes(int bytes) {
        this.m_progress.addBytes(bytes);
    }

    @Override
    public void onStartPhase(int phase) {
    }

    @Override
    public void onDonePhase(int phase) {
    }

    @Override
    public void onStartDeinstall() {
    }

    @Override
    public void onDoneDeinstall() {
    }

    public void addProgressUIListener(OiifrProgressUIListener plistener) {
        this.m_listener = plistener;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.m_listener != null) {
            this.m_listener.onCancelConfirm(true);
        }
        this.onAbort();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

