/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Vector;
import oracle.ewt.EwtContainer;
import oracle.ewt.button.PushButton;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.SortableTwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridEvent;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.layout.GroupBoxContainer;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWChoice;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWPasswordField;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TextPainter;
import oracle.ewt.table.TableEvent;
import oracle.ewt.table.TableRowSelectListener;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifd.OiifdChgPwdDlg;
import oracle.sysman.oii.oiif.oiifd.OiifdPropertyPage;
import oracle.sysman.oii.oiif.oiifd.OiifdPropertySheet;
import oracle.sysman.oii.oiif.oiifd.OiifdPubPS;
import oracle.sysman.oii.oiif.oiifd.OiifdScrollableTable;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiig.OiigAuthDetails;
import oracle.sysman.oii.oiig.OiigServerConfig;
import oracle.sysman.oii.oiig.OiigSourceConfigs;

public class OiifdLoginPage
extends OiifdPropertyPage
implements ItemListener,
TableRowSelectListener,
ActionListener {
    protected short m_totalColumns = (short)4;
    private final int m_extMargin = 5;
    private static final short PUBLISHER_COL = 0;
    private static final short URL_COL = 1;
    private static final short SUB_ID_COL = 2;
    private static final short PUBLISHER_COL_WIDTH = 140;
    private static final short URL_COL_WIDTH = 180;
    private static final short SUB_ID_COL_WIDTH = 80;
    private static final String INTERNAL = "internal";
    protected TextPainter m_textPainter = new TextPainter();
    private LWCheckbox m_specifyRadio = null;
    private LWCheckbox m_anoRadio = null;
    private PushButton m_deleteBtn;
    private PushButton m_okButton;
    private PushButton m_cancelButton;
    private PushButton m_chgPwdBtn = null;
    private LWLabel m_subIdLabel = null;
    private LWLabel m_pwdLabel = null;
    private LWLabel m_catLabel = null;
    private boolean m_bHasDeletion = false;
    private LWChoice m_catChoice = null;
    private LWTextField m_subIdTF = null;
    private LWPasswordField m_pwdTF = null;
    private boolean m_bSpecify = false;
    private OiifdScrollableTable m_table = null;
    private SortableTwoDDataSource m_tableData = null;
    private OiigSourceConfigs m_srcConfigs = null;
    private OiigServerConfig[] m_svrConfigs = null;

    public OiifdLoginPage(OiigSourceConfigs srcConfigs) {
        super("Login");
        this.m_srcConfigs = srcConfigs;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object authDetails = null;
        Object source = e.getSource();
        if (source == this.m_anoRadio) {
            this.enableSpecify(false);
        } else if (source == this.m_specifyRadio) {
            this.enableSpecify(true);
        } else {
            this.handleCatChoice();
        }
    }

    protected short getColumnCount() {
        return this.m_totalColumns;
    }

    protected OiifdScrollableTable getMCW() {
        return this.m_table;
    }

    protected SortableTwoDDataSource getTableData() {
        return this.m_tableData;
    }

    protected Grid getGrid() {
        return this.m_table.getTable().getGrid();
    }

    public void cellDeselected(GridEvent event) {
    }

    public void cellSelected(GridEvent event) {
    }

    public void cellSelecting(GridEvent event) {
    }

    public void cellDeselecting(GridEvent event) {
    }

    public void cellEditing(GridEvent event) {
    }

    public void cellEdited(GridEvent event) {
    }

    public void setStateChanged(boolean isModified) {
        this.setModified(isModified);
    }

    protected ArrayOneDDataSource getColumnHeaders() {
        return new ArrayOneDDataSource((Object[])new String[]{"Name", "URL", "Subscriber ID", ""});
    }

    public void setSelectedRow(int row) {
        Grid grid = this.m_table.getTable().getGrid();
        if (grid.getRowCount() == 0) {
            return;
        }
        grid.getGridSelection().setRowSelected(row, true);
    }

    private void handleCatChoice() {
        String sSel = null;
        sSel = this.m_catChoice.getSelectedItem();
        this.clearInputFields();
    }

    private void clearInputFields() {
        this.m_subIdTF.setText("");
        this.m_pwdTF.setText("");
    }

    private void resetInputFields(boolean bIntSub) {
        System.out.println("resetInputFields: " + bIntSub);
        this.m_subIdTF.setText("");
        this.m_pwdTF.setText("");
        if (bIntSub) {
            this.m_subIdTF.setEnabled(true);
            this.m_pwdTF.setEnabled(true);
        } else {
            this.m_subIdTF.setEnabled(true);
            this.m_pwdTF.setEnabled(false);
        }
    }

    private void enableSpecify(boolean bEnabled) {
        boolean bIntSub = false;
        Object sSelCat = null;
        this.m_bSpecify = bEnabled;
        OiigAuthDetails authDetails = null;
        OiigServerConfig svrConfig = this.getSelSvrConfig();
        if (svrConfig != null) {
            authDetails = svrConfig.getAuthDets();
        }
        if (authDetails != null) {
            bIntSub = authDetails.getCategory().equalsIgnoreCase(INTERNAL);
        }
        this.m_subIdTF.setEnabled(bEnabled);
        this.m_pwdTF.setEnabled(bEnabled);
        this.m_catChoice.setEnabled(bEnabled);
        this.m_chgPwdBtn.setEnabled(false);
        this.fillSubInfo();
    }

    public void rowSelected(TableEvent e) {
        this.setupLoginPanel();
    }

    public void rowDeselected(TableEvent e) {
    }

    public void rowSelecting(TableEvent e) {
    }

    public void rowDeselecting(TableEvent e) {
    }

    void addLoginPanel() {
        EwtContainer gbPanel = new EwtContainer((LayoutManager)new GridBagLayout());
        LWCheckbox loginBox = new LWCheckbox("Login as vchao", true);
        EwtContainer userPanel = new EwtContainer((LayoutManager)new GridBagLayout());
        LWCheckboxGroup selectGroup = new LWCheckboxGroup();
        this.m_anoRadio = new LWCheckbox("Anonymous:", true, selectGroup);
        this.m_specifyRadio = new LWCheckbox("Specify:", false, selectGroup);
        GroupBoxContainer gb = new GroupBoxContainer((Component)this.m_specifyRadio, (Component)userPanel);
        this.m_subIdLabel = new LWLabel("Subscriber ID:");
        this.m_pwdLabel = new LWLabel("Password:");
        this.m_pwdTF = new LWPasswordField(30);
        this.m_subIdTF = new LWTextField(30);
        this.m_catLabel = new LWLabel("Subscriber category:");
        this.m_catChoice = new LWChoice();
        this.add(userPanel, (Component)this.m_catLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 5, 20, 0, 8, 0, 0);
        this.add(userPanel, (Component)this.m_catChoice, 1, 0, 1, 1, 2, 17, 1.0, 0.0, 5, 40, 0, 8, 0, 0);
        this.add(userPanel, (Component)this.m_subIdLabel, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 10, 20, 0, 8, 0, 0);
        this.add(userPanel, (Component)this.m_subIdTF, 1, 1, 0, 1, 2, 17, 1.0, 0.0, 10, 0, 0, 8, 0, 0);
        this.add(userPanel, (Component)this.m_pwdLabel, 0, 2, 1, 1, 0, 17, 0.0, 1.0, 5, 20, 5, 8, 0, 0);
        this.add(userPanel, (Component)this.m_pwdTF, 1, 2, 1, 1, 2, 17, 1.0, 1.0, 5, 0, 0, 8, 0, 0);
        this.m_chgPwdBtn = new PushButton("Change Password...");
        this.add(userPanel, (Component)this.m_chgPwdBtn, 1, 3, 1, 1, 0, 13, 0.0, 0.0, 5, 0, 5, 8, 0, 0);
        this.m_pwdTF.setEnabled(false);
        this.m_chgPwdBtn.setRightmost(true);
        this.m_chgPwdBtn.setLeftmost(true);
        this.add((Component)this.m_anoRadio, 0, 7, 3, 1, 1, 16, 1.0, 0.0, 12, 23, 5, 8, 0, 0);
        this.add((Component)gb, 0, 8, 3, 1, 1, 16, 1.0, 0.0, 0, 8, 8, 8, 0, 0);
    }

    @Override
    protected void initializePage() {
        this.initTableData();
    }

    @Override
    protected void onCreatePage() {
        OiifdPropertySheet _ps = null;
        if (_ps == null) {
            Object c = this;
            while ((c = ((Component)c).getParent()) != null) {
                if (!(c instanceof OiifdPropertySheet)) continue;
                _ps = (OiifdPropertySheet)c;
            }
        }
        LWCheckboxGroup actionGroup = new LWCheckboxGroup();
        LWCheckboxGroup triggerGroup = new LWCheckboxGroup();
        LWCheckboxGroup typeGroup = new LWCheckboxGroup();
        ArrayOneDDataSource columnHeaders = this.getColumnHeaders();
        this.m_tableData = new SortableTwoDDataSource((int)this.getColumnCount(), 0);
        this.m_tableData.addRows(0, 5);
        this.m_table = new OiifdScrollableTable((TwoDDataSource)this.m_tableData, (OneDDataSource)columnHeaders, null, this);
        Grid grid = this.m_table.getGrid();
        this.setupGrid(grid);
        this.m_deleteBtn = new PushButton("Delete");
        this.m_okButton = new PushButton("OK");
        this.m_cancelButton = new PushButton("Cancel");
        EwtContainer buttonPanel = new EwtContainer((LayoutManager)new GridBagLayout());
        this.m_deleteBtn.setLeftmost(true);
        this.add(buttonPanel, (Component)this.m_deleteBtn, 0, 0, 1, 1, 0, 10, 1.0, 0.0, 5, 15, 0, 0, 0, 0);
        this.add((Component)new LWLabel("Available Servers:"), 0, 0, 1, 1, 0, 16, 1.0, 0.0, 12, 8, 0, 8, 0, 0);
        this.add((Component)((Object)this.m_table), 0, 1, 4, 6, 1, 18, 1.0, 1.0, 2, 8, 8, 8, 0, 0);
        this.m_deleteBtn.setRightmost(true);
        this.add((Component)this.m_deleteBtn, 4, 1, 1, 1, 0, 18, 1.0, 1.0, 20, 5, 8, 5, 0, 0);
        this.addLoginPanel();
        this.validate();
        this.addActionListeners();
        this.enableSpecify(false);
        this.fillSubInfo();
    }

    protected void addComponents() {
    }

    private void addActionListeners() {
        this.m_deleteBtn.addActionListener((ActionListener)this);
        this.m_okButton.addActionListener((ActionListener)this);
        this.m_cancelButton.addActionListener((ActionListener)this);
        this.m_chgPwdBtn.addActionListener((ActionListener)this);
        this.m_specifyRadio.addItemListener((ItemListener)this);
        this.m_anoRadio.addItemListener((ItemListener)this);
        this.m_catChoice.addItemListener((ItemListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.m_deleteBtn)) {
            this.onDelete();
        } else if (e.getSource().equals(this.m_chgPwdBtn)) {
            this.onChgPwd();
        }
    }

    public boolean hasDeletion() {
        return this.m_bHasDeletion;
    }

    private void onDelete() {
        int[] sels = null;
        sels = this.m_table.getGrid().getGridSelection().getSelectedRows();
        if (sels == null & sels.length == 0) {
            return;
        }
        OiigServerConfig svrConfig = this.getSelSvrConfig();
        if (svrConfig == null) {
            return;
        }
        String msg = "Are you sure you want to delete " + svrConfig.getName() + "?";
        int result = OiifmAlert.displayAlert("Warning", msg, 30, 3, 4);
        if (result != 1) {
            return;
        }
        this.m_tableData.removeRows(sels[0], 1);
        this.m_bHasDeletion = true;
        this.initTableData();
        this.setupLoginPanel();
    }

    @Override
    public boolean validateControls() {
        boolean bUpdate = false;
        boolean bIntSub = true;
        OiigAuthDetails authDetails = null;
        bUpdate = this.m_bHasDeletion;
        String subID = this.m_subIdTF.getText().trim();
        String pwd = this.m_pwdTF.getText().trim();
        String sSelCat = this.m_catChoice.getSelectedItem();
        OiigServerConfig svrConfig = this.getSelSvrConfig();
        boolean bl = bIntSub = sSelCat != null && sSelCat.equalsIgnoreCase(INTERNAL);
        if (svrConfig != null) {
            authDetails = svrConfig.getAuthDets();
            if (this.m_bSpecify) {
                if (pwd.equals("") || subID.equals("")) {
                    OiifmAlert.displayAlert("Warning", "You have to sepcify the subscriber id and password", 50, 1, 1, 10);
                    if (subID.equals("")) {
                        this.m_subIdTF.requestFocus();
                    } else {
                        this.m_pwdTF.requestFocus();
                    }
                    return false;
                }
                if (authDetails != null) {
                    if (authDetails.isAnonLogin()) {
                        authDetails.setUsername(subID);
                        authDetails.setCategory(sSelCat);
                        authDetails.setPassword(pwd);
                        authDetails.setAnonLogin(false);
                        svrConfig.setAuthDets(authDetails);
                        bUpdate = true;
                    } else if (!(authDetails.isAnonLogin() || authDetails.getUsername().equals(subID) && authDetails.getPassword().equals(pwd))) {
                        authDetails.setUsername(subID);
                        authDetails.setPassword(pwd);
                        authDetails.setCategory(sSelCat);
                        svrConfig.setAuthDets(authDetails);
                        bUpdate = true;
                    }
                }
            } else if (!this.m_bSpecify && authDetails != null && !authDetails.isAnonLogin()) {
                authDetails.setAnonLogin(true);
                svrConfig.setAuthDets(authDetails);
                bUpdate = true;
            }
        }
        if (bUpdate) {
            ((OiifdPubPS)this.getPropSheet()).setHasDeletion(this.m_bHasDeletion);
            if (this.m_bHasDeletion) {
                this.m_srcConfigs.removeSvrConfig(svrConfig);
            }
            if (!this.updateConfigFile()) {
                return false;
            }
        }
        return true;
    }

    private void clearList() {
        int len = 0;
        Object sItem = null;
        String[] sItems = null;
        if (this.m_catChoice != null) {
            int i;
            len = this.m_catChoice.getItemCount();
            sItems = new String[len];
            for (i = 0; i < len; ++i) {
                sItems[i] = this.m_catChoice.getItem(i);
            }
            for (i = 0; i < len; ++i) {
                this.m_catChoice.remove(sItems[i]);
            }
        }
    }

    private boolean updateConfigFile() {
        String msg = null;
        try {
            this.m_srcConfigs.saveToFile();
        }
        catch (IOException ioe) {
            msg = "Fail to update configuration file";
            int result = OiifmAlert.displayAlert("Warning", msg, 30, 1, 1);
            return false;
        }
        return true;
    }

    private void onChgPwd() {
        OiigAuthDetails authDetails = null;
        OiigServerConfig svrConfig = this.getSelSvrConfig();
        if (svrConfig != null && (authDetails = svrConfig.getAuthDets()) != null) {
            OiifdChgPwdDlg dlg = new OiifdChgPwdDlg(authDetails, WindowUtils.parentFrame((Component)((Object)this)));
            dlg.setVisible(true);
        }
    }

    protected void setupGrid(Grid grid) {
        ComplexAppearanceManager am = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)am);
        grid.setColumnPainter(0, (Painter)this.m_textPainter);
        this.m_table.setColumnWidth(0, 140);
        this.m_table.setColumnWidth(1, 180);
        this.m_table.setColumnWidth(2, 80);
        this.m_table.setColumnWidth(3, 1);
        for (int i = 1; i < this.m_totalColumns - 1; ++i) {
            Appearance colApp = am.getColumnAppearance(i);
            colApp.setHorizontalJustify(1);
            colApp.setVerticalJustify(1);
            am.setColumnAppearance(i, colApp);
        }
        this.m_table.getTable().addRowSelectListener((TableRowSelectListener)this);
        SingleRowSelection rowSelObj = new SingleRowSelection();
        rowSelObj.setParent(grid);
        grid.setGridSelection((GridSelection)rowSelObj);
    }

    private void checkRadio(boolean bSpecify) {
        this.m_anoRadio.setState(!bSpecify);
        this.m_specifyRadio.setState(bSpecify);
        this.enableSpecify(bSpecify);
    }

    private int[] getSelections() {
        int[] sels = null;
        sels = this.m_table.getGrid().getGridSelection().getSelectedRows();
        return sels;
    }

    private void fillSubInfo() {
        OiigAuthDetails authDetails = null;
        String[] sCats = null;
        int len = 0;
        boolean itemCnt = false;
        Object sNewCats = null;
        OiigServerConfig svrConfig = this.getSelSvrConfig();
        if (svrConfig != null && (authDetails = svrConfig.getAuthDets()) != null) {
            if (this.m_catChoice.getItemCount() > 0) {
                this.clearList();
            }
            if ((sCats = this.getSupCategories(authDetails)) != null) {
                len = sCats.length;
                for (int i = 0; i < len; ++i) {
                    this.m_catChoice.addItem(sCats[i]);
                }
                this.m_catChoice.select(authDetails.getCategory());
            }
            this.m_subIdTF.setText(authDetails.getUsername());
            this.m_pwdTF.setText(authDetails.getPassword());
        }
    }

    private String[] getSupCategories(OiigAuthDetails authDetails) {
        boolean len = false;
        String[] sCats = null;
        Object sNewCats = null;
        sCats = authDetails.getSupCategories();
        return sCats;
    }

    private void initTableData() {
        int len = 0;
        OiigAuthDetails authDetails = null;
        Vector svrConfigsV = new Vector();
        Grid grid = this.m_table.getGrid();
        svrConfigsV = this.m_srcConfigs.getSvrConfigs();
        if (svrConfigsV != null) {
            len = svrConfigsV.size();
            this.m_svrConfigs = new OiigServerConfig[len];
            for (int i = 0; i < len; ++i) {
                this.m_svrConfigs[i] = (OiigServerConfig)svrConfigsV.elementAt(i);
                this.m_tableData.setData(0, i, (Object)this.m_svrConfigs[i].getName());
                this.m_tableData.setData(1, i, (Object)this.m_svrConfigs[i].getURL());
                authDetails = this.m_svrConfigs[i].getAuthDets();
                boolean bAnonymous = authDetails.isAnonLogin();
                this.m_tableData.setData(2, i, (Object)(bAnonymous ? "Anonymous" : authDetails.getUsername()));
                this.m_tableData.setData(3, i, (Object)this.m_svrConfigs[i]);
            }
        }
        grid.setPreferredRowsOnScreen(5);
        if (len > 0) {
            this.setSelectedRow(0);
        }
    }

    private OiigServerConfig getSelSvrConfig() {
        OiigServerConfig svrConfig = null;
        int[] sels = this.getSelections();
        if (sels != null && sels.length != 0 && this.m_svrConfigs.length != 0) {
            svrConfig = (OiigServerConfig)this.m_tableData.getData(3, sels[0]);
        }
        return svrConfig;
    }

    private void setupLoginPanel() {
        OiigAuthDetails authDetails = null;
        OiigServerConfig svrConfig = this.getSelSvrConfig();
        if (svrConfig != null) {
            authDetails = svrConfig.getAuthDets();
            if (authDetails != null) {
                this.m_bSpecify = !authDetails.isAnonLogin();
                this.checkRadio(this.m_bSpecify);
            }
        } else {
            this.m_bSpecify = false;
            this.checkRadio(false);
        }
    }
}

