/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdInstallErrorDlg
extends BufferedDialog
implements ActionListener,
WindowListener,
OiifbIRetry {
    public static final boolean NO_RETRY = false;
    public static final boolean ALLOW_RETRY = true;
    private static final int INSETS = 10;
    private static final int MSG_BUTTON_GAP = 10;
    private static final int BUTTON_BUTTON_GAP = 5;
    private boolean allow_retry;
    private boolean allow_continue;
    private boolean allow_propagate;
    private boolean allow_cancel;
    private OiicInstallCancelHandler _cancelHandler;
    private boolean m_bCancel;
    private boolean m_bCancelAllOnly;
    private int _buttonPressed;
    private LWButton _help;
    private LWButton _retry;
    private LWButton _continue;
    private LWButton _propagate;
    private LWButton _cancel;
    private String m_sMsg;
    private boolean m_bExitOnCancel;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;

    public OiifdInstallErrorDlg(OiifmGraphicInterfaceManager interfaceManager, String msg, int flags, int type) {
        this(interfaceManager, OiixResourceBundle.getString("S_ERROR"), msg, flags, type, true);
    }

    public OiifdInstallErrorDlg(OiifmGraphicInterfaceManager interfaceManager, String sTitle, String msg, int flags, int type, boolean bAllowCancel) {
        super((Frame)((Object)interfaceManager.getMainFrame()), sTitle, true);
        LWLabel cancel_hint;
        this.m_sMsg = msg;
        this.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        LWContainer centerPanel = new LWContainer();
        centerPanel.setLayout((LayoutManager)new BorderLayout(1, 10));
        centerPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.add((Component)centerPanel, "Center");
        MultiLineLabel msgLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), msg);
        msgLabel.setFont(new Font(OiixResourceBundle.getFont(), 0, 12));
        centerPanel.add((Component)msgLabel, (Object)"North");
        this.m_bExitOnCancel = false;
        int numButtons = 1;
        this.allow_retry = (flags & 2) != 0;
        this.allow_continue = (flags & 4) != 0;
        this.allow_propagate = (flags & 8) != 0;
        this.allow_cancel = bAllowCancel;
        if (this.allow_retry) {
            ++numButtons;
        }
        if (this.allow_continue) {
            ++numButtons;
        }
        if (this.allow_propagate) {
            ++numButtons;
        }
        if (this.allow_cancel) {
            ++numButtons;
        }
        if (numButtons == 1) {
            numButtons = 2;
        }
        LWContainer hintPanel = new LWContainer();
        hintPanel.setLayout((LayoutManager)new GridLayout(numButtons, 1, 0, 0));
        centerPanel.add((Component)hintPanel, (Object)"Center");
        Font hintFont = new Font(OiixResourceBundle.getFont(), OiixLanguage.getFontStyle(2), 11);
        String hintStr = OiixResourceBundle.getString("S_HELP_HINT");
        LWLabel help_hint = new LWLabel(hintStr);
        help_hint.setFont(hintFont);
        hintPanel.add((Component)help_hint);
        if (this.allow_retry) {
            hintStr = OiixResourceBundle.getString("S_RETRY_HINT");
            LWLabel retry_hint = new LWLabel(hintStr);
            retry_hint.setFont(hintFont);
            hintPanel.add((Component)retry_hint);
        }
        if (this.allow_continue) {
            hintStr = OiixResourceBundle.getString(0 == type ? "S_IGNORE_HINT" : "S_CONTINUE_HINT");
            LWLabel continue_hint = new LWLabel(hintStr);
            continue_hint.setFont(hintFont);
            hintPanel.add((Component)continue_hint);
        }
        if (this.allow_propagate) {
            hintStr = OiixResourceBundle.getString("S_PROPAGATE_HINT");
            LWLabel propagate_hint = new LWLabel(hintStr);
            propagate_hint.setFont(hintFont);
            hintPanel.add((Component)propagate_hint);
        }
        if (!(this.allow_continue || this.allow_retry || this.allow_propagate)) {
            hintStr = OiixResourceBundle.getString(bAllowCancel ? "S_OK_HINT" : "S_OK_CONTINUE_HINT");
            cancel_hint = new LWLabel(hintStr);
            cancel_hint.setFont(hintFont);
            hintPanel.add((Component)cancel_hint);
        } else if (bAllowCancel) {
            hintStr = OiixResourceBundle.getString("S_CANCEL_HINT");
            cancel_hint = new LWLabel(hintStr);
            cancel_hint.setFont(hintFont);
            hintPanel.add((Component)cancel_hint);
        }
        LWContainer buttonPanel = new LWContainer();
        buttonPanel.setLayout((LayoutManager)new GridLayout(1, numButtons, 5, 1));
        centerPanel.add((Component)buttonPanel, (Object)"South");
        String buttonStr = OiixResourceBundle.getString("S_HELP_BUTTON");
        this._help = new LWButton(buttonStr);
        this._help.setLeftmost(true);
        this._help.addActionListener((ActionListener)this);
        buttonPanel.add((Component)this._help);
        if (this.allow_retry) {
            buttonStr = OiixResourceBundle.getString("S_RETRY_BUTTON");
            this._retry = new LWButton(buttonStr);
            this._retry.addActionListener((ActionListener)this);
            buttonPanel.add((Component)this._retry);
        }
        if (this.allow_continue) {
            buttonStr = OiixResourceBundle.getString(0 == type ? "S_IGNORE_BUTTON" : "S_CONTINUE_BUTTON");
            this._continue = new LWButton(buttonStr);
            this._continue.addActionListener((ActionListener)this);
            buttonPanel.add((Component)this._continue);
        }
        if (this.allow_propagate) {
            buttonStr = OiixResourceBundle.getString("S_PROPAGATE_BUTTON");
            this._propagate = new LWButton(buttonStr);
            this._propagate.addActionListener((ActionListener)this);
            buttonPanel.add((Component)this._propagate);
        }
        if (!(this.allow_retry || this.allow_continue || this.allow_propagate)) {
            buttonStr = OiixResourceBundle.getString("S_OK_BUTTON");
            this._cancel = new LWButton(buttonStr);
            this._cancel.setRightmost(true);
            this._cancel.addActionListener((ActionListener)this);
            buttonPanel.add((Component)this._cancel);
        } else if (bAllowCancel) {
            buttonStr = OiixResourceBundle.getString("S_CANCEL_BUTTON");
            this._cancel = new LWButton(buttonStr);
            this._cancel.setRightmost(true);
            this._cancel.addActionListener((ActionListener)this);
            buttonPanel.add((Component)this._cancel);
        }
        OiifmKeyActionConverter keyActionConverter = new OiifmKeyActionConverter((PushButton)this._cancel, (PushButton)this._help, this);
        this.addKeyListener(keyActionConverter);
        OiifmMnemonicOps.processMnemonic((Container)centerPanel);
        this.addWindowListener(this);
        this.validate();
        this.m_bCancel = true;
    }

    public void setExitOnCancel(boolean exitFlag) {
        this.m_bExitOnCancel = exitFlag;
    }

    public void setEnabledRetry(boolean enabled) {
        this._retry.setEnabled(enabled);
    }

    @Override
    public void setEnableCancel(boolean bFlag) {
        this.m_bCancel = bFlag;
    }

    private void onCancel() {
        if (!(this.allow_retry || this.allow_continue || this.allow_propagate)) {
            this._buttonPressed = 16;
            this.setVisible(false);
        } else if (this.m_bCancel && this.allow_cancel) {
            if (this._cancelHandler == null) {
                this._cancelHandler = this.m_bCancelAllOnly ? OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(5, null, 0) : OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(7, null, 0);
            }
            int cancelResult = this._cancelHandler.doCancelOperation();
            this._cancelHandler.dispose();
            this._cancelHandler = null;
            switch (cancelResult) {
                case 1: {
                    this._buttonPressed = 16;
                    this.setVisible(false);
                    break;
                }
                case 2: {
                    this._buttonPressed = 32;
                    this.setVisible(false);
                    break;
                }
            }
        } else {
            this._buttonPressed = 16;
            this.setVisible(false);
        }
    }

    private void onExit() {
        if (!(this.allow_retry || this.allow_continue || this.allow_propagate)) {
            this._buttonPressed = 16;
            this.setVisible(false);
        } else if (this.m_bCancel && this.allow_cancel) {
            String title = OiixResourceBundle.getString("S_EXIT_TITLE");
            String message = OiixResourceBundle.getString("S_CANCEL_ALL_EXIT_WARNING");
            int cancelVal = 1;
            cancelVal = OiifmAlert.displayAlert(title, message, 30, 3, 1, 10);
            switch (cancelVal) {
                case 1: {
                    this._buttonPressed = 16;
                    this.setVisible(false);
                }
                case 2: {
                    break;
                }
            }
        } else {
            this._buttonPressed = 16;
            this.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._retry) {
            this._buttonPressed = 2;
            this.setVisible(false);
        } else if (source == this._continue) {
            this._buttonPressed = 4;
            this.setVisible(false);
        } else if (source == this._propagate) {
            this._buttonPressed = 8;
            this.setVisible(false);
        } else if (source == this._cancel) {
            if (this.m_bExitOnCancel) {
                this.onExit();
            } else {
                this.onCancel();
            }
        } else if (source == this._help) {
            OiixHelp.displayInstHelp("OiifdInstallErrorDlg");
        }
    }

    @Override
    public int doModal(String sMsg, int flags, int type) {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)WindowUtils.parentFrame((Component)((Object)this)));
        this._help.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        return this._buttonPressed;
    }

    @Override
    public int doModal(String sMsg) {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)WindowUtils.parentFrame((Component)((Object)this)));
        this._help.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        return this._buttonPressed;
    }

    @Override
    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)WindowUtils.parentFrame((Component)((Object)this)));
        this._help.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        return this._buttonPressed;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.onCancel();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

