/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import oracle.bali.share.nls.StringUtils;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmKeyActionConverter;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdInstallCancelDlg
extends BufferedDialog
implements ActionListener,
ItemListener,
WindowListener,
OiicInstallCancelHandler {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 32;
    private static final int INSETS = 10;
    private static final int CONTENT_GAP = 5;
    private int _buttonPressed;
    private LWButton _help;
    private LWButton _ok;
    private LWCheckboxGroup _radioButtonGroup;
    private LWCheckbox _allButton;
    private LWCheckbox _thisButton;
    private LWButton _cancel;
    private LWLabel _allLabel;
    private String m_prompt;
    private int m_dlgType;
    private int m_flags;
    private OiifmGraphicInterfaceManager m_interfaceManager;
    private boolean m_bUseRadioButtons = true;

    public OiifdInstallCancelDlg(OiifmGraphicInterfaceManager interfaceManager, int flags, String msg, int type) {
        super((Frame)((Object)interfaceManager.getMainFrame()), StringUtils.stripMnemonic((String)OiixResourceBundle.getString("S_CANCEL_BUTTON")), true);
        this.m_interfaceManager = interfaceManager;
        this.setBackground(Color.lightGray);
        if (type == 1) {
            this.setTitle(OiixResourceBundle.getString("S_ERROR"));
        }
        this.m_dlgType = type;
        this.m_flags = flags;
        this.setLayout(new BorderLayout());
        LWContainer mainPanel = new LWContainer();
        mainPanel.setLayout((LayoutManager)new BorderLayout());
        mainPanel.setBorderPainter((BorderPainter)new FixedBorderPainter(10, 10, 10, 10));
        this.add((Component)mainPanel, "Center");
        LWContainer centerPanel = new LWContainer();
        centerPanel.setLayout((LayoutManager)new BorderLayout(1, 1));
        mainPanel.add((Component)centerPanel, (Object)"Center");
        this.m_prompt = msg != null ? msg : "";
        MultiLineLabel promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.m_prompt);
        centerPanel.add((Component)promptLabel, (Object)"North");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 0;
        LWContainer checkPanel = new LWContainer();
        checkPanel.setLayout((LayoutManager)gridbag);
        centerPanel.add((Component)checkPanel, (Object)"Center");
        this._radioButtonGroup = new LWCheckboxGroup();
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0) {
                this._allButton = new LWCheckbox(OiixResourceBundle.getString("S_CANCEL_ALL"), this._radioButtonGroup, true);
                gridbag.setConstraints((Component)this._allButton, c);
                checkPanel.add((Component)this._allButton);
                this._allButton.addItemListener((ItemListener)this);
            } else {
                this._allLabel = new LWLabel(OiixResourceBundle.getString("S_CANCEL_ALL_WARNING"));
                gridbag.setConstraints((Component)this._allLabel, c);
                checkPanel.add((Component)this._allLabel);
                this.m_bUseRadioButtons = false;
            }
        }
        if ((flags & 2) != 0) {
            this._thisButton = new LWCheckbox(OiixResourceBundle.getString("S_CANCEL_THIS"), this._radioButtonGroup, false);
            this._thisButton.setEnabled(true);
            gridbag.setConstraints((Component)this._thisButton, c);
            checkPanel.add((Component)this._thisButton);
            this._thisButton.addItemListener((ItemListener)this);
        }
        LWContainer buttonPanel = new LWContainer((LayoutManager)new BorderLayout());
        centerPanel.add((Component)buttonPanel, (Object)"South");
        LWContainer tmpPanel = new LWContainer((LayoutManager)new GridLayout(1, 2, 5, 0));
        buttonPanel.add((Component)tmpPanel, (Object)"East");
        this._help = new LWButton(OiixResourceBundle.getString("S_HELP_BUTTON"));
        this._help.setLeftmost(true);
        this._help.addActionListener((ActionListener)this);
        tmpPanel.add((Component)this._help);
        this._ok = new LWButton(OiixResourceBundle.getString("S_OK_BUTTON"));
        this._ok.addActionListener((ActionListener)this);
        this._ok.setLeftmost(true);
        tmpPanel.add((Component)this._ok);
        if ((flags & 4) != 0 && type != 1) {
            this._cancel = new LWButton(OiixResourceBundle.getString("S_CANCEL_BUTTON"));
            this._cancel.setRightmost(true);
            this._cancel.addActionListener((ActionListener)this);
            tmpPanel.add((Component)this._cancel);
        }
        OiifmKeyActionConverter keyActionConverter = new OiifmKeyActionConverter((PushButton)this._cancel, (PushButton)this._help, this);
        this.addKeyListener(keyActionConverter);
        OiifmMnemonicOps.processMnemonic((Container)mainPanel);
        this.validate();
        this.addWindowListener(this);
    }

    public int doModal() {
        this.pack();
        WindowUtils.centerWindow((Window)((Object)this), (Component)WindowUtils.parentFrame((Component)((Object)this)));
        this._help.requestFocus();
        Toolkit.getDefaultToolkit().beep();
        this.setVisible(true);
        return this._buttonPressed;
    }

    @Override
    public int doCancelOperation() {
        return this.doModal();
    }

    @Override
    public int doCancelOperation(String sMsg) {
        return this.doModal();
    }

    @Override
    public int doCancelOperation(boolean isExit) {
        return this.doCancelOperation();
    }

    private void beginLogDialog() {
        Object[] logArr = new String[]{this.getTitle(), this.m_prompt};
        String logTxt = OiixResourceBundle.getString("S_LOG_DIALOG");
        OiiolTextLogger.appendText(MessageFormat.format(logTxt, logArr));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        this.beginLogDialog();
        String resultStr = OiixResourceBundle.getString("S_LOG_USER_SEL");
        if (source == this._ok) {
            String selStr = "";
            LWCheckbox selection = this._radioButtonGroup.getSelectedCheckbox();
            if (selection == this._allButton) {
                selStr = StringUtils.stripMnemonic((String)OiixResourceBundle.getString("S_CANCEL_ALL"));
                this._buttonPressed = 1;
            } else if (selection == this._thisButton) {
                selStr = StringUtils.stripMnemonic((String)this._thisButton.getLabel());
                this._buttonPressed = 2;
                OiicInstallTimeSession oSession = this.m_interfaceManager.getSession();
                if (oSession != null && oSession instanceof OiicInstallSession) {
                    ((OiicInstallSession)oSession).setSuccessfullInstallation(false);
                }
            } else {
                this._buttonPressed = -1;
            }
            OiiolTextLogger.appendText(resultStr + selStr + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
            this.setVisible(false);
        } else if (source == this._cancel) {
            this._buttonPressed = 4;
            OiiolTextLogger.appendText(resultStr + this._cancel.getLabel() + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
            this.setVisible(false);
        } else if (source == this._help) {
            OiixHelp.displayInstHelp("OiifdInstallCancelDlg");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object source = event.getItem();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.beginLogDialog();
        String resultStr = OiixResourceBundle.getString("S_LOG_USER_SEL");
        if ((this.m_flags & 4) != 0 && this.m_dlgType != 1) {
            if (!this.m_bUseRadioButtons) {
                this._buttonPressed = -1;
                OiiolTextLogger.appendText(resultStr + OiixResourceBundle.getString("S_CANCEL_BUTTON") + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
                this.setVisible(false);
            } else {
                this.handleSelection();
            }
        } else {
            LWCheckbox selection = this._radioButtonGroup.getSelectedCheckbox();
            this._buttonPressed = selection == this._allButton || selection == null ? 1 : (selection == this._thisButton ? 2 : -1);
            OiiolTextLogger.appendText(resultStr + this._radioButtonGroup.getSelectedCheckbox().getLabel() + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
            this.setVisible(false);
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void handleSelection() {
        String resultStr = OiixResourceBundle.getString("S_LOG_USER_SEL");
        LWCheckbox selection = this._radioButtonGroup.getSelectedCheckbox();
        OiicInstallTimeSession oSession = this.m_interfaceManager.getSession();
        if (selection == this._allButton || selection == null) {
            this._buttonPressed = 1;
            if (oSession != null && oSession instanceof OiicInstallSession) {
                ((OiicInstallSession)oSession).onBackIntoLocations();
            }
        } else if (selection == this._thisButton) {
            this._buttonPressed = 2;
            if (oSession != null && oSession instanceof OiicInstallSession) {
                ((OiicInstallSession)oSession).setSuccessfullInstallation(false);
            }
        } else {
            this._buttonPressed = -1;
        }
        String selStr = this._radioButtonGroup.getSelectedCheckbox().getLabel();
        OiiolTextLogger.appendText(resultStr + selStr + OiiolTextLogger.NEW_LINE, OiiolTextLogger.LOG_BASIC);
        this.setVisible(false);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

