/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifd.OiifdGenericDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmDirectoryDlg;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdDiskPromptDialog
extends OiifdGenericDlg {
    private String m_sPrompt;
    private LWContainer m_pBrowsePanel;
    private String m_sDefLocation;
    private LWButton m_fromBrowse;
    private OiifmDirectoryDlg m_fromDlg;
    private LWTextField m_fromField;
    private String m_sLabel;
    private int m_nDiskNum;

    public OiifdDiskPromptDialog(Frame f, String defLoc, int nDiskNum, String sLabel) {
        super(f, new LWContainer(), true, 3, true);
        this.m_sDefLocation = defLoc;
        this.m_nDiskNum = nDiskNum;
        this.m_sLabel = sLabel;
        this.initDlg();
    }

    private void initDlg() {
        this.setTitle(OiixResourceBundle.getString("S_MULTI_DISK_TITLE"));
        Object[] mArr = new String[]{this.m_sLabel, new Integer(this.m_nDiskNum).toString()};
        String mStr = OiixResourceBundle.getString("S_MULTI_DISK_PROMPT");
        this.m_sPrompt = MessageFormat.format(mStr, mArr);
        this.m_pBrowsePanel = this.createFromPanel(this.m_sPrompt);
        this.setHelpID("OiifdDiskPromptDlg");
        this.setPanel(this.m_pBrowsePanel);
        this.setPrefSize(390, 170);
    }

    private LWContainer createFromPanel(String prompt) {
        LWContainer pPanel = new LWContainer();
        pPanel.setLayout((LayoutManager)new BorderLayout());
        MultiLineLabel promptLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), prompt);
        promptLabel.setPreferredAspectRatio(0.0f);
        pPanel.add((Component)promptLabel, (Object)"North");
        LWContainer dPanel = new LWContainer();
        pPanel.add((Component)dPanel, (Object)"Center");
        GridBagLayout gridbag = new GridBagLayout();
        dPanel.setLayout((LayoutManager)gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 0, 10, 10);
        c.anchor = 18;
        c.weightx = 0.01;
        c.weighty = 0.98;
        c.gridwidth = 1;
        c.fill = 2;
        String locStr = OiixResourceBundle.getString("S_PATH_LABEL");
        LWLabel locLabel = new LWLabel(locStr);
        gridbag.setConstraints((Component)locLabel, c);
        dPanel.add((Component)locLabel);
        c.weightx = 0.98;
        c.gridwidth = -1;
        this.m_fromField = new LWTextField(this.m_sDefLocation);
        locLabel.setLabelFor((Component)this.m_fromField);
        gridbag.setConstraints((Component)this.m_fromField, c);
        dPanel.add((Component)this.m_fromField);
        LWButton m_browse = new LWButton(OiixResourceBundle.getString("S_BROWSE_BUTTON"));
        m_browse.addActionListener((ActionListener)this);
        c.weightx = 0.01;
        c.gridwidth = 0;
        this.m_fromBrowse = new LWButton(OiixResourceBundle.getString("S_BROWSE_BUTTON"));
        this.m_fromBrowse.addActionListener((ActionListener)this);
        this.m_fromBrowse.setRightmost(true);
        gridbag.setConstraints((Component)this.m_fromBrowse, c);
        dPanel.add((Component)this.m_fromBrowse);
        return pPanel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_fromBrowse) {
            this.onBrowse();
        }
        super.actionPerformed(event);
    }

    private void onBrowse() {
        if (this.m_fromDlg != null && this.m_fromDlg.isVisible()) {
            this.m_fromDlg.toFront();
        } else {
            File curDir;
            String selItem;
            OiipgFileSystem pgFS = new OiipgFileSystem();
            this.m_fromDlg = new OiifmDirectoryDlg(WindowUtils.parentFrame((Component)((Object)this)), OiixResourceBundle.getString("S_CHOOSE_DIR"));
            Object[] mArr = new String[]{this.m_sLabel, new Integer(this.m_nDiskNum).toString()};
            String sPrompt = OiixResourceBundle.getString("S_MULTI_DISK_BROWSE_PROMPT", mArr);
            this.m_fromDlg.setMessage(sPrompt);
            this.m_fromDlg.setCreateAllowed(false);
            this.m_fromDlg.setCenterOver((Component)((Object)this));
            DirectoryDrive[] volumes = pgFS.getDirectoryDrives();
            if (volumes != null) {
                this.m_fromDlg.setDrives(volumes);
            }
            if ((selItem = (selItem = this.m_fromField.getText()) != null ? selItem.trim() : "").length() == 0) {
                curDir = new File(System.getProperty("user.dir"));
            } else {
                curDir = new File(selItem);
                if (!curDir.exists()) {
                    curDir = new File(System.getProperty("user.dir"));
                } else {
                    try {
                        String sFileName = OiixPathOps.getFileCanonicalPath(selItem);
                        curDir = new File(sFileName);
                    }
                    catch (IOException sFileName) {
                        // empty catch block
                    }
                }
            }
            File chosenDir = this.m_fromDlg.runDialog(curDir);
            if (chosenDir != null) {
                String dirStr = chosenDir.getAbsolutePath();
                this.m_fromField.setText(dirStr);
            }
            this.m_fromDlg = null;
        }
    }

    public String getDiskLocation() {
        return this.m_fromField.getText();
    }
}

