/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.layout.EqualColumnLayout;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAction;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.oii.oiif.oiifb.OiifbConfigLauncher;
import oracle.sysman.oii.oiif.oiifd.OiifdGenericDlg;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifdConfigToolSelectionDlg
extends OiifdGenericDlg
implements ItemListener {
    private String[] m_toolNames;
    private IMicroStepStateReference[] m_plugIns;
    CfwSession m_cfSession;
    IMicroStepStateReference m_sSelectedPlugIn;
    private String m_sSelectedTool;
    private OiifbConfigLauncher m_configLauncher;

    public OiifdConfigToolSelectionDlg(Frame f, String[] sTools, OiifbConfigLauncher configLauncher) {
        super(f, null, true, 3);
        OiiolTextLogger.appendText("exit only tools execution in old style.");
        this.unsetPrefSize();
        this.m_toolNames = sTools;
        this.m_sSelectedTool = this.m_toolNames[0];
        this.m_configLauncher = configLauncher;
        super.setPanel(this.createMainPanel());
        this.setTitle(OiixResourceBundle.getString("S_EXIT_CONFIG_TITLE"));
        this.setHelpID("OiifdConfigToolSelectionDlg");
    }

    public OiifdConfigToolSelectionDlg(Frame f, IMicroStepStateReference[] sTools, CfwSession cfwSession) {
        super(f, null, true, 3);
        OiiolTextLogger.appendText("exit only tools execution in new style.");
        this.unsetPrefSize();
        this.m_plugIns = sTools;
        this.m_sSelectedPlugIn = this.m_plugIns[0];
        this.m_cfSession = cfwSession;
        super.setPanel(this.createMainPanel());
        this.setTitle(OiixResourceBundle.getString("S_EXIT_CONFIG_TITLE"));
        this.setHelpID("OiifdConfigToolSelectionDlg");
    }

    private LWContainer createMainPanel() {
        LWContainer panel = new LWContainer();
        panel.setLayout((LayoutManager)new BorderLayout(10, 10));
        String sPrompt = null;
        int l = -1;
        if (this.m_plugIns != null) {
            OiiolTextLogger.appendText("exit only tools in action: " + this.m_plugIns.length);
            l = this.m_plugIns.length;
        } else {
            OiiolTextLogger.appendText("exit only tools in action: 0");
            l = 0;
        }
        sPrompt = l > 1 ? OiixResourceBundle.getString("S_EXIT_MULTIPLE_CONFIG_PROMT") : OiixResourceBundle.getString("S_EXIT_SINGLE_CONFIG_PROMT");
        MultiLineLabel label = new MultiLineLabel(sPrompt);
        panel.add((Component)label, (Object)"North");
        panel.add((Component)this.createCenterPanel(), (Object)"Center");
        return panel;
    }

    private LWContainer createCenterPanel() {
        LWContainer panel = new LWContainer((LayoutManager)new EqualColumnLayout(10, 0, 0));
        LWCheckboxGroup group = new LWCheckboxGroup();
        int l = -1;
        if (this.m_plugIns != null) {
            OiiolTextLogger.appendText("exit only tools in action: " + this.m_plugIns.length);
            l = this.m_plugIns.length;
        } else {
            OiiolTextLogger.appendText("exit only tools in action: 0");
            l = 0;
        }
        for (int i = 0; i < l; ++i) {
            LWCheckbox radioBtn = null;
            String plugInName = OiixCFOps.getPlugInName(this.m_plugIns[i], this.m_cfSession);
            radioBtn = new LWCheckbox(plugInName, i == 0, group);
            radioBtn.setName(String.valueOf(i));
            panel.add((Component)radioBtn);
            radioBtn.addItemListener((ItemListener)this);
        }
        return panel;
    }

    @Override
    protected void onOk() {
        int nSelectedTool = 0;
        for (int i = 0; i < this.m_plugIns.length; ++i) {
            String plugInName = OiixCFOps.getPlugInName(this.m_plugIns[i], this.m_cfSession);
            String selectedPlugInName = OiixCFOps.getPlugInName(this.m_sSelectedPlugIn, this.m_cfSession);
            if (selectedPlugInName.compareTo(plugInName) != 0) continue;
            nSelectedTool = i;
            break;
        }
        String ownerAggrID = OiixCFOps.getAggregateID(this.m_plugIns[nSelectedTool], this.m_cfSession);
        IAggregate ownerAggr = OiixCFOps.getAggregate(this.m_cfSession, ownerAggrID);
        ActionType ownerAct = OiixCFOps.getActionType();
        IAction act = OiixCFOps.getAction(ownerAggr, ownerAct);
        int actionStepIndex = OiixCFOps.getActionStepIndex(this.m_plugIns[nSelectedTool], this.m_cfSession);
        int microStepIndex = OiixCFOps.getMicroStepIndex(this.m_plugIns[nSelectedTool], this.m_cfSession);
        try {
            act.performSelectedStep(false, actionStepIndex, microStepIndex);
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendText(ce.getMessage());
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source instanceof LWCheckbox && e.getStateChange() == 1) {
            int pos = Integer.parseInt(((LWCheckbox)source).getName());
            this.m_sSelectedPlugIn = this.m_plugIns[pos];
        }
    }
}

