/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifc;

import java.text.MessageFormat;
import java.util.Vector;
import oracle.sysman.oii.oiif.oiifc.OiifcCTTwoDDataSource;
import oracle.sysman.oii.oiif.oiifc.OiifcCTUtils;
import oracle.sysman.oii.oiif.oiifc.OiifcCompTree;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepBaseObject;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepCompObject;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngCmpListener;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepPatchObject;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifcCompTreeObject
implements OiiodIDepEngCmpListener {
    private OiifcCompTree m_cmpTree;
    private int m_row;
    private boolean m_userDetermined;
    protected boolean m_enabled;
    protected boolean m_patchEnabled;
    private OiiodIDepBaseObject m_iObject;
    private Vector m_vPaintData;
    private boolean m_selectionChanging;

    public OiifcCompTreeObject(OiifcCompTree cmpTree, int row, OiiodIDepBaseObject iObject) {
        this.m_cmpTree = cmpTree;
        this.m_row = row;
        this.m_iObject = iObject;
        this.m_patchEnabled = true;
        this.m_userDetermined = true;
        this.setEnabled(true);
        this.m_vPaintData = new Vector();
        this.m_selectionChanging = false;
    }

    public OiiodIDepBaseObject getInterfaceObject() {
        return this.m_iObject;
    }

    public boolean isUserDetermined() {
        return this.m_userDetermined;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isPatchEnabled() {
        return this.m_patchEnabled;
    }

    public int getRow() {
        OiifcCTTwoDDataSource ds = this.m_cmpTree.getDataSource();
        return ds.getRow(this);
    }

    public void setUserDetermined(boolean userDet) {
        this.m_userDetermined = userDet;
    }

    public void setSelected(boolean newlySelected) {
        this.m_selectionChanging = true;
        OiiodIDepBaseObject iObj = this.getInterfaceObject();
        if (iObj instanceof OiiodIDepCompObject) {
            boolean succeeded = false;
            succeeded = newlySelected ? ((OiiodIDepCompObject)iObj).select(this.m_cmpTree) : ((OiiodIDepCompObject)iObj).deselect(this.m_cmpTree);
            if (!succeeded) {
                this.m_selectionChanging = false;
            }
        }
        this.setEnabled(true);
        this.repaint();
    }

    public void selectPatchLevel(OiiiVersion selectedVersion) {
        OiiodIDepBaseObject iObject = this.getInterfaceObject();
        if (iObject != null && iObject instanceof OiiodIDepPatchObject) {
            OiiodIDepPatchObject oPatch = (OiiodIDepPatchObject)iObject;
            oPatch.selectPatchLevel(this.m_cmpTree, selectedVersion);
        }
    }

    public boolean setEnabled(boolean enabled) {
        OiiodIDepCompObject cObject;
        OiiodIDepBaseObject iObject = this.getInterfaceObject();
        if (iObject instanceof OiiodIDepPatchObject) {
            OiiodIDepPatchObject pObject = (OiiodIDepPatchObject)iObject;
            int installStatus = pObject.getInstallStatus();
            this.m_patchEnabled = installStatus == 3 ? false : (OiifcCTUtils.allowChildrenEnabled(this) ? enabled : false);
            if (pObject.isSelectable() && pObject.getInstallStatus() == 5) {
                enabled = true;
            }
        }
        if (iObject instanceof OiiodIDepCompObject && (!(cObject = (OiiodIDepCompObject)iObject).isSelectable() || cObject.getInstallStatus() == 3)) {
            enabled = false;
        }
        if (this.m_selectionChanging) {
            enabled = true;
        }
        this.m_enabled = enabled;
        return this.m_enabled;
    }

    public Vector getPaintDataVector() {
        if (this.m_vPaintData == null) {
            this.m_vPaintData = new Vector();
        }
        return this.m_vPaintData;
    }

    public boolean areAllSubCmpsSelected() {
        OiifcCTTwoDDataSource ds = this.m_cmpTree.getDataSource();
        int nRow = this.getRow();
        int nSize = ds.getDescendantCount(nRow);
        for (int i = nRow + 1; i <= nRow + nSize; ++i) {
            OiifcCompTreeObject ctobj = OiifcCTUtils.getExpandedCTObjectFromHGrid(this.m_cmpTree.getGrid(), 0, i);
            OiiodIDepBaseObject iObject = ctobj.getInterfaceObject();
            if (!(iObject instanceof OiiodIDepCompObject)) continue;
            OiiodIDepCompObject cObject = (OiiodIDepCompObject)iObject;
            if (!cObject.isSelected()) {
                return false;
            }
            if (ctobj.areAllSubCmpsSelected()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stateChanged(int stateID) {
        OiiodIDepBaseObject iObj;
        if ((stateID & 1) != 0) {
            this.setUserDetermined(this.m_selectionChanging);
            OiiodIDepBaseObject iObject = this.getInterfaceObject();
            if (iObject instanceof OiiodIDepCompObject) {
                OiiodIDepCompObject cObject = (OiiodIDepCompObject)iObject;
                boolean bEnable = cObject.isSelected() || cObject.getInstallStatus() == 5;
                this.m_cmpTree.enableSubtree(this.getRow(), bEnable);
                this.m_cmpTree.repaint();
            }
            this.m_selectionChanging = false;
        }
        if ((stateID & 2) != 0 && (iObj = this.getInterfaceObject()) instanceof OiiodIDepCompObject) {
            this.setEnabled(((OiiodIDepCompObject)iObj).isSelected());
        }
        if ((stateID & 4) != 0) {
            // empty if block
        }
        if ((stateID & 8) != 0) {
            // empty if block
        }
        if ((stateID & 0x10) != 0) {
            // empty if block
        }
        if ((stateID & 0x20) != 0) {
            // empty if block
        }
        this.repaint();
    }

    public void repaint() {
        OiifcCTTwoDDataSource ds = this.m_cmpTree.getDataSource();
        int nRow = this.getRow();
        ds.invalidateVisibleRow(nRow);
        while (ds.isRowVisible(nRow)) {
            if (nRow == -1) break;
            int parentRow = ds.getParentRow(nRow);
            ds.invalidateVisibleRow(parentRow);
            nRow = parentRow;
        }
    }

    public String toString() {
        return this.m_iObject.toString();
    }

    public String getCompStatusDisplayString() {
        String sStatus = null;
        if (this.m_iObject instanceof OiiodIDepPatchObject) {
            sStatus = this.getPatchISDisplayStr((OiiodIDepPatchObject)this.m_iObject);
        } else if (this.m_iObject instanceof OiiodIDepCompObject) {
            sStatus = this.getCompISDisplayStr((OiiodIDepCompObject)this.m_iObject);
        } else if (this.m_iObject instanceof OiiodIDepBaseObject) {
            sStatus = "";
        }
        return sStatus;
    }

    private String getPatchISDisplayStr(OiiodIDepCompObject obj) {
        int statusID = obj.getInstallStatus();
        String str = "";
        switch (statusID) {
            case 6: {
                str = OiixResourceBundle.getString("S_CTPATCH_NOT_INST");
                break;
            }
            case 3: 
            case 5: {
                str = this.getVersionInstalledStr(obj, true);
                break;
            }
            case 2: {
                str = OiixResourceBundle.getString("S_CTPATCH_REINST");
                break;
            }
            case 0: 
            case 1: {
                str = obj.isSelected() ? OiixResourceBundle.getString("S_CTPATCH_NEW_INST") : this.getVersionInstalledStr(obj, true);
            }
        }
        return str;
    }

    private String getCompISDisplayStr(OiiodIDepCompObject obj) {
        int statusID = obj.getInstallStatus();
        String str = "";
        switch (statusID) {
            case 6: {
                str = OiixResourceBundle.getString("S_CTCMP_NOT_INST");
                break;
            }
            case 3: 
            case 5: {
                str = this.getVersionInstalledStr(obj, false);
                break;
            }
            case 0: {
                str = OiixResourceBundle.getString("S_CTCMP_NEW_INST");
                break;
            }
            case 2: {
                str = OiixResourceBundle.getString("S_CTCMP_REINST");
                break;
            }
            case 1: {
                str = OiixResourceBundle.getString("S_CTCMP_UPGRADE");
            }
        }
        return str;
    }

    private String getVersionInstalledStr(OiiodIDepCompObject obj, boolean isPatch) {
        String str = "";
        OiiiVersion version = obj.getInstalledVersion();
        if (version != null) {
            Object[] arr = new String[]{version.toString()};
            str = isPatch ? OiixResourceBundle.getString("S_CTPATCH_VERSION_INST") : OiixResourceBundle.getString("S_CTCMP_VERSION_INST");
            str = MessageFormat.format(str, arr);
        } else {
            str = isPatch ? OiixResourceBundle.getString("S_CTPATCH_ALREADY_INST") : OiixResourceBundle.getString("S_CTCMP_ALREADY_INST");
        }
        return str;
    }
}

