/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.util.Vector;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.grid.AppearanceManager;
import oracle.ewt.grid.CellInputHandler;
import oracle.ewt.grid.ComplexAppearanceManager;
import oracle.ewt.grid.Grid;
import oracle.ewt.grid.GridSelection;
import oracle.ewt.grid.NullInputHandler;
import oracle.ewt.grid.SingleRowSelection;
import oracle.ewt.grid.hGrid.HDataObject;
import oracle.ewt.header.NullItemSelection;
import oracle.ewt.painter.Painter;
import oracle.ewt.table.SpreadTable;
import oracle.ewt.util.WindowUtils;
import oracle.sysman.oii.oiif.oiifc.OiifcCTGridDisablingPainter;
import oracle.sysman.oii.oiif.oiifc.OiifcCTHGrid;
import oracle.sysman.oii.oiif.oiifc.OiifcCTInstallStatusPainter;
import oracle.sysman.oii.oiif.oiifc.OiifcCTToolTipClient;
import oracle.sysman.oii.oiif.oiifc.OiifcCTTwoDDataSource;
import oracle.sysman.oii.oiif.oiifc.OiifcCTUtils;
import oracle.sysman.oii.oiif.oiifc.OiifcCompTreeObject;
import oracle.sysman.oii.oiif.oiifm.OiifmDetailsAlert;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepPatchNode;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepBaseObject;
import oracle.sysman.oii.oiio.oiiod.OiiodIDepEngErrListener;
import oracle.sysman.oii.oiio.oiiod.OiiodPatchesNode;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifcCompTree
extends SpreadTable
implements OiiodIDepEngErrListener {
    private static int NUM_COLS = 2;
    private static int S_CMP_COL_WIDTH = 395;
    private static int S_INSTALL_STATUS_COL_WIDTH = 120;
    private OiiodDepEngine m_depEngine;
    private boolean m_bShowAll = false;

    public OiifcCompTree(OiiodDepEngine depEngine) {
        this(depEngine, false);
    }

    public OiifcCompTree(OiiodDepEngine depEngine, boolean bShowAll) {
        this.m_depEngine = depEngine;
        this.m_bShowAll = bShowAll;
        OiifcCTTwoDDataSource ds = new OiifcCTTwoDDataSource(NUM_COLS, 0);
        Object[] colHeaders = new String[]{OiixResourceBundle.getString("S_CT_CMP_HEADER"), OiixResourceBundle.getString("S_CT_IS_HEADER")};
        ArrayOneDDataSource colDS = new ArrayOneDDataSource(colHeaders);
        Grid grid = this.getGrid();
        ds.setTreeObject(this);
        this.setDataSources((TwoDDataSource)ds, (OneDDataSource)colDS, null);
        this.initDataSource(ds);
        this.getColumnHeader().setHeaderSelection(NullItemSelection.getHeaderSelection());
        this.setFont(new Font(OiixResourceBundle.getFont(), 0, 11));
        this.setDefaultColumnWidth(S_INSTALL_STATUS_COL_WIDTH);
        this.setColumnWidth(0, S_CMP_COL_WIDTH);
        this.setHorizontalSeparatorsVisible(true);
        grid.setGridSelection((GridSelection)new SingleRowSelection());
        Vector proxies = OiifcCTUtils.createCTProxies(grid);
        grid.setColumnPainter(0, (Painter)proxies.elementAt(0));
        grid.setColumnCellInputHandler(0, (CellInputHandler)proxies.elementAt(1));
        grid.setColumnPainter(1, (Painter)new OiifcCTGridDisablingPainter((Painter)new OiifcCTInstallStatusPainter()));
        grid.setColumnCellInputHandler(1, NullInputHandler.getCellInputHandler());
        grid.setToolTipValue(OiifcCTToolTipClient.getToolTipClient());
        ComplexAppearanceManager appManager = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)appManager);
        Appearance appearance = appManager.getColumnAppearance(1);
        appearance.setForeground(Color.black);
        appearance.setBackground(Color.lightGray);
        appManager.setColumnAppearance(1, appearance);
    }

    public OiifcCTTwoDDataSource getDataSource() {
        TwoDDataSource data = this.getGrid().getDataSource();
        if (data instanceof OiifcCTTwoDDataSource) {
            return (OiifcCTTwoDDataSource)data;
        }
        return null;
    }

    protected void initDataSource(OiifcCTTwoDDataSource ds) {
        if (ds == null) {
            return;
        }
        this.addChildrenToTree(-1, null, true, 0);
    }

    public boolean hasItems() {
        return this.getDataSource().getRowCount() > 0;
    }

    public void enableSubtree(int row, boolean enable) {
        OiifcCTTwoDDataSource ds = this.getDataSource();
        int descendants = ds.getDescendantCount(row);
        for (int i = 1; i <= descendants; ++i) {
            OiifcCompTreeObject ctobj = OiifcCTUtils.getExpandedCTObjectFromHGrid(this.getGrid(), 0, row + i);
            OiiodIDepBaseObject iObj = ctobj.getInterfaceObject();
            ctobj.setEnabled(enable);
            if (!OiifcCTUtils.allowChildrenEnabled(ctobj) && enable) {
                int subcmpDesCount = ds.getDescendantCount(row + i);
                i += subcmpDesCount;
            }
            ctobj.repaint();
        }
    }

    public Vector getChildren(int parentRow, OiiodIDepBaseObject iParent, boolean enableChildren) {
        boolean childrenAreRoot;
        Vector children = null;
        boolean bl = childrenAreRoot = parentRow == -1;
        children = childrenAreRoot && iParent == null ? (!this.m_bShowAll ? this.m_depEngine.getVisibleTopLevelSelectors() : this.m_depEngine.getTopLevelSelectors()) : (!this.m_bShowAll ? iParent.getVisibleChildren() : iParent.getAllChildren());
        return children;
    }

    public void addChildrenToTree(int parentRow, OiiodIDepBaseObject iParent, boolean enableChildren, int nIter) {
        if (nIter > 2) {
            return;
        }
        OiifcCTTwoDDataSource ds = this.getDataSource();
        boolean childrenAreRoot = parentRow == -1;
        Vector children = this.getChildren(parentRow, iParent, enableChildren);
        if (children == null) {
            return;
        }
        boolean bAddNew = true;
        if (parentRow != -1 && ds.getDescendantCount(parentRow) > 0) {
            bAddNew = false;
        }
        int numChildren = children.size();
        if (bAddNew) {
            if (childrenAreRoot) {
                ds.addRootRows(0, numChildren);
            } else {
                ds.addChildrenRows(parentRow, numChildren);
            }
        }
        int newRowIndex = parentRow + 1;
        for (int i = 0; i < numChildren; ++i) {
            OiiodIDepBaseObject iObj = (OiiodIDepBaseObject)children.elementAt(i);
            boolean enableGC = enableChildren;
            OiifcCompTreeObject child = null;
            if (bAddNew) {
                child = new OiifcCompTreeObject(this, newRowIndex, iObj);
                child.setEnabled(enableChildren);
                iObj.addUIListener(child);
                for (int col = 0; col < NUM_COLS; ++col) {
                    ds.setExpandedData(col, newRowIndex, child);
                }
                enableGC = OiifcCTUtils.allowChildrenEnabled(child);
                if (iObj instanceof OiiodPatchesNode) {
                    OiiodPatchesNode opn = (OiiodPatchesNode)iObj;
                    OiiodDepPatchNode oiiodDepPatchNode = opn.getPatchNode(opn.getSelectedPatchLevel());
                }
            } else {
                HDataObject dataObj;
                Object data = ds.getExpandedData(0, newRowIndex);
                if (data instanceof HDataObject && (data = (dataObj = (HDataObject)data).getData()) instanceof OiifcCompTreeObject) {
                    child = (OiifcCompTreeObject)data;
                }
                if (child == null) continue;
                enableGC = OiifcCTUtils.allowChildrenEnabled(child);
            }
            this.addChildrenToTree(newRowIndex, iObj, enableGC, nIter + 1);
            if (iObj.isExpandedByDefault()) {
                ds.expandExpandedRow(newRowIndex);
            }
            newRowIndex += ds.getDescendantCount(newRowIndex) + 1;
        }
    }

    public OiiiCompInstallID getHilightedCompID() {
        OiiodIDepBaseObject obj;
        int[] selectedRows;
        Grid grid = this.getGrid();
        GridSelection selection = grid.getGridSelection();
        if (selection != null && (selectedRows = selection.getSelectedRows()) != null && selectedRows.length > 0 && (obj = OiifcCTUtils.getIObjectFromHGrid(grid, 0, selectedRows[0])) != null) {
            return obj.getCompInstallID();
        }
        return null;
    }

    @Override
    public void processError(String errmsg, Vector oDetails) {
        Frame f = WindowUtils.parentFrame((Component)((Object)this));
        String sTitle = OiixResourceBundle.getString("S_ERROR");
        OiifmDetailsAlert.displayError(f, sTitle, errmsg, oDetails);
    }

    @Override
    public int processWarning(String errmsg, Vector oDetails) {
        String sTitle = OiixResourceBundle.getString("S_CAUTION");
        Frame f = WindowUtils.parentFrame((Component)((Object)this));
        int nResult = OiifmDetailsAlert.displayAlert(f, 1, sTitle, errmsg, oDetails);
        nResult = nResult == 1 ? 0 : 1;
        return nResult;
    }

    protected Grid createGrid(TwoDDataSource ds) {
        return new OiifcCTHGrid(ds);
    }
}

