/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.lwAWT.LWContainer;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiif.oiifw.OiifwWizActionListener;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiSessionCloneVars;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisDialogLoadingException;
import oracle.sysman.oii.oiis.OiisDlgInElem;
import oracle.sysman.oii.oiis.OiisDlgInOutElem;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixHelpDetails;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;

public abstract class OiifbWizChainDlgElem
implements OiifbCondWizOperation,
OiifwWizActionListener,
Serializable {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x2000010;
    protected transient String m_helpKey = null;
    protected Vector m_dlgInElems = null;
    private boolean m_bDefValUsed = false;
    protected Vector m_dlgInOutElems = null;
    protected int m_wizardPageID = -1;
    protected Vector m_backupValues = null;
    protected OiisVariableOwner m_varOwner = null;
    protected OiicPullSession m_session = null;
    protected Object m_wizPanel = null;
    private String m_sTitle = null;
    private boolean m_bWCDEDisplayed = true;
    protected String m_sWizPanelClassName = null;
    private boolean m_bComponentDialog = false;
    private OiiiLibraryID m_libraryID = null;
    private String m_sDispCtrlVar = null;

    public void setComponentDialog(boolean bComponentDialog) {
        this.m_bComponentDialog = bComponentDialog;
        if (this.m_bComponentDialog) {
            this.logPageName();
        }
    }

    public boolean isComponentDialog() {
        return this.m_bComponentDialog;
    }

    public boolean isWCDEDisplayed() {
        return this.m_bWCDEDisplayed;
    }

    private void logPageName() {
        Object[] arr = new String[]{this.getDisplayName()};
        String logTxt = OiixResourceBundle.getString("S_LOG_PAGE");
        OiiolTextLogger.appendText(OiiolTextLogger.NEW_LINE + MessageFormat.format(logTxt, arr), OiiolTextLogger.LOG_BASIC);
    }

    protected void logDialog() {
        this.logInElems();
        this.logInOutElems();
    }

    private void logInElems() {
        int size = this.m_dlgInElems.size();
        for (int i = 0; i < size; ++i) {
            Object dispVal;
            OiisDlgInElem elem = (OiisDlgInElem)this.m_dlgInElems.elementAt(i);
            OiisVariable v = null;
            if (elem.isVarProp()) {
                v = this.m_varOwner.getVariable(elem.getVarName());
                dispVal = v.getLogValue();
            } else {
                dispVal = elem.getObject();
            }
            this.logDialogElem(elem.getProperty(), v, dispVal, elem.isSecure(), false);
        }
    }

    private void logInOutElems() {
        int size = this.m_dlgInOutElems.size();
        for (int i = 0; i < size; ++i) {
            OiisDlgInOutElem elem = (OiisDlgInOutElem)this.m_dlgInOutElems.elementAt(i);
            OiisVariable v = this.m_varOwner.getVariable(elem.getVarName());
            if (!v.getAdvice()) continue;
            this.logDialogElem(elem.getProperty(), v, v.getLogValue(), v.isSecure(), true);
        }
    }

    public void logDialogElem(String sName, OiisVariable oVar, Object oVal, boolean bProtected, boolean bInOut) {
        if (bProtected) {
            oVal = OiixResourceBundle.getString("S_LOG_PROTECTED_VALUE");
        } else if (oVal instanceof String[]) {
            oVal = OiiolTextLogger.StringArrayToStringBuf((String[])oVal);
        }
        Object[] args = null;
        String sResKey = "S_LOG_SETTING_PAGE_ELEM";
        if (!bInOut && oVar == null) {
            sResKey = "S_LOG_SETTING_PAGE_INELEM";
            args = new Object[]{sName, oVal};
        } else {
            args = new Object[]{sName, oVar.getName(), oVal, oVar.getValueTypeLogString()};
        }
        OiiolTextLogger.appendText(OiixResourceBundle.getString(sResKey, args), OiiolTextLogger.LOG_BASIC);
    }

    protected OiifbWizChainDlgElem(OiisVariableOwner vo) {
        this.m_varOwner = vo;
        this.m_backupValues = new Vector();
        this.m_dlgInElems = new Vector();
        this.m_dlgInOutElems = new Vector();
        this.m_session = this.m_varOwner.getSession();
    }

    @Override
    public void dispose() {
        if (this.m_backupValues != null) {
            this.m_backupValues.removeAllElements();
            this.m_backupValues = null;
        }
        if (this.m_dlgInElems != null) {
            this.m_dlgInElems.removeAllElements();
            this.m_dlgInElems = null;
        }
        if (this.m_dlgInOutElems != null) {
            this.m_dlgInOutElems.removeAllElements();
            this.m_dlgInOutElems = null;
        }
        if (this.m_helpKey != null) {
            this.m_helpKey = null;
        }
        this.m_sTitle = null;
        this.m_varOwner = null;
        if (this.m_wizPanel != null) {
            ((OiifpWizPanel)this.m_wizPanel).dispose();
            this.m_wizPanel = null;
        }
    }

    public void setTitle(String sTitle) {
        this.m_sTitle = sTitle;
    }

    public String getDisplayName() {
        if (this.m_wizPanel != null) {
            if (this.m_wizPanel instanceof OiifpWizPanel) {
                return ((OiifpWizPanel)this.m_wizPanel).getTitleLabel();
            }
        } else {
            if (this.m_sTitle != null) {
                return this.m_sTitle;
            }
            int nSize = this.m_dlgInElems.size();
            for (int i = 0; i < nSize; ++i) {
                Object dispVal;
                OiisDlgInElem elem = (OiisDlgInElem)this.m_dlgInElems.elementAt(i);
                if (!elem.getProperty().equals("TitleLabel")) continue;
                if (elem.isVarProp()) {
                    OiisVariable v = this.m_varOwner.getVariable(elem.getVarName());
                    dispVal = v.getValueForDisplay();
                } else {
                    dispVal = elem.getObject();
                }
                if (!(dispVal instanceof String)) break;
                this.m_sTitle = (String)dispVal;
                break;
            }
            if (this.m_sTitle == null) {
                this.m_sTitle = this.getName();
            }
        }
        return this.m_sTitle;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        if (this.isPreConditionsSet() || OiicPullSession.isDebugMode()) {
            this.logPageName();
        }
    }

    public void setWizPanel() {
    }

    public Vector getInOutElems() {
        return this.m_dlgInOutElems;
    }

    public OiisVariableOwner getVarOwner() {
        return this.m_varOwner;
    }

    public int getWizardPageID() {
        return this.m_wizardPageID;
    }

    public Vector getBackupValues() {
        return this.m_backupValues;
    }

    public void setBackupValues(Vector v) {
        this.m_backupValues = v;
    }

    public Vector getInElems() {
        return this.m_dlgInElems;
    }

    public Object getWizPanel() {
        return this.m_wizPanel;
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        int retVal;
        OiicSessionInterfaceManager osim = OiicSessionInterfaceManager.getInterfaceManager();
        if (!isBack) {
            this.registerCloneVars();
        }
        if ((retVal = osim.doWizardPageOperation(this, isBack)) != 1 && (OiicPullSession.isDebugMode() || this.isPreConditionsSet())) {
            this.logDialog();
        }
        if (retVal == 1 && osim.canNavigateBack()) {
            OiicExitCode.setExitCode(-5);
            osim.dispose();
            throw new OiifbEndIterateException("Exit On back");
        }
        return retVal;
    }

    protected void registerCloneVars() {
        OiiiSessionCloneVars sessionCloneVars = this.m_session.getSessionCloneVars();
        for (int i = 0; i < this.m_dlgInOutElems.size(); ++i) {
            OiisDlgInOutElem elem = (OiisDlgInOutElem)this.m_dlgInOutElems.elementAt(i);
            OiisVariable oVar = this.m_varOwner.getVariable(elem.getVarName());
            if (oVar == null || sessionCloneVars == null) continue;
            sessionCloneVars.addVariable(oVar);
        }
    }

    protected void setComponentVariables(boolean onlyBackup) throws OiisVarSettingException, OiifbCancelException {
    }

    @Override
    public int getNext() {
        return -1;
    }

    protected void setDialogProperties() {
    }

    protected void doSaveOperations() {
    }

    protected void unsetComponentVariables() {
    }

    protected void doUnsetOperations() {
    }

    protected void doSetOperations() throws OiisVarSettingException, OiifbCancelException {
    }

    @Override
    public boolean onNext() throws OiifbCancelException {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        try {
            OiixDebug.printTime("OiifbWizChainDlgElem", " starting time : ");
            OiifbWizChainDlgElem oiifbWizChainDlgElem = this;
            if (!oiifbWizChainDlgElem.m_session.isSilentMode() && this.m_wizPanel != null) {
                if (!((OiifpWizPanel)this.m_wizPanel).validateInput()) {
                    return false;
                }
                this.doSetOperations();
            }
        }
        catch (OiisVarSettingException vse) {
            String message = vse.getMessage();
            if (message == null) {
                Object[] msgArr = new String[]{" "};
                if (this.m_varOwner instanceof OiisCompContext) {
                    OiisCompContext oContext = (OiisCompContext)this.m_varOwner;
                    msgArr[0] = this.m_session.getStgCompDisplayName(oContext.getCompInstallID());
                }
                message = MessageFormat.format(OiixResourceBundle.getString("S_ERR_INTERVIEW"), msgArr);
            }
            OiifmAlert.displayAlert(OiixResourceBundle.getString("S_ERROR"), message, 50, 1, 20);
            return false;
        }
        return true;
    }

    @Override
    public boolean onBack() {
        return true;
    }

    @Override
    public void onHelp() {
    }

    protected void setDisplayControlVariable(String sVar) {
        this.m_sDispCtrlVar = sVar;
    }

    protected void setHelpKey(String key) {
        this.m_helpKey = key;
    }

    public String getHelpKey() {
        return this.m_helpKey;
    }

    public OiixHelpDetails getHelpDetails() {
        OiixHelpDetails helpDetails = new OiixHelpDetails(this.m_helpKey);
        return helpDetails;
    }

    @Override
    public void onExit() {
    }

    @Override
    public void onView(Vector vCompsList) {
    }

    @Override
    public void onExitConfirm() {
    }

    @Override
    public void onExitCancel() {
    }

    protected void setImage(String file) {
    }

    protected void imageNeeded(boolean need) {
    }

    protected final void bindVariable(OiiiCompInstallID cid, String varName, OiisAdvisedValue val) throws OiisVarSettingException, OiifbCancelException {
        OiicInstallSession instSession = (OiicInstallSession)this.m_varOwner.getSession();
        instSession.bindVariable(cid, varName, val);
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public LWContainer loadDialog(OiiiLibraryID lid, String dialogName) throws OiisDialogLoadingException, OiifbCancelException {
        this.setDlgLibId(lid);
        this.setWizPanelClassName(dialogName);
        this.setComponentDialog(true);
        return null;
    }

    public void addInElem(OiisDlgInElem elem) {
        this.m_dlgInElems.addElement(elem);
    }

    public void addInOutElem(OiisDlgInOutElem elem) {
        int index = OiixVectorOps.vectIndexOf(this.m_dlgInOutElems, (Object)elem);
        if (index == -1) {
            elem.setRefreshedDefaultValue(null);
            this.m_dlgInOutElems.addElement(elem);
        } else {
            OiisDlgInOutElem oElem = (OiisDlgInOutElem)this.m_dlgInOutElems.elementAt(index);
            oElem.setRefreshedDefaultValue(elem.getDefaultVal());
        }
    }

    public void setWizPanel(LWContainer panel) {
        this.m_wizPanel = panel;
    }

    public boolean validate() throws OiifbCancelException, OiifbEndIterateException {
        return true;
    }

    public void setWizardPageID(int wizardPageID) {
        this.m_wizardPageID = wizardPageID;
    }

    public void setWizPanelClassName(String sWizPanelClassName) {
        this.m_sWizPanelClassName = sWizPanelClassName;
    }

    public String getWizPanelClassName() {
        return this.m_sWizPanelClassName;
    }

    public void setDlgLibId(OiiiLibraryID libraryID) {
        this.m_libraryID = libraryID;
    }

    public OiiiLibraryID getDlgLibId() {
        return this.m_libraryID;
    }

    public final boolean showWCDE() {
        boolean bShowWCDE = this.canShowWCDE();
        this.setWCDEDisplayed(bShowWCDE);
        return bShowWCDE;
    }

    protected boolean canShowWCDE() {
        Object oVarValue;
        OiisVariable oVar;
        Vector vUnInitializedElems;
        boolean bShowWCDE = false;
        bShowWCDE = this.m_dlgInOutElems != null && this.m_dlgInOutElems.size() > 0 ? (vUnInitializedElems = this.getAllUnInitializedElems()) != null && vUnInitializedElems.size() > 0 : (this.m_sDispCtrlVar != null ? ((oVar = this.m_varOwner.getVariable(this.m_sDispCtrlVar)) == null ? true : (oVar.getType() == OiisVariable.BOOL ? (oVarValue = oVar.getValue()) == null || (Boolean)oVarValue != false : true)) : true);
        return bShowWCDE;
    }

    public void doBackOperations() {
    }

    protected void setWCDEDisplayed(boolean bDisplayed) {
        this.m_bWCDEDisplayed = bDisplayed;
    }

    public Vector getAllUnInitializedElems() {
        if (this.m_dlgInOutElems == null) {
            return null;
        }
        Vector<OiisDlgInOutElem> vNotsetProps = new Vector<OiisDlgInOutElem>(this.m_dlgInOutElems.size());
        Enumeration e = this.m_dlgInOutElems.elements();
        while (e.hasMoreElements()) {
            OiisDlgInOutElem elem = (OiisDlgInOutElem)e.nextElement();
            OiisVariable v = this.m_varOwner.getVariable(elem.getVarName());
            if (v.isValueSet() && v.getAdvice()) continue;
            vNotsetProps.addElement(elem);
        }
        return vNotsetProps;
    }

    public void setDefaultValuesUsed(boolean bDefValUsed) {
        this.m_bDefValUsed = bDefValUsed;
    }

    public boolean isDefaultValuesUsed() {
        return this.m_bDefValUsed;
    }

    public boolean isPreConditionsSet() {
        return true;
    }

    @Override
    public void onViewSetup() {
    }
}

