/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public abstract class OiifbWizChainCondElem
implements OiifbCondWizOperation {
    protected OiisVariableOwner m_varOwner;
    protected Vector m_varsUsed;
    protected Hashtable m_backValues;

    public OiifbWizChainCondElem(OiisVariableOwner vo) {
        this.m_varOwner = vo;
        this.m_varsUsed = new Vector();
        this.m_backValues = new Hashtable();
    }

    @Override
    public void dispose() {
    }

    private void saveUsedVars() {
        for (int i = 0; i < this.m_varsUsed.size(); ++i) {
            OiisVariable nextVar = this.m_varOwner.getVariable((String)this.m_varsUsed.elementAt(i));
            if (!nextVar.isValueSet()) continue;
            OiisAdvisedValue val = new OiisAdvisedValue(nextVar.getValue(), nextVar.getAdvice());
            this.m_backValues.put((String)this.m_varsUsed.elementAt(i), val);
        }
    }

    private void handleException(Exception vse) throws OiifbCancelException {
        int button_ops = 0;
        button_ops |= 1;
        button_ops |= 2;
        String sMsg = "";
        if (this.m_varOwner instanceof OiisCompContext) {
            OiisCompContext oContext = (OiisCompContext)this.m_varOwner;
            String displayName = this.m_varOwner.getSession().getStgCompDisplayName(oContext.getCompInstallID());
            if (displayName == null) {
                displayName = "";
            }
            Object[] arr = new String[]{displayName};
            sMsg = OiixResourceBundle.getString("S_ERR_INTERVIEW");
            sMsg = MessageFormat.format(sMsg, arr);
        }
        OiicInstallCancelHandler calcErrDlg = OiicSessionInterfaceManager.getInterfaceManager().getInstallCancelHandler(button_ops, sMsg + " " + vse.getMessage(), 1);
        int userInput = calcErrDlg.doCancelOperation();
        switch (userInput) {
            case 1: {
                throw new OiifbCancelException(vse.getMessage(), true);
            }
            case 2: {
                throw new OiifbCancelException(vse.getMessage(), false);
            }
        }
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        this.saveUsedVars();
        try {
            try {
                this.doCalculation();
            }
            catch (OiisVarSettingException vse) {
                if (System.getProperty("oracle.installer.exitOnVarValidationFailure", "false").equals("true")) {
                    String sMsg = vse.getMessage();
                    OiifmAlert.displayError(sMsg);
                    OiicExitCode.setExitCode(-2);
                    throw new OiifbEndIterateException(sMsg);
                }
                this.handleException(vse);
            }
        }
        catch (OiifbCancelException ce) {
            throw new OiifbEndIterateException(ce);
        }
    }

    public void doCalculation() throws OiifbCancelException, OiisVarSettingException {
    }

    @Override
    public final int doOperation(boolean isBack) {
        if (isBack) {
            for (int i = 0; i < this.m_varsUsed.size(); ++i) {
                OiisVariable nextVar = this.m_varOwner.getVariable((String)this.m_varsUsed.elementAt(i));
                OiisAdvisedValue prevVal = (OiisAdvisedValue)this.m_backValues.get((String)this.m_varsUsed.elementAt(i));
                if (prevVal != null) {
                    try {
                        this.m_varOwner.getVariable((String)this.m_varsUsed.elementAt(i)).setValue(prevVal, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                nextVar.unsetValue();
            }
        }
        return isBack ? 1 : 0;
    }

    @Override
    public abstract int getNext();

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public void addVarUsed(String s) {
        if (this.m_varsUsed == null) {
            this.m_varsUsed = new Vector();
        }
        this.m_varsUsed.addElement(s);
    }
}

