/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.sysman.oii.oiif.oiifd.OiifdReadmeDlg;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgSpawn;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawner;

public class OiifbSpawnReadme {
    private String m_toExec;
    private String m_readmeFile;
    private String m_prefTool;
    private BufferedFrame m_mainFrame;
    private OiifdReadmeDlg m_readmeDialog = null;

    public void spawn(BufferedFrame mainFrame, String toExec, String readmeFile, String prefTool) {
        this.m_toExec = toExec;
        this.m_readmeFile = readmeFile;
        this.m_mainFrame = mainFrame;
        this.m_prefTool = prefTool;
        this.showReadme();
    }

    private void showReadme() {
        int result = OiifdReadmeDlg.FILE_VIEWED;
        boolean bFirstTime = true;
        do {
            try {
                if (!this.m_prefTool.equals("")) {
                    String[] args = new String[]{this.m_readmeFile};
                    this.executeSpawner(this.m_prefTool, args);
                } else if (OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform()) == -3) {
                    this.executeSpawner(this.m_readmeFile, null);
                } else {
                    this.showViewerForReadme();
                }
                result = OiifdReadmeDlg.FILE_VIEWED;
            }
            catch (OiixSpawnException se) {
                if (!bFirstTime) {
                    Object[] sObj = new String[]{this.m_toExec};
                    String sMessage = OiixResourceBundle.getString("S_ERR_EXEC_README1");
                    sMessage = MessageFormat.format(sMessage, sObj);
                    OiifmAlert.displayError(sMessage);
                }
                bFirstTime = false;
                this.showViewerForReadme();
            }
        } while (result == OiifdReadmeDlg.SPAWN_VIEWER);
    }

    private void showViewerForReadme() {
        int result;
        if (this.m_readmeDialog == null) {
            File readmeToDisplay = new File(this.stripQuotes(this.m_readmeFile));
            this.m_readmeDialog = new OiifdReadmeDlg((Frame)this.m_mainFrame, readmeToDisplay);
        }
        if ((result = this.m_readmeDialog.doModal()) == OiifdReadmeDlg.SPAWN_VIEWER) {
            String newApp = this.m_readmeDialog.getApp();
            this.m_toExec = newApp + " " + OiixPathOps.getStandardForm(this.m_readmeFile);
        }
    }

    public void displayFile(BufferedFrame oFrame, String sDisplayFile) {
        if (sDisplayFile == null) {
            return;
        }
        String sDisplayTool = null;
        OiipgSpawn oSpawner = new OiipgSpawn();
        File fileToDisplay = new File(sDisplayFile = OiixPathOps.getNativeForm(sDisplayFile));
        if (fileToDisplay.exists()) {
            sDisplayTool = oSpawner.getFileViewer(sDisplayFile);
            if (sDisplayTool == null) {
                sDisplayTool = "";
            }
            if (!(sDisplayFile.indexOf(32) == -1 || sDisplayFile.startsWith("\"") && sDisplayFile.endsWith("\""))) {
                sDisplayFile = "\"" + sDisplayFile + "\"";
            }
            String toExec = sDisplayTool + " " + sDisplayFile;
            this.spawn(oFrame, toExec, sDisplayFile, sDisplayTool);
        } else {
            OiifmAlert.displayError(OiixResourceBundle.getString("S_ERR_FILE_NOT_FOUND") + fileToDisplay);
        }
    }

    private void executeSpawner(String toExec, String[] args) throws OiixSpawnException {
        this.executeSpawnerImpl(toExec, args);
    }

    private void executeSpawnerImpl(String toExec, String[] args) throws OiixSpawnException {
        OiixSpawner spawner = new OiixSpawner();
        Object[] sObj = new String[]{toExec};
        String sMessage = OiixResourceBundle.getString("S_README_LOG");
        sMessage = MessageFormat.format(sMessage, sObj);
        OiiolTextLogger.appendText(sMessage);
        spawner.beginExecute(toExec, args, null);
    }

    private String stripQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

