/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.io.File;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiif.oiifb.OiifbSpawnReadme;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifm.OiifmMainFrame;
import oracle.sysman.oii.oiis.OiisReadmeDetails;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiifbReadmeListener {
    OiicInstPostActionsPhase m_phase;
    OiicPullSession m_pullSession;

    public OiifbReadmeListener(OiicInstPostActionsPhase phase, OiicPullSession pullSession) {
        this.m_phase = phase;
        this.m_pullSession = pullSession;
    }

    public void onSelectReadme(String elementSelected, int index) {
        OiisReadmeDetails rd = this.m_phase.getReadmeDetails(index);
        String location = rd.getLocation();
        if (location == null) {
            return;
        }
        String prefTool = rd.getPreferredDisplayTool();
        if (prefTool == null) {
            prefTool = "";
        }
        location = OiixPathOps.getNativeForm(location);
        OiifmMainFrame mainFrame = this.m_pullSession.getMainFrame();
        File readmeToDisplay = new File(location);
        if (readmeToDisplay.exists()) {
            if (!(location.indexOf(32) == -1 || location.startsWith("\"") && location.endsWith("\""))) {
                location = "\"" + location + "\"";
            }
            String toExec = prefTool + " " + location;
            OiifbSpawnReadme sr = new OiifbSpawnReadme();
            sr.spawn(mainFrame, toExec, location, prefTool);
        } else {
            OiifmAlert.displayError(OiixResourceBundle.getString("S_ERR_FILE_NOT_FOUND") + readmeToDisplay);
        }
    }

    public void onSelectReadme(String sReadmeFileToBeShown) {
        if (this.m_pullSession != null) {
            OiifmMainFrame oMainFrame = this.m_pullSession.getMainFrame();
            OiifbSpawnReadme oSpawnReadme = new OiifbSpawnReadme();
            oSpawnReadme.displayFile(oMainFrame, sReadmeFileToBeShown);
        }
    }
}

