/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwIdentifier;
import oracle.sysman.emCfg.common.IActionState;
import oracle.sysman.emCfg.common.IActionStepState;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IMicroStepState;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.common.IPlugIn;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.common.IPlugInReference;
import oracle.sysman.emCfg.common.macros.PlugInInvocation;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OiifbConfigToolInfo {
    public static final int STATUS_PENDING = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_WAITING = 2;
    public static final int STATUS_SUCCEEDED = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_CANCELED = 5;
    public static final int STATUS_SKIPPED = 6;
    public static final int TOOLTYPE_RECOMMENDED = 0;
    public static final int TOOLTYPE_OPTIONAL = 1;
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16;
    private String m_sToolName;
    private int m_nToolType;
    private int m_nToolStatus;
    private int m_nAttempts;
    private String m_sOraHome;
    private String m_sActionID;
    private String m_sStepIndex;
    private String m_sMicroStepIndex;
    private String m_sTopLevelCompName;
    private String m_sTopLevelCompExtName;
    private String m_sAggrName;
    private String m_toolCommand;
    private IMicroStepStateReference m_oPluginRef;
    private String m_sExternalName = "";
    private String m_sToolArgs = "";

    public OiifbConfigToolInfo(String sToolName, int nToolType, int nToolStatus) {
        this.m_sToolName = sToolName;
        this.m_nToolType = nToolType;
        this.m_nToolStatus = nToolStatus;
    }

    public OiifbConfigToolInfo(CfwSession cfwSession, IAggregate aggr, IMicroStepStateReference sPlugin, int nToolStatus, String sTLCompName, String sTLCompExtName, String toolCommand, boolean bSilent) {
        this.m_oPluginRef = sPlugin;
        this.extractToolInfo(sPlugin, cfwSession, aggr, bSilent);
        this.m_nToolStatus = nToolStatus;
        this.m_sTopLevelCompName = sTLCompName;
        this.m_sTopLevelCompExtName = sTLCompExtName;
        this.m_toolCommand = toolCommand;
    }

    private void extractToolInfo(IMicroStepStateReference invocation, CfwSession cfwSession, IAggregate aggr, boolean bSilent) {
        IMicroStepState mstate = cfwSession.getMicroStepState(invocation);
        try {
            IActionState astate = mstate.getActionState();
            IActionStepState sstate = mstate.getActionStepState();
            this.m_nToolType = sstate.isRequired() ? 0 : 1;
            this.m_sToolName = mstate.getPlugInID();
            this.m_sExternalName = mstate.getPlugInID();
            this.m_sMicroStepIndex = mstate.getSelfID();
            this.m_sStepIndex = sstate.getSelfID();
            this.m_sActionID = astate.getSelfID();
            this.m_sOraHome = astate.getOriginator().getOracleHome();
            this.m_sAggrName = astate.getOriginator().getSelfID();
            IPlugInInvocationState pState = mstate.getPlugInInvocationState();
            String cmd = pState.getCommand() == null ? "#" : pState.getCommand();
            String args = PlugInInvocation.getNextInvocationArgs((IMicroStepState)mstate, (boolean)bSilent, (boolean)true) == null ? "" : PlugInInvocation.getNextInvocationArgs((IMicroStepState)mstate, (boolean)bSilent, (boolean)true);
            this.m_sToolArgs = this.m_sToolArgs.concat(cmd + " " + args);
            this.m_sToolArgs = this.m_sToolArgs.concat("\n");
            CfwIdentifier cident = new CfwIdentifier(astate.getOriginator().getSelfID());
            IAggregate aggrgate = cfwSession.getAggregate(cfwSession.getAggregateReference(cident));
            IPlugInReference[] allPlugIns = aggrgate.getPlugInReferences();
            for (int i = 0; i < allPlugIns.length; ++i) {
                IPlugIn plugIn = aggr.getPlugIn(allPlugIns[i]);
                if (!plugIn.getSelfID().equals(mstate.getPlugInID())) continue;
                this.m_sExternalName = plugIn.getLocalizedDisplayName();
                break;
            }
        }
        catch (CfwException ce) {
            OiiolTextLogger.appendErrorText(ce.getMessage());
            ce.printStackTrace();
        }
    }

    public String getToolArgs() {
        return this.m_sToolArgs;
    }

    public String getToolName() {
        return this.m_sToolName;
    }

    public String getActionID() {
        return this.m_sActionID;
    }

    public String getAggrName() {
        return this.m_sAggrName;
    }

    public String getStepIndex() {
        return this.m_sStepIndex;
    }

    public String getMicroStepIndex() {
        return this.m_sMicroStepIndex;
    }

    public String getOraHome() {
        return this.m_sOraHome;
    }

    public String getTopLevelCompName() {
        return this.m_sTopLevelCompName;
    }

    public String getTopLevelCompExtName() {
        return this.m_sTopLevelCompExtName;
    }

    public int getToolType() {
        return this.m_nToolType;
    }

    public int getToolStatus() {
        return this.m_nToolStatus;
    }

    public void setToolStatus(int nToolStatus) {
        this.m_nToolStatus = nToolStatus;
    }

    public void setAttempts(int nAttempts) {
        this.m_nAttempts = nAttempts;
    }

    public int getAttempts() {
        return this.m_nAttempts;
    }

    public String getToolCommand() {
        return this.m_toolCommand;
    }

    public void setToolCommand(String sToolCmd) {
        this.m_toolCommand = sToolCmd;
    }

    public void setExternalName(String sName) {
        this.m_sExternalName = sName;
    }

    public String getExternalName() {
        return this.m_sExternalName;
    }

    public IMicroStepStateReference getPluginReference() {
        return this.m_oPluginRef;
    }

    public void printDebugMsg() {
        String sMsg = "";
        sMsg = sMsg + " Tool External name  = " + this.m_sExternalName;
        sMsg = sMsg + " Aggregate Name  = " + this.m_sAggrName;
        sMsg = sMsg + " Oracle Home Name  = " + this.m_sOraHome;
        sMsg = sMsg + " Tool Internal Name  = " + this.m_sToolName;
        sMsg = sMsg + " Step Index   = " + this.m_sStepIndex;
        sMsg = sMsg + " Micro Step Index  = " + this.m_sMicroStepIndex;
        sMsg = sMsg + " Action ID  = " + this.m_sActionID;
        sMsg = sMsg + " Tool Command  = " + this.m_toolCommand;
        sMsg = sMsg + " Tool args Name  = " + this.m_sToolArgs;
        sMsg = sMsg + " Tool Attempts = " + this.m_nAttempts;
    }
}

