/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiif.oiifb;

import java.io.OutputStream;
import java.text.MessageFormat;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiiol.OiiolXMLConfigLog;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisPostInstallTool;
import oracle.sysman.oii.oiix.OiixBufferOutputStream;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixRunnableCmd;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixThreadLaunchException;
import oracle.sysman.oii.oiix.OiixThreadLauncher;
import oracle.sysman.oii.oiix.OiixWorkNotifiable;

public class OiifbConfigListener
implements OiixWorkNotifiable {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 16;
    public static final int reqAL = 1;
    public static final int optAL = 2;
    public static final int optNonAL = 3;
    public static final int FAILED = 1;
    public static final int SUCCEEDED = 0;
    public static final int CANCELED = -1;
    private OiixWorkNotifiable myClient = null;
    private OiicInstPostActionsPhase m_phase;
    private String m_toolName = null;
    private OiisPostInstallTool m_pTool;
    private OiixRunnableCmd m_runCmd = null;
    private int m_configToolResult = 1;
    private boolean m_bToolCanceled = false;
    private OutputStream m_configToolStream = null;
    private OiixThreadLauncher m_thrLauncher = null;

    public OiifbConfigListener(OiicInstPostActionsPhase phase) {
        this.m_phase = phase;
        this.m_thrLauncher = new OiixThreadLauncher();
    }

    public int onSelectConfig(String elementSelected, int index, int toolType, OutputStream results) {
        block12: {
            this.m_configToolResult = 1;
            this.m_bToolCanceled = false;
            this.m_configToolStream = results;
            this.m_pTool = null;
            this.m_toolName = null;
            switch (toolType) {
                case 1: {
                    this.m_pTool = this.m_phase.getReqConfigToolDetails(index).getPostInstallTool();
                    this.m_toolName = this.m_phase.getReqConfigToolDetails(index).getExternalName();
                    break;
                }
                case 2: {
                    this.m_pTool = this.m_phase.getOptALConfigToolDetails(index).getPostInstallTool();
                    this.m_toolName = this.m_phase.getOptALConfigToolDetails(index).getExternalName();
                    break;
                }
                case 3: {
                    this.m_pTool = this.m_phase.getOptNonALConfigToolDetails(index).getPostInstallTool();
                    this.m_toolName = this.m_phase.getOptNonALConfigToolDetails(index).getExternalName();
                }
            }
            int nToolLaunchType = 1;
            this.m_phase.getSession();
            if (OiicPullSession.isSilentMode()) {
                nToolLaunchType = 3;
            }
            if (this.m_phase.getSession().isCloneMode()) {
                if (this.m_pTool.isClone()) {
                    nToolLaunchType = 5;
                } else {
                    this.m_phase.getSession();
                    nToolLaunchType = OiicPullSession.isSilentMode() ? 3 : 1;
                }
            }
            String command = this.m_pTool.constructCommandLine(nToolLaunchType);
            OutputStream errStream = this.m_configToolStream != null ? this.m_configToolStream : new OiixBufferOutputStream();
            OutputStream outStream = this.m_configToolStream != null ? this.m_configToolStream : new OiixBufferOutputStream();
            this.m_runCmd = new OiixRunnableCmd(command, outStream, errStream);
            try {
                this.m_thrLauncher.setWorkNotifiable(this);
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_LAUNCHED_TOOL", new Object[]{this.m_toolName}));
                String sCommandToLog = this.m_pTool.constructLogCommand(nToolLaunchType);
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_COMMAND_SPAWNED", new Object[]{sCommandToLog}));
                this.m_thrLauncher.setWork(this.m_runCmd);
            }
            catch (OiixThreadLaunchException e) {
                OiiolTextLogger.appendText(errStream.toString());
                if (OiicPullSession.isSilentMode() || this.m_phase.getSession().isCloneMode()) {
                    OiiolTextLogger.appendErrorText(errStream.toString());
                }
                this.m_configToolResult = 1;
                this.m_thrLauncher.clearClient();
                if (this.myClient == null) break block12;
                this.myClient.workCompleted(this);
            }
        }
        return 1;
    }

    public int getResultFromLastTool() {
        return this.m_configToolResult;
    }

    public void setWorkNotifiable(OiixWorkNotifiable c) throws Exception {
        if (this.myClient != null) {
            throw new Exception("Too many listeners");
        }
        this.myClient = c;
    }

    public void clearClient() {
        this.myClient = null;
        this.m_runCmd = null;
    }

    public void stopRunningTool() {
        this.m_bToolCanceled = true;
        this.m_runCmd.stopRunningProcess();
    }

    private boolean isValidExitCode(int code) {
        return code == -1 || code == 1 || code == 0;
    }

    @Override
    public void workStarted(Object o) {
        if (this.myClient != null) {
            this.myClient.workStarted(this);
        }
    }

    @Override
    public void workCompleted(Object o) {
        block24: {
            Object[] tarr = new String[]{this.m_toolName};
            try {
                String lTxt;
                if (this.m_runCmd.isExceptionThrown()) {
                    throw this.m_runCmd.getException();
                }
                this.m_configToolResult = !this.m_bToolCanceled ? this.m_runCmd.getResultCode() : -1;
                if (!this.isValidExitCode(this.m_configToolResult)) {
                    this.m_configToolResult = 1;
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_LOG_INVALID_EXIT_CODE") + this.m_configToolResult);
                    if (OiicPullSession.isSilentMode()) {
                        OiiolTextLogger.appendErrorText(OiixResourceBundle.getString("S_LOG_INVALID_EXIT_CODE") + this.m_configToolResult);
                    }
                }
                if (this.m_configToolResult == 1) {
                    lTxt = OiixResourceBundle.getString("S_LOG_TOOL_FAILED");
                    lTxt = MessageFormat.format(lTxt, tarr);
                    OiiolTextLogger.appendText(lTxt);
                    if (OiicPullSession.isSilentMode()) {
                        OiiolTextLogger.appendErrorText(lTxt);
                    }
                    if (this.m_configToolStream != null && this.m_configToolStream instanceof OiixBufferOutputStream) {
                        OiixBufferOutputStream err = (OiixBufferOutputStream)this.m_configToolStream;
                        OiiolTextLogger.appendText(err.getContents());
                        if (OiicPullSession.isSilentMode()) {
                            OiiolTextLogger.appendErrorText(err.getContents());
                        }
                    }
                }
                if (this.m_configToolResult == -1) {
                    lTxt = OiixResourceBundle.getString("S_LOG_TOOL_CANCELED");
                    lTxt = MessageFormat.format(lTxt, tarr);
                    OiiolTextLogger.appendText(lTxt);
                    if (OiicPullSession.isSilentMode()) {
                        OiiolTextLogger.appendErrorText(lTxt);
                    }
                }
                if (this.m_configToolResult == 0) {
                    OiiiInstallCompInvEntry icie;
                    lTxt = OiixResourceBundle.getString("S_LOG_TOOL_SUCCEEDED");
                    lTxt = MessageFormat.format(lTxt, tarr);
                    OiiolTextLogger.appendText(lTxt);
                    OiisCompContext oCompContext = this.m_pTool.getCompContext();
                    OiicPullSession instSession = oCompContext.getSession();
                    OiicSessionPlan oSessionPlan = instSession.getSessionPlan();
                    if (this.m_pTool.isRequired()) {
                        oSessionPlan.setAdditionPhase(oCompContext.getCompInstallID(), 50);
                    }
                    if (this.m_pTool.needDeinstallLog() && (icie = (OiiiInstallCompInvEntry)oSessionPlan.getAdditionInfo(oCompContext.getCompInstallID())) != null) {
                        String sCompLoc;
                        OiiiCompInstallID oCompId = icie.getCompInstallID();
                        int ohIndex = ((OiicInstallSession)instSession).getHomeIndex(oCompId);
                        OiiiInstallAreaControl oInstAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
                        String sConfigLogLoc = oInstAreaControl.getXMLConfigLogLoc(ohIndex, sCompLoc = icie.getLocationInXMLInventory());
                        OiiolXMLConfigLog oConfigLog = this.m_phase.getConfigLog(sConfigLogLoc);
                        if (oConfigLog != null) {
                            oConfigLog.addConfigToolForDeinstallLog(this.m_pTool);
                        }
                    }
                }
            }
            catch (OiixSpawnException spx) {
                this.m_configToolResult = 1;
                String lTxt = OiixResourceBundle.getString("S_LOG_TOOL_FAILED");
                lTxt = MessageFormat.format(lTxt, tarr);
                OiiolTextLogger.appendText(lTxt);
                if (OiicPullSession.isSilentMode()) {
                    OiiolTextLogger.appendErrorText(lTxt);
                }
                if (this.m_configToolStream != null && this.m_configToolStream instanceof OiixBufferOutputStream) {
                    OiixBufferOutputStream err = (OiixBufferOutputStream)this.m_configToolStream;
                    OiiolTextLogger.appendText(err.getContents());
                    if (OiicPullSession.isSilentMode()) {
                        OiiolTextLogger.appendErrorText(err.getContents());
                    }
                }
            }
            catch (Exception e) {
                this.m_configToolResult = 1;
                String lTxt = OiixResourceBundle.getString("S_LOG_TOOL_FAILED");
                lTxt = MessageFormat.format(lTxt, tarr);
                OiiolTextLogger.appendText(lTxt);
                if (OiicPullSession.isSilentMode()) {
                    OiiolTextLogger.appendErrorText(lTxt);
                }
                if (this.m_configToolStream == null || !(this.m_configToolStream instanceof OiixBufferOutputStream)) break block24;
                OiixBufferOutputStream err = (OiixBufferOutputStream)this.m_configToolStream;
                OiiolTextLogger.appendText(err.getContents());
                if (!OiicPullSession.isSilentMode()) break block24;
                OiiolTextLogger.appendErrorText(err.getContents());
            }
        }
        if (this.m_configToolStream != null) {
            try {
                this.m_configToolStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.m_thrLauncher.clearClient();
        if (this.myClient != null) {
            this.myClient.workCompleted(this);
        }
    }
}

