/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiid;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import oracle.sysman.oii.oiic.OiicGlobalVarsReader;
import oracle.sysman.oii.oiic.OiicSessionVarsReader;
import oracle.sysman.oii.oiid.OiidVariableDef;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OiidVariablesList {
    private static Hashtable[] m_vVariableLists;
    private static Hashtable m_vGlobalVariables;
    private static OiidVariablesList m_fnsList;

    private static Hashtable getSessionVars() {
        OiicSessionVarsReader oReader = null;
        try {
            oReader = new OiicSessionVarsReader("OUI_Session_Variables.xml");
        }
        catch (OiixException e) {
            return new Hashtable();
        }
        return oReader.getSessionVars();
    }

    private static Map getGlobalVars() {
        String sVarPropsLoc = System.getProperty("variable.properties");
        if (null == sVarPropsLoc) {
            return new Hashtable();
        }
        File file = new File(sVarPropsLoc);
        String sLoc = file.getAbsolutePath();
        OiicGlobalVarsReader oReader = null;
        String sOuiLoc = System.getProperty("oracle.installer.oui_loc");
        if (null != sOuiLoc) {
            String sSchemaLoc = OiixPathOps.concatPath(sOuiLoc, OiixPathOps.concatPath("schema", "globalvars.xsd"));
            OiicGlobalVarsReader.setSchemaLoc(OiixPathOps.getStandardCanonicalPath(sSchemaLoc));
        }
        System.out.println("Loading global variables..");
        try {
            oReader = new OiicGlobalVarsReader(sVarPropsLoc);
        }
        catch (OiixException e) {
            System.out.println("Error: " + e.getErrorMessage());
            return new Hashtable();
        }
        System.out.print("Done");
        return oReader.getGlobalVariablesOSP();
    }

    public static OiidVariablesList getVariablesList() {
        return m_fnsList;
    }

    public static Enumeration getVariableNames() {
        return m_vVariableLists[4].keys();
    }

    public static Enumeration getVariableNames(int iType) {
        if (iType >= 0 && iType < m_vVariableLists.length) {
            Hashtable table = new Hashtable();
            table.putAll(m_vVariableLists[iType]);
            table.putAll(m_vGlobalVariables);
            return table.keys();
        }
        return null;
    }

    public static OiidVariableDef getVariable(String catName) {
        return (OiidVariableDef)m_vVariableLists[4].get(catName);
    }

    private void addVariableToList(String catName, OiidVariableDef defVar, int iType) {
        if (iType >= 0 && iType < m_vVariableLists.length) {
            m_vVariableLists[iType].put(catName, defVar);
        }
    }

    private static OiidVariablesList genVariablesLists() {
        m_vVariableLists = new Hashtable[5];
        OiidVariablesList.m_vVariableLists[0] = new Hashtable();
        OiidVariablesList.m_vVariableLists[1] = new Hashtable();
        OiidVariablesList.m_vVariableLists[2] = m_vVariableLists[1];
        OiidVariablesList.m_vVariableLists[3] = new Hashtable();
        OiidVariablesList.m_vVariableLists[4] = new Hashtable();
        m_vGlobalVariables = new Hashtable();
        OiidVariablesList fnsList = new OiidVariablesList();
        String catName = "APPLTOP";
        boolean bShow = false;
        String extendFrom = "OiisVariable";
        String descKey = "APPLTOP_DESC";
        boolean bValid = false;
        boolean bCalc = false;
        boolean bHandleError = false;
        int nType = 1;
        OiidVariableDef def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 4);
        catName = "APPLTOP_NAME";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "APPLTOP_NAME_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 4);
        catName = "INVENTORY_LOCATION";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "INVENTORY_LOCATION_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 4);
        catName = "ORACLE_HOME";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "ORACLE_HOME_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "ORACLE_HOME_NAME";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "ORACLE_HOME_NAME_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "ORACLE_HOME_KEY";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "ORACLE_HOME_KEY_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "ORACLE_HOME_FOLDER";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "ORACLE_HOME_FOLDER_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "ORACLE_HOME_SERVICE";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "ORACLE_HOME_SERVICE_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "CLUSTER_NODES";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "CLUSTER_NODES_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 4;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "REMOTE_NODES";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "S_REMOTE_NODES_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 4;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "LOCAL_NODE";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "S_LOCAL_NODE_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "ROOTSH_LOCATION";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "S_ROOTSH_LOCATION_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "PROD_HOME";
        bShow = true;
        extendFrom = "OiisProdHomeVar";
        descKey = "PROD_HOME_DESC";
        bValid = true;
        bCalc = true;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "PRE_REQUISITE";
        bShow = true;
        extendFrom = "OiisPreRequisiteVar";
        descKey = "PRE_REQUISTIE_DESC";
        bValid = false;
        bCalc = true;
        bHandleError = true;
        nType = 3;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 4);
        catName = "SELECTED_LANGUAGES";
        bShow = true;
        extendFrom = "OiisVariable";
        descKey = "COMPONENT_LANGUAGES_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 4;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 4);
        catName = "LOG_LOCATION";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "LOG_LOCATION_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 4);
        catName = "ORACLE_HOSTNAME";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "S_ORACLE_HOSTNAME_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 4);
        catName = "USE_OLD_INSTALL_PREREQS";
        bShow = false;
        extendFrom = "OiisVariable";
        descKey = "S_USE_OLD_INSTALL_PREREQS_DESC";
        bValid = false;
        bCalc = false;
        bHandleError = false;
        nType = 1;
        def = new OiidVariableDef(catName, nType, bShow, bValid, bCalc, extendFrom, descKey, bHandleError);
        fnsList.addVariableToList(catName, def, 3);
        fnsList.addVariableToList(catName, def, 1);
        fnsList.addVariableToList(catName, def, 0);
        fnsList.addVariableToList(catName, def, 4);
        m_vVariableLists[1].putAll(OiidVariablesList.getSessionVars());
        m_vVariableLists[4].putAll(OiidVariablesList.getSessionVars());
        m_vGlobalVariables.putAll(OiidVariablesList.getGlobalVars());
        m_vVariableLists[4].putAll(m_vGlobalVariables);
        return fnsList;
    }

    public static void main(String[] args) throws Exception {
        OiidVariablesList fList = new OiidVariablesList();
        fList = fList.getVariablesList();
        Enumeration categories = fList.getVariableNames();
        while (categories.hasMoreElements()) {
            String catName = (String)categories.nextElement();
            System.out.println("Variable found: " + catName);
            OiidVariableDef def = OiidVariablesList.getVariable(catName);
            System.out.println("Variable Values in: " + def);
        }
        for (int i = 0; i < 5; ++i) {
            System.out.println("Comp type:" + i);
            categories = OiidVariablesList.getVariableNames(i);
            System.out.println("categories = " + categories);
            while (categories.hasMoreElements()) {
                String catName = (String)categories.nextElement();
                System.out.println("Variable found: " + catName);
                OiidVariableDef def = OiidVariablesList.getVariable(catName);
                System.out.println("Variable Values in: " + def);
            }
        }
    }

    static {
        m_fnsList = OiidVariablesList.genVariablesLists();
    }
}

