/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicUpdateNodeList;
import oracle.sysman.oii.oiii.OiiiInventoryException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstallUtil;

public class OiicUpdateNodeListEx {
    private static OiicUpdateNodeListEx s_oUpdateNodeListEx = null;
    public static final String S_DELIMITER_COMMA = ",";

    public static OiicUpdateNodeListEx getOiicUpdateNodeListExInstance() {
        if (s_oUpdateNodeListEx == null) {
            s_oUpdateNodeListEx = new OiicUpdateNodeListEx();
        }
        return s_oUpdateNodeListEx;
    }

    public static void main(String[] args) {
        Properties p1 = new Properties(System.getProperties());
        HashMap h1 = new HashMap();
        h1 = (HashMap)p1.get("prop");
    }

    public List updateNodeListEx(String[] hostsToUpdate, String[] nodesWhereUpdate, String oracleHome, boolean isCRS, boolean isShared, boolean isLocal) {
        return this.updateNodeListEx(hostsToUpdate, nodesWhereUpdate, oracleHome, isCRS, isShared, isLocal, true);
    }

    public List updateNodeListEx(String[] hostsToUpdate, String[] nodesWhereUpdate, String oracleHome, boolean isCRS, boolean isShared, boolean isLocal, boolean m_updateLocalInventory, String invLoc) throws OiiiInventoryException {
        if (invLoc != null) {
            if (!new File(invLoc).exists()) {
                throw new OiiiInventoryException("Invalid invenotry location:" + invLoc, 4);
            }
            System.setProperty("oracle.installer.inventory_location", invLoc);
        }
        return this.updateNodeListEx(hostsToUpdate, nodesWhereUpdate, oracleHome, isCRS, isShared, isLocal, m_updateLocalInventory);
    }

    public List updateNodeListEx(String[] hostsToUpdate, String[] nodesWhereUpdate, String oracleHome, boolean isCRS, boolean isShared, boolean isLocal, boolean m_updateLocalInventory) {
        String logDir = OiiolTextLogger.getLogDir();
        OiixInstallUtil.setOption("oracle.installer.setCustomNodelist");
        OiixInstallUtil.setOption("oracle.installer.ouiApiMode");
        System.setProperty("DO_NOT_UPDATE_LOCAL_NODE_LIST", new Boolean(!m_updateLocalInventory).toString());
        OiixInstallUtil.setOption("oracle.installer.ignoreExitCode");
        OiicExitCode.setExitCodeToSuccess();
        OiicUpdateNodeList oUpdateNodeList = OiicUpdateNodeList.getOiicUpdateNodeListInstance();
        oUpdateNodeList.setBigClusterNodeList(hostsToUpdate);
        oUpdateNodeList.setClusterListForUpdateEx(nodesWhereUpdate);
        if (isCRS) {
            oUpdateNodeList.setCRSForUpdateEx(true);
        }
        oUpdateNodeList.updateLocalInventory(m_updateLocalInventory);
        String[] cmdStrList = this.getCommandLineArgs(oracleHome, isCRS, isShared, isLocal, nodesWhereUpdate, hostsToUpdate);
        oUpdateNodeList.main_helper(cmdStrList);
        List failedNodes = oUpdateNodeList.getFailedNodesList();
        OiiolTextLogger.setLogLoc(logDir);
        return failedNodes;
    }

    private String[] getCommandLineArgs(String oracleHome, boolean isCRS, boolean isShared, boolean isLocal, String[] nodesWhereUpdate, String[] hostsToUpdate) {
        String m_nodesWhereUpdate = OiixFunctionOps.implodeList(nodesWhereUpdate, S_DELIMITER_COMMA);
        String m_hostsToUpdate = OiixFunctionOps.implodeList(hostsToUpdate, S_DELIMITER_COMMA);
        Vector<String> cmdArgs = new Vector<String>();
        cmdArgs.add(new String("-updateNodeList"));
        cmdArgs.add(new String("-setCustomNodelist"));
        cmdArgs.add(new String("ORACLE_HOME=" + oracleHome));
        cmdArgs.add(new String("\"CLUSTER_NODES={" + m_nodesWhereUpdate + "}\""));
        cmdArgs.add(new String("NODES_TO_SET={" + m_hostsToUpdate + "}"));
        cmdArgs.add(new String("CRS=" + (isCRS ? "true" : "false")));
        if (isShared) {
            cmdArgs.add(new String("-cfs"));
        }
        if (isLocal) {
            cmdArgs.add(new String("-local"));
        }
        String[] sampleStringList = new String[cmdArgs.size()];
        String[] cmdStrList = cmdArgs.toArray(sampleStringList);
        return cmdStrList;
    }

    public int getStatus() {
        return OiicExitCode.getExitCode();
    }
}

