/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointFactory;
import oracle.sysman.oic.oics.OicsICheckPoint;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oic.oics.OicsICheckPointProperty;
import oracle.sysman.oic.oics.OicsICheckPointSession;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiMissingDependeeException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicUpdateNodeList
extends OiicBaseInventoryApp {
    private static OiicUpdateNodeList s_oUpdateNodeList = null;
    private static boolean m_updateLocalInventory = true;
    private static final String appName = "oui";
    private String sOBase = null;
    private String sOHomeLoc = null;
    private final String sComponent = "oui";
    private String sOHomeName;
    private String sFileName;
    private String chkpointFile;
    private static OicsICheckPointIndexSession cpis = null;
    private OicsICheckPointSession cps = null;
    private Vector nodeListBigCluster = null;
    private Vector newClusterList = null;
    private boolean isCRSEx = false;

    private OiicUpdateNodeList() {
        super(appName);
    }

    private OiicUpdateNodeList(String app) {
        super(app);
    }

    public static OiicUpdateNodeList getOiicUpdateNodeListInstance() {
        if (s_oUpdateNodeList == null) {
            s_oUpdateNodeList = new OiicUpdateNodeList();
        }
        return s_oUpdateNodeList;
    }

    @Override
    protected String getLogPrefix() {
        return "UpdateNodeList";
    }

    @Override
    public void doOperation(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiifbCancelException, IOException, OiixException, OiisVarSettingException, OiiiMissingDependeeException, OiipgClusterException {
        OicsICheckPoint cp2 = this.initCheckPointOps(oContext);
        OiiiOracleHomeInfo homeInfo = this.getOracleHomeInfo(iac, oContext);
        Object nodesToSet_Obj = oContext.getVarValue("NODES_TO_SET");
        Object[] nodesToSet = null;
        if (nodesToSet_Obj != null && nodesToSet_Obj.toString().length() > 0) {
            nodesToSet = (String[])nodesToSet_Obj;
        }
        if (OiixInstallUtil.isOptionSet("oracle.installer.setCustomNodelist") && !OiixUtil.isEmpty(nodesToSet)) {
            if (this.getClusterListForUpdateEx() != null) {
                oContext.setVarValue("CLUSTER_NODES", this.getClusterListForUpdateEx());
            }
            if (!OiixUtil.isEmpty(this.getBigClusterNodeList()) && OiixInstallUtil.isAPIMode()) {
                homeInfo.setNodeListBigCluster(this.getBigClusterNodeList());
            } else {
                homeInfo.setNodeListBigCluster((String[])nodesToSet);
            }
            homeInfo.setCRSHome(this.getCRSForUpdateEx());
        }
        boolean bSharedHome = this.isSharedHome(homeInfo.getLocation(), this.m_sLocalNode);
        this.updateOHProperties(homeInfo, oContext, bSharedHome);
        OiiiInstallInventory instinv = iac.getInstallInventory();
        instinv.setAllCompsVect(homeInfo.getIndex(), null);
        if (m_updateLocalInventory) {
            iac.saveInstallInventory();
        }
        if (!OiixUtil.isEmpty(this.m_saRemoteNodes)) {
            String sCustomInvPtrLoc = this.getCustomUnixInvPtrLoc();
            String[] clusterNodes = (String[])oContext.getVarValue("CLUSTER_NODES");
            if (!OiixUtil.isNullOrBlank(sCustomInvPtrLoc, true)) {
                this.setupRemoteInvPtrLoc(this.m_saRemoteNodes, sCustomInvPtrLoc);
            }
            boolean bGenerateGUID = OiixInstallUtil.isOptionSet("oracle.installer.generateGUID");
            if (bSharedHome) {
                bGenerateGUID = false;
            }
            if (!OiixUtil.isEmpty(nodesToSet) || this.getBigClusterNodeList() != null) {
                if (!OiixUtil.isEmpty(nodesToSet) && !OiixInstallUtil.isAPIMode()) {
                    this.setBigClusterNodeList((String[])nodesToSet);
                } else {
                    this.setBigClusterNodeList(this.getBigClusterNodeList());
                }
            }
            String invLoc = null;
            OiisVariable inv = oContext.getVariable("INVENTORY_LOCATION");
            if (inv != null) {
                invLoc = inv.getValueAsString();
            }
            this.clsCmdUpdateNodeList(clusterNodes, this.m_saRemoteNodes, this.m_sOracleHome, this.m_sOracleHomeName, homeInfo.isCRSHome(), this.m_sLocalNode, invLoc, sCustomInvPtrLoc, bSharedHome, bGenerateGUID);
        }
        this.endCheckPointOps(cp2);
    }

    private void endCheckPointOps(OicsICheckPoint cp2) {
        if (cp2 != null && this.cps != null) {
            OicsICheckPointProperty cpp = OicsCheckPointFactory.constructStringProperty((String)"LOCALNODE", (String)this.m_sLocalNode);
            cp2.addCheckPointProperty(cpp);
            cp2.setCheckPointState(3);
            this.cps.addCheckPoint(cp2);
            this.cps.saveCheckPointSession();
            try {
                this.cps.closeCheckPointSession();
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
    }

    private OicsICheckPoint initCheckPointOps(OiicSessionContext oContext) {
        String checkpointLoc;
        OicsICheckPointProperty cpp = null;
        OicsICheckPoint cp2 = null;
        String string = checkpointLoc = this.computeCheckPointLoc(oContext) == null ? null : this.computeCheckPointLoc(oContext);
        if (checkpointLoc != null) {
            this.initializeCheckPointIndexSession(checkpointLoc, appName);
        }
        this.initializeCheckPointSession(oContext);
        OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session for UpdateNodeList.");
        if (cpis != null) {
            cpp = this.sOBase != null ? OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)this.sOBase) : OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)"");
            this.cps = cpis.initCheckPointSession(this.sFileName);
            if (this.cps != null && (cp2 = this.cps.getCheckPoint("oracle.installer.updateNodeList")) == null) {
                cp2 = OicsCheckPointFactory.constructCheckPoint((int)1, (String)"oracle.installer.updateNodeList", (String)"This is the UpdateNodeList inventory operation");
                cp2.setCheckPointState(2);
                cp2.addCheckPointProperty(cpp);
                cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME_NAME", (String)this.sOHomeName);
                cp2.addCheckPointProperty(cpp);
                cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME", (String)this.sOHomeLoc);
                cp2.addCheckPointProperty(cpp);
                if (this.cps != null && cp2 != null) {
                    this.cps.addCheckPoint(cp2);
                }
            }
        }
        return cp2;
    }

    public void clsCmdUpdateNodeList(String[] nodeList, String[] nodesToRunOn, String oracleHome, String oracleHomeName, boolean bCRS, String currentNode, String invLoc, String invPtrLoc, boolean bSharedHome, boolean bGenerateGUID) {
        this.m_clsRunCmd = new OiipgClusterRunCmd(nodesToRunOn);
        String sNodeList = OiixFunctionOps.implodeList(nodeList, ",");
        String cmd = "";
        if (OiixInstallUtil.isOptionSet("oracle.installer.setCustomNodelist")) {
            String sCLSNodeList = OiixFunctionOps.implodeList(this.getBigClusterNodeList(), ",");
            cmd = "-updateNodeList -setCustomNodelist -noClusterEnabled ORACLE_HOME=" + oracleHome + " \"" + "CLUSTER_NODES={" + sNodeList + "}\"" + " \"" + "NODES_TO_SET={" + sCLSNodeList + "}\"";
        } else {
            cmd = "-updateNodeList -noClusterEnabled ORACLE_HOME=" + oracleHome + " \"" + "CLUSTER_NODES={" + sNodeList + "}\"";
        }
        if (!bGenerateGUID) {
            cmd = cmd + " -nogenerateGUID ";
        }
        cmd = cmd + " CRS=" + bCRS + " ";
        this.runRemoteInvOpCmd(cmd, nodesToRunOn, oracleHome, oracleHomeName, currentNode, invLoc, invPtrLoc, bSharedHome);
    }

    private void initializeCheckPointSession(OiicSessionContext s_context) {
        if (s_context != null) {
            String checkpointLoc;
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiicUpdateNodeList.");
            if (s_context.getVarValue("ORACLE_BASE") != null) {
                this.sOBase = (String)s_context.getVarValue("ORACLE_BASE");
            }
            if (s_context.getVarValue("ORACLE_HOME") != null) {
                this.sOHomeLoc = (String)s_context.getVarValue("ORACLE_HOME");
            }
            if (s_context.getVarValue("ORACLE_HOME_NAME") != null) {
                this.sOHomeName = (String)s_context.getVarValue("ORACLE_HOME_NAME");
            }
            String string = checkpointLoc = this.computeCheckPointLoc(s_context) == null ? null : this.computeCheckPointLoc(s_context);
            if (checkpointLoc != null) {
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(checkpointLoc, "checkpoints"));
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, appName));
                this.chkpointFile = "checkpoint_" + this.sOHomeName + ".xml";
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, this.chkpointFile));
                if (cpis != null) {
                    OiicExitOps.getExitOps().addIndexSessionObj(cpis);
                }
            }
        }
    }

    private String computeCheckPointLoc(OiicSessionContext s_context) {
        String oracleHome;
        String oracleBase;
        if (s_context.getVarValue("ORACLE_BASE") != null && (oracleBase = (String)s_context.getVarValue("ORACLE_BASE")) != null) {
            return oracleBase;
        }
        if (s_context.getVarValue("ORACLE_HOME") != null && (oracleHome = (String)s_context.getVarValue("ORACLE_HOME")) != null) {
            String temp = oracleHome;
            if (new File(temp = OiixPathOps.getNativeForm(OiixPathOps.concatPath(temp, "install"))).exists()) {
                return temp;
            }
            oracleHome = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHome, "inventory"));
            return oracleHome;
        }
        return null;
    }

    private void initializeCheckPointIndexSession(String checkPointLoc, String moduleName) {
        if (checkPointLoc != null && moduleName != null) {
            cpis = OicsCheckPointFactory.getIndexSession((String)checkPointLoc, (String)moduleName);
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiicUpdateNodeList.");
            OiiolTextLogger.appendText("Checkpoint:Location is- " + checkPointLoc);
        }
    }

    public static void main(String[] args) {
        OiicUpdateNodeList oUpdateNodeList = OiicUpdateNodeList.getOiicUpdateNodeListInstance();
        oUpdateNodeList.main_helper(args);
    }

    public void setBigClusterNodeList(String[] bigClusterNodeList) {
        this.nodeListBigCluster = this.nodeListBigCluster != null ? OiixVectorOps.strArr2Vect(bigClusterNodeList) : new Vector(OiixVectorOps.strArr2Vect(bigClusterNodeList));
    }

    public String[] getBigClusterNodeList() {
        return OiixVectorOps.vect2StrArr(this.nodeListBigCluster);
    }

    public void setClusterListForUpdateEx(String[] clusterList) {
        this.newClusterList = OiixVectorOps.strArr2Vect(clusterList);
    }

    public String[] getClusterListForUpdateEx() {
        if (this.newClusterList != null) {
            return OiixVectorOps.list2StrArr(this.newClusterList);
        }
        return null;
    }

    public void setCRSForUpdateEx(boolean flag) {
        this.isCRSEx = flag;
    }

    public boolean getCRSForUpdateEx() {
        return this.isCRSEx;
    }

    public void updateLocalInventory(boolean value) {
        m_updateLocalInventory = value;
    }
}

