/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodVolumeInfo;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicSummaryInformation {
    private OiicInstallTimeSession m_instTimeSession;
    private OiicSessionPlan m_sessionPlan = null;
    private OiiodDepEngine m_depEngine = null;
    private OiicSessionContext oContext = null;
    private Vector installIEs;
    private Vector comps;
    private List vNewInstalls;
    private List vReinstalls;
    private List vUpgrades;
    private List vDowngrades;
    private String[] remoteNodes;
    private Map volumesLocal = new HashMap();
    private Map volumesRemote = new HashMap();
    private boolean bDisplayClusterSpace = false;
    private boolean bAllVolsShared = true;
    private Vector volumesOnCFS = new Vector();

    public OiicSummaryInformation(OiicInstallTimeSession instTimeSession) {
        this.m_instTimeSession = instTimeSession;
        this.m_sessionPlan = this.m_instTimeSession.getSessionPlan();
        this.oContext = this.m_instTimeSession.getSessionContext();
        this.initialize();
    }

    private void initialize() {
        this.remoteNodes = (String[])this.oContext.getVarValue("REMOTE_NODES");
        if (this.m_instTimeSession instanceof OiicInstallSession && this.m_instTimeSession.isInstallMode()) {
            this.initializeInstallSession();
        } else if (this.m_instTimeSession instanceof OiicDeinstallSession && this.m_instTimeSession.isDeinstallMode()) {
            this.initializeDeinstallSession();
        } else if (this.m_instTimeSession instanceof OiicPullSession && this.m_instTimeSession.isCloneMode()) {
            this.initializeCloneSession();
        }
    }

    private void initializeInstallSession() {
        OiicInstallSession oSession = (OiicInstallSession)this.m_instTimeSession;
        this.m_depEngine = oSession.getDepEngine();
        this.computeProductsInfo();
        this.computeSpaceInfo();
    }

    private void initializeDeinstallSession() {
    }

    private void initializeCloneSession() {
    }

    private void computeProductsInfo() {
        this.installIEs = this.m_sessionPlan.getSuccessfulAdditions(10);
        this.comps = this.m_depEngine.getCompsToInstallAsOhVector();
        this.vNewInstalls = new ArrayList(10);
        this.vReinstalls = new ArrayList(5);
        this.vUpgrades = new ArrayList(5);
        this.vDowngrades = new ArrayList(5);
        int numElems = this.comps.size();
        block6: for (int i = 0; i < numElems; ++i) {
            OiiiCompIdOhPair coh = (OiiiCompIdOhPair)this.comps.elementAt(i);
            OiiiCompInstallID cid = coh.getCompID();
            if (cid.getCompType() != 4 && OiixVectorOps.vectIndexOf(this.installIEs, (Object)cid) == -1) continue;
            switch (coh.getCompInstallType()) {
                case 0: {
                    this.vNewInstalls.add(cid);
                    continue block6;
                }
                case 2: {
                    if (this.m_depEngine.isTopLevelSelComp(cid)) {
                        System.setProperty("oracle.installer.fastcopy", "false");
                        System.setProperty("oracle.installer.reinstallsession", "true");
                    }
                    this.vReinstalls.add(cid);
                    continue block6;
                }
                case 1: {
                    this.vUpgrades.add(cid);
                    continue block6;
                }
                case 3: {
                    this.vDowngrades.add(cid);
                }
            }
        }
    }

    private void computeSpaceInfo() {
        OiiodVolumeInfo oVolInfo;
        List oVolumeInfo = null;
        oVolumeInfo = !OiicPullSession.isLangAddonMode() ? this.m_depEngine.getRequiredSpace(false) : this.m_depEngine.getLangAddonRequiredSpace(this.installIEs);
        int nSize = oVolumeInfo.size();
        boolean[] abInvalidateOnUse = new boolean[nSize];
        if (this.remoteNodes != null && this.remoteNodes.length > 0) {
            this.bDisplayClusterSpace = true;
        }
        for (int i = 0; i < nSize; ++i) {
            oVolInfo = (OiiodVolumeInfo)oVolumeInfo.get(i);
            String sVolume = oVolInfo.getVolumeName();
            long[] obj = new long[]{oVolInfo.getRequiredSpace(), oVolInfo.getTempSpace(), oVolInfo.getTotalRequiredSpace(true), oVolInfo.getAvailableSpace()};
            abInvalidateOnUse[i] = obj[2] > obj[3];
            this.volumesLocal.put(sVolume, obj);
        }
        if (this.bDisplayClusterSpace) {
            String[] sVolume = new String[nSize];
            long[] lReqSize = new long[nSize];
            String[] sReqSpace = new String[nSize];
            boolean[] bCFS = new boolean[nSize];
            OiiodVolumeInfo[] oVolInfo2 = new OiiodVolumeInfo[nSize];
            for (int i = 0; i < nSize; ++i) {
                oVolInfo2[i] = (OiiodVolumeInfo)oVolumeInfo.get(i);
                sVolume[i] = oVolInfo2[i].getVolumeName();
                lReqSize[i] = oVolInfo2[i].getTotalRequiredSpace(false);
                bCFS[i] = oVolInfo2[i].isCFS();
                if (!bCFS[i]) {
                    this.bAllVolsShared = false;
                    continue;
                }
                this.volumesOnCFS.add(sVolume[i]);
            }
            if (!this.bAllVolsShared) {
                long lAvailSpaceCluster = 0L;
                for (int j = 0; j < this.remoteNodes.length; ++j) {
                    HashMap<String, long[]> nodeVolumeMap = new HashMap<String, long[]>();
                    for (int k = 0; k < nSize; ++k) {
                        if (bCFS[k]) continue;
                        lAvailSpaceCluster = oVolInfo2[k].getAvailableSpace(this.remoteNodes[j]);
                        long[] obj = new long[]{lAvailSpaceCluster, lReqSize[k]};
                        abInvalidateOnUse[k] = lReqSize[k] > lAvailSpaceCluster;
                        nodeVolumeMap.put(sVolume[k], obj);
                    }
                    this.volumesRemote.put(this.remoteNodes[j], nodeVolumeMap);
                }
            }
        }
        for (int j = 0; j < nSize; ++j) {
            oVolInfo = (OiiodVolumeInfo)oVolumeInfo.get(j);
            if (!abInvalidateOnUse[j]) continue;
            oVolInfo.invalidateAvailableSpace();
        }
    }

    public List getComponentsForInstall() {
        return this.vNewInstalls;
    }

    public List getComponentsForReinstall() {
        return this.vReinstalls;
    }

    public List getComponentsForUpgrade() {
        return this.vUpgrades;
    }

    public List getComponentsForDowngrade() {
        return this.vDowngrades;
    }

    public String[] getRemoteNodeNames() {
        return this.remoteNodes;
    }

    public Map getVolumeDetailsLocal() {
        return this.volumesLocal;
    }

    public Map getVolumeDetailsRemote(String remoteNode) {
        return (Map)this.volumesRemote.get(remoteNode);
    }

    public boolean displayClusterSpace() {
        return this.bDisplayClusterSpace;
    }

    public boolean allVolsShared() {
        return this.bAllVolsShared;
    }

    public boolean isVolumeOnCFS(String volumeName) {
        int index = this.volumesOnCFS.indexOf(volumeName);
        return index != -1;
    }
}

