/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.util.Locale;
import oracle.sysman.oii.oiic.OiicInventorySession;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiit.OiitDefaultConflictResolver;
import oracle.sysman.oii.oiit.OiitLockHeartbeat;
import oracle.sysman.oii.oiit.OiitLockMonitor;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiit.OiitTargetLocker;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiicStandardInventorySession
extends OiicInventorySession {
    private OiitLockHeartbeat m_lock;
    private OiiiInstallAreaControl m_instAreaControl;
    static final int DEFAULT_LOG = 0;
    static final int ALWAYS_LOG = 1;
    static final int DEFAULT_LOCK = 0;
    static final int ALWAYS_LOCK = 1;
    private int m_nLockType = 0;
    private int m_nAccessLevel = 0;
    private boolean reuseInventory;

    public OiicStandardInventorySession(String sAppID, String sAppVer) {
        super(sAppID, sAppVer);
    }

    public void initSession(int nAccessLevel) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        this.initSession(nAccessLevel, this.isWow64());
    }

    public void initSession(int nAccessLevel, int iCreateLog, int iAquireLocks) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        this.initSession(nAccessLevel, this.isWow64(), iCreateLog, iAquireLocks);
    }

    public void initSession(int nAccessLevel, boolean bWow64) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        this.initSession(nAccessLevel, bWow64, 0, 0);
    }

    public synchronized void initSession(int nAccessLevel, boolean bWow64, int iCreateLog, int iAquireLocks) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        OiixUtilityOps.displayStackTraceInformation(new Throwable());
        this.updateProperties();
        OiipgPropertyLoader.setWOW64(this.isWow64());
        this.m_nAccessLevel = nAccessLevel;
        Locale.setDefault(OiixLanguage.getDefaultLocale());
        this.initAreaControl(nAccessLevel, iAquireLocks);
        this.initLog(nAccessLevel, iCreateLog);
    }

    private void initAreaControl(int nAccessLevel, int iAquireLocks) throws OiiiInventoryDoesNotExistException, OiitTargetLockNotAvailableException, IOException, OiiiInstallInventoryReadException {
        OiiiInstallAreaControl existing = OiiiInstallAreaControl.getInstallAreaControl();
        String invLoc = null;
        if (existing != null) {
            invLoc = existing.getAreaRoot();
            this.reuseInventory = true;
        } else {
            invLoc = OiiiInstallAreaControl.getInventoryLocation();
        }
        if (nAccessLevel < 2) {
            this.acquireLocks(nAccessLevel, iAquireLocks, invLoc);
        }
        if (this.canUseExisting(nAccessLevel, existing)) {
            OiiolTextLogger.appendText("Using an existing InstallAreaControl for this Inventory Session with existing access level " + existing.getAccessLevel());
            this.m_instAreaControl = existing;
        } else {
            OiiolTextLogger.appendText("Creating a new Install area Control for this inventory session with new  access level  " + nAccessLevel);
            OiiiInstallAreaControl.initAreaControlWithAccessCheck(nAccessLevel, invLoc);
            this.m_instAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        }
    }

    private boolean canUseExisting(int nAccessLevel, OiiiInstallAreaControl existing) {
        return existing != null && existing.getAccessLevel() != 1 && nAccessLevel != 1;
    }

    private boolean isWow64() {
        boolean is64bit;
        String osname = OiixPlatform.getCurrentPlatformOSName();
        if (osname == null) {
            return false;
        }
        if (!osname.contains("windows") && !osname.contains("Windows")) {
            return false;
        }
        String jvmArch = System.getProperty("os.arch", "");
        boolean bl = is64bit = System.getenv("ProgramFiles(x86)") != null;
        return !jvmArch.contains("64") && is64bit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean conflictingLocksDetected() throws IOException {
        boolean bLockDetected = true;
        if (this.m_nAccessLevel != 2) {
            if (this.m_nAccessLevel != 0) throw new IllegalStateException("This method cannot be called for read/write sessions");
            if (this.m_nLockType != 0) throw new IllegalStateException("This method cannot be called for read/write sessions");
            return ((OiitLockMonitor)this.m_lock).isLockDetected();
        }
        try {
            this.acquireLocks(0, 0, null);
            bLockDetected = false;
            this.releaseLocks();
            return bLockDetected;
        }
        catch (OiitTargetLockNotAvailableException ioe1) {
            return true;
        }
    }

    public void endSession() {
        OiiolTextLogger.appendText("Ending the inventory Session ");
        OiixUtilityOps.displayStackTraceInformation(new Throwable());
        if (!this.reuseInventory) {
            OiiolTextLogger.appendText("Disposing the install area control objects");
            OiiiInstallAreaControl.dispose();
            this.m_instAreaControl = null;
        }
        this.dispose();
        this.releaseLocks();
        OiiolTextLogger.setEnabled(true);
    }

    public OiiiInstallAreaControl getInstallAreaControl() {
        return this.m_instAreaControl;
    }

    private void acquireLocks(int nAccessLevel, int iLockType, String invLoc) throws OiitTargetLockNotAvailableException, IOException {
        if (invLoc == null && this.m_instAreaControl != null) {
            invLoc = this.m_instAreaControl.getAreaRoot();
        }
        OiitDefaultConflictResolver cl = new OiitDefaultConflictResolver();
        OiitTargetLocker tl = new OiitTargetLocker(invLoc, cl);
        if (nAccessLevel == 1 || iLockType == 1) {
            this.m_lock = tl.getWriterLock();
            this.m_nLockType = iLockType;
        } else {
            this.m_lock = tl.getWriterLockMonitor();
        }
    }

    private void releaseLocks() {
        if (this.m_lock != null) {
            this.m_lock.releaseLock();
            this.m_lock = null;
        }
    }

    private void updateProperties() {
        String sOUILoc = System.getProperty("oracle.installer.oui_loc");
        if (sOUILoc == null) {
            this.computeDefaultOUILoc();
        }
        if (sOUILoc != null && System.getProperty("oracle.installer.library_loc", null) == null) {
            String sLibraryLoc = OiixPathOps.concatPath(sOUILoc, "lib");
            sLibraryLoc = OiixPathOps.concatPath(sLibraryLoc, OiixPlatform.getCurrentPlatformDirectoryName());
            sLibraryLoc = OiixPathOps.getNativeForm(sLibraryLoc);
            System.setProperty("oracle.installer.library_loc", sLibraryLoc);
        }
        String clusterSwitch = "false";
        if (this.m_nAccessLevel == 1) {
            clusterSwitch = System.getProperty("oracle.installer.clusterSwitch", "true");
        }
        System.setProperty("oracle.installer.clusterSwitch", clusterSwitch);
        OiipgPropertyLoader.setUnixPtrFileLocFromSysProps();
    }

    private void initLog(int nAccessLevel, int iCreateLog) throws IOException {
        if (nAccessLevel == 1 || iCreateLog == 1) {
            OiiolTextLogger.setLogLoc(this.m_instAreaControl.getLogsLoc(), this.getAppID());
        } else {
            OiiolTextLogger.setEnabled(false);
        }
    }

    private void computeDefaultOUILoc() {
        String sOUILoc;
        Class<?> oClass = null;
        try {
            oClass = Class.forName("oracle.sysman.oii.oiic.OiicStandardInventorySession");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            OiiolTextLogger.appendText("Error occurred while trying to find class oracle/sysman/oii/oiic/OiicStandardInventorySession");
        }
        if (oClass != null && (sOUILoc = oClass.getProtectionDomain().getCodeSource().getLocation().getPath()) != null && !sOUILoc.equalsIgnoreCase("")) {
            sOUILoc = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sOUILoc));
            sOUILoc = OiixPathOps.getNativeForm(OiixPathOps.getParentDir(sOUILoc));
            System.setProperty("oracle.installer.oui_loc", sOUILoc);
        }
    }
}

