/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstAccessSetupWCCE;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPickSelMethodWCCE;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionPlan;
import oracle.sysman.oii.oiic.OiicStagePlan;
import oracle.sysman.oii.oiic.OiicStageTimeSession;
import oracle.sysman.oii.oiic.OiicStagingProgressListener;
import oracle.sysman.oii.oiic.OiicStgDepWizEngine;
import oracle.sysman.oii.oiic.OiicTLCompsStage;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmGraphicInterfaceManager;
import oracle.sysman.oii.oiif.oiifm.OiifmMainFrame;
import oracle.sysman.oii.oiif.oiifw.OiifwPubInvCompsSelWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwPubLoginWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwStgDepSetPlanWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwStgEndSessionWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwStgLocWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwStgTopLevelSelWCDE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiStageAreaControl;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiis.OiisCompJarLoader;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisCompStaging;
import oracle.sysman.oii.oiis.OiisDepInfo;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;

public class OiicStageSession
extends OiicPullSession
implements OiicStageTimeSession {
    private static final boolean s_debug = true;
    private static final int s_debugCategory = 4;
    private Hashtable m_IDsToComps;
    private static final int STG_LOC_IND = 0;
    private static final int PUB_LOGIN_IND = 1;
    private static final int ACC_SETUP_IND = 2;
    private static final int PICK_SEL_MTHD_IND = 3;
    private static final int STG_PICK_COMPS_IND = 4;
    private static final int PUBINV_PICK_COMPS_IND = 5;
    private static final int DEP_ENGINE_IND = 6;
    private static final int STG_COMPS_IND = 7;
    private static final int STG_DONE_IND = 8;
    private OiicStagingProgressListener m_stgProgListener;
    private OiifbProgressControl m_progCtrl;

    public OiicStageSession(OiicInstaller install, boolean silentMode) {
        super(install, silentMode);
        System.out.println("After calling constructor of OiicPullSession..");
        this.m_IDsToComps = new Hashtable();
        this.setSessionPlan(new OiicStagePlan());
    }

    public OiicStageSession(OiicInstaller install) {
        this(install, false);
    }

    public void setStagingProgressListener(OiicStagingProgressListener lstnr) {
        this.m_stgProgListener = lstnr;
    }

    public void setProgressControl(OiifbProgressControl progCtrl) {
        this.m_progCtrl = progCtrl;
    }

    @Override
    public OiifmMainFrame getMainFrame() {
        OiicSessionInterfaceManager interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        if (interfaceManager instanceof OiifmGraphicInterfaceManager) {
            OiifmGraphicInterfaceManager graphicInterfaceManager = (OiifmGraphicInterfaceManager)interfaceManager;
            return graphicInterfaceManager.getMainFrame();
        }
        return null;
    }

    @Override
    public Vector getIterElements() {
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>();
        OiifwStgLocWCDE StgLoc = new OiifwStgLocWCDE(this.m_sessionContext, 1, 2);
        iterEls.addElement(StgLoc);
        OiifwPubLoginWCDE pubLogin = new OiifwPubLoginWCDE(this.m_sessionContext, 2);
        iterEls.addElement(pubLogin);
        OiicInstAccessSetupWCCE setupAccess = new OiicInstAccessSetupWCCE(this.m_sessionContext, 3);
        iterEls.addElement(setupAccess);
        OiicPickSelMethodWCCE pickSelMthd = new OiicPickSelMethodWCCE(this, 4, 5);
        iterEls.addElement(pickSelMthd);
        OiifwStgTopLevelSelWCDE tlSelWCDE = new OiifwStgTopLevelSelWCDE(this.m_sessionContext, 6);
        iterEls.addElement(tlSelWCDE);
        OiifwPubInvCompsSelWCDE selPIComps = new OiifwPubInvCompsSelWCDE(this.m_sessionContext, 6);
        iterEls.addElement(selPIComps);
        OiicStgDepWizEngine depWEngine = new OiicStgDepWizEngine(this.m_sessionContext, 7);
        iterEls.addElement(depWEngine);
        OiicTLCompsStage stgComps = new OiicTLCompsStage(this, 8);
        iterEls.addElement(stgComps);
        OiifwStgEndSessionWCDE endSession = new OiifwStgEndSessionWCDE(this.m_sessionContext);
        iterEls.addElement(endSession);
        return iterEls;
    }

    @Override
    public void initSession() {
        this.m_namespaceTable = new Hashtable();
        this.m_sessionContext = new OiicSessionContext(this);
        this.m_namespaceTable.put(this.m_sessionContext, new Hashtable());
        try {
            this.m_sessionContext.setVariables();
        }
        catch (OiifbEndIterateException oiifbEndIterateException) {
            // empty catch block
        }
    }

    public void setChosenPlats(Vector plats) throws OiisVarSettingException, OiifbCancelException {
        OiicSessionContext sCntxt = this.getSessionContext();
        OiisVariable selPlats = sCntxt.getVariable("SELECTED_PLATFORMS");
        String[] platCNs = OiixPlatform.platIDsToCommonNameArray(plats);
        selPlats.setValue(platCNs);
    }

    public OiicSessionPlan computeStagingPlan() {
        OiicSessionContext sCntxt = this.getSessionContext();
        OiifwStgDepSetPlanWCCE planner = new OiifwStgDepSetPlanWCCE(sCntxt);
        planner.setStagingProgressListener(this.m_stgProgListener);
        planner.initialize();
        return this.getSessionPlan();
    }

    public void executeStagingPlan() throws OiifbEndIterateException {
        OiicTLCompsStage stager = new OiicTLCompsStage(this, -1);
        stager.setStagingProgressListener(this.m_stgProgListener);
        stager.setProgressControl(this.m_progCtrl);
        stager.initialize();
        stager.doOperation(false);
    }

    @Override
    public void setupAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException {
        String stageSource = (String)this.m_sessionContext.getVariable("STAGE_TO_LOCATION").getValue();
        stageSource = OiixPathOps.getStandardForm(stageSource);
        this.setTargetAreaControl(new OiiiStageAreaControl(stageSource));
        super.setupAccessObjects();
        this.setupTopLevelList(false);
        OiixProgressListener progListener = this.getProgressListener();
        if (progListener != null) {
            progListener.onDoneProgress();
        }
    }

    @Override
    public OiiiStageAreaControl getStageAreaControl() {
        return (OiiiStageAreaControl)this.getTargetAreaControl();
    }

    @Override
    public boolean inRollbackMode() {
        return false;
    }

    public OiisCompStaging getCompStage(OiiiStageCompInvEntry scie) {
        Vector compStages = this.getCompStages(scie.getCompInstallID());
        int numCSs = compStages.size();
        OiisCompStaging retCS = null;
        for (int i = 0; i < numCSs; ++i) {
            OiisCompStaging cs = (OiisCompStaging)compStages.elementAt(i);
            OiiiStageCompInvEntry csie = cs.getStageCompInvEntry();
            if (!csie.equalTags(scie) || !csie.equalsIgnoringPlatsnTags(scie)) continue;
            retCS = cs;
            break;
        }
        return retCS;
    }

    public Vector getCompStages(OiiiCompInstallID cid) {
        if (!this.m_IDsToComps.containsKey(cid)) {
            OiiiStageAreaControl sac = this.getStageAreaControl();
            OiiiStageInventory trgtStgInv = sac.getStageInventory();
            Vector scies = this.getStageInventory().getCompatCompEntries2(cid, 0);
            try {
                int numScies = scies.size();
                Vector<OiisCompStaging> csVect = new Vector<OiisCompStaging>();
                for (int i = 0; i < numScies; ++i) {
                    String compJarLoc;
                    OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)scies.elementAt(i);
                    OiiiCompInstallID ieId = scie.getCompInstallID();
                    OiisCompStaging cs = new OiisCompStaging();
                    OiisDeps ieDeps = scie.getDeps();
                    if (ieDeps != null) {
                        cs.setDeps(new OiisDepInfo(ieDeps));
                    }
                    cs.setFileSizeInfo(scie.getFileSizeInfoEx());
                    OiiiStageCompInvEntry locscie = trgtStgInv.getMatchCompInvEntry(scie);
                    if (locscie == null) {
                        compJarLoc = this.m_sourceAccess.fetchCompInsJar(ieId, new Vector(), null);
                    } else {
                        String localLoc = locscie.getLocation();
                        compJarLoc = sac.genFileSysLoc(OiixPathOps.concatPath(localLoc, "compIns.jar"));
                    }
                    OiisCompJarLoader cjLoader = new OiisCompJarLoader(compJarLoc);
                    cs.setStageCompInvEntry(scie);
                    cs.setCompJarLoader(cjLoader);
                    csVect.addElement(cs);
                }
                this.m_IDsToComps.put(cid, csVect);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error in loading component staging..");
                return null;
            }
        }
        return (Vector)this.m_IDsToComps.get(cid);
    }

    public void addPlanStages(Vector scies) {
        int numInvs = scies.size();
        OiiiStageAreaControl sac = this.getStageAreaControl();
        for (int i = 0; i < numInvs; ++i) {
            OiiiStageCompInvEntry locscie = (OiiiStageCompInvEntry)scies.elementAt(i);
            OiiiCompInstallID cid = locscie.getCompInstallID();
            if (this.m_IDsToComps.containsKey(cid)) continue;
            try {
                OiisCompStaging cs = new OiisCompStaging();
                String localLoc = locscie.getLocation();
                String compJarLoc = sac.genFileSysLoc(OiixPathOps.concatPath(localLoc, "compIns.jar"));
                OiixDebug.debug("OiicStageSession", "Reading comp jar from " + compJarLoc);
                OiisCompJarLoader cjLoader = new OiisCompJarLoader(compJarLoc);
                cjLoader.loadCompStaging(cs);
                cs.setStageCompInvEntry(locscie);
                this.m_IDsToComps.put(cid, cs);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error in loading component staging..");
                return;
            }
        }
    }
}

