/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import oracle.sysman.oii.oiic.OiicAddNodeSession;
import oracle.sysman.oii.oiic.OiicCloneSession;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicGlobalContext;
import oracle.sysman.oii.oiic.OiicGlobalContextReaderWriter;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicISessionProxy;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicLangAddonSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiol.OiiolLogger;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiicSessionWrapper
implements OiifbWizOperation,
OiicISessionProxy {
    boolean firstRun = true;
    boolean m_repeat = true;
    OiicPullSession m_curSession = null;
    OiicSessionContext m_oCurSessionContext = null;
    OiicInstaller m_installer = null;
    OiicDeinstallSession m_curDeinstallSession = null;
    OiicSessionContext m_oDeinstallSessionContext = null;

    public OiicSessionWrapper(OiicInstaller installer, boolean bRepeat) throws OiifbEndIterateException {
        this.m_installer = installer;
        this.m_repeat = bRepeat;
        this.createNewSession(null);
    }

    public OiicPullSession getCurSession() {
        return this.m_curSession;
    }

    @Override
    public void dispose() {
        if (this.m_curSession != null) {
            if (this.m_oCurSessionContext != null) {
                OiicSessionWrapper oiicSessionWrapper = this;
                oiicSessionWrapper.m_oCurSessionContext.unsetResponseFile();
            }
            this.m_curSession.dispose();
            this.m_curSession = null;
        }
        if (this.m_curDeinstallSession != null) {
            if (this.m_oDeinstallSessionContext != null) {
                OiicSessionWrapper oiicSessionWrapper = this;
                oiicSessionWrapper.m_oDeinstallSessionContext.unsetResponseFile();
            }
            this.m_curDeinstallSession.dispose();
            this.m_curDeinstallSession = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int doOperation(boolean back) throws OiifbEndIterateException {
        if (this.m_curDeinstallSession != null) {
            return this.doDeinstallOperation(back);
        }
        int retBack = 0;
        boolean bCancelSession = false;
        if (back) return retBack;
        OiicGlobalContextReaderWriter oGCRW = null;
        OiicGlobalContext oGlobalContext = null;
        if (this.m_curSession.isInstallMode()) {
            oGCRW = OiicGlobalContextReaderWriter.getGlobalContextReaderWriter("oracle.sysman.oii.oiic.OiicGlobalContextXMLReaderWriter");
            oGlobalContext = OiicGlobalContext.getGlobalContext();
            if (oGlobalContext.getKey(0) == null) {
                String sReadXMLPath = System.getProperty("oracle.installer.globalcontextxml");
                if (sReadXMLPath != null) {
                    oGCRW.readGlobalContextFile(oGlobalContext, sReadXMLPath);
                }
            } else {
                new Throwable().printStackTrace();
            }
        }
        while (true) {
            boolean retValue;
            block22: {
                retValue = true;
                try {
                    retBack = this.m_curSession.doOperation(back);
                    if (retBack == 0) {
                        this.firstRun = false;
                        retValue = true;
                    } else if (retBack == 1 && this.firstRun) {
                        return retBack;
                    }
                }
                catch (OiifbEndIterateException e) {
                    Object[] objs;
                    retValue = false;
                    this.logMessage(e.getMessage());
                    Exception tmpE = e.getException();
                    if (OiicExitCode.getExitCode() == -3 || OiicExitCode.getExitCode() == -2 || OiicExitCode.getExitCode() == -4 || OiicExitCode.getExitCode() == -5) {
                        if (OiicPullSession.isSilentMode() && OiicExitCode.getExitCode() == -2) {
                            objs = new String[]{OiiolTextLogger.getErrorLogFileName()};
                            this.logMessage(OiixResourceBundle.getString("S_SILENT_INSTALL_FAILURE"));
                            OiiolTextLogger.writeMessageToConsole(OiixResourceBundle.getString("S_SILENT_INSTALL_FAILURE"));
                            OiiolTextLogger.writeMessageToConsole(MessageFormat.format(OiixResourceBundle.getString("S_SILENT_INSTALL_DETAILS"), objs));
                        }
                        try {
                            this.m_curSession.onBackIntoLocations();
                            this.unAdviceSessionVariables();
                            this.resetPropertiesOnNextInstall(false);
                            this.resetSession();
                            throw e;
                        }
                        catch (Exception ex) {
                            this.logMessage(ex.getMessage());
                        }
                        throw e;
                    }
                    if (tmpE == null) throw e;
                    if (tmpE instanceof OiifbUserEndException) {
                        throw e;
                    }
                    if (!(tmpE instanceof OiifbCancelException)) throw e;
                    OiifbCancelException ce = (OiifbCancelException)tmpE;
                    if (ce.isCancelSession()) {
                        bCancelSession = true;
                    }
                    if (!OiicPullSession.isSilentMode()) break block22;
                    objs = new String[]{OiiolTextLogger.getErrorLogFileName()};
                    this.logMessage(OiixResourceBundle.getString("S_SILENT_INSTALL_FAILURE"));
                    OiiolTextLogger.writeMessageToConsole(MessageFormat.format(OiixResourceBundle.getString("S_SILENT_INSTALL_DETAILS"), objs));
                    return 1;
                }
            }
            if (!bCancelSession && this.m_curSession.isInstallMode() && retBack == 0) {
                OiisVariable oOHNameVar = this.m_oCurSessionContext.getVariable("ORACLE_HOME_NAME");
                String sOHName = (String)oOHNameVar.getValue();
                OiiiCompInstallID currComp = (OiiiCompInstallID)this.m_oCurSessionContext.getVarValue("ToplevelComp");
                oGlobalContext.addLWVariableOwner(sOHName, currComp.getName(), this.m_oCurSessionContext);
                String sFirstKey = oGlobalContext.getKey(0);
                String sFirstOHLoc = oGlobalContext.getVariableValue(sFirstKey, "ORACLE_HOME");
                oGCRW.writeGlobalContextFile(oGlobalContext, sFirstOHLoc);
            }
            if (!bCancelSession && this.m_curSession.getRebootInfo() != null && !OiicSessionInterfaceManager.getInterfaceManager().isNextSessionSet()) return retBack;
            if (!bCancelSession && !this.checkIfNextSession(retValue, this.m_oCurSessionContext)) {
                if (!(this.m_curSession instanceof OiicInstallSession) || !System.getProperty("oracle.installer.cleanUpOnExit", "true").equals("true")) return retBack;
                ((OiicInstallSession)this.m_curSession).cleanupScratchPath();
                return retBack;
            }
            String sNextRspFile = null;
            if (bCancelSession) {
                this.m_curSession.onBackIntoLocations();
                this.unAdviceSessionVariables();
                this.resetPropertiesOnNextInstall(false);
                this.resetSession();
            } else {
                Boolean showProgress = (Boolean)this.m_oCurSessionContext.getVariable("SHOW_NEXT_SESSION_PROGRESS").getValue();
                if (showProgress.booleanValue()) {
                    OiicSessionInterfaceManager osim = OiicSessionInterfaceManager.getInterfaceManager();
                    osim.showNextSessionProgress();
                }
                sNextRspFile = (String)this.m_oCurSessionContext.getVariable("NEXT_SESSION_RESPONSE").getValue();
                this.resetPropertiesOnNextInstall(true);
                this.createNewSession(sNextRspFile);
                this.setupDuplicateStreams();
                this.setChainInstallProgress();
            }
            this.initialize(true);
        }
    }

    public int doDeinstallOperation(boolean back) throws OiifbEndIterateException {
        int retBack = 0;
        if (!back) {
            while (true) {
                boolean retValue;
                block8: {
                    retValue = true;
                    try {
                        retBack = this.m_curDeinstallSession.doOperation(back);
                        if (retBack == 0 || retBack == 3) {
                            this.firstRun = false;
                            retValue = true;
                        }
                    }
                    catch (OiifbEndIterateException e) {
                        retValue = false;
                        this.logMessage(e.getMessage());
                        Exception tmpE = e.getException();
                        if (tmpE != null && tmpE instanceof OiifbUserEndException) {
                            throw e;
                        }
                        if (!OiicPullSession.isSilentMode()) break block8;
                        this.logMessage(OiixResourceBundle.getString("S_SILENT_DEINSTALL_FAILURE"));
                        String sLogLoc = OiiolTextLogger.getSilentInstallLogLoc();
                        if (sLogLoc != null) {
                            Object[] objs = new String[]{sLogLoc};
                            OiiolTextLogger.writeMessageToConsole(MessageFormat.format(OiixResourceBundle.getString("S_SILENT_INSTALL_DETAILS"), objs));
                        }
                        return 1;
                    }
                }
                if (!this.m_repeat) break;
                if (!this.checkIfNextSession(retValue, this.m_oDeinstallSessionContext)) {
                    this.m_curDeinstallSession.releaseReaderLock();
                    break;
                }
                this.resetPropertiesOnNextInstall(true);
                String sNextRspFile = (String)this.m_oDeinstallSessionContext.getVariable("NEXT_SESSION_RESPONSE").getValue();
                this.createNewSession(sNextRspFile);
                this.setupDuplicateStreams();
                this.initialize(true);
            }
        }
        return retBack;
    }

    private void resetPropertiesOnNextInstall(boolean bResetLogs) {
        Properties props = System.getProperties();
        props.put("oracle.installer.timestamp", OiixUtilityOps.getTimeStamp());
        props.put("oracle.installer.welcome", "false");
        props.put("oracle.installer.defaultifyLanguages", "false");
        props.put("oracle.srvm.formCluster", "false");
        if (bResetLogs) {
            OiiolLogger.resetLoggers();
        }
        OiicPullSession.resetLangAddonMode();
        if (OiicPullSession.isLangAddonMode()) {
            System.setProperty("oracle.installer.sessionType", "LangAddon");
        }
        OiicInstaller.getOiicInstallerInstance().resetCommandLineArgsTable();
    }

    private boolean isResponseFileSpecified(String rspFile) {
        int iLen = rspFile != null ? rspFile.length() : 0;
        return iLen > 0;
    }

    private boolean checkIfNextSession(boolean bSuccess, OiicSessionContext ctx) {
        boolean moreSessions = false;
        boolean bSuppSrc = Boolean.getBoolean("oracle.installer.suppressedSource");
        boolean bSilent = OiicPullSession.isSilentMode();
        String sNextRspFile = (String)ctx.getVariable("NEXT_SESSION_RESPONSE").getValue();
        Boolean bNextSession = (Boolean)ctx.getVariable("NEXT_SESSION").getValue();
        Boolean bContinueOnFailure = (Boolean)ctx.getVariable("NEXT_SESSION_ON_FAIL").getValue();
        if (bNextSession != null && bNextSession.booleanValue() && (bSuccess || bContinueOnFailure != null && bContinueOnFailure.booleanValue())) {
            moreSessions = this.isResponseFileSpecified(sNextRspFile) ? true : (bSilent ? false : (bSuppSrc ? false : this.m_curDeinstallSession == null));
        }
        return moreSessions;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        this.initialize(false);
    }

    public void initialize(boolean noBack) throws OiifbEndIterateException {
        if (this.m_curSession != null) {
            this.m_curSession.initialize(noBack);
        }
        if (this.m_curDeinstallSession != null) {
            this.m_curDeinstallSession.initialize(noBack);
        }
    }

    public void setupDuplicateStreams() throws OiifbEndIterateException {
        if (this.m_curSession != null) {
            this.m_curSession.setupDuplicateStreams();
        } else if (this.m_curDeinstallSession != null) {
            this.m_curDeinstallSession.setupDuplicateStreams();
        }
    }

    private void resetSession() {
        OiicSessionInterfaceManager osim = OiicSessionInterfaceManager.getInterfaceManager();
        osim.initialize();
    }

    private void createNewSession(String newResponseFile) throws OiifbEndIterateException {
        boolean bSilent = OiicPullSession.isSilentMode();
        if (OiixPlatform.getCurrentPlatform() == 0) {
            throw new OiifbEndIterateException(OiixResourceBundle.getString("S_UNIDENTIFIED_PLATFORM_ERROR"));
        }
        this.dispose();
        if (this.isResponseFileSpecified(newResponseFile)) {
            Properties sysProps = System.getProperties();
            sysProps.put("oracle.installer.responseFile", newResponseFile);
            System.setProperties(sysProps);
        }
        System.gc();
        String sessionType = System.getProperty("oracle.installer.sessionType");
        if (sessionType.equalsIgnoreCase("Install")) {
            this.m_curSession = new OiicInstallSession(this.m_installer, bSilent);
        } else if (sessionType.equalsIgnoreCase("DeInstall")) {
            this.m_curDeinstallSession = new OiicDeinstallSession(this.m_installer, bSilent);
        } else if (sessionType.equalsIgnoreCase("Clone")) {
            this.m_curSession = new OiicCloneSession(this.m_installer, bSilent);
        } else if (sessionType.equalsIgnoreCase("AddNode")) {
            this.m_curSession = new OiicAddNodeSession(this.m_installer, bSilent);
        } else if (sessionType.equalsIgnoreCase("LangAddon")) {
            this.m_curSession = new OiicLangAddonSession(this.m_installer, bSilent);
        }
        if (this.m_curSession != null) {
            OiicSessionInterfaceManager osim = OiicSessionInterfaceManager.getInterfaceManager();
            osim.setSession(this.m_curSession);
            osim.initialize();
            this.m_oCurSessionContext = this.m_curSession.getSessionContext();
        } else if (this.m_curDeinstallSession != null) {
            this.m_oDeinstallSessionContext = this.m_curDeinstallSession.getSessionContext();
        }
    }

    private void logMessage(String msg) {
        if (OiicPullSession.isSilentMode()) {
            OiiolTextLogger.appendErrorText(msg);
        } else {
            OiiolTextLogger.appendText(msg);
        }
    }

    @Override
    public OiicISession getCurrentSession() {
        return this.getCurSession();
    }

    private void unAdviceSessionVariables() {
        OiicSessionContext ctx = this.m_curSession.getSessionContext();
        ArrayList<String> oListOfSessionVarsToBeUnAdviced = new ArrayList<String>();
        oListOfSessionVarsToBeUnAdviced.add("FROM_LOCATION");
        oListOfSessionVarsToBeUnAdviced.add("ORACLE_HOME_NAME");
        oListOfSessionVarsToBeUnAdviced.add("ORACLE_HOME");
        int iSize = oListOfSessionVarsToBeUnAdviced.size();
        for (int i = 0; i < iSize; ++i) {
            OiisVariable oVar = ctx.getVariable((String)oListOfSessionVarsToBeUnAdviced.get(i));
            if (oVar == null) continue;
            oVar.setAdvice(false);
        }
    }

    private void setChainInstallProgress() {
        try {
            OiicGlobalContext oGlobalContext = OiicGlobalContext.getGlobalContext();
            int numPrevSessions = oGlobalContext.getSize();
            if (numPrevSessions == 0) {
                return;
            }
            String sKey = oGlobalContext.getKey(numPrevSessions - 1);
            OiicSessionContext sCntxt = this.m_curSession.getSessionContext();
            OiisVariable showProgress = sCntxt.getVariable("SHOW_NEXT_SESSION_PROGRESS");
            showProgress.setValue(oGlobalContext.getVarValue(sKey, "SHOW_NEXT_SESSION_PROGRESS"));
            OiisVariable title = sCntxt.getVariable("NEXT_SESSION_PROGRESS_TITLE");
            title.setValue(oGlobalContext.getVariableValue(sKey, "NEXT_SESSION_PROGRESS_TITLE"));
            OiisVariable text = sCntxt.getVariable("NEXT_SESSION_PROGRESS_TEXT");
            text.setValue(oGlobalContext.getVariableValue(sKey, "NEXT_SESSION_PROGRESS_TEXT"));
            OiisVariable sInvLoc = sCntxt.getVariable("INVENTORY_LOCATION");
            sInvLoc.setValue(oGlobalContext.getVariableValue(sKey, "INVENTORY_LOCATION"));
            OiisVariable sUnixGroupName = sCntxt.getVariable("UNIX_GROUP_NAME");
            sUnixGroupName.setValue(oGlobalContext.getVariableValue(sKey, "UNIX_GROUP_NAME"));
        }
        catch (OiisVarSettingException oiisVarSettingException) {
        }
        catch (OiifbCancelException oiifbCancelException) {
            // empty catch block
        }
    }
}

