/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicCleanup;
import oracle.sysman.oii.oiic.OiicDeinstallSession;
import oracle.sysman.oii.oiic.OiicGlobalVarsReader;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicLWSessionContext;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContextConstants;
import oracle.sysman.oii.oiic.OiicSessionVarsReader;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiioz.OiiozResponseFileManager;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;
import oracle.sysman.oii.oiis.OiisAdvisedValue;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisDepMode;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisLWVariableOwner;
import oracle.sysman.oii.oiis.OiisPatchSetInstallation;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixInteractiveOps;
import oracle.sysman.oii.oiix.OiixJarResourceBundle;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OiicSessionContext
extends OiicLWSessionContext
implements OiisVariableOwner,
OiicSessionContextConstants {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private OiiiCompInstallID m_compID = null;
    private OiicPullSession m_pullSession = null;
    private OiicDeinstallSession m_deinstallSession = null;
    private static OiiozResponseFileManager m_responseMgr = null;
    private Hashtable m_cmdVarsTable = null;
    private static List m_InstallSessionVars = null;
    private static OiicSessionVarsReader m_reader = null;
    private List m_GlobalVars = new LinkedList();
    private OiicGlobalVarsReader m_GVReader = null;

    protected OiicSessionContext(OiicPullSession pullSession) {
        this.m_pullSession = pullSession;
        this.setupSessionContext();
    }

    protected OiicSessionContext(OiicDeinstallSession deinstallSession) {
        this.m_deinstallSession = deinstallSession;
        this.m_deinstallSession.getDeinstallList();
        this.setupSessionContext();
    }

    protected OiicSessionContext(OiicBaseInventoryApp baseApp) {
        this.setupSessionContext(baseApp);
    }

    protected OiicSessionContext(OiicCleanup cleanup) {
        this.setupSessionContext(cleanup);
    }

    protected OiicSessionContext(OiicBaseApp baseApp) {
        this.setupSessionContext(baseApp);
    }

    private void readSessionVarsSetRB() {
        try {
            m_reader = new OiicSessionVarsReader("OUI_Session_Variables.xml");
            m_InstallSessionVars = m_reader.getInstallSessionVariables(this, false);
            m_InstallSessionVars.addAll(m_reader.getTopLevelSessionVariables(this, false));
        }
        catch (OiixException pe) {
            pe.printStackTrace();
        }
        this.m_varTable = new Hashtable();
        this.m_compID = OiicPullSession.sessionContextID;
        int iSize = m_InstallSessionVars != null ? m_InstallSessionVars.size() : 0;
        for (int i = 0; i < iSize; ++i) {
            OiisVariable var = (OiisVariable)m_InstallSessionVars.get(i);
            this.addVariable(var);
        }
    }

    private void setupSessionContext() {
        this.readSessionVarsSetRB();
        this.m_cmdVarsTable = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("false") ? OiicInstaller.getOiicInstallerInstance().getCommandLineArgsTable() : OiicAPIInstaller.getAPIInstallerInstance().getCommandLineArgsTable();
    }

    private void setupSessionContext(OiicBaseApp baseApp) {
        this.readSessionVarsSetRB();
        this.m_cmdVarsTable = baseApp.getCommandLineArgsTable();
    }

    @Override
    public Hashtable getCommandLineArgsTable() {
        return this.m_cmdVarsTable;
    }

    public static String[] getSessionVariablesArray() {
        Vector sessionVect = OiicSessionContext.constructVariablesVector("InstallSession");
        int iSize = sessionVect != null ? sessionVect.size() : 0;
        String[] sessionVars = new String[iSize];
        for (int i = 0; i < iSize; ++i) {
            OiisVariable oVar = (OiisVariable)sessionVect.get(i);
            sessionVars[i] = oVar.getName();
        }
        return sessionVars;
    }

    public void setupGlobalVars() {
        this.resetGlobalVars();
        if (null == this.getSession()) {
            return;
        }
        if (this.getSession().isCloneMode() || this.getSession().isAddNodeMode()) {
            OiiiStageInventory stageInv = this.m_pullSession.getSourceAccess().getStageInventory();
            Vector vComps = stageInv.getTopLevelComps(0, OiixPlatform.getCurrentPlatform());
            for (int i = 0; i < vComps.size(); ++i) {
                OiiiCompInstallID cid = (OiiiCompInstallID)vComps.elementAt(i);
                if (cid.getCompType() != 1) continue;
                String sCompName = cid.getName();
                OiiolTextLogger.appendText("Loading global variables for component " + sCompName);
                String sGlobalVarsLoc = this.getGlobalVarsLocFromInv(sCompName);
                this.loadGlobalVarsFromInventory(sGlobalVarsLoc);
            }
        } else {
            String sVarPropsLoc = this.getGlobalVarsLocFromStage();
            OiiolTextLogger.appendText("Loading global variables");
            this.readGlobalVariables(sVarPropsLoc);
        }
        OiiolTextLogger.appendText("Loading of globalvariables complete");
        try {
            this.setValForGlobalVars();
        }
        catch (OiifbEndIterateException oiifbEndIterateException) {
            // empty catch block
        }
    }

    public void resetGlobalVars() {
        this.m_GVReader = null;
        for (int i = 0; i < this.m_GlobalVars.size(); ++i) {
            OiisVariable oVar = (OiisVariable)this.m_GlobalVars.get(i);
            this.getVariablesMap().remove(oVar.getName());
        }
        this.m_GlobalVars = new LinkedList();
    }

    public String getGlobalVarsLocFromStage() {
        String sCompStgLoc = OiixPathOps.getParentDir(this.getSession().getSourceAccess().getLocalStgInvLoc());
        String sVarPropsLoc = OiixPathOps.concatPath(OiixPathOps.concatPath(sCompStgLoc, "globalvariables"), "variable.properties");
        return sVarPropsLoc;
    }

    public String getGlobalVarsLocFromInv(String sTopLvlCompName) {
        OiiiInstallInventory instInv = this.getSession().getInstallInventory();
        if (null == instInv) {
            return null;
        }
        String sInvLoc = OiixPathOps.concatPath(instInv.getHomeLocation(this.getSession().getOHIndex()), "inventory");
        String sGlobalVarsDirInv = OiixPathOps.concatPath(sInvLoc, "globalvariables");
        String sCompGlobalVarsDir = OiixPathOps.concatPath(sGlobalVarsDirInv, sTopLvlCompName);
        String sGlobalVarsFileInv = OiixPathOps.concatPath(sCompGlobalVarsDir, "globalvariables.xml");
        return sGlobalVarsFileInv;
    }

    private void setValForGlobalVars() throws OiifbEndIterateException {
        if (null == this.m_GlobalVars) {
            return;
        }
        for (int i = 0; i < this.m_GlobalVars.size(); ++i) {
            OiisVariable oVar = (OiisVariable)this.m_GlobalVars.get(i);
            if (null == oVar) continue;
            try {
                oVar.setVariable(null);
                continue;
            }
            catch (OiifbCancelException e) {
                e.printStackTrace();
                continue;
            }
            catch (OiisVarSettingException e) {
                e.printStackTrace();
            }
        }
    }

    public static Vector getGlobalVariablesList(String sStageLoc) {
        OiicGlobalVarsReader respReader = null;
        if (null == sStageLoc) {
            return new Vector();
        }
        String sStageDir = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sStageLoc));
        String sVarPropsLoc = OiixPathOps.concatPath(sStageDir, OiixPathOps.concatPath("globalvariables", "variable.properties"));
        File fVarProps = new File(sVarPropsLoc);
        if (!fVarProps.exists()) {
            return new Vector();
        }
        Vector<OiisVariable> vRespVars = new Vector<OiisVariable>();
        try {
            respReader = new OiicGlobalVarsReader(sVarPropsLoc);
        }
        catch (OiixException e) {
            System.out.println("Unable to generate global variable list");
            return new Vector();
        }
        List gVars = respReader.getGlobalVariablesRSP(null);
        for (int i = 0; i < gVars.size(); ++i) {
            OiisVariable oVar = (OiisVariable)gVars.get(i);
            if (!oVar.getGenerateRSP()) continue;
            vRespVars.add(oVar);
        }
        return vRespVars;
    }

    private void readGlobalVariables(String sVarPropsLoc) {
        if (!new File(sVarPropsLoc).exists() && null == System.getProperty("oracle.installer.globalvarxml")) {
            return;
        }
        try {
            if (null == this.m_GVReader) {
                this.m_GVReader = new OiicGlobalVarsReader(sVarPropsLoc);
            }
        }
        catch (OiixException e) {
            OiiolTextLogger.appendText(e.getMessage());
            return;
        }
        List oVars = this.m_GVReader.getGlobalVariables(this);
        for (int i = 0; i < oVars.size(); ++i) {
            OiisVariable oVar = (OiisVariable)oVars.get(i);
            this.addGlobalVariable(oVar);
        }
    }

    private void addGlobalVariable(OiisVariable oVar) {
        this.addGlobalVariable(oVar, true);
    }

    private void addGlobalVariable(OiisVariable oVar, boolean bOverwrite) {
        String str = oVar.getName();
        OiisVariable oOldVar = this.getVariable(str);
        if (oOldVar != null) {
            if (!oOldVar.isGlobalVar()) {
                String sErrMsg = OiixResourceBundle.getString("S_ERROR_DUPLICATE_GLOBAL_VAR", new String[]{oVar.getName()});
                OiiolTextLogger.appendText(sErrMsg, OiiolTextLogger.LOG_WARNING);
                return;
            }
            if (!bOverwrite && oOldVar.isValueSet()) {
                return;
            }
            if (!oVar.isValueSet()) {
                return;
            }
            try {
                oOldVar.setValue(oVar.getValue());
            }
            catch (OiisVarSettingException oiisVarSettingException) {
            }
            catch (OiifbCancelException oiifbCancelException) {}
        } else {
            this.addVariable(oVar);
            this.m_GlobalVars.add(oVar);
        }
    }

    public void setupGlobalVars(int ohIndex) throws OiifbEndIterateException {
        this.resetGlobalVars();
        if (this.m_deinstallSession != null) {
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            OiiiInstallInventory instInv = iac.getInstallInventory();
            Vector<String> vTopLvlComps = new Vector<String>();
            if (null == instInv) {
                return;
            }
            Vector vComps = this.m_deinstallSession.getSessionPlan().getRemoves(10);
            for (int i = 0; i < vComps.size(); ++i) {
                OiiiCompIdOhPair compOH = (OiiiCompIdOhPair)vComps.elementAt(i);
                if (compOH.getOHIndex() != ohIndex) continue;
                OiiiCompInstallID cid = compOH.getCompID();
                if (instInv.getCompInvEntry(cid, ohIndex).isTopLevel()) {
                    // empty if block
                }
                vTopLvlComps.add(cid.getName());
            }
            this.loadGlobalVarsFromInventory(vTopLvlComps, ohIndex);
        }
    }

    private void loadGlobalVarsFromInventory(Vector vComps, int ohIndex) {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = null;
        String sOHLoc = null;
        String sGlobalXmlFileLoc = null;
        if (null == iac) {
            return;
        }
        instInv = iac.getInstallInventory();
        if (null == instInv) {
            return;
        }
        sOHLoc = instInv.getHomeInfo(ohIndex).getLocation();
        if (null == sOHLoc) {
            return;
        }
        String sInvLoc = OiixPathOps.concatPath(sOHLoc, "inventory");
        String sGlobalVarsDir = OiixPathOps.concatPath(sInvLoc, "globalvariables");
        for (int i = 0; i < vComps.size(); ++i) {
            String sCompName = (String)vComps.elementAt(i);
            String sTopLevelDir = OiixPathOps.concatPath(sGlobalVarsDir, sCompName);
            sGlobalXmlFileLoc = OiixPathOps.concatPath(sTopLevelDir, "globalvariables.xml");
            this.loadGlobalVarsFromInventory(sGlobalXmlFileLoc);
        }
    }

    private void loadGlobalVarsFromInventory(String pathToInvVarsFile) {
        this.loadGlobalVarsFromInventory(pathToInvVarsFile, true);
    }

    private void loadGlobalVarsFromInventory(String pathToInvVarsFile, boolean bOverwrite) {
        if (pathToInvVarsFile != null) {
            List newVars = OiicGlobalVarsReader.readVarValuesFromInventory(pathToInvVarsFile, this);
            if (null == this.m_GlobalVars) {
                this.m_GlobalVars = newVars;
            }
            for (int i = 0; i < newVars.size(); ++i) {
                OiisVariable oVar = (OiisVariable)newVars.get(i);
                this.addGlobalVariable(oVar, bOverwrite);
            }
        }
    }

    public List getGlobalVariables() {
        return this.m_GlobalVars;
    }

    public void writeGlobalVarsToInv() throws IOException {
        if (this.getSession() == null) {
            return;
        }
        OiiiCompInstallID[] compIDs = this.getSession().getSelTopLevelCompIDs();
        for (int i = 0; i < compIDs.length; ++i) {
            Vector v;
            OiiiCompInstallID compID = compIDs[i];
            OiiolTextLogger.appendText("Saving global variables for component " + compID.getName());
            String sGlobalVarsFileInv = this.getGlobalVarsLocFromInv(compID.getName());
            this.writeGlobalVarsToInv(sGlobalVarsFileInv);
            if (compID.getCompType() != 4) continue;
            OiiiPatchSetInstallID psid = (OiiiPatchSetInstallID)compID;
            OiisPatchSetInstallation pis = this.getSession().getPSetInstall(psid);
            if (null == pis || pis.getContents() == null || null == (v = pis.getContents().getContainedPatches())) continue;
            for (int j = 0; j < v.size(); ++j) {
                OiiiPatchInstallID pid = (OiiiPatchInstallID)v.elementAt(i);
                if (null == pid || !new File(sGlobalVarsFileInv = this.getGlobalVarsLocFromInv(pid.getName())).exists()) continue;
                OiiolTextLogger.appendText("Updating global variables for component " + pid.getName());
                this.loadGlobalVarsFromInventory(sGlobalVarsFileInv, false);
                this.writeGlobalVarsToInv(sGlobalVarsFileInv);
            }
        }
        OiiolTextLogger.appendText("Saving global variables completed");
    }

    public void writeGlobalVarsToInv(String path) throws IOException {
        if (this.m_GlobalVars.size() == 0) {
            return;
        }
        OiixFileOps.createDirForDest(OiixPathOps.getParentDir(path));
        OutputStreamWriter fWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter((Writer)bWriter, true);
        OiicGlobalVarsReader.writeGlobalVarsToXML(pWriter, this.m_GlobalVars.iterator());
        pWriter.close();
        bWriter.close();
        fWriter.close();
    }

    private void setNumberVar(String varName, int defVal, boolean advVal, boolean suppressOnSilent) {
        OiisVariable v = this.getVariable(varName);
        Integer iVal = (Integer)v.getValue();
        try {
            if (OiicPullSession.isSilentMode() && suppressOnSilent) {
                v.setValue(new OiisAdvisedValue(new Integer(defVal), true), false);
            } else if (v.getValue() == null) {
                v.setValue(new OiisAdvisedValue(new Integer(defVal), false), false);
            } else if (iVal != null && iVal == 0) {
                v.setAdvice(advVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBoolVar(String varName, boolean defVal, boolean advVal, boolean suppressOnSilent) {
        OiisVariable v = this.getVariable(varName);
        boolean bVal = false;
        if (v.getValue() != null) {
            bVal = Boolean.parseBoolean(v.getValue().toString());
        }
        try {
            if (OiicPullSession.isSilentMode() && suppressOnSilent) {
                v.setValue(new OiisAdvisedValue(new Boolean(false), true), false);
            } else if (v.getValue() == null) {
                v.setValue(new OiisAdvisedValue(new Boolean(defVal), false), false);
            } else if (bVal) {
                v.setAdvice(advVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setStringVar(String propName, String varName, boolean dispVal, boolean normalize) throws OiisVarSettingException {
        String propVal = System.getProperty(propName);
        if (propVal != null) {
            if (normalize) {
                propVal = OiiiSourceAccess.getAbsoluteForm(propVal);
            }
            if (this.m_pullSession != null) {
                this.m_pullSession.bindSessionVariable(varName, new OiisAdvisedValue(propVal, dispVal));
            }
        }
    }

    public void setVariables() throws OiifbEndIterateException {
        try {
            boolean dispVal = true;
            OiicSessionContext.createResponseFileManager();
            this.setStringVar("oracle.installer.sourceLoc", "FROM_LOCATION", !dispVal, true);
            this.setStringVar("oracle.installer.ORACLE_HOME", "ORACLE_HOME", !dispVal, false);
            this.setStringVar("oracle.installer.ORACLE_HOME_NAME", "ORACLE_HOME_NAME", !dispVal, false);
            this.setStringVar("oracle.installer.APPLTOP", "APPLTOP", !dispVal, false);
            this.setStringVar("oracle.installer.APPLTOP_NAME", "APPLTOP_NAME", !dispVal, false);
            this.setStringVar("oracle.installer.prereqConfigLoc", "PREREQ_CONFIG_LOCATION", dispVal, true);
            this.setStringVar("oracle.installer.prereqLogLoc", "PREREQ_LOG_LOCATION", dispVal, true);
            this.setStringVar("oracle.installer.prereqEntryPoint", "PREREQ_ENTRY_POINT", dispVal, true);
        }
        catch (IOException ioe) {
            if (OiicPullSession.isSilentMode()) {
                OiiolTextLogger.writeMessageToConsole(ioe.getMessage());
            } else {
                OiifmAlert.displayError(ioe.getMessage());
            }
            throw new OiifbEndIterateException(ioe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] varNames = OiicSessionContext.getSessionVariablesArray();
        boolean bVal = false;
        boolean adVal = false;
        boolean bSuppress = false;
        for (int i = 0; i < varNames.length; ++i) {
            OiisVariable v = this.getVariable(varNames[i]);
            int type = v.getType();
            bSuppress = v.isSuppressedOnSilent();
            int defVal = 0;
            if (type == 3) {
                bVal = v.getValue() != null ? Boolean.parseBoolean(v.getValue().toString()) : false;
                adVal = v.getAdvice();
            } else if (type == 2) {
                adVal = v.getAdvice();
                defVal = (Integer)v.getValue();
            }
            try {
                v.setVariable(null);
                v.setType(type);
            }
            catch (OiifbCancelException ce) {
                ce.printStackTrace();
            }
            catch (OiisVarSettingException ce1) {
                ce1.printStackTrace();
            }
            if (type == 3) {
                if (v.getName().equalsIgnoreCase("USE_PREREQ_CHECKER")) {
                    this.setBoolVar("USE_PREREQ_CHECKER", OiixOraparam.usePrereqChecker(), adVal, bSuppress);
                    continue;
                }
                if (v.getName().equalsIgnoreCase("USE_OLD_INSTALL_PREREQS")) {
                    this.setBoolVar("USE_OLD_INSTALL_PREREQS", OiixOraparam.useOldInstallPrereqs(), adVal, bSuppress);
                    continue;
                }
                if (v.getName().equalsIgnoreCase("IGNORE_PREREQ")) continue;
                this.setBoolVar(v.getName(), bVal, adVal, bSuppress);
                continue;
            }
            if (type != 2) continue;
            this.setNumberVar(v.getName(), defVal, adVal, bSuppress);
        }
        String sOuiHostName = (String)this.m_cmdVarsTable.get("OUI_HOSTNAME");
        String sOracleHostName = (String)this.m_cmdVarsTable.get("ORACLE_HOSTNAME");
        String sHostName = null;
        if (sOracleHostName != null && sOracleHostName.trim().length() > 0) {
            sHostName = sOracleHostName;
        } else if (sOuiHostName != null && sOuiHostName.trim().length() > 0) {
            sHostName = sOuiHostName;
        }
        if (sHostName != null) {
            OiisVariable oOUIHostName = this.getVariable("OUI_HOSTNAME");
            OiisVariable oOracleHostName = this.getVariable("ORACLE_HOSTNAME");
            try {
                oOUIHostName.setValue(sHostName);
                oOracleHostName.setValue(sHostName);
            }
            catch (OiisVarSettingException oiisVarSettingException) {
            }
            catch (OiifbCancelException oiifbCancelException) {
                // empty catch block
            }
        }
        if (this.getVarValue("ORACLE_HOME") != null) {
            System.setProperty("HOME_LOCATION_API", this.getVarValue("ORACLE_HOME").toString());
        }
    }

    public void setDiskVariables() {
        int nDisks = OiiiTargetAreaControl.getTotalDisks(this.m_pullSession.getSourceAccess().getStageInventory());
        if (nDisks > 1) {
            for (int iDisk = 2; iDisk <= nDisks; ++iDisk) {
                OiisVariable v = new OiisVariable(this, "LOCATION_FOR_DISK" + iDisk);
                v.setType(OiisVariable.STRING);
                this.addVariable(v);
                try {
                    v.setVariable(null);
                    continue;
                }
                catch (Exception ce) {
                    ce.printStackTrace();
                }
            }
        }
    }

    @Override
    public OiiozResponseFileManager getResponseFileManager() {
        return m_responseMgr;
    }

    @Override
    public void setResponseFileManager(OiiozResponseFileManager rf) {
        m_responseMgr = rf;
    }

    public static void createResponseFileManager() throws IOException {
        String rf = System.getProperty("oracle.installer.responseFile");
        if (rf != null && !rf.equals("NONE")) {
            try {
                m_responseMgr = new OiiozResponseFileManager();
                m_responseMgr.addResponseFile(rf);
            }
            catch (IOException ie) {
                OiicSessionContext.unsetResponseFile();
                throw ie;
            }
        }
    }

    public static void unsetResponseFile() {
        Properties sysProps = System.getProperties();
        sysProps.put("oracle.installer.responseFile", "NONE");
        System.setProperties(sysProps);
        m_responseMgr = null;
    }

    public static boolean isResponseFileUsed() {
        String sResponseFile = System.getProperty("oracle.installer.responseFile");
        return sResponseFile != null && sResponseFile.length() != 0 && !sResponseFile.equals("NONE");
    }

    @Override
    public OiicPullSession getSession() {
        return this.m_pullSession;
    }

    private String genSessionContextLoc() {
        String retLoc = this.m_pullSession.getTargetAreaControl().genFileSysLoc("sessionContext.ser");
        return retLoc;
    }

    public void writeContext() throws IOException {
        String fileName = this.genSessionContextLoc();
        FileOutputStream fos = new FileOutputStream(fileName);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeInt(this.getVariablesCount());
        Enumeration vars = this.getAllVariables();
        while (vars.hasMoreElements()) {
            OiisVariable var = (OiisVariable)vars.nextElement();
            oos.writeUTF(var.getName().toUpperCase());
            oos.writeBoolean(var.getAdvice());
            oos.writeObject(var.getValue());
        }
        oos.flush();
        oos.close();
        fos.close();
    }

    public void readContext() throws IOException, OiisVarSettingException, ClassNotFoundException {
        String fileName = this.genSessionContextLoc();
        FileInputStream fis = new FileInputStream(fileName);
        ObjectInputStream ois = new ObjectInputStream(fis);
        int numVars = ois.readInt();
        for (int i = 0; i < numVars; ++i) {
            String varName = ois.readUTF();
            boolean advice = ois.readBoolean();
            Object val = ois.readObject();
            OiisVariable var = this.getVariable(varName);
            try {
                var.setValue(new OiisAdvisedValue(val, advice), false);
                continue;
            }
            catch (OiifbCancelException ce) {
                ce.printStackTrace();
                continue;
            }
            catch (OiisVarSettingException oiisVarSettingException) {
                // empty catch block
            }
        }
        ois.close();
        fis.close();
    }

    @Override
    public int hashCode() {
        return this.m_compID.hashCode();
    }

    @Override
    public Enumeration getConstants() {
        return null;
    }

    @Override
    public OiisCompConstants getCompConstants() {
        return null;
    }

    public static Vector getDisplayROVarNames() {
        Vector<String> roList = new Vector<String>();
        for (int i = 0; i < s_roVarNames.length; ++i) {
            roList.addElement(s_roVarNames[i]);
        }
        return roList;
    }

    public static boolean isDlgToBeShown(String sVarName) {
        Boolean bVal;
        OiisAdvisedValue retval;
        boolean bShowDlg = true;
        String propResp = null;
        OiisAdvisedValue cmdVal = OiisVariable.getValueFromCommandLine(null, sVarName);
        if (cmdVal != null && cmdVal.getValue() instanceof Boolean) {
            Boolean bVal2 = (Boolean)cmdVal.getValue();
            if (bVal2 != null && !bVal2.booleanValue()) {
                return false;
            }
            if (bVal2 != null && bVal2.booleanValue()) {
                return true;
            }
        }
        if (m_responseMgr == null) {
            try {
                try {
                    propResp = System.getProperty("oracle.installer.responseFile");
                    OiicSessionContext.createResponseFileManager();
                }
                catch (IOException ioe) {
                    if (propResp != null) {
                        System.setProperty("oracle.installer.responseFile", propResp);
                    }
                }
            }
            catch (SecurityException se) {
                OiiolTextLogger.writeMessageToConsole("Security Exception" + se.getMessage());
            }
            catch (NullPointerException npe) {
                OiiolTextLogger.writeMessageToConsole("NullPointerException" + npe.getMessage());
            }
            catch (IllegalArgumentException iae) {
                OiiolTextLogger.writeMessageToConsole("Illegal Argument Exception" + iae.getMessage());
            }
        }
        if (m_responseMgr != null && (retval = m_responseMgr.getValue(sVarName, null, true)) != null && retval.getValue() instanceof Boolean && (bVal = (Boolean)retval.getValue()) != null && !bVal.booleanValue()) {
            bShowDlg = false;
        }
        return bShowDlg;
    }

    public static Vector getSessionVariables() {
        return OiicSessionContext.constructVariablesVector("InstallSession");
    }

    public static Vector getToplevelVariables() {
        return OiicSessionContext.constructVariablesVector("TopLevel");
    }

    private static Vector constructVariablesVector(String varType) {
        if (m_reader == null) {
            try {
                m_reader = new OiicSessionVarsReader(null, "OUI_Session_Variables.xml");
            }
            catch (OiixException pe) {
                pe.printStackTrace();
            }
        }
        Vector<OiisVariable> vVars = new Vector<OiisVariable>();
        if (m_reader != null) {
            List sessionVars = null;
            if (varType.compareTo("InstallSession") == 0) {
                sessionVars = m_reader.getInstallSessionVariables(null, false);
                sessionVars.addAll(m_reader.getTopLevelSessionVariables(null, false));
            } else if (varType.compareTo("TopLevel") == 0) {
                sessionVars = m_reader.getTopLevelSessionVariables(null, false);
            }
            int iSize = sessionVars != null ? sessionVars.size() : 0;
            for (int i = 0; i < iSize; ++i) {
                OiisVariable v = (OiisVariable)sessionVars.get(i);
                vVars.addElement(v);
            }
        }
        return vVars;
    }

    public boolean ignorePreReqCheck() {
        if (Boolean.getBoolean("oracle.installer.ignorePreReq")) {
            return true;
        }
        OiisVariable ignorePrereq = this.getVariable("IGNORE_PREREQ");
        boolean ignoreCheck = ignorePrereq.getValue() == null ? false : (Boolean)ignorePrereq.getValue();
        return ignoreCheck;
    }

    private static OiisVariable createVariable(OiisVariable oVar, String bVarDef, String sVarVal, boolean bVarReq, OiixJarResourceBundle jrb) {
        Object[] objs = new String[2];
        oVar.setExported(true);
        oVar.setCalcMethodPresent(!bVarReq);
        oVar.setResourceBundle(jrb);
        if (!sVarVal.equals("")) {
            oVar.setInitialValue(new OiisAdvisedValue(sVarVal, false));
        }
        String sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
        objs[0] = oVar.getName();
        objs[1] = bVarDef;
        sDesc = MessageFormat.format(sDesc, objs);
        oVar.setAllValueList(sDesc);
        return oVar;
    }

    public static Vector getSessionVariablesList(OiiiStageInventory inv) {
        Vector<OiisVariable> v = new Vector<OiisVariable>();
        List sessionVars = null;
        String sNewLine = System.getProperty("line.separator");
        OiisVariable oVar = null;
        OiixJarResourceBundle jrb = new OiixJarResourceBundle(OiixResourceBundle.getBundle());
        String sDefVal = null;
        OiicSessionVarsReader respReader = null;
        try {
            respReader = new OiicSessionVarsReader("OUI_Session_Variables.xml");
            sessionVars = respReader.getInstallSessionVariables(null, true);
            sessionVars.addAll(respReader.getTopLevelSessionVariables(null, true));
        }
        catch (OiixException pe) {
            pe.printStackTrace();
        }
        int iSize = sessionVars != null ? sessionVars.size() : 0;
        for (int j = 0; j < iSize; ++j) {
            String schoices;
            OiisVariable var = (OiisVariable)sessionVars.get(j);
            if (!var.getGenerateRSP()) continue;
            if (var.getName().equals("FROM_LOCATION")) {
                sDefVal = "\".." + File.separator + "stage" + File.separator + "products.xml" + "\"";
                var = OiicSessionContext.createVariable(var, sDefVal, sDefVal, false, jrb);
            }
            Vector vComps = inv.getTopLevelComps(0);
            int nComps = vComps.size();
            String sCompsList = "";
            String sInitialValue = "";
            Object[] obj = new String[2];
            for (int i = 0; i < nComps; ++i) {
                OiiiCompInstallID id = (OiiiCompInstallID)vComps.elementAt(i);
                OiiiStageCompInvEntry entry = inv.getStageCompInvEntry(id, new Vector());
                String s = OiixResourceBundle.getString("S_ALL_VALUE_COMPS_FROMAT");
                if (i == 0) {
                    sInitialValue = OiixResourceBundle.getString("S_TOPLEVEL_COMP_FORMAT");
                    obj[0] = id.getName();
                    obj[1] = id.getVersion().toString();
                    sInitialValue = MessageFormat.format(sInitialValue, obj);
                }
                Object[] val = new String[]{id.getName(), id.getVersion().toString(), entry.getFullDisplayName()};
                s = MessageFormat.format(s, val);
                sCompsList = sCompsList + sNewLine + s;
            }
            if (var.getName().equals("TOPLEVEL_COMPONENT")) {
                var = OiicSessionContext.createVariable(var, sInitialValue, sInitialValue, false, jrb);
                String sTLCompsList = sCompsList + sNewLine + var.getAllValueList();
                schoices = null;
                if (!sCompsList.equals("")) {
                    schoices = OiixResourceBundle.getString("S_CHOICES1_FORMAT") + sNewLine;
                    schoices = schoices + OiixResourceBundle.getString("S_CHOICES_TOPLEVEL_FORMAT");
                    sTLCompsList = schoices + sTLCompsList;
                }
                var.setAllValueList(sTLCompsList);
            }
            if (var.getName().equals("DEINSTALL_LIST")) {
                var = OiicSessionContext.createVariable(var, sInitialValue, sInitialValue, false, jrb);
                String sDCCompsList = sCompsList + sNewLine + var.getAllValueList();
                schoices = null;
                if (!sCompsList.equals("")) {
                    schoices = OiixResourceBundle.getString("S_CHOICES1_FORMAT") + sNewLine;
                    schoices = schoices + OiixResourceBundle.getString("S_CHOICES_TOPLEVEL_FORMAT");
                    sDCCompsList = schoices + sDCCompsList;
                }
                var.setAllValueList(sDCCompsList);
            }
            Object[] args = new Object[]{"node1"};
            sInitialValue = OiixResourceBundle.getString("S_STRLIST_FROMAT", args);
            if (var.getName().equals("CLUSTER_NODES")) {
                var = OiicSessionContext.createVariable(var, sInitialValue, "", false, jrb);
            }
            v.addElement(var);
        }
        int nDisks = OiiiTargetAreaControl.getTotalDisks(inv);
        if (nDisks > 1) {
            for (int iDisk = 2; iDisk <= nDisks; ++iDisk) {
                sDefVal = "\".." + File.separator + ".." + File.separator + "Disk" + iDisk + "\"";
                oVar = new OiisVariable(null, "LOCATION_FOR_DISK" + iDisk);
                oVar.setDescription("S_DISK_LOCATION_DESC");
                oVar = OiicSessionContext.createVariable(oVar, sDefVal, sDefVal, false, jrb);
                v.addElement(oVar);
            }
        }
        return v;
    }

    public static OiisVariable getSelLangsVar(OiiiStageCompInvEntry ie) {
        OiixJarResourceBundle jrb = new OiixJarResourceBundle(OiixResourceBundle.getBundle());
        OiisVariable oVar = null;
        String sNewLine = System.getProperty("line.separator");
        Vector vLangs = ie.getLanguages();
        int nLangs = vLangs.size();
        if (nLangs > 1) {
            oVar = new OiisVariable(null, "SELECTED_LANGUAGES");
            oVar.setType(OiisVariable.STRINGLIST);
            oVar.setDescription("S_COMPONENT_LANGUAGES_DESC");
            oVar.setResourceBundle(jrb);
            String sLangsList = "";
            Locale defLocale = Locale.getDefault();
            boolean bDefLocalePresent = false;
            for (int i = 0; i < nLangs; ++i) {
                Locale l = (Locale)vLangs.elementAt(i);
                if (l.equals(defLocale)) {
                    bDefLocalePresent = true;
                }
                String s = OiixResourceBundle.getString("S_ALL_VALUE_COMPS_FROMAT");
                Object[] val = new String[]{l.toString(), " ", OiixLanguage.getDisplayName(l)};
                s = MessageFormat.format(s, val);
                sLangsList = sLangsList + sNewLine + s;
            }
            if (!bDefLocalePresent) {
                defLocale = (Locale)vLangs.elementAt(0);
            }
            String sVal = OiixResourceBundle.getString("S_STRLIST_FROMAT");
            Object[] obj = new String[]{defLocale.toString()};
            sVal = MessageFormat.format(sVal, obj);
            oVar.setInitialValue(new OiisAdvisedValue(sVal, true));
            String sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
            oVar.setCalcMethodPresent(true);
            obj = new String[]{"SELECTED_LANGUAGES", sVal};
            sDesc = MessageFormat.format(sDesc, obj);
            sLangsList = sLangsList + sNewLine + sDesc;
            String schoices = OiixResourceBundle.getString("S_CHOICES1_FORMAT") + sNewLine;
            schoices = schoices + OiixResourceBundle.getString("S_CHOICES3_FORMAT");
            sLangsList = schoices + sLangsList;
            oVar.setAllValueList(sLangsList);
        }
        return oVar;
    }

    public static Vector getToplevelCompVarsList(OiiiStageCompInvEntry ie, boolean bCustom) {
        OiisDeps oDeps;
        String sDesc;
        OiixJarResourceBundle jrb = new OiixJarResourceBundle(OiixResourceBundle.getBundle());
        Vector<OiisVariable> v = new Vector<OiisVariable>();
        OiisVariable oVar = null;
        String sNewLine = System.getProperty("line.separator");
        Vector vLangs = ie.getLanguages();
        int nLangs = vLangs.size();
        if (nLangs > 1) {
            oVar = new OiisVariable(null, "COMPONENT_LANGUAGES");
            oVar.setType(OiisVariable.STRINGLIST);
            oVar.setDescription("S_COMPONENT_LANGUAGES_DESC");
            oVar.setResourceBundle(jrb);
            String sLangsList = "";
            Locale defLocale = Locale.getDefault();
            boolean bDefLocalePresent = false;
            for (int i = 0; i < nLangs; ++i) {
                Locale l = (Locale)vLangs.elementAt(i);
                if (l.equals(defLocale)) {
                    bDefLocalePresent = true;
                }
                String s = OiixResourceBundle.getString("S_ALL_VALUE_COMPS_FROMAT");
                Object[] val = new String[]{l.toString(), " ", OiixLanguage.getDisplayName(l)};
                s = MessageFormat.format(s, val);
                sLangsList = sLangsList + sNewLine + s;
            }
            if (!bDefLocalePresent) {
                defLocale = (Locale)vLangs.elementAt(0);
            }
            String sVal = OiixResourceBundle.getString("S_STRLIST_FROMAT");
            Object[] obj = new String[]{defLocale.toString()};
            sVal = MessageFormat.format(sVal, obj);
            oVar.setInitialValue(new OiisAdvisedValue(sVal, true));
            sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
            oVar.setCalcMethodPresent(true);
            obj = new String[]{"COMPONENT_LANGUAGES", sVal};
            sDesc = MessageFormat.format(sDesc, obj);
            sLangsList = sLangsList + sNewLine + sDesc;
            String schoices = OiixResourceBundle.getString("S_CHOICES1_FORMAT") + sNewLine;
            schoices = schoices + OiixResourceBundle.getString("S_CHOICES3_FORMAT");
            sLangsList = schoices + sLangsList;
            oVar.setAllValueList(sLangsList);
            v.addElement(oVar);
        }
        if ((oDeps = ie.getDeps()) != null) {
            Vector vDepModes = oDeps.getDepModes();
            int nDepModes = vDepModes.size();
            if (nDepModes > 1) {
                oVar = new OiisVariable(null, "INSTALL_TYPE");
                oVar.setType(OiisVariable.STRING);
                oVar.setDescription("S_INSTALL_TYPE_DESC");
                oVar.setResourceBundle(jrb);
                oVar.setCalcMethodPresent(true);
                String sInstallTypeList = "";
                for (int i = 0; i < nDepModes; ++i) {
                    OiisDepMode oDepMode = (OiisDepMode)vDepModes.elementAt(i);
                    String s = OiixResourceBundle.getString("S_ALL_VALUE_COMPS_FROMAT");
                    Object[] val = new String[]{oDepMode.getInternalName(), " ", oDepMode.getName()};
                    s = MessageFormat.format(s, val);
                    sInstallTypeList = sInstallTypeList + sNewLine + s;
                }
                OiisDepMode defMode = (OiisDepMode)vDepModes.elementAt(0);
                oVar.setInitialValue(new OiisAdvisedValue("\"" + defMode.getInternalName() + "\"", true));
                sDesc = OiixResourceBundle.getString("S_EXAMPLE_FORMAT");
                Object[] objs = new String[]{"INSTALL_TYPE", "\"" + defMode.getInternalName() + "\""};
                sDesc = MessageFormat.format(sDesc, objs);
                sInstallTypeList = sInstallTypeList + sNewLine + sDesc;
                String schoices = OiixResourceBundle.getString("S_CHOICES1_FORMAT") + sNewLine;
                schoices = schoices + OiixResourceBundle.getString("S_CHOICES3_FORMAT");
                sInstallTypeList = schoices + sInstallTypeList;
                oVar.setAllValueList(sInstallTypeList);
                v.addElement(oVar);
            }
        } else {
            oVar = new OiisVariable(null, "INSTALL_TYPE");
            oVar.setType(OiisVariable.STRING);
            oVar.setDescription("S_INSTALL_TYPE_DESC");
            oVar.setResourceBundle(jrb);
            oVar.setCalcMethodPresent(true);
        }
        return v;
    }

    public final OiisLWVariableOwner getLWVariableOwner() {
        return new OiicLWSessionContext((Hashtable)this.getVariablesMap());
    }

    public static void writeToXML(String sSessionContextFileName, OiisLWVariableOwner oVarOwner, String startTag) throws IOException {
        FileWriter fWriter = new FileWriter(sSessionContextFileName, false);
        BufferedWriter bWriter = new BufferedWriter(fWriter);
        PrintWriter pWriter = new PrintWriter((Writer)bWriter, true);
        OiicSessionContext.writeToXML(pWriter, oVarOwner, startTag, null);
        pWriter.close();
        bWriter.close();
        fWriter.close();
    }

    public static void writeToXML(PrintWriter pWriter, OiisLWVariableOwner oVarOwner, String startTag, XMLElement globalRootElement) throws IOException {
        OiicSessionContext.writeToXML(pWriter, oVarOwner, startTag, globalRootElement, null);
    }

    public static void writeToXML(PrintWriter pWriter, OiisLWVariableOwner oVarOwner, String startTag, XMLElement globalRootElement, Vector attributes) throws IOException {
        if (pWriter != null && oVarOwner != null && startTag != null && startTag.length() > 0) {
            if (globalRootElement == null) {
                pWriter.println(OixsXMLOps.createXMLDirective(true));
                pWriter.println(OixsXMLOps.getStandardHeader());
            }
            XMLElement sessionVarRoot = new XMLElement("SESSIONVARS");
            int numAttr = attributes == null ? 0 : attributes.size();
            for (int k = 0; k < numAttr; ++k) {
                String[] attr = (String[])attributes.get(k);
                sessionVarRoot.setAttribute(attr[0], attr[1]);
            }
            pWriter.println(OixsXMLOps.getStartTag(sessionVarRoot));
            if (globalRootElement != null) {
                globalRootElement.appendChild((Node)sessionVarRoot);
            }
            XMLElement childElement = new XMLElement(startTag);
            sessionVarRoot.appendChild((Node)childElement);
            pWriter.println(OixsXMLOps.getStartTag(childElement));
            Iterator listVars = ((OiicLWSessionContext)oVarOwner).getVariablesMap().values().iterator();
            while (listVars.hasNext()) {
                OiisVariable oVar;
                XMLElement element = new XMLElement("VAR");
                if (element == null || null == (oVar = (OiisVariable)listVars.next()) || oVar.isGlobalVar()) continue;
                element.setAttribute("NAME", oVar.getName());
                int type = oVar.getType();
                String val = OiicSessionVarsReader.getTypeStringValue(type);
                element.setAttribute("TYPE", val);
                val = oVar.getValueAsString();
                if (type == 3) {
                    Boolean valueObj = (Boolean)oVar.getValue();
                    boolean bValue = valueObj == null ? false : valueObj;
                    val = OiicSessionVarsReader.setBooleanValue(bValue);
                }
                if (!oVar.isSecure()) {
                    element.setAttribute("VALUE", val);
                }
                boolean flag = oVar.getAdvice();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("ADVISE", val);
                flag = oVar.isComputeAtClone();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("COMPUTE_AT_CLONE", val);
                flag = oVar.isCalcMethodPresent();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("CALC_REQD", val);
                element.setAttribute("CLASS", oVar.getClass().getName());
                val = oVar.getExtendsFrom();
                element.setAttribute("EXTENDS_FROM", val);
                flag = oVar.isPublish();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("PUBLISH", val);
                flag = oVar.isShowInOSP();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("SHOW_IN_OSP", val);
                element.setAttribute("DESC_ID", oVar.getDescriptionID());
                flag = oVar.isAllowAssignment();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("ALLOW_ASSIGNMENT", val);
                flag = oVar.isHandleErrors();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("HANDLE_ERRORS", val);
                flag = oVar.isValueReqd();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("VAL_REQD", val);
                flag = oVar.isSecure();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("SECURE", val);
                flag = oVar.isSuppressedOnSilent();
                val = OiicSessionVarsReader.setBooleanValue(flag);
                element.setAttribute("SUPPRESS_ON_SILENT", val);
                childElement.appendChild((Node)element);
                element.print(pWriter);
            }
            pWriter.println(OixsXMLOps.getEndTag(childElement));
            Map envVarMap = ((OiicLWSessionContext)oVarOwner).getEnvironmentVariablesSet();
            if (envVarMap != null) {
                XMLElement envVarRoot = new XMLElement("ENVVARS");
                sessionVarRoot.appendChild((Node)envVarRoot);
                pWriter.println(OixsXMLOps.getStartTag(envVarRoot));
                Iterator envVars = envVarMap.keySet().iterator();
                while (envVars.hasNext()) {
                    XMLElement envElement = new XMLElement("VAR");
                    if (envElement == null) continue;
                    String sName = (String)envVars.next();
                    envElement.setAttribute("NAME", sName);
                    envElement.setAttribute("VALUE", (String)envVarMap.get(sName));
                    envVarRoot.appendChild((Node)envElement);
                    envElement.print(pWriter);
                }
                pWriter.println(OixsXMLOps.getEndTag(envVarRoot));
            }
            pWriter.println(OixsXMLOps.getEndTag(sessionVarRoot));
        }
    }

    public void setSessionVarValFromUser(OiisVariable var) {
        String consoleMessage = null;
        int type = var.getType();
        try {
            if (type == 4) {
                consoleMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22009", new String[]{var.getName()});
                String fetchedInput = OiixInteractiveOps.fetchUserInput(consoleMessage).trim();
                String[] fetchedInputList = OiixFunctionOps.explodeString(fetchedInput, ",");
                var.setValue(fetchedInputList);
            } else if (type == 3) {
                consoleMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22010", new String[]{var.getName()});
                String fetchedInput = OiixInteractiveOps.fetchUserInput(consoleMessage).trim();
                Boolean fetchedInputBool = Boolean.valueOf(fetchedInput);
                var.setValue(fetchedInputBool);
            } else if (type == 2) {
                consoleMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22011", new String[]{var.getName()});
                String fetchedInput = OiixInteractiveOps.fetchUserInput(consoleMessage).trim();
                Integer fetchedInputInt = Integer.valueOf(fetchedInput);
                var.setValue(fetchedInputInt);
            } else {
                consoleMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIC-22011", new String[]{var.getName()});
                String fetchedInput = OiixInteractiveOps.fetchUserInput(consoleMessage).trim();
                var.setValue(fetchedInput);
            }
        }
        catch (OiisVarSettingException e) {
            OiiolTextLogger.appendException(e);
        }
        catch (OiifbCancelException e) {
            OiiolTextLogger.appendException(e);
        }
    }

    public void setVarValue(String varName, Object value) throws OiisVarSettingException, OiifbCancelException {
        OiisVariable oVar = this.getVariable(varName);
        oVar.setValue(value);
    }

    public String[] setRemoteNodeList() throws OiifbCancelException, OiisVarSettingException {
        OiisVariable nodesVar = this.getVariable("REMOTE_NODES");
        String[] remoteNodes = new String[]{};
        if (!Boolean.getBoolean("oracle.installer.clusterEnabled")) {
            nodesVar.setValue(remoteNodes);
            return remoteNodes;
        }
        if (nodesVar.isValueSetByUser()) {
            return (String[])this.getVarValue("REMOTE_NODES");
        }
        String localNode = (String)this.getVarValue("LOCAL_NODE");
        String[] clusterList = (String[])this.getVarValue("CLUSTER_NODES");
        if (localNode == null) {
            if (clusterList != null && clusterList.length > 0) {
                localNode = clusterList[0];
            } else {
                return remoteNodes;
            }
        }
        if (clusterList != null && clusterList.length > 0) {
            remoteNodes = this.removeElement(clusterList, localNode);
        }
        this.setVarValue("REMOTE_NODES", remoteNodes);
        return remoteNodes;
    }

    public String setLocalNodeName(OiiiOracleHomeInfo homeInfo) throws OiisVarSettingException, OiifbCancelException {
        OiipgDetectCluster detectCluster;
        OiisVariable localNodeVar = this.getVariable("LOCAL_NODE");
        String[] nodeList = (String[])this.getVarValue("CLUSTER_NODES");
        if (nodeList == null || nodeList.length <= 0) {
            if (localNodeVar.isValueSet()) {
                localNodeVar.unsetValue();
            }
            OiiolTextLogger.appendText("Cluster nodes not set, local node is unset.", OiiolTextLogger.LOG_DETAILED);
            return null;
        }
        String localNode = (String)localNodeVar.getValue();
        if (localNode != null) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1020", new String[]{localNode}));
            return localNode;
        }
        if (homeInfo != null && (localNode = homeInfo.getLocalNode()) != null) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1025", new String[]{localNode}));
        }
        if (localNode == null && (detectCluster = OiipgDetectCluster.getDetectCluster()) != null && detectCluster.isCluster() && (localNode = detectCluster.getLocalNodeName()) != null) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1024", new String[]{localNode}));
        }
        if (localNode == null && (localNode = nodeList[0]) != null) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OIIFW1021", new String[]{localNode}));
        }
        if (localNode != null) {
            this.setVarValue("LOCAL_NODE", localNode);
        } else {
            OiiolTextLogger.appendText("Local node cannot be computed.", OiiolTextLogger.LOG_DETAILED);
        }
        return localNode;
    }

    private String[] removeElement(String[] input, String element) {
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < input.length; ++i) {
            String item = input[i];
            if (element.equalsIgnoreCase(item)) continue;
            result.add(item);
        }
        return result.toArray(new String[0]);
    }
}

