/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallOneoffInvEntry;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiOneoffException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;

public class OiicSaveInventory
extends OiicBaseApp {
    private static final String s_baseAppPrefix = "oui";
    private static OiicSaveInventory s_oiicSaveInventory = null;
    private static boolean s_bIsWindows = false;
    private OiicSessionContext m_oContext = null;
    private String m_sOracleHome = null;
    private String m_sOldCompsXML = null;
    private String m_sNewCompsXML = null;
    private Vector m_vExistingOneoffs = null;

    public static OiicSaveInventory getOiicSaveInventoryInstance() {
        if (s_oiicSaveInventory == null) {
            s_oiicSaveInventory = new OiicSaveInventory();
        }
        return s_oiicSaveInventory;
    }

    public OiicSaveInventory() {
        super(s_baseAppPrefix);
    }

    public static void main(String[] args) {
        OiicSaveInventory oSaveInventory = OiicSaveInventory.getOiicSaveInventoryInstance();
        System.setProperty("oracle.installer.noGUI", "yes");
        boolean bl = s_bIsWindows = -3 == OiixPlatform.getPlatGroup(OiixPlatform.getCurrentPlatform());
        if (!s_bIsWindows) {
            oSaveInventory.main_helper(args);
        }
    }

    @Override
    public void processCommandLine(String[] args) {
        this.processCmdLine(args);
        this.setAdditionalProperties();
    }

    @Override
    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main_helper(String[] args) {
        String sMsg;
        OiicExitCode.setExitCode(0);
        try {
            this.processCommandLine(args);
            if (this.isHelpOptionSpecified()) {
                this.displayHelp();
            } else {
                this.m_oContext = new OiicSessionContext(this);
                this.m_oContext.setVariables();
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_BASIC) {
                    OiiolTextLogger.appendText("Done creating session context and setting session variables as per command line", OiiolTextLogger.LOG_BASIC);
                }
                this.m_sOracleHome = (String)this.m_oContext.getVarValue("ORACLE_HOME");
                OiiolTextLogger.appendText("OiicSaveInventory: ORACLE_HOME is " + this.m_sOracleHome);
                try {
                    this.doOperation();
                }
                catch (Exception e) {
                    OiiolTextLogger.appendException(e);
                    OiicExitCode.setExitCode(-1);
                }
            }
            sMsg = null;
        }
        catch (Throwable e) {
            String sMsg2;
            try {
                System.err.println("Exception " + e + " occurred..");
                e.printStackTrace();
                OiicExitCode.setExitCode(-1);
                String sMsg3 = "";
                String sUnknown = OiixResourceBundle.getString("S_LOG_UNKNOWN");
                String sLogLoc = OiiolTextLogger.getCurLogFileName();
                sLogLoc = sLogLoc == null || sLogLoc.equals("") ? sUnknown : sLogLoc;
                String sErrLoc = OiixTeePrintStream.getErrFileLoc();
                sErrLoc = sErrLoc == null || sErrLoc.equals("") ? sUnknown : sErrLoc;
                String sOutLoc = OiixTeePrintStream.getOutFileLoc();
                sOutLoc = sOutLoc == null || sOutLoc.equals("") ? sUnknown : sOutLoc;
                sMsg3 = OiixResourceBundle.getString("S_CALL_SUPPORT", new Object[]{sLogLoc, sErrLoc, sOutLoc});
                sMsg3 = OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_MSG") + " " + sMsg3;
                OiifmAlert.displayError(sMsg3, OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_TITLE"));
                sMsg2 = null;
            }
            catch (Throwable throwable) {
                String sMsg4 = null;
                int iExitCode = OiicExitCode.getExitCode();
                String op = OiicSaveInventory.getLogPrefix();
                Object[] args1 = new String[]{op};
                switch (iExitCode) {
                    case 0: {
                        sMsg4 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTEOP_SUCCESS", args1);
                        break;
                    }
                    case -1: {
                        sMsg4 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTEOP_FAILURE", args1);
                    }
                }
                if (sMsg4 != null) {
                    OiiolTextLogger.writeToLogAndConsole(sMsg4);
                }
                throw throwable;
            }
            int iExitCode = OiicExitCode.getExitCode();
            String op = OiicSaveInventory.getLogPrefix();
            Object[] args1 = new String[]{op};
            switch (iExitCode) {
                case 0: {
                    sMsg2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTEOP_SUCCESS", args1);
                    break;
                }
                case -1: {
                    sMsg2 = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTEOP_FAILURE", args1);
                }
            }
            if (sMsg2 != null) {
                OiiolTextLogger.writeToLogAndConsole(sMsg2);
            }
        }
        int iExitCode = OiicExitCode.getExitCode();
        String op = OiicSaveInventory.getLogPrefix();
        Object[] args1 = new String[]{op};
        switch (iExitCode) {
            case 0: {
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTEOP_SUCCESS", args1);
                break;
            }
            case -1: {
                sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_REMOTEOP_FAILURE", args1);
            }
        }
        if (sMsg != null) {
            OiiolTextLogger.writeToLogAndConsole(sMsg);
        }
    }

    public void doOperation() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiiiInventoryUpdateException, OiifbCancelException, OiisVarSettingException, OiifbEndIterateException, OiiiOneoffException {
        if (!this.validateHomeVariable()) {
            return;
        }
        if (!this.checkNewInventoryExists()) {
            return;
        }
        if (this.checkOldInventoryExists()) {
            this.readOldInventory();
        }
        this.saveNewInventory();
    }

    private static String getLogPrefix() {
        return "SaveInventory";
    }

    private boolean validateHomeVariable() {
        if (this.m_sOracleHome == null || this.m_sOracleHome.equals("")) {
            Object[] args1 = new String[]{" ORACLE_HOME"};
            OiiolTextLogger.writeToLogAndConsole("OIIC-22014", args1);
            OiicExitCode.setExitCode(-1);
            return false;
        }
        return true;
    }

    private boolean checkNewInventoryExists() {
        String invDir = OiixPathOps.concatPath(this.m_sOracleHome, "inventory");
        this.m_sOldCompsXML = OiixPathOps.concatPath(invDir, "ContentsXML");
        this.m_sOldCompsXML = OiixPathOps.concatPath(this.m_sOldCompsXML, "comps.xml");
        this.m_sNewCompsXML = OiixPathOps.concatPath(invDir, "ContentsXML");
        this.m_sNewCompsXML = OiixPathOps.concatPath(this.m_sNewCompsXML, "comps.new.xml");
        OiiolTextLogger.appendText("OiicSaveInventory: Checking new inventory at : " + this.m_sNewCompsXML);
        if (this.m_sNewCompsXML != null && this.m_sNewCompsXML != "") {
            File fCompsNew = new File(this.m_sNewCompsXML);
            if (!fCompsNew.exists()) {
                OiiolTextLogger.appendText("OiicSaveInventory: new inventory does not exist.");
                return false;
            }
            OiiolTextLogger.appendText("OiicSaveInventory: new inventory exists.");
        }
        return true;
    }

    private boolean checkOldInventoryExists() {
        File fCompsOld;
        OiiolTextLogger.appendText("OiicSaveInventory: Checking old inventory at : " + this.m_sOldCompsXML);
        if (this.m_sOldCompsXML != null && this.m_sOldCompsXML != "" && !(fCompsOld = new File(this.m_sOldCompsXML)).exists()) {
            OiiolTextLogger.appendText("OiicSaveInventory: old inventory does not exist.");
            return false;
        }
        OiiolTextLogger.appendText("OiicSaveInventory: old inventory exist.");
        return true;
    }

    private void readOldInventory() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        OiicStandardInventorySession invSession = null;
        OiiolTextLogger.appendText("Creating a new Inventory Session");
        invSession = new OiicStandardInventorySession(OiicSaveInventory.getLogPrefix(), OiicInstVersion.getVersionString());
        OiiolTextLogger.appendText("Iniitializing the inventory session with access 0");
        invSession.initSession(0);
        OiiiInstallAreaControl iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        OiiolTextLogger.appendText("The access level of the inventory is " + iAreaControl.getAccessLevel());
        OiiiInstallInventory instinv = iAreaControl.getInstallInventory();
        OiiiOracleHomeInfo ohi = instinv.getHomeWithLocation(this.m_sOracleHome);
        if (ohi != null) {
            OiiolTextLogger.appendText("OiicSaveInventory: reading the one-off entried from old inventory");
            this.m_vExistingOneoffs = instinv.getAllOneoffInvEntries(ohi);
        }
        if (invSession != null) {
            invSession.endSession();
        }
    }

    private void saveNewInventory() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiifbCancelException, OiiiOneoffException, OiifbEndIterateException {
        OiixFileOps.copyFile(this.m_sNewCompsXML, this.m_sOldCompsXML, true);
        OiicStandardInventorySession invSession = null;
        OiiolTextLogger.appendText("Creating a new Inventory Session");
        invSession = new OiicStandardInventorySession(OiicSaveInventory.getLogPrefix(), OiicInstVersion.getVersionString());
        OiiolTextLogger.appendText("Iniitializing the inventory session with access 1");
        invSession.initSession(1);
        OiiiInstallAreaControl iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        OiiolTextLogger.appendText("The access level of the inventory is " + iAreaControl.getAccessLevel());
        String sInvLocation = iAreaControl.getAreaRoot();
        OiicPullSession.createDuplicateStreams(sInvLocation);
        OiiiInstallInventory instinv = iAreaControl.getInstallInventory();
        OiiiOracleHomeInfo ohi = instinv.getHomeWithLocation(this.m_sOracleHome);
        if (ohi != null) {
            int iSize = this.m_vExistingOneoffs != null ? this.m_vExistingOneoffs.size() : 0;
            OiiolTextLogger.appendText("OiicSaveInventory: adding " + iSize + " one-off entried to new inventory.");
            for (int k = 0; k < iSize; ++k) {
                OiiiInstallOneoffInvEntry ooEntry = (OiiiInstallOneoffInvEntry)this.m_vExistingOneoffs.elementAt(k);
                instinv.addOneoffInvEntry(ooEntry, ohi.getIndex());
            }
            OiiolTextLogger.appendText("OiicSaveInventory: saving the new inventory");
            iAreaControl.saveInstallInventory();
            File fNewComps = new File(this.m_sNewCompsXML);
            if (fNewComps.exists()) {
                OiiolTextLogger.appendText("OiicSaveInventory: now removing the file: " + this.m_sNewCompsXML);
                fNewComps.delete();
            }
        }
        if (invSession != null) {
            invSession.endSession();
        }
    }
}

