/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.emCfg.common.EmCfgActionPerform;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicRunConfig {
    private static final String logFileName = "configActions";
    private static final String logExtension = ".log";
    private static final String errExtension = ".err";
    private static final String LIB_DIR = "lib";
    private static final String false_val = "false";
    private static final String oui = "oui";
    private static final String SEPERATOR = "\n-------------------------------------------------------\n";
    private static final String COMMAND_ARRAY = "Command Array: ";
    private static final int RUNCONFIG_EXIT_CODE_RUNCONFIG_FAILURE = 1;
    private Map m_oCommandLineArgs;
    private Map m_oValidArgs;
    private String m_oracle_installer_invptrloc = null;
    private static OiicStandardInventorySession m_oSession = null;
    private String installerVersion = OiicInstVersion.getVersionString();
    private List m_oInvalidArgs;
    private String helpString = null;
    private boolean bArgsPresent = false;
    private String m_oh = null;
    private String m_logLoc = null;
    private String m_actionName = null;
    private String m_mode = "listTools";
    private String m_runConfigProdHomeLoc = null;
    private static final String[] validArgs = new String[]{"ORACLE_HOME", "ACTION", "MODE", "RESPONSE_FILE", "INV_PTR_LOC", "RERUN", "COMPONENT_XML", "help", "debug", "OPTIONAL_CONFIG_TOOLS", "CUSTOM_ACTION"};

    public void runConfig() {
    }

    public void init() {
        this.m_oValidArgs = new HashMap(20, 10.0f);
        for (int i = 0; i < validArgs.length; ++i) {
            this.m_oValidArgs.put(validArgs[i], validArgs[i]);
        }
    }

    private String getAppHelpString() {
        String helpStr = null;
        Object[] sArgs = new String[]{OiicInstVersion.getCopyrightCurrentYear()};
        helpStr = OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform()) ? OiixResourceBundle.getString("S_OUI_NAME") + "," + OiicInstVersion.getVersionString() + "\n" + OiixResourceBundle.getString("S_COPYRIGHT", sArgs) + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_DESCRIPTION") + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_USAGE_UNIX") + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_OPTION_REFERENCE") + " \n\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_OPTIONS") + " \n" + OiixResourceBundle.getString("S_RUNCONFIG_ORACLE_HOME_OPTION") + "      \n " + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_ACTION_OPTION") + "       \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_CUSTOM_ACTION") + "       \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_MODE_OPTION") + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_MODE_EXAMPLE") + "      \n " + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_COMPONENT_XML_OPTION_UNIX") + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_COMPONENT_XML_EXAMPLE") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_OPTIONAL_CONFIG_TOOLS_UNIX") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_RESPONSE_FILE_UNIX") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_INV_PTR_LOC") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_RERUN_OPTION") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_HELP_UNIX") + "        \n " + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_EXAMPLE1_UNIX") + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_EXAMPLE2_UNIX") + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_EXAMPLE3_UNIX") : OiixResourceBundle.getString("S_OUI_NAME") + "," + OiicInstVersion.getVersionString() + "\n" + OiixResourceBundle.getString("S_COPYRIGHT", sArgs) + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_DESCRIPTION") + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_USAGE_WINDOWS") + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_OPTION_REFERENCE") + " \n\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_OPTIONS") + " \n" + OiixResourceBundle.getString("S_RUNCONFIG_ORACLE_HOME_OPTION") + "      \n " + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_ACTION_OPTION") + "       \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_CUSTOM_ACTION") + "       \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_MODE_OPTION") + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_MODE_EXAMPLE") + "      \n " + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_COMPONENT_XML_OPTION_WINDOWS") + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_COMPONENT_XML_EXAMPLE") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_OPTIONAL_CONFIG_TOOLS_WINDOWS") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_RESPONSE_FILE_WINDOWS") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_RERUN_OPTION") + "      \n" + "      \n" + OiixResourceBundle.getString("S_RUNCONFIG_HELP_WINDOWS") + "        \n " + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_EXAMPLE1_WINDOWS") + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_EXAMPLE2_WINDOWS") + "\n\n" + OiixResourceBundle.getString("S_RUNCONFIG_EXAMPLE3_WINDOWS");
        return helpStr;
    }

    private void loadInventory() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException {
        String sLibraryLoc = OiixPathOps.concatPath(this.m_runConfigProdHomeLoc, LIB_DIR);
        String dirName = OiixPlatform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath(sLibraryLoc, dirName);
        sLibraryLoc = OiixPathOps.getNativeForm(sLibraryLoc);
        System.setProperty("oracle.installer.library_loc", sLibraryLoc);
        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            if (this.m_oracle_installer_invptrloc == null) {
                this.m_oracle_installer_invptrloc = OiipgPropertyLoader.getUnixPtrFileLoc();
            }
            System.setProperty("oracle.installer.invPtrLoc", this.m_oracle_installer_invptrloc);
        }
        m_oSession = new OiicStandardInventorySession(oui, this.installerVersion);
        m_oSession.initSession(0);
    }

    public void processCmdLine(String[] args) {
        this.parseCmdLine(args);
    }

    public Map getCommandLineArgs() {
        if (this.m_oCommandLineArgs == null) {
            this.m_oCommandLineArgs = new HashMap(20, 10.0f);
        }
        return this.m_oCommandLineArgs;
    }

    protected void parseCmdLine(String[] args) {
        Map commandLineArgsTable = this.getCommandLineArgs();
        int nArgsIndex = 0;
        if (args == null) {
            return;
        }
        if (args.length > 0) {
            this.setArgsPresent(true);
        }
        while (nArgsIndex < args.length) {
            int advanceBy = 1;
            boolean found = false;
            String sCurArg = args[nArgsIndex].trim();
            if (!found) {
                int iIndex = sCurArg.indexOf("=");
                if (iIndex != -1) {
                    String varName = sCurArg.substring(0, iIndex);
                    String varValue = sCurArg.substring(iIndex + 1, sCurArg.length());
                    if (this.isValidArg(varName)) {
                        found = true;
                        commandLineArgsTable.put(varName, varValue);
                    }
                } else {
                    iIndex = sCurArg.indexOf("-");
                    if (iIndex != -1) {
                        String varValue = "";
                        String varName = sCurArg.substring(iIndex + 1, sCurArg.length());
                        if (this.isValidArg(varName)) {
                            found = true;
                            commandLineArgsTable.put(varName, varValue);
                        }
                    }
                }
            }
            if (!found) {
                if (sCurArg.trim().length() == 0) {
                    ++nArgsIndex;
                    continue;
                }
                this.addToInvalidArgs(sCurArg);
            }
            nArgsIndex += advanceBy;
        }
    }

    private boolean isValidArg(String arg) {
        return this.m_oValidArgs != null && this.m_oValidArgs.get(arg) != null;
    }

    private void addToInvalidArgs(String sInvalidArg) {
        if (this.m_oInvalidArgs == null) {
            this.m_oInvalidArgs = new ArrayList(5);
        }
        this.m_oInvalidArgs.add(sInvalidArg);
    }

    public boolean anyInValidArgPresent() {
        return this.m_oInvalidArgs != null && !this.m_oInvalidArgs.isEmpty();
    }

    public List getInValidArgs() {
        return this.m_oInvalidArgs;
    }

    private String[] getArgumentList() {
        String optionalTools;
        String outFile;
        int reqt;
        Integer reqT;
        String Md;
        String rerunVal;
        String Action2;
        String Hyphen = "-";
        boolean bValidateActionType = true;
        ArrayList<String> argList = new ArrayList<String>();
        String OH = (String)this.m_oCommandLineArgs.get("ORACLE_HOME");
        if (OH == null) {
            System.out.println(OiixResourceBundle.getString("S_RUNCONFIG_NO_HOME_SPECIFIED"));
            System.exit(1);
        }
        argList.add(Hyphen.concat("oracleHome"));
        argList.add(OH);
        this.m_oh = OH;
        String sCustomActionSpecified = (String)this.m_oCommandLineArgs.get("CUSTOM_ACTION");
        if (null != sCustomActionSpecified) {
            boolean bl = bValidateActionType = new Boolean(sCustomActionSpecified) == false;
        }
        if ((Action2 = (String)this.m_oCommandLineArgs.get("ACTION")) == null) {
            System.out.println(OiixResourceBundle.getString("S_RUNCONFIG_NO_ACTION_SPECIFIED"));
            System.exit(1);
        }
        argList.add(Hyphen.concat("actionType"));
        if (bValidateActionType) {
            String actTypeName = OiixCFOps.getActionTypeNameFromUFActionName(Action2);
            if (actTypeName == null) {
                System.out.println(OiixResourceBundle.getString("S_RUNCONFIG_INVALID_ACTION_SPECIFIED"));
                System.exit(1);
            }
            this.m_actionName = Action2;
            argList.add(actTypeName);
        } else {
            this.m_actionName = Action2;
            argList.add(this.m_actionName);
        }
        String Mode = (String)this.m_oCommandLineArgs.get("MODE");
        argList.add(Hyphen.concat("requestType"));
        Integer reqType = new Integer(this.getRequestType(Mode));
        int rt = reqType;
        if (rt == 1 || rt == 5) {
            this.m_mode = Mode;
        }
        argList.add(reqType.toString());
        String ComponentXMLs = (String)this.m_oCommandLineArgs.get("COMPONENT_XML");
        String[] CompXMLs = this.getComponentXMLs(ComponentXMLs);
        if (CompXMLs == null) {
            boolean bFound = false;
            String homeLoc = OH;
            OiiiOracleHomeInfo oh = m_oSession.getInstallAreaControl().getInstallInventory().getHomeWithLocation(homeLoc);
            if (null != oh) {
                bFound = true;
            }
            if (!bFound) {
                System.out.println(OiixResourceBundle.getString("S_RUNCONFIG_INVALID_ORAHOME"));
                System.exit(1);
            } else {
                int ohIndex = oh.getIndex();
                OiiiInstallInventory installInv = m_oSession.getInstallAreaControl().getInstallInventory();
                Vector TLComps = installInv.getTopLevelComps(ohIndex, OiixPlatform.getCurrentPlatform());
                String aggrIDList = null;
                for (int i = 0; i < TLComps.size(); ++i) {
                    OiiiCompInstallID cid = (OiiiCompInstallID)TLComps.elementAt(i);
                    OiiiInstallCompInvEntry icie = installInv.getInstallCompInvEntry(cid, ohIndex);
                    OiiiVersion v102 = OiicInstVersion.getCompatibleInstallerVersion();
                    if (!icie.getInstallerVersion().laterThan(v102) && !icie.getInstallerVersion().equals(v102)) continue;
                    aggrIDList = aggrIDList == null ? cid.getName() + "," : aggrIDList + cid.getName() + ",";
                }
                aggrIDList = aggrIDList.substring(0, aggrIDList.length() - 1);
                argList.add(Hyphen.concat("aggregateID"));
                argList.add(aggrIDList);
            }
        } else {
            String aggrIDList = null;
            if (CompXMLs.length != 0) {
                for (int i = 0; i < CompXMLs.length; ++i) {
                    String aggrXMLFileName = CompXMLs[i];
                    String aggrId = this.getAggrID(aggrXMLFileName);
                    aggrIDList = aggrIDList == null ? aggrId + "," : aggrIDList + aggrId + ",";
                }
            }
            aggrIDList = aggrIDList.substring(0, aggrIDList.length() - 1);
            argList.add(Hyphen.concat("aggregateID"));
            argList.add(aggrIDList);
        }
        argList.add(Hyphen.concat("descriptionPath"));
        argList.add(OiiiInstallAreaControl.getConfigXMLDirRltPath());
        argList.add(Hyphen.concat("instancePath"));
        argList.add(OiiiInstallAreaControl.getConfigXMLDirRltPath());
        String rspFileName = (String)this.m_oCommandLineArgs.get("RESPONSE_FILE");
        if (rspFileName != null) {
            argList.add(Hyphen.concat("responseFile"));
            argList.add(rspFileName);
        }
        if ((rerunVal = (String)this.m_oCommandLineArgs.get("RERUN")) != null) {
            Md = (String)this.m_oCommandLineArgs.get("MODE");
            reqT = new Integer(this.getRequestType(Md));
            reqt = reqT;
            if (rerunVal.equalsIgnoreCase(false_val) && reqt == 1) {
                argList.add(Hyphen.concat("retry"));
            }
        } else {
            Md = (String)this.m_oCommandLineArgs.get("MODE");
            reqT = new Integer(this.getRequestType(Md));
            reqt = reqT;
            if (reqt == 1) {
                argList.add(Hyphen.concat("retry"));
            }
        }
        this.m_logLoc = outFile = this.getLogFile();
        argList.add(Hyphen.concat("out"));
        argList.add(outFile);
        String errFile = this.getErrFile();
        argList.add(Hyphen.concat("err"));
        argList.add(errFile);
        String debugFlag = (String)this.m_oCommandLineArgs.get("debug");
        if (debugFlag != null) {
            argList.add(Hyphen.concat("debug"));
        }
        if ((optionalTools = (String)this.m_oCommandLineArgs.get("OPTIONAL_CONFIG_TOOLS")) != null) {
            argList.add(Hyphen.concat("optionalTools"));
            argList.add(optionalTools);
        }
        String[] tmp = new String[argList.size()];
        argList.toArray(tmp);
        return tmp;
    }

    private String getLogFile() {
        String relLogLoc = "cfgtoollogs/oui/";
        String logAbsDir = this.m_oh.concat("/").concat(relLogLoc);
        String propName = "oracle.installer.logScratchPath";
        if (System.getProperty(propName, null) != null) {
            logAbsDir = System.getProperty(propName) + File.separator;
        }
        String logFileAbsName = null;
        logFileAbsName = logAbsDir + logFileName + OiiolLoggerUtil.getTimeStamp() + logExtension;
        String logFileNativeName = OiixPathOps.getNativeForm(logFileAbsName);
        return logFileNativeName;
    }

    private String getErrFile() {
        String relLogLoc = "cfgtoollogs/oui/";
        String logAbsDir = this.m_oh.concat("/").concat(relLogLoc);
        String errLogFileAbsName = null;
        errLogFileAbsName = logAbsDir + "/" + logFileName + OiiolLoggerUtil.getTimeStamp() + errExtension;
        String errLogFileNativeName = OiixPathOps.getNativeForm(errLogFileAbsName);
        return errLogFileNativeName;
    }

    private int getRequestType(String mode) {
        if (mode == null) {
            return 4;
        }
        if (mode.compareToIgnoreCase("listTools") == 0) {
            return 4;
        }
        if (mode.compareToIgnoreCase("perform") == 0) {
            return 1;
        }
        if (mode.compareToIgnoreCase("showStatus") == 0) {
            return 5;
        }
        return 4;
    }

    private String[] getComponentXMLs(String compXMLs) {
        if (compXMLs == null) {
            return null;
        }
        String[] retStr = null;
        String XMLs = compXMLs.replace('{', ' ');
        XMLs = XMLs.replace('}', ' ');
        if ((XMLs = XMLs.trim()) != null && XMLs.length() != 0) {
            retStr = XMLs.split(",");
            for (int i = 0; i < retStr.length; ++i) {
                retStr[i] = retStr[i].trim();
            }
            if (retStr != null && retStr.length != 0) {
                return retStr;
            }
            return null;
        }
        return null;
    }

    private boolean isHelpNeeded() {
        String help = (String)this.m_oCommandLineArgs.get("help");
        return help != null && help.length() == 0;
    }

    private void setInvPtr() {
        String OH;
        String invPtrLoc = (String)this.m_oCommandLineArgs.get("INV_PTR_LOC");
        if (invPtrLoc != null) {
            this.m_oracle_installer_invptrloc = invPtrLoc;
        }
        if (this.m_oracle_installer_invptrloc == null && null != (OH = (String)this.m_oCommandLineArgs.get("ORACLE_HOME"))) {
            this.m_oracle_installer_invptrloc = OH + File.separator + "oraInst.loc";
            if (new File(this.m_oracle_installer_invptrloc).exists()) {
                System.out.println("Setting the invPtrLoc to " + this.m_oracle_installer_invptrloc);
            } else {
                this.m_oracle_installer_invptrloc = null;
            }
        }
    }

    private String getAggrID(String aggrXMLFileName) {
        int secondLastDotIndex;
        int lastDotIndex = aggrXMLFileName.lastIndexOf(".");
        if (lastDotIndex < 0) {
            System.out.println("COMPONENT_XML" + OiixResourceBundle.getString("S_RUNCONFIG_COMPONENT_XML_WRONG_FORMAT"));
            System.exit(1);
        }
        if ((secondLastDotIndex = aggrXMLFileName.lastIndexOf(".", lastDotIndex - 1)) < 0) {
            System.out.println("COMPONENT_XML" + OiixResourceBundle.getString("S_RUNCONFIG_COMPONENT_XML_WRONG_FORMAT"));
            System.exit(1);
        }
        String aggrID = aggrXMLFileName.substring(0, secondLastDotIndex);
        return aggrID;
    }

    private boolean argumentListOk() {
        String[] mandatoryArgs = new String[]{"ORACLE_HOME", "ACTION"};
        String val = (String)this.m_oCommandLineArgs.get("help");
        if (val != null) {
            return true;
        }
        for (int i = 0; i < mandatoryArgs.length; ++i) {
            val = (String)this.m_oCommandLineArgs.get(mandatoryArgs[i]);
            if (val != null) continue;
            return false;
        }
        return true;
    }

    public boolean isDebugOn() {
        String val = (String)this.m_oCommandLineArgs.get("debug");
        return val != null;
    }

    private boolean isArgsPresent() {
        return this.bArgsPresent;
    }

    private void setArgsPresent(boolean bVal) {
        this.bArgsPresent = bVal;
    }

    private String getHelpString() {
        if (this.helpString == null) {
            this.helpString = this.getAppHelpString();
        }
        return this.helpString;
    }

    public String getLogLocation() {
        return OiixPathOps.getNativeForm(this.m_logLoc);
    }

    public void writeArgList(String[] argList) {
        System.out.println(COMMAND_ARRAY);
        for (int i = 0; i < argList.length; ++i) {
            System.out.print(argList[i] + " ");
        }
        System.out.println(SEPERATOR);
    }

    public String getActionName() {
        return this.m_actionName;
    }

    public String getMode() {
        return this.m_mode;
    }

    public void setRunConfigPROD_HOME(String loc) {
        this.m_runConfigProdHomeLoc = loc;
    }

    public static void main(String[] arguments) {
        OiicRunConfig runConfig = new OiicRunConfig();
        runConfig.init();
        if (arguments.length > 0) {
            runConfig.setRunConfigPROD_HOME(arguments[0]);
        }
        String[] args = null;
        if (arguments.length > 1) {
            args = new String[arguments.length - 1];
            for (int argCount = 1; argCount < arguments.length; ++argCount) {
                args[argCount - 1] = arguments[argCount];
            }
        }
        runConfig.processCmdLine(args);
        if (runConfig.anyInValidArgPresent()) {
            List inValidArgs = runConfig.getInValidArgs();
            String[] tmp = new String[inValidArgs.size()];
            inValidArgs.toArray(tmp);
            for (int j = 0; j < tmp.length; ++j) {
                System.out.print(tmp[j] + " ");
            }
            System.out.print(OiixResourceBundle.getString("S_RUNCONFIG_INVALID_OPTION_NOT_SUPPORTED"));
            System.out.println(OiixResourceBundle.getString("S_RUNCONFIG_TRY_HELP"));
            System.exit(1);
        }
        if (!runConfig.isArgsPresent()) {
            System.out.println(runConfig.getHelpString());
            System.exit(1);
        }
        if (!runConfig.argumentListOk()) {
            System.out.println(OiixResourceBundle.getString("S_RUNCONFIG_INVALID_ARG_LIST"));
            System.exit(1);
        }
        if (runConfig.isHelpNeeded()) {
            System.out.println(runConfig.getHelpString());
            System.exit(1);
        }
        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            runConfig.setInvPtr();
        }
        try {
            runConfig.loadInventory();
        }
        catch (OiitTargetLockNotAvailableException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        String[] argList = runConfig.getArgumentList();
        System.out.println("\n" + runConfig.getMode() + OiixResourceBundle.getString("S_RUNCONFIG_ACTION_START_MESSAGE") + runConfig.getActionName() + "\n");
        if (runConfig.isDebugOn()) {
            runConfig.writeArgList(argList);
        }
        if (null != m_oSession) {
            m_oSession.endSession();
        }
        int exitCode = EmCfgActionPerform.start((String[])argList);
        System.out.println("\n" + runConfig.getMode() + OiixResourceBundle.getString("S_RUNCONFIG_ACTION_END_MESSAGE") + runConfig.getActionName() + "\n");
        System.out.println(OiixResourceBundle.getString("S_RUNCONFIG_LOGFILE_MESSAGE") + runConfig.getLogLocation());
        System.exit(exitCode);
    }
}

