/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointFactory;
import oracle.sysman.oic.oics.OicsICheckPoint;
import oracle.sysman.oic.oics.OicsICheckPointIndexSession;
import oracle.sysman.oic.oics.OicsICheckPointProperty;
import oracle.sysman.oic.oics.OicsICheckPointSession;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiMissingDependeeException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterRunCmd;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicRemoveHome
extends OiicBaseInventoryApp {
    private static final String appName = "removehome";
    private static OiicRemoveHome s_oRemoveHome = null;
    private String sOBase = null;
    private String sOHomeLoc = null;
    private final String sComponent = "oui";
    private String sOHomeName;
    private String sFileName;
    private String chkpointFile;
    private static OicsICheckPointIndexSession cpis = null;
    private OicsICheckPointSession cps = null;

    private OiicRemoveHome() {
        super(appName);
    }

    private OiicRemoveHome(String app) {
        super(app);
    }

    public static OiicRemoveHome getOiicRemoveHomeInstance() {
        if (s_oRemoveHome == null) {
            s_oRemoveHome = new OiicRemoveHome();
        }
        return s_oRemoveHome;
    }

    @Override
    protected String getLogPrefix() {
        return "RemoveHome";
    }

    protected void setHomeLocalNode(OiiiOracleHomeInfo homeInfo, String localNode) {
    }

    @Override
    protected String[] setClusterNodes(OiiiOracleHomeInfo homeInfo, OiicSessionContext oContext) throws OiisVarSettingException, OiifbCancelException {
        String[] clusterNodes = OiixVectorOps.list2StrArr(homeInfo.getNodeList());
        oContext.setVarValue("CLUSTER_NODES", clusterNodes);
        return clusterNodes;
    }

    @Override
    public void doOperation(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiifbCancelException, OiiiInventoryUpdateException, IOException, OiixException, OiiiMissingDependeeException, OiisVarSettingException, OiipgClusterException {
        String checkpointLoc;
        OiiiOracleHomeInfo homeInfo = this.getOracleHomeInfo(iac, oContext);
        String invLoc = (String)oContext.getVarValue("INVENTORY_LOCATION");
        OicsICheckPointProperty cpp = null;
        OicsICheckPoint cp2 = null;
        String chkPointName2 = null;
        String string = checkpointLoc = this.computeCheckPointLoc(oContext) == null ? null : this.computeCheckPointLoc(oContext);
        if (checkpointLoc != null) {
            this.initializeCheckPointIndexSession(checkpointLoc, "oui");
        }
        this.initializeCheckPointSession(oContext);
        OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session for removeHome.");
        if (cpis != null) {
            cpp = this.sOBase != null ? OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)this.sOBase) : OicsCheckPointFactory.constructStringProperty((String)"ORACLE_BASE", (String)"");
            chkPointName2 = "oracle.installer.removeHome";
            this.cps = cpis.initCheckPointSession(this.sFileName);
            if (this.cps != null && (cp2 = this.cps.getCheckPoint(chkPointName2)) == null) {
                cp2 = OicsCheckPointFactory.constructCheckPoint((int)1, (String)chkPointName2, (String)"This is the removeHome inventory operation");
                cp2.setCheckPointState(2);
                cp2.addCheckPointProperty(cpp);
                cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME_NAME", (String)this.sOHomeName);
                cp2.addCheckPointProperty(cpp);
                cpp = OicsCheckPointFactory.constructStringProperty((String)"ORACLE_HOME", (String)this.sOHomeLoc);
                cp2.addCheckPointProperty(cpp);
                if (this.cps != null && cp2 != null) {
                    this.cps.addCheckPoint(cp2);
                }
            }
        }
        OiiiInstallInventory instinv = iac.getInstallInventory();
        boolean bSharedHome = this.isSharedHome(homeInfo.getLocation(), this.m_sLocalNode);
        this.updateOHProperties(homeInfo, oContext, bSharedHome);
        instinv.removeHomeForce(homeInfo, true);
        iac.saveInstallInventory();
        if (this.m_saRemoteNodes != null && this.m_saRemoteNodes.length > 0) {
            String sCustomInvPtrLoc = this.getCustomUnixInvPtrLoc();
            if (sCustomInvPtrLoc != null && sCustomInvPtrLoc.trim().length() > 0) {
                this.setupRemoteInvPtrLoc(this.m_saRemoteNodes, sCustomInvPtrLoc);
            }
            this.clsCmdRemoveHome(this.m_saRemoteNodes, this.m_sOracleHome, this.m_sOracleHomeName, this.m_sLocalNode, invLoc, sCustomInvPtrLoc, bSharedHome);
        }
        if (cp2 != null && this.cps != null) {
            cpp = OicsCheckPointFactory.constructStringProperty((String)"LOCALNODE", (String)this.m_sLocalNode);
            cp2.addCheckPointProperty(cpp);
            cp2.setCheckPointState(3);
            this.cps.addCheckPoint(cp2);
            this.cps.saveCheckPointSession();
            try {
                this.cps.closeCheckPointSession();
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText(e.getMessage());
            }
        }
    }

    public void clsCmdRemoveHome(String[] nodesToRunOn, String oracleHome, String oracleHomeName, String currentNode, String invLoc, String invPtrLoc, boolean bSharedHome) {
        this.m_clsRunCmd = new OiipgClusterRunCmd(nodesToRunOn);
        String cmd = "-removeHome -noClusterEnabled ORACLE_HOME=" + oracleHome;
        this.runRemoteInvOpCmd(cmd, nodesToRunOn, oracleHome, oracleHomeName, currentNode, invLoc, invPtrLoc, bSharedHome);
    }

    private void initializeCheckPointSession(OiicSessionContext s_context) {
        if (s_context != null) {
            String checkpointLoc;
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiicremoveHome.");
            if (s_context.getVarValue("ORACLE_BASE") != null) {
                this.sOBase = (String)s_context.getVarValue("ORACLE_BASE");
            }
            if (s_context.getVarValue("ORACLE_HOME") != null) {
                this.sOHomeLoc = (String)s_context.getVarValue("ORACLE_HOME");
            }
            if (s_context.getVarValue("ORACLE_HOME_NAME") != null) {
                this.sOHomeName = (String)s_context.getVarValue("ORACLE_HOME_NAME");
            }
            String string = checkpointLoc = this.computeCheckPointLoc(s_context) == null ? null : this.computeCheckPointLoc(s_context);
            if (checkpointLoc != null) {
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(checkpointLoc, "checkpoints"));
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, "oui"));
                this.chkpointFile = "checkpoint_" + this.sOHomeName + ".xml";
                this.sFileName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(this.sFileName, this.chkpointFile));
                if (cpis != null) {
                    OiicExitOps.getExitOps().addIndexSessionObj(cpis);
                }
            }
        }
    }

    private String computeCheckPointLoc(OiicSessionContext s_context) {
        String oracleBase = null;
        String oracleHome = null;
        if (s_context.getVarValue("ORACLE_BASE") != null) {
            oracleBase = (String)s_context.getVarValue("ORACLE_BASE");
        }
        if (s_context.getVarValue("ORACLE_HOME") != null) {
            oracleHome = (String)s_context.getVarValue("ORACLE_HOME");
        }
        if (oracleBase != null) {
            return oracleBase;
        }
        if (oracleHome != null) {
            String temp = oracleHome;
            if (new File(temp = OiixPathOps.getNativeForm(OiixPathOps.concatPath(temp, "install"))).exists()) {
                return temp;
            }
            oracleHome = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHome, "inventory"));
            return oracleHome;
        }
        return null;
    }

    private void initializeCheckPointIndexSession(String checkPointLoc, String moduleName) {
        if (checkPointLoc != null && moduleName != null) {
            cpis = OicsCheckPointFactory.getIndexSession((String)checkPointLoc, (String)moduleName);
            OiiolTextLogger.appendText("Checkpoint:Initializing checkpoint session in oiicremovehome.");
            OiiolTextLogger.appendText("Checkpoint:Location is- " + checkPointLoc);
        }
    }

    public static void main(String[] args) {
        OiicRemoveHome oRemoveHome = OiicRemoveHome.getOiicRemoveHomeInstance();
        oRemoveHome.main_helper(args);
    }
}

