/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.awt.Frame;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControlListener;
import oracle.sysman.oii.oiif.oiifd.OiifdExitDlg;
import oracle.sysman.oii.oiif.oiifw.OiifwExitEventListener;
import oracle.sysman.oii.oiig.OiigNotifConfig;
import oracle.sysman.oii.oiig.OiigNotifRequest;
import oracle.sysman.oii.oiig.OiigPubClient;
import oracle.sysman.oii.oiig.OiigRequestStatusListener;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawner;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicNotifChecker
implements OiifwExitEventListener,
OiigRequestStatusListener,
OiifbProgressControlListener {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private boolean m_bAllReqs = false;
    private Hashtable m_patchCheckComps;
    private Hashtable m_notifReqComps;
    private OiigNotifConfig m_notifCfg;
    private static final String ORAPARAM_UPDATES_SECTION = "Updates";
    private static final String DEFSERVER = "DefaultServer";
    private OiicInstaller m_installer;
    private String m_defUpdateSiteLoc = null;
    private Vector m_notifURLs;
    private OiifdExitDlg m_progressDlg;
    private Vector m_reqCtrls = null;
    private OiifbProgressControl m_uploadProg = null;
    private static final int NEUTRAL = 0;
    private static final int SEND_REG = 1;
    private static final int UPLOAD = 2;
    private static final int CHECK = 3;
    private int m_numServers = 0;
    private int m_numSuccSends = 0;
    private int m_numSendFailures = 0;
    private int m_numSuccReplies = 0;
    private int m_numReplyFailures = 0;
    private static final int[] PCNT_POS = new int[]{0, 0, 20, 50, 100};
    private int m_curState = 1;
    private boolean m_invUploadComplete = false;

    public OiicNotifChecker(OiicInstaller installer) {
        this.m_installer = installer;
        this.m_patchCheckComps = new Hashtable();
        this.m_notifReqComps = new Hashtable();
        this.m_defUpdateSiteLoc = OiixOraparam.getOraparamProfileString(ORAPARAM_UPDATES_SECTION, DEFSERVER, null);
        this.m_notifURLs = new Vector();
        this.m_notifCfg = null;
    }

    public OiigNotifConfig getNotifConfig() {
        if (this.m_notifCfg == null) {
            this.loadNotifConfig();
        }
        return this.m_notifCfg;
    }

    private void loadNotifConfig() {
        OiicNotifChecker oiicNotifChecker = this;
        OiicSessionContext sessCntxt = oiicNotifChecker.m_installer.getSessionWrapper().getCurSession().getSessionContext();
        if (sessCntxt == null) {
            return;
        }
        OiisVariable invLocVar = sessCntxt.getVariable("INVENTORY_LOCATION");
        String invLoc = (String)invLocVar.getValue();
        String loc = null;
        if (invLoc != null) {
            loc = OiigNotifConfig.calcFileLoc(invLoc);
            try {
                this.m_notifCfg = OiigNotifConfig.loadFromFile(loc);
                this.m_notifCfg.setPersistLoc(loc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (loc != null && this.m_notifCfg == null) {
            this.m_notifCfg = new OiigNotifConfig();
            this.m_notifCfg.setPersistLoc(loc);
        }
    }

    public void setAllReqs(boolean bAllReqs) {
        this.m_bAllReqs = bAllReqs;
    }

    public boolean anyRequests() {
        boolean anyReqs = false;
        Enumeration reqLists = this.m_patchCheckComps.elements();
        while (reqLists.hasMoreElements()) {
            Vector comps = (Vector)reqLists.nextElement();
            if (comps.size() <= 0) continue;
            anyReqs = true;
            break;
        }
        return anyReqs;
    }

    public void addPatchCheckComps(int homeInd, Vector compEntries) {
        this.addCheckEntries(this.m_patchCheckComps, homeInd, compEntries);
    }

    public void addNotifReqComps(int homeInd, Vector compEntries) {
        this.addCheckEntries(this.m_notifReqComps, homeInd, compEntries);
    }

    private void addCheckEntries(Hashtable checkTable, int homeInd, Vector compEntries) {
        Vector homeEntries = (Vector)checkTable.get(new Integer(homeInd));
        if (homeEntries == null) {
            homeEntries = new Vector();
            checkTable.put(new Integer(homeInd), homeEntries);
        }
        OiixVectorOps.unionInPlace(homeEntries, compEntries);
    }

    public Hashtable getPatchCheckComps() {
        return this.m_patchCheckComps;
    }

    public Hashtable getNotifReqComps() {
        return this.m_notifReqComps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExit() {
        block10: {
            boolean bCheckPatches = false;
            boolean bRegForNotifs = false;
            OiigNotifConfig notCfg = this.getNotifConfig();
            if (notCfg != null) {
                bCheckPatches = notCfg.shouldCheckPatches();
                bRegForNotifs = notCfg.shouldRegisterForNotifs();
                try {
                    notCfg.saveToFile();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                return;
            }
            if (bRegForNotifs) {
                this.saveInstallInventory();
            }
            try {
                Hashtable serverPatchComps = null;
                Hashtable serverNotifComps = null;
                serverPatchComps = bCheckPatches ? this.convertHomeToServerTables(this.m_patchCheckComps, false) : new Hashtable();
                serverNotifComps = bRegForNotifs ? this.convertHomeToServerTables(this.m_notifReqComps, true) : new Hashtable();
                Hashtable notifReqs = this.computeNotifReqs(serverPatchComps, serverNotifComps);
                int numServers = notifReqs.size();
                if (numServers <= 0) break block10;
                this.setNumServers(numServers);
                this.m_progressDlg = new OiifdExitDlg(new Frame(), bCheckPatches, bRegForNotifs, this);
                this.m_progressDlg.displayDialog();
                this.contactServers(notifReqs);
                this.performInvUpload();
                OiicNotifChecker oiicNotifChecker = this;
                synchronized (oiicNotifChecker) {
                    this.wait();
                }
                this.launchBrowsers(this.getNotifURLs());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getDefUpdateSiteLoc() {
        return this.m_defUpdateSiteLoc;
    }

    private Hashtable convertHomeToServerTables(Hashtable perHomeComps, boolean checkIfNotifReq) {
        Hashtable perServerTable = new Hashtable();
        Enumeration homes = perHomeComps.keys();
        while (homes.hasMoreElements()) {
            Integer homeIndOb = (Integer)homes.nextElement();
            int homeInd = homeIndOb;
            Vector compEntries = (Vector)perHomeComps.get(homeIndOb);
            int numEntries = compEntries.size();
            for (int i = 0; i < numEntries; ++i) {
                OiiiInstallCompInvEntry icie = (OiiiInstallCompInvEntry)compEntries.elementAt(i);
                if (icie.isDeleted()) continue;
                String updateLoc = icie.getUpdateSiteLoc();
                boolean addEntry = !checkIfNotifReq || icie.isNotifRequested();
                Vector<OiiiCompIdOhPair> perServerVect = (Vector<OiiiCompIdOhPair>)perServerTable.get(updateLoc);
                if (perServerVect == null && (this.m_bAllReqs || addEntry)) {
                    perServerVect = new Vector<OiiiCompIdOhPair>();
                    perServerTable.put(updateLoc, perServerVect);
                }
                if (!addEntry) continue;
                OiiiCompIdOhPair cidOh = new OiiiCompIdOhPair(icie.getCompInstallID(), homeInd);
                perServerVect.addElement(cidOh);
            }
        }
        return perServerTable;
    }

    private Hashtable computeNotifReqs(Hashtable perServerPatches, Hashtable perServerNotifs) {
        OiigNotifRequest notifReq;
        Vector notifComps;
        Vector patchComps;
        String server;
        Hashtable<String, OiigNotifRequest> notifReqs = new Hashtable<String, OiigNotifRequest>();
        OiigNotifConfig notifCfg = this.getNotifConfig();
        if (notifCfg == null) {
            return notifReqs;
        }
        String guid = notifCfg.getGUID();
        String emailId = notifCfg.getEmailId();
        String hostName = notifCfg.getHostName();
        OiiiInstallInventory instInv = this.getInstallInventory();
        if (instInv == null) {
            return notifReqs;
        }
        Enumeration patchKeys = perServerPatches.keys();
        while (patchKeys.hasMoreElements()) {
            server = (String)patchKeys.nextElement();
            patchComps = (Vector)perServerPatches.get(server);
            notifComps = (Vector)perServerNotifs.get(server);
            if (notifComps == null) {
                notifComps = new Vector();
            }
            notifReq = OiigNotifRequest.genNotifRequest(guid, emailId, hostName, patchComps, notifComps, instInv, this.m_bAllReqs);
            notifReqs.put(server, notifReq);
        }
        Enumeration notifKeys = perServerNotifs.keys();
        while (notifKeys.hasMoreElements()) {
            server = (String)notifKeys.nextElement();
            if (notifReqs.get(server) != null) continue;
            patchComps = new Vector();
            notifComps = (Vector)perServerNotifs.get(server);
            notifReq = OiigNotifRequest.genNotifRequest(guid, emailId, hostName, patchComps, notifComps, instInv, this.m_bAllReqs);
            notifReqs.put(server, notifReq);
        }
        return notifReqs;
    }

    private void contactServers(Hashtable notifReqs) {
        Vector notifURLs = new Vector();
        this.m_reqCtrls = new Vector();
        this.m_uploadProg = new OiifbProgressControl();
        Enumeration notifs = notifReqs.keys();
        while (notifs.hasMoreElements()) {
            String server = (String)notifs.nextElement();
            OiigNotifRequest notifReq = (OiigNotifRequest)notifReqs.get(server);
            OiicNotifRequestor reqstr = new OiicNotifRequestor(server, notifReq, this);
            this.m_reqCtrls.addElement(reqstr.startRequest());
        }
    }

    private void performInvUpload() {
        if (this.m_uploadProg.canContinue()) {
            // empty if block
        }
        this.onInvUploadComplete();
    }

    private void addNotifURL(String notifURL) {
        if (notifURL != null && notifURL.length() > 0) {
            this.m_notifURLs.addElement(notifURL);
        }
        this.checkForReplyCompletion();
    }

    private Vector getNotifURLs() {
        return this.m_notifURLs;
    }

    private void launchBrowsers(Vector notifURLs) {
        int numURLs = notifURLs.size();
        String browserExecutable = this.getNotifConfig().getBrowserLoc();
        for (int i = 0; i < numURLs; ++i) {
            String url;
            String encUrl = url = (String)notifURLs.elementAt(i);
            String execCmd = "\"" + browserExecutable + "\" " + encUrl;
            try {
                OiixSpawner spawn = new OiixSpawner();
                spawn.beginExecute(execCmd);
                continue;
            }
            catch (OiixSpawnException se) {
                se.printStackTrace();
            }
        }
    }

    private OiiiInstallInventory getInstallInventory() {
        OiiiInstallInventory instInv = null;
        OiiiInstallAreaControl instAC = this.getInstallAreaControl();
        if (instAC != null) {
            instInv = instAC.getInstallInventory();
        }
        return instInv;
    }

    private void saveInstallInventory() {
        try {
            OiiiInstallAreaControl instAC = this.getInstallAreaControl();
            if (instAC != null) {
                instAC.saveInstallInventory();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (OiifbCancelException ce) {
            ce.printStackTrace();
        }
    }

    private OiiiInstallAreaControl getInstallAreaControl() {
        OiiiInstallAreaControl instAC = null;
        OiicNotifChecker oiicNotifChecker = this;
        OiicPullSession curSession = oiicNotifChecker.m_installer.getSessionWrapper().getCurSession();
        if (curSession instanceof OiicInstallSession) {
            instAC = (OiiiInstallAreaControl)curSession.getTargetAreaControl();
        }
        return instAC;
    }

    @Override
    public void suspendProgress() {
        switch (this.m_curState) {
            case 1: 
            case 3: {
                int numReqs = this.m_reqCtrls.size();
                for (int i = 0; i < numReqs; ++i) {
                    OiifbProgressControl progCtrl = (OiifbProgressControl)this.m_reqCtrls.elementAt(i);
                    progCtrl.suspend();
                }
                break;
            }
            case 2: {
                this.m_uploadProg.suspend();
            }
        }
    }

    @Override
    public void resumeProgress() {
        switch (this.m_curState) {
            case 1: 
            case 3: {
                int numReqs = this.m_reqCtrls.size();
                for (int i = 0; i < numReqs; ++i) {
                    OiifbProgressControl progCtrl = (OiifbProgressControl)this.m_reqCtrls.elementAt(i);
                    progCtrl.resume();
                }
                break;
            }
            case 2: {
                this.m_uploadProg.resume();
            }
        }
    }

    @Override
    public void cancelProgress() {
        switch (this.m_curState) {
            case 1: 
            case 3: {
                int numReqs = this.m_reqCtrls.size();
                for (int i = 0; i < numReqs; ++i) {
                    OiifbProgressControl progCtrl = (OiifbProgressControl)this.m_reqCtrls.elementAt(i);
                    progCtrl.confirmCancel(null);
                }
                if (this.m_curState != 3) break;
                this.moveProgress();
                break;
            }
            case 2: {
                this.m_uploadProg.confirmCancel(null);
            }
        }
    }

    private void onInvUploadComplete() {
        if (this.m_curState == 2) {
            this.moveProgress();
        }
        this.m_invUploadComplete = true;
        this.checkForReplyCompletion();
    }

    private void setNumServers(int numServers) {
        this.m_numServers = numServers;
    }

    @Override
    public synchronized void onSendComplete() {
        ++this.m_numSuccSends;
        this.checkForSendCompletion();
    }

    @Override
    public synchronized void onReplyComplete() {
        ++this.m_numSuccReplies;
    }

    @Override
    public synchronized void onErrorDuringSend(Exception ex) {
        ++this.m_numSendFailures;
        this.checkForSendCompletion();
    }

    @Override
    public synchronized void onErrorDuringReply(Exception ex) {
        ++this.m_numReplyFailures;
    }

    private void checkForSendCompletion() {
        if (this.m_numSuccSends + this.m_numSendFailures == this.m_numServers) {
            this.moveProgress();
            if (this.m_invUploadComplete) {
                this.moveProgress();
            }
        }
    }

    private void checkForReplyCompletion() {
        if (this.m_curState == 3 && this.m_numSuccReplies + this.m_numReplyFailures == this.m_numSuccSends) {
            this.moveProgress();
        }
    }

    private synchronized void moveProgress() {
        ++this.m_curState;
        if (this.m_curState > 3) {
            this.notifyAll();
        }
        this.m_progressDlg.setProgPercent(PCNT_POS[this.m_curState]);
        this.m_progressDlg.doNext();
    }

    private class OiicNotifRequestor
    implements Runnable {
        private String m_server;
        private OiigNotifRequest m_notifReq;
        private OiigRequestStatusListener m_lsnr;
        private OiifbProgressControl m_progCtrl;

        public OiicNotifRequestor(String server, OiigNotifRequest notifReq, OiigRequestStatusListener lsnr) {
            this.m_server = server;
            this.m_notifReq = notifReq;
            this.m_lsnr = lsnr;
            this.m_progCtrl = new OiifbProgressControl();
        }

        public OiifbProgressControl startRequest() {
            new Thread(this).start();
            return this.m_progCtrl;
        }

        @Override
        public void run() {
            try {
                String notifURL = OiigPubClient.sendUpgradeReq(this.m_server, this.m_notifReq, this.m_lsnr, this.m_progCtrl);
                OiicNotifChecker.this.addNotifURL(notifURL);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

