/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.util.Vector;
import oracle.ops.util.FatalException;
import oracle.sysman.oii.oiic.OiicAttachHome;
import oracle.sysman.oii.oiic.OiicBaseInventoryApp;
import oracle.sysman.oii.oiic.OiicDetachHome;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class OiicInventoryOperationHelper {
    private static final String Attach_Home = "attachHome";
    private static final String Detach_Home = "detachHome";

    public static void attachHome(String oracleHome, String oracleHomeName, String[] params) throws FatalException {
        OiiolTextLogger.appendText("Attach Home" + oracleHome);
        OiicInventoryOperationHelper.doOperation(Attach_Home, oracleHome, oracleHomeName, params);
    }

    public static void detachHome(String oracleHome, String oracleHomeName, String[] params) throws FatalException {
        OiiolTextLogger.appendText("Detach Home" + oracleHome);
        OiicInventoryOperationHelper.doOperation(Detach_Home, oracleHome, oracleHomeName, params);
    }

    private static void doOperation(String op, String oracleHome, String oracleHomeName, String[] params) throws FatalException {
        if (OiicInventoryOperationHelper.isEmpty(oracleHome)) {
            throw new FatalException("oracleHome is required");
        }
        if (OiicInventoryOperationHelper.isEmpty(oracleHomeName)) {
            try {
                if (OiiiInstallAreaControl.getInstallAreaControl() == null) {
                    OiiiInstallAreaControl.initAreaControl(1);
                }
                oracleHomeName = OiiiOracleHomeInfo.getDefHomeName(OiiiInstallAreaControl.getInstallAreaControl().getInstallInventory(), 0);
            }
            catch (Exception e) {
                throw new FatalException(e.getMessage());
            }
        }
        OiicBaseInventoryApp obj = null;
        if (Attach_Home.equals(op)) {
            obj = OiicAttachHome.getOiicAttachHomeInstance();
        } else if (Detach_Home.equals(op)) {
            obj = OiicDetachHome.getOiicDetachHomeInstance();
        } else {
            throw new FatalException("Operation not supported");
        }
        System.setProperty("oracle.installer.ouiApiMode", "true");
        String[] args = OiicInventoryOperationHelper.getInputs(op, oracleHome, oracleHomeName, params);
        obj.main_helper(args);
    }

    private static String[] getInputs(String op, String oracleHome, String oracleHomeName, String[] params) {
        Vector<String> cmdArgs = new Vector<String>();
        cmdArgs.add(new String("-" + op + " "));
        cmdArgs.add(new String("ORACLE_HOME=" + oracleHome));
        cmdArgs.add(new String("ORACLE_HOME_NAME=" + oracleHomeName));
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                if (OiicInventoryOperationHelper.isEmpty(params[i])) continue;
                cmdArgs.add(params[i]);
            }
        }
        OiiolTextLogger.appendText("Command used for " + op + " is  " + cmdArgs);
        String[] retVal = cmdArgs.toArray(new String[cmdArgs.size()]);
        return retVal;
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() < 1;
    }
}

