/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class OiicInvSetupWCCE
implements OiifbWizOperation {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private OiisVariableOwner m_vo;
    private boolean m_errorOcc = false;
    private int m_nextInd;

    public OiicInvSetupWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialize() {
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_INIT_SAV_SETUP"));
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_DOOP_INVSETUP"));
        if (isBack) {
            return 1;
        }
        OiipgBootstrap pgb = new OiipgBootstrap();
        OiisVariable oInvLoc = this.m_vo.getVariable("INVENTORY_LOCATION");
        String sInvLoc = (String)oInvLoc.getValue();
        OiisVariable oUnixGroup = this.m_vo.getVariable("UNIX_GROUP_NAME");
        String unixGroup = (String)oUnixGroup.getValue();
        int retVal = OiicSessionInterfaceManager.getInterfaceManager().doInvSetupOperations(sInvLoc, unixGroup);
        if (retVal == 1) {
            if (pgb.isUnixGroupNeeded()) {
                oUnixGroup.setAdvice(false);
            } else {
                oInvLoc.setAdvice(false);
            }
            return retVal;
        }
        return retVal;
    }

    private boolean saveInvProperties(String locationFileLoc, String unixGroup) {
        String scratchDirLoc = locationFileLoc;
        String nativeExtractLoc = locationFileLoc;
        String cust_libLoc = locationFileLoc;
        String cust_logLoc = locationFileLoc;
        OiipgBootstrap pgb = new OiipgBootstrap();
        String sPath = System.getProperty("oracle.installer.scratchPath");
        Properties m_properties = new Properties();
        OiipgPropertyLoader.setPropertiesScratchPath(m_properties, sPath);
        OiipgPropertyLoader.setPropertiesNativeExtractDir(m_properties, sPath);
        OiipgPropertyLoader.setPropertiesLogLoc(m_properties, cust_logLoc);
        OiipgPropertyLoader.setPropertiesLibLoc(m_properties, cust_libLoc);
        OiicInvSetupWCCE.writeLocationFile(m_properties, locationFileLoc);
        return false;
    }

    private void setSystemProperties(String invLoc) {
        OiipgPropertyLoader pg = new OiipgPropertyLoader();
        try {
            String propVal;
            Properties props = OiipgPropertyLoader.loadInstallerProperties(invLoc);
            Properties sysProps = System.getProperties();
            if (sysProps.get("oracle.installer.scratchPath") == null) {
                propVal = OiipgPropertyLoader.getPropertiesScratchPath(props);
                sysProps.put("oracle.installer.scratchPath", propVal);
            }
            propVal = OiipgPropertyLoader.getPropertiesLogLoc(props);
            sysProps.put("oracle.installer.log_loc", propVal);
            propVal = OiipgPropertyLoader.getPropertiesLibLoc(props);
            sysProps.put("oracle.installer.lib_loc", propVal);
            propVal = OiipgPropertyLoader.getPropertiesLibLoc(props);
            sysProps.put("oracle.installer.NatLibDir", propVal);
            System.setProperties(sysProps);
        }
        catch (IOException exp) {
            this.exitWithErrMsg(OiixResourceBundle.getString("S_ERROR_LOAD_PROP"));
        }
    }

    private void exitWithErrMsg(String msg) {
        OiifmAlert.displayError(msg);
        System.exit(0);
    }

    public int getNext() {
        return this.m_nextInd;
    }

    public static void writeLocationFile(Properties props, String sLocation) {
        FileOutputStream fos = null;
        String file = sLocation + File.separatorChar + "oraInstaller.properties";
        if (props == null) {
            props = new Properties();
        }
        try {
            fos = new FileOutputStream(file);
            props.save(fos, "Oracle Installer Properties -FallBack");
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

