/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicCloneSession;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicExitOps;
import oracle.sysman.oii.oiic.OiicInterfaceManagerCreationError;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionProvider;
import oracle.sysman.oii.oiic.OiicSessionWrapper;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbLinearIterator;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiix.OiixCipher;
import oracle.sysman.oii.oiix.OiixDebug;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;

public class OiicInstaller
extends OiicBaseApp {
    public static final String STAGE_SESSION = "Stage";
    public static final String INSTALL_SESSION = "Install";
    public static final String DEINSTALL_SESSION = "DeInstall";
    public static final String CLONE_SESSION = "Clone";
    public static final String ADDNODE_SESSION = "AddNode";
    public static final String LANGADDON_SESSION = "LangAddon";
    public static final String UPGRADE_SESSION = "Upgrade";
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private static OiicSessionWrapper m_sessionWrapper;
    private OiicSessionInterfaceManager m_oSessionInterfaceManager = null;
    private static OiicInstaller s_oiicInstaller;
    private static final String appName = "oui";
    OiifbLinearIterator iter;

    private OiicInstaller() {
        super(appName);
    }

    private OiicInstaller(String app) {
        super(app);
    }

    public static OiicInstaller getOiicInstallerInstance() {
        if (s_oiicInstaller == null) {
            s_oiicInstaller = new OiicInstaller();
        }
        return s_oiicInstaller;
    }

    public static OiicInstaller getHandleToOiicInstaller() {
        return s_oiicInstaller;
    }

    private void putCmdArgsIntoSystemProperty() {
        Properties props = this.getCmdProps();
        Properties defProps = this.getDefaultsOverriden();
        Properties sysProps = System.getProperties();
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            sysProps.put(propName, props.get(propName));
            defProps.remove(propName);
        }
    }

    public static void setDebugProps() {
        OiixDebug.PRINT_MEMORY = Boolean.getBoolean("oracle.installer.printmemory");
        OiixDebug.PRINT_DISKUSAGE = Boolean.getBoolean("oracle.installer.printdiskusage");
        OiixDebug.PRINT_VERBOSETIME = Boolean.getBoolean("oracle.installer.printtimeverbose");
        OiixDebug.PRINT_TIME = Boolean.getBoolean("oracle.installer.printtime") || Boolean.getBoolean("oracle.installer.printtimeverbose");
    }

    public OiicSessionInterfaceManager getInterfaceManager() {
        if (this.m_oSessionInterfaceManager == null) {
            this.m_oSessionInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
        }
        return this.m_oSessionInterfaceManager;
    }

    void init(boolean bRepeat) throws OiifbEndIterateException {
        OiicInstaller o_oiicInstaller = OiicInstaller.getOiicInstallerInstance();
        try {
            if (o_oiicInstaller.anyInvalidArgsFound()) {
                this.m_oSessionInterfaceManager.hideSplashScr();
                Object[] args = new Object[]{o_oiicInstaller.getInvalidCommandLineArgsList(), o_oiicInstaller.getAppExecutableName()};
                String sMessage = OiixResourceBundle.getString("S_INVALID_COMMANDLINE_ARGS", args);
                throw new OiifbEndIterateException(sMessage);
            }
            m_sessionWrapper = new OiicSessionWrapper(this, bRepeat);
            m_sessionWrapper.setupDuplicateStreams();
            OiicSessionProvider.setSessionProxy(m_sessionWrapper);
        }
        catch (OiifbEndIterateException fe) {
            if (OiicPullSession.isSilentMode()) {
                OiiolTextLogger.writeMessageToConsole(fe.getMessage());
            }
            OiifmAlert.displayError(fe.getMessage());
            throw fe;
        }
    }

    public static OiicSessionWrapper getSessionWrapper() {
        return m_sessionWrapper;
    }

    void run() {
        try {
            m_sessionWrapper.initialize();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.writeLogWithTimeAndTrace("The current session type is :" + System.getProperty("oracle.installer.sessionType"), OiiolTextLogger.STR_LOG_TRACE);
            }
            m_sessionWrapper.doOperation(false);
        }
        catch (OiifbEndIterateException oiifbEndIterateException) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.m_oSessionInterfaceManager != null) {
            this.m_oSessionInterfaceManager.dispose();
        }
        if (m_sessionWrapper != null) {
            m_sessionWrapper.dispose();
        }
    }

    @Override
    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    @Override
    public void processCommandLine(String[] args) {
        this.processCmdLine(args);
        this.putCmdArgsIntoSystemProperty();
        String location = System.getProperty("oracle.installer.installprops");
        if (location != null && (location = location.trim()).length() != 0 && this.loadInstallPropertiesFile(location)) {
            altInstallProps = true;
        }
        this.setAdditionalProperties();
        OiicInstaller.setDebugProps();
        String sessionType = System.getProperty("oracle.installer.sessionType");
        String cmdDeins = System.getProperty("oracle.installer.deinstall");
        boolean bDeinstall = cmdDeins.equalsIgnoreCase("true");
        String cmdClone = System.getProperty("oracle.installer.clone");
        boolean bClone = cmdClone.equalsIgnoreCase("true");
        boolean bAddNode = Boolean.getBoolean("oracle.installer.addNode");
        boolean bLangAddon = Boolean.getBoolean("oracle.installer.addLangs");
        sessionType = bDeinstall ? DEINSTALL_SESSION : (bClone ? CLONE_SESSION : (bAddNode ? ADDNODE_SESSION : (bLangAddon ? LANGADDON_SESSION : INSTALL_SESSION)));
        System.setProperty("oracle.installer.sessionType", sessionType);
        boolean bOneClick = Boolean.getBoolean("oracle.installer.oneclick");
        if (bOneClick) {
            try {
                this.processOneclickPasswords();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void exitSession() {
        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
            System.exit(OiicExitCode.getExitCode());
        }
        if (OiicPullSession.isSilentMode() && Boolean.getBoolean("oracle.installer.wait")) {
            OiiolTextLogger.writeMessageToConsole(OiixResourceBundle.getString("S_EXIT_CONTINUE"));
            try {
                System.in.read();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.exit(OiicExitCode.getExitCode());
    }

    public static int updateHome(HashMap hmCloneVars, boolean bSilent) throws OiifbEndIterateException {
        if (bSilent) {
            System.setProperty("oracle.installer.silent", "true");
        } else {
            System.setProperty("oracle.installer.silent", "false");
        }
        String sConsole = System.getProperty("oracle.installer.console");
        if (sConsole == null) {
            System.setProperty("oracle.installer.console", "true");
        }
        OiicInstaller installer = OiicInstaller.getOiicInstallerInstance();
        if (hmCloneVars != null) {
            for (String sKey : hmCloneVars.keySet()) {
                String sValue = (String)hmCloneVars.get(sKey);
                installer.addToCommandLineTable(sKey, sValue);
            }
        }
        System.setProperty("oracle.installer.sessionType", CLONE_SESSION);
        System.setProperty("oracle.installer.splash", "false");
        installer.setAdditionalProperties();
        try {
            OiipgBootstrap.initScratchLoc(OiicCloneSession.getOutStreamFileName());
        }
        catch (IOException e) {
            throw new OiifbEndIterateException(e);
        }
        installer.init(false);
        installer.run();
        installer.dispose();
        return OiicExitCode.getExitCode();
    }

    public static void main(String[] args) {
        OiicInstaller o_oiicInstaller = OiicInstaller.getOiicInstallerInstance();
        try {
            o_oiicInstaller.runInstaller(args);
            o_oiicInstaller.exitSession();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runInstaller(String[] args) {
        try {
            this.processCommandLine(args);
            this.setJREScratchDirectories();
            this.displayBanner();
            if (this.isHelpOptionSpecified()) {
                this.displayHelp();
                int n = OiicExitCode.getExitCode();
                return n;
            }
            if (this.isResponseFileRequired() && !this.isResponseFileSpecified()) {
                OiiolTextLogger.writeToLogAndConsole(OiixResourceBundle.getString("S_RSP_FILE_NOT_SPECIFIED"));
                OiicExitCode.setExitCode(-1);
            } else {
                String sTempLoc = System.getProperty("oracle.installer.scratchPath");
                String sCleanLoc = OiixPathOps.getNativeForm(sTempLoc);
                OiicExitOps.getExitOps().addDelDir(sCleanLoc);
                boolean bRepeat = Boolean.getBoolean("oracle.installer.repeat");
                this.getInterfaceManager();
                this.init(bRepeat);
                this.run();
            }
        }
        catch (OiicInterfaceManagerCreationError ex) {
            OiiolTextLogger.writeToLogAndConsole(ex.getMessage());
            OiicExitCode.setExitCode(-1);
        }
        catch (OiifbEndIterateException ex) {
            OiicExitCode.setExitCode(-1);
        }
        catch (Throwable e) {
            System.err.println("Exception " + e + " occurred..");
            e.printStackTrace();
            OiicExitCode.setExitCode(-1);
            String sMsg = "";
            String sUnknown = OiixResourceBundle.getString("S_LOG_UNKNOWN");
            String sLogLoc = OiiolTextLogger.getCurLogFileName();
            sLogLoc = sLogLoc == null || sLogLoc.equals("") ? sUnknown : sLogLoc;
            String sErrLoc = OiixTeePrintStream.getErrFileLoc();
            sErrLoc = sErrLoc == null || sErrLoc.equals("") ? sUnknown : sErrLoc;
            String sOutLoc = OiixTeePrintStream.getOutFileLoc();
            sOutLoc = sOutLoc == null || sOutLoc.equals("") ? sUnknown : sOutLoc;
            sMsg = OiixResourceBundle.getString("S_CALL_SUPPORT");
            sMsg = MessageFormat.format(sMsg, sLogLoc, sErrLoc, sOutLoc);
            sMsg = OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_MSG") + " " + sMsg;
            OiifmAlert.displayError(sMsg, OiixResourceBundle.getString("S_ABNORMAL_TERMINATION_TITLE"));
        }
        finally {
            if (OiicInstaller.getOiicInstallerInstance() != null) {
                this.dispose();
            }
        }
        if (System.getProperty("oracle.installer.cleanUpOnExit", "true").equals("true")) {
            OiicExitOps.getExitOps().doExitOperations();
        }
        return OiicExitCode.getExitCode();
    }

    private void processOneclickPasswords() {
        Hashtable hArgs = this.getCommandLineArgsTable();
        String sStrPwdVars = (String)hArgs.get("OCSTRPVARS");
        String sStrListPwdVars = (String)hArgs.get("OCSTRLISTPVARS");
        String sObfsPwdVal = (String)hArgs.get("OCPWDVAL");
        if (sObfsPwdVal == null || sObfsPwdVal.length() == 0) {
            return;
        }
        OiixCipher oCipher = new OiixCipher(sObfsPwdVal);
        String sPwd = oCipher.decode().toString();
        StringTokenizer strTok = new StringTokenizer(sStrPwdVars, "{,}");
        while (strTok.hasMoreTokens()) {
            String sVar = strTok.nextToken();
            hArgs.put(sVar, sPwd);
        }
        StringTokenizer strlistTok = new StringTokenizer(sStrListPwdVars, "{,}");
        while (strlistTok.hasMoreTokens()) {
            String sVar = strlistTok.nextToken();
            hArgs.put(sVar, "{" + sPwd + "}");
        }
    }

    static {
        s_oiicInstaller = null;
    }
}

