/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicCompsWizEngine;
import oracle.sysman.oii.oiic.OiicDepWizEngine;
import oracle.sysman.oii.oiic.OiicInstPostActionsPhase;
import oracle.sysman.oii.oiic.OiicInstSHSetupWCCE;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstallActionsPhase;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicInvSetupWCCE;
import oracle.sysman.oii.oiic.OiicPickSelMethodWCCE;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionSettingSaveWCCE;
import oracle.sysman.oii.oiic.OiicSilentInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbLinearIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbSyncObject;
import oracle.sysman.oii.oiif.oiifb.OiifbUIManager;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterSessionVarWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwInstExitWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwInvLocWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwInvLocationUnixGroupWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwLicenseWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwPubInvCompsSelWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwRegistrationWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwSHLocWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwSummaryWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwTopLevelSelWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwValidateDiskSpaceWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwValidateShipHomeVarsWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwWelcomeWCDE;
import oracle.sysman.oii.oiii.OiiiCdLabel;
import oracle.sysman.oii.oiii.OiiiCompIDPool;
import oracle.sysman.oii.oiii.OiiiCompIdOhPair;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiDiskNotFoundException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallPatchInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallPatchSetInvEntry;
import oracle.sysman.oii.oiii.OiiiInventoryEnvUpdater;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiLibraryID;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfoXMLReader;
import oracle.sysman.oii.oiii.OiiiPatchSetInstallID;
import oracle.sysman.oii.oiii.OiiiReleaseNotesInfo;
import oracle.sysman.oii.oiii.OiiiShipHomeInfo;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiij.OiijFastCopyData;
import oracle.sysman.oii.oiil.OiilWinActions;
import oracle.sysman.oii.oiio.oiiod.OiiodAdditionalComps;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiio.oiioz.OiiozResponseFileWriter;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiis.OiisActionLibLoader;
import oracle.sysman.oii.oiis.OiisCompConstants;
import oracle.sysman.oii.oiis.OiisCompInstallation;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisDepRule;
import oracle.sysman.oii.oiis.OiisDeps;
import oracle.sysman.oii.oiis.OiisDialogLibLoader;
import oracle.sysman.oii.oiis.OiisDiskLocator;
import oracle.sysman.oii.oiis.OiisGenActionsReader;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisLibraryLoader;
import oracle.sysman.oii.oiis.OiisQueryLibLoader;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixHelp;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawner;
import oracle.sysman.oii.oiix.OiixTeePrintStream;
import oracle.sysman.oii.oiix.OiixUtilityOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiicInstallSession
extends OiicPullSession
implements OiiiInventoryEnvUpdater {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 4;
    private static int s_iNextIndex = 0;
    private boolean m_bInvChanged = false;
    private long m_lLibsSpaceRequired = 0L;
    private long m_lLargestFileGroupJarSize = 0L;
    private OiifbSyncObject m_invSetupSync = new OiifbSyncObject();
    private OiicSelCompsInstall m_selCompsInstall = null;
    private OiiiCdLabel m_curDisk = new OiiiCdLabel();
    public static final int WELCOME_IND = OiicInstallSession.getNextIndex(0);
    public static final int LICENSE_IND = OiicInstallSession.getNextIndex();
    public static final int REGISTRATION_IND = OiicInstallSession.getNextIndex();
    public static final int INV_LOC_IND = OiicInstallSession.getNextIndex();
    public static final int UNIX_GRP_IND = OiicInstallSession.getNextIndex();
    public static final int INV_SETUP_IND = OiicInstallSession.getNextIndex();
    public static final int SH_LOC_IND = OiicInstallSession.getNextIndex();
    public static final int VALIDATE_SHIPHOME_IND = OiicInstallSession.getNextIndex();
    public static final int ACCESS_SETUP_IND = OiicInstallSession.getNextIndex();
    public static final int PICK_SELMTHD_IND = OiicInstallSession.getNextIndex();
    public static final int STG_PICK_COMP_IND = OiicInstallSession.getNextIndex();
    public static final int PUBINV_PICK_COMP_IND = OiicInstallSession.getNextIndex();
    public static final int DEP_ENGINE_IND = OiicInstallSession.getNextIndex();
    public static final int INSTALL_COMP_IND = OiicInstallSession.getNextIndex();
    public static final int MORE_COMP_IND = OiicInstallSession.getNextIndex();
    public static final int EXIT_SESSION_IND = OiicInstallSession.getNextIndex();
    public static final int INST_SUMMARY_IND = 101;
    private static String s_LastDiskLocation = null;
    OiiozResponseFileWriter m_ResponseFile = null;
    public static final int NO_FAST_MODE = 0;
    public static final int FAST_MODE_CLEAN_OH = 1;
    public static final int FAST_MODE_DIRTY_OH = 2;
    private int m_nFastMode = 0;
    private OiijFastCopyData m_oFastCopyData = null;
    private String m_sAccessFilePath = null;
    private OiiiReleaseNotesInfo m_oReadmeInfo = null;
    private Vector m_vInstalledTLComps;
    private boolean printLogLocAPIMode = true;

    static final int getNextIndex(int p_seed) {
        s_iNextIndex = p_seed;
        return s_iNextIndex++;
    }

    static final int getNextIndex() {
        return s_iNextIndex++;
    }

    public OiiozResponseFileWriter getResponseFile() {
        if (this.m_ResponseFile == null) {
            this.m_ResponseFile = new OiiozResponseFileWriter();
        }
        return this.m_ResponseFile;
    }

    public void setResponseFile(OiiozResponseFileWriter resFile) {
        this.m_ResponseFile = resFile;
    }

    public void record() {
        this.getResponseFile().generate(this);
    }

    public void resetStreams() {
        try {
            OiixTeePrintStream.restoreSystemOut();
            OiixTeePrintStream.restoreSystemErr();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setLargestFileGroupJarSize(long lSize) {
        this.m_lLargestFileGroupJarSize = lSize;
    }

    public long getLargestFileGroupJarSize() {
        return this.m_lLargestFileGroupJarSize;
    }

    public void setLibsSpaceRequired(long lSize) {
        this.m_lLibsSpaceRequired = lSize;
    }

    public long getLibsSpaceRequired() {
        return this.m_lLibsSpaceRequired;
    }

    @Override
    public void initialize() {
        try {
            super.initialize();
        }
        catch (OiifbEndIterateException ee) {
            System.err.println(ee.getMessage());
        }
    }

    public OiicInstallSession(OiicInstaller install, boolean silentMode) throws OiifbEndIterateException {
        super(install, silentMode);
        this.m_depEngine = new OiiodDepEngine(this);
        this.m_sessionContext = new OiicSessionContext(this);
        this.setAreaControls(null);
        if (OiicInstallSession.isSilentMode()) {
            System.setProperty("oracle.installer.silentVariableValidation", OiixOraparam.isSilentVarValidation());
        }
        System.setProperty("oracle.installer.httpRetryCount", OiixOraparam.getHttpRetryCount());
        System.setProperty("oracle.installer.httpRetryInterval", OiixOraparam.getHttpRetryInterval());
    }

    public OiicInstallSession(OiicInstaller install) throws OiifbEndIterateException {
        this(install, false);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.m_namespaceTable != null) {
            this.m_namespaceTable.clear();
        }
        if (this.m_selCompsInstall != null) {
            this.m_selCompsInstall.dispose();
            this.m_selCompsInstall = null;
        }
        this.m_namespaceTable = null;
        OiifbUIManager.setSession(null);
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        if (iac != null) {
            iac.setInvEnvUpdater(null);
        }
        if (!Boolean.getBoolean("oracle.installer.silent")) {
            OiixHelp.clearCompHelp();
        }
        OiicInstallSession.setLastDiskLocation(null);
        this.releaseLocks();
    }

    public void disposeUnusedUIObjects() {
        if (this.m_selCompsInstall != null) {
            this.m_selCompsInstall.disposePreStateObjects();
        }
        if (this.m_iter != null) {
            this.m_iter.clearIterElements(DEP_ENGINE_IND);
        }
    }

    @Override
    public Vector getIterElements() {
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>();
        OiifwWelcomeWCDE welcomePage = new OiifwWelcomeWCDE(this.m_sessionContext, LICENSE_IND);
        iterEls.addElement(welcomePage);
        OiifwLicenseWCCE licWCCE = new OiifwLicenseWCCE(REGISTRATION_IND);
        iterEls.addElement(licWCCE);
        OiifwRegistrationWCDE regWCDE = new OiifwRegistrationWCDE(this.m_sessionContext, INV_LOC_IND);
        iterEls.addElement(regWCDE);
        OiifwInvLocWCCE invLoc = new OiifwInvLocWCCE(this.m_sessionContext, UNIX_GRP_IND, INV_SETUP_IND);
        iterEls.addElement(invLoc);
        OiifwInvLocationUnixGroupWCDE invLocUnixGrp = new OiifwInvLocationUnixGroupWCDE(this.m_sessionContext, INV_SETUP_IND);
        iterEls.addElement(invLocUnixGrp);
        OiicInvSetupWCCE setupInv = new OiicInvSetupWCCE(this.m_sessionContext, SH_LOC_IND);
        iterEls.addElement(setupInv);
        OiifwSHLocWCDE SHLoc = new OiifwSHLocWCDE(this.m_sessionContext, VALIDATE_SHIPHOME_IND);
        iterEls.addElement(SHLoc);
        OiifwValidateShipHomeVarsWCCE validateSH = new OiifwValidateShipHomeVarsWCCE(this.m_sessionContext, ACCESS_SETUP_IND);
        iterEls.addElement(validateSH);
        OiicInstSHSetupWCCE setupAccess = new OiicInstSHSetupWCCE(this.m_sessionContext, PICK_SELMTHD_IND);
        iterEls.addElement(setupAccess);
        OiicPickSelMethodWCCE pickSelMthd = new OiicPickSelMethodWCCE(this, STG_PICK_COMP_IND, PUBINV_PICK_COMP_IND);
        iterEls.addElement(pickSelMthd);
        OiifwTopLevelSelWCDE selTLComp = new OiifwTopLevelSelWCDE(this.m_sessionContext, DEP_ENGINE_IND);
        iterEls.addElement(selTLComp);
        OiifwPubInvCompsSelWCDE selPIComps = new OiifwPubInvCompsSelWCDE(this.m_sessionContext, DEP_ENGINE_IND);
        iterEls.addElement(selPIComps);
        OiicDepWizEngine depWEngine = new OiicDepWizEngine(this.m_sessionContext, INSTALL_COMP_IND);
        iterEls.addElement(depWEngine);
        this.m_selCompsInstall = new OiicSelCompsInstall(this, MORE_COMP_IND);
        iterEls.addElement(this.m_selCompsInstall);
        OiifwInstExitWCDE instExit = new OiifwInstExitWCDE(this.m_sessionContext);
        iterEls.addElement(instExit);
        return iterEls;
    }

    @Override
    public void initSession() throws OiifbEndIterateException {
        this.m_namespaceTable = new Hashtable();
        this.m_namespaceTable.put(this.m_sessionContext, new Hashtable());
        this.m_sessionContext.setVariables();
        this.setInventoryLocation(this.getInvLoc());
        this.setSessionMode("Install");
        this.setUnixGroupName(this.m_sessionContext);
    }

    public void waitOnLoadInv() {
        this.m_invSetupSync.sync();
    }

    public void signalLoadInv() {
        this.m_invSetupSync.signal();
    }

    @Override
    public void onBackIntoLocations() {
        this.signalLoadInv();
        if (this.m_sessionContext != null) {
            OiisVariable var = this.m_sessionContext.getVariable("ToplevelComp");
            var.setAdvice(false);
            var = this.m_sessionContext.getVariable("DEP_MODE");
            var.setAdvice(false);
            var = this.m_sessionContext.getVariable("SELECTED_LANGUAGES");
            var.setAdvice(false);
        }
        super.onBackIntoLocations();
        OiiiCompIDPool.getInstance().clearPool();
        OiixHelp.clearCompHelp();
        OiicSessionInterfaceManager.getInterfaceManager().setProgressListener(null);
        try {
            System.setProperty("oracle.installer.prereqConfigLoc", "");
            OiisVariable oPrereqConfigVar = this.m_sessionContext.getVariable("PREREQ_CONFIG_LOCATION");
            oPrereqConfigVar.setValue("", true);
        }
        catch (OiifbCancelException e) {
            String sMsg = e.getMessage();
            OiiolTextLogger.appendText(sMsg);
        }
        catch (OiisVarSettingException e) {
            String sMsg = e.getMessage();
            OiiolTextLogger.appendText(sMsg);
        }
    }

    public void cleanupScratchPath() {
        String compLoc = System.getProperty("oracle.installer.scratchPath");
        String cleanLoc = OiixPathOps.getNativeForm(compLoc);
        OiiolTextLogger.appendText("Recursively delete: " + cleanLoc);
        OiixFileOps.recdelete(new File(cleanLoc));
    }

    public void releaseReaderLock() {
        try {
            OiiiTargetAreaControl otac = this.getTargetAreaControl();
            if (otac != null) {
                otac.releaseReaderLock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setInvChanged(boolean bChanged) {
        this.m_bInvChanged = bChanged;
    }

    public boolean isInvChanged() {
        return this.m_bInvChanged;
    }

    @Override
    public void setAreaControls(String sInvLoc) throws OiifbEndIterateException {
        OiiiTargetAreaControl sTargetAreaControl;
        boolean bIsAPI = System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true");
        this.setInvLoc(sInvLoc);
        if (sInvLoc == null) {
            try {
                String invLoc = System.getProperty("oracle.installer.custom_inventory");
                if (invLoc != null && invLoc != "") {
                    this.setInvLoc(invLoc);
                } else {
                    OiipgPropertyLoader pl = new OiipgPropertyLoader();
                    this.setInvLoc(pl.getLocationFileLoc());
                }
            }
            catch (IOException e) {
                this.setInvLoc(null);
            }
            String sInvLoc1 = this.getInvLoc();
            try {
                if (sInvLoc1 != null && sInvLoc1.trim().length() > 0) {
                    OiipgFileSystem.checkWritablePath(sInvLoc1);
                }
            }
            catch (OiipgPathException pge) {
                if (pge.getLevel() == OiipgPathException.INVALID_PATH) {
                    File f = new File(sInvLoc1);
                    f.delete();
                }
                Object[] args = new Object[]{sInvLoc1};
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INV_START_SETUP_ERR", args);
                throw new OiifbEndIterateException(sMsg);
            }
        }
        String sInvLoc2 = this.getInvLoc();
        boolean binitAreaControl = true;
        if (sInvLoc2 != null && sInvLoc2.trim().length() > 0 && ((sTargetAreaControl = this.getTargetAreaControl()) == null || sInvLoc2 != sTargetAreaControl.getAreaRoot())) {
            try {
                OiiiInstallAreaControl targetAreaControl;
                OiiiTargetAreaControl existingTargetAreaControl;
                if (bIsAPI && null != (existingTargetAreaControl = OiiiInstallAreaControl.getInventoryAreaControl()) && sInvLoc2.compareToIgnoreCase(existingTargetAreaControl.getAreaRoot()) == 0) {
                    binitAreaControl = false;
                }
                if (null == OiiiInstallAreaControl.getInstallAreaControl()) {
                    binitAreaControl = true;
                }
                if (binitAreaControl) {
                    OiiiInstallAreaControl.initAreaControl(sInvLoc2);
                }
                if ((targetAreaControl = OiiiInstallAreaControl.getInstallAreaControl()).getInstallInventory() != null) {
                    targetAreaControl.grabReaderLock();
                    this.setTargetAreaControl(targetAreaControl);
                    targetAreaControl.setInvEnvUpdater(this);
                    this.signalLoadInv();
                    String logLoc = targetAreaControl.genFileSysLoc("logs");
                    boolean bUseCustomLog = false;
                    String sCustomLogLoc = System.getProperty("oracle.installer.log_loc");
                    if (null != sCustomLogLoc && !targetAreaControl.getAreaRoot().equalsIgnoreCase(sCustomLogLoc)) {
                        logLoc = sCustomLogLoc;
                        bUseCustomLog = true;
                    }
                    if (bIsAPI && null != OiicAPIInstaller.getHandleToAPIInstaller().getCustomLogDir()) {
                        OiicAPIInstaller installerInst = OiicAPIInstaller.getHandleToAPIInstaller();
                        try {
                            logLoc = installerInst.getCustomLogDir();
                            OiiolTextLogger.setLogLoc(installerInst.getCustomLogDir(), installerInst.getCustomLogFileName(), installerInst.getCustomLogFileExtn(), installerInst.getCustomLevel(), installerInst.getCustomFormatter());
                            bUseCustomLog = true;
                        }
                        catch (IOException e) {
                            OiiolTextLogger.setLogLoc(logLoc);
                            bUseCustomLog = false;
                        }
                    } else {
                        OiiolTextLogger.setLogLoc(logLoc);
                        bUseCustomLog = false;
                    }
                    if (!bIsAPI && sInvLoc != null && sInvLoc != "") {
                        this.setupDuplicateStreams();
                    } else if (bIsAPI && (this.getInvLoc() != null || this.getInvLoc().length() > 0)) {
                        if (bUseCustomLog) {
                            this.setupDuplicateStreamsForLog(logLoc);
                        } else {
                            this.setupDuplicateStreams();
                        }
                    }
                    if (OiicPullSession.isSilentMode() || bIsAPI && this.printLogLocAPIMode) {
                        String logStr = OiixResourceBundle.getString("S_LOG_LOC_PROMPT");
                        String curLogFile = OiiolTextLogger.getCurLogFileName();
                        if (curLogFile != null && curLogFile != "") {
                            Object[] arr = new String[]{curLogFile};
                            OiiolTextLogger.writeMessageToConsole(MessageFormat.format(logStr, arr));
                            this.printLogLocAPIMode = false;
                        }
                    }
                    OiiolTextLogger.setSilentInstallErrLog(logLoc);
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_INSTVER") + OiicBaseApp.getInstallerVersion().toString() + System.getProperty("line.separator"));
                    OiicInstallSession.writeToMonitorFile("installactionslog=" + OiiolTextLogger.getCurLogFileName());
                    OiicInstallSession.writeToMonitorFile("silentlog=" + OiiolTextLogger.getErrorLogFileName());
                    this.initSessionCloneVars();
                } else {
                    this.setInvLoc(null);
                }
            }
            catch (IOException e) {
                throw new OiifbEndIterateException(e);
            }
            catch (OiitTargetLockNotAvailableException ee) {
                throw new OiifbEndIterateException(ee);
            }
        }
    }

    @Override
    protected void setTargetAreaControl(OiiiTargetAreaControl targetAreaControl) {
        super.setTargetAreaControl(targetAreaControl);
        this.m_installInv = ((OiiiInstallAreaControl)targetAreaControl).getInstallInventory();
    }

    @Override
    public void setupSHAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException {
        OiixProgressListener progListener;
        OiifbUIManager.setSession(this);
        OiixPlatform.optimize();
        super.setupAccessObjects();
        try {
            this.m_curDisk.readLabelFile(this.m_sourceAccess.getSourceRoot());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.m_sessionContext.setDiskVariables();
        OiiiStageInventory stageInv = null;
        IOException ioe = null;
        try {
            stageInv = this.m_sourceAccess.getStageInventory(true);
        }
        catch (IOException e) {
            String errMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_FROMLOC");
            ioe = new IOException(errMsg);
        }
        if (ioe == null) {
            try {
                this.prepareSHTopLevelSels(stageInv);
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if ((progListener = this.getProgressListener()) != null) {
            progListener.onDoneProgress();
        }
        if (ioe != null) {
            throw ioe;
        }
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        iac.setSourceStageProvider(this.m_sourceAccess);
    }

    @Override
    public void setupOHAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException {
        if (this.getTargetAreaControl() != null) {
            this.grabLocks();
            this.updateInventoryWithHomes();
        }
        this.setShiphomeProperties();
    }

    private void setShiphomeProperties() throws IOException {
        OiixProgressListener progListener;
        OiiiStageInventory stageInv = null;
        IOException ioe = null;
        try {
            stageInv = this.m_sourceAccess.getStageInventory(true);
        }
        catch (IOException e) {
            String errMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_FROMLOC");
            ioe = new IOException(errMsg);
        }
        if (ioe == null) {
            this.loadShiphomePropertiesXML(stageInv);
            OiiiShipHomeInfo oNewHome = stageInv.getSHPropObj();
            if (oNewHome != null) {
                Properties props;
                OiiiOracleHomeInfo currentHome = this.m_installInv.getHomeInfo(this.getOHIndex());
                int iOldARUID = currentHome.getARUID();
                int iNewARUID = oNewHome.getARUID();
                if (iNewARUID != iOldARUID) {
                    currentHome.setARUID(iNewARUID);
                    currentHome.setARUIDDescription(oNewHome.getARUIDDescription());
                }
                if ((props = oNewHome.getAdditionalOracleHomeProperties()) != null) {
                    for (String string : props.keySet()) {
                        String value = props.getProperty(string);
                        currentHome.setAdditionalOracleHomeProperty(string, value);
                    }
                }
            }
            try {
                this.prepareOHTopLevelSels();
            }
            catch (IOException e) {
                ioe = e;
            }
        }
        if ((progListener = this.getProgressListener()) != null) {
            progListener.onDoneProgress();
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public void setAccessFullPath(String sAccessFileName) {
        this.m_sAccessFilePath = sAccessFileName;
    }

    public String getAccessFullPath() {
        return this.m_sAccessFilePath;
    }

    public void setReadmeInfo(OiiiReleaseNotesInfo oReadmeInfo) {
        this.m_oReadmeInfo = oReadmeInfo;
    }

    public OiiiReleaseNotesInfo getReadmeInfo() {
        return this.m_oReadmeInfo;
    }

    @Override
    public void setupAccessObjects() throws IOException, ClassNotFoundException, OiisCompLoadingException, OiitTargetLockNotAvailableException {
        OiifbUIManager.setSession(this);
        if (this.getTargetAreaControl() != null) {
            this.grabLocks();
            this.updateInventoryWithHomes();
        }
        OiixPlatform.optimize();
        super.setupAccessObjects();
        try {
            this.m_curDisk.readLabelFile(this.m_sourceAccess.getSourceRoot());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.m_sessionContext.setDiskVariables();
        this.setShiphomeProperties();
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        iac.setSourceStageProvider(this.m_sourceAccess);
    }

    public void loadShiphomePropertiesXML(OiiiStageInventory stageInv) {
        if (stageInv != null) {
            String sSHPropFilePath = stageInv.getSHPropLoc();
            String sHomeLoc = this.m_installInv.getHomeLocation(this.getOHIndex());
            OiiiShipHomeInfo oShipHomeInfo = new OiiiShipHomeInfo(this.getOHIndex(), sHomeLoc);
            if (sSHPropFilePath != null) {
                File oSHPropFile = new File(sSHPropFilePath);
                if (oSHPropFile.exists()) {
                    OiiolTextLogger.appendText("Loading shiphomepropertiesfrom " + sSHPropFilePath);
                    OiiiOracleHomeInfoXMLReader OHInfoReader = OiiiOracleHomeInfoXMLReader.getOHInfoXMLReader();
                    OHInfoReader.updateHomeProperties(oShipHomeInfo, sSHPropFilePath);
                    stageInv.setSHPropObj(oShipHomeInfo);
                }
            } else {
                OiisVariable srcLocVar = this.m_sessionContext.getVariable("FROM_LOCATION");
                String stageSource = (String)srcLocVar.getValue();
                stageSource = OiixPathOps.getStandardForm(stageSource);
                String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-6004", new Object[]{stageSource});
                OiiolTextLogger.appendText(sMsg);
            }
        }
    }

    public void prepareSHTopLevelSels(OiiiStageInventory stageInv) throws IOException {
        this.setupTopLevelList(true);
        stageInv.optimize();
        this.prefetchFastCopyXml();
        this.m_sourceAccess.fetchSHInfoProps();
    }

    public void prepareOHTopLevelSels() throws IOException {
        this.setupTopLevelList(true);
        this.prefetchComponentJars();
    }

    public void prepareTopLevelSels(OiiiStageInventory stageInv) throws IOException {
        this.setupTopLevelList(true);
        stageInv.optimize();
        this.prefetchComponentJars();
        this.prefetchFastCopyXml();
        this.m_sourceAccess.fetchSHInfoProps();
    }

    private void updateInventoryWithHomes() throws IOException {
        String s = System.getProperty("oracle.installer.useORACLE_BASE");
        if (s != null && s.equalsIgnoreCase("true")) {
            this.updateOracleBase();
        }
        this.updateOracleHome();
        if (OiixOraparam.isApplTopStage()) {
            // empty if block
        }
    }

    private void updateOracleHome() throws IOException {
        block18: {
            OiisVariable ohVar = this.m_sessionContext.getVariable("ORACLE_HOME");
            String oracleHomeString = (String)ohVar.getValue();
            try {
                if (Boolean.getBoolean("oracle.installer.homepermissioncheck")) {
                    oracleHomeString = OiipgFileSystem.checkWritablePath(oracleHomeString);
                }
            }
            catch (OiipgPathException pge) {
                throw new IOException(pge.getMessage() + System.getProperty("line.separator") + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_CREAT_TOLOC_REASON"));
            }
            try {
                this.validateDestination(oracleHomeString);
                oracleHomeString = OiixPathOps.getUnexpandedCanonicalPath(oracleHomeString);
                try {
                    ohVar.setValue(oracleHomeString, true);
                }
                catch (OiifbCancelException e) {
                    e.printStackTrace();
                }
                catch (OiisVarSettingException e) {
                    e.printStackTrace();
                }
                this.updateLogLocation(oracleHomeString);
            }
            catch (NullPointerException npe) {
                throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_OPEN_TOLOC"));
            }
            boolean bOldStyleRegEntries = OiixOraparam.createOldStyleRegEntries();
            if (OiixInstallUtil.isWindows() && bOldStyleRegEntries) {
                try {
                    OiipgOracleHomes.syncAllHomes();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            if (this.m_installInv == null) break block18;
            Vector oracleHomes = this.m_installInv.getHomes();
            int ohIndex = OiiiOracleHomeInfo.getOHIndex(oracleHomes, oracleHomeString);
            if (ohIndex == -1) {
                OiisVariable ohNameVar = this.m_sessionContext.getVariable("ORACLE_HOME_NAME");
                String oracleHomeNameStr = (String)ohNameVar.getValue();
                OiiiOracleHomeInfo newHome = null;
                OiisVariable chVar = this.m_sessionContext.getVariable("COMPOSITE_HOME");
                String chStr = (String)chVar.getValue();
                OiisVariable chTypeVar = this.m_sessionContext.getVariable("COMPOSITE_HOME_TYPE");
                String chTypeStr = (String)chTypeVar.getValue();
                newHome = chStr != null ? this.m_installInv.addHome(oracleHomeNameStr, oracleHomeString, 0, chStr, chTypeStr) : this.m_installInv.addHome(oracleHomeNameStr, oracleHomeString, 0);
                if (newHome != null) {
                    newHome.setDirty(true);
                    ohIndex = newHome.getIndex();
                    if (bOldStyleRegEntries) {
                        try {
                            OiipgOracleHomes.validateHomeWithRegEntries(newHome);
                        }
                        catch (IOException e) {
                            OiifmAlert.displayError(e.getMessage());
                            throw e;
                        }
                    }
                }
            }
            OiipgOracleHomes.setupRegEntriesAndContext(this.m_sessionContext, bOldStyleRegEntries);
            this.setOHIndex(ohIndex);
        }
    }

    private void updateOracleBase() throws IOException {
        OiisVariable obVar = this.m_sessionContext.getVariable("ORACLE_BASE");
        String oracleBasestring = (String)obVar.getValue();
        try {
            oracleBasestring = OiipgFileSystem.checkWritablePath(oracleBasestring);
        }
        catch (OiipgPathException pge) {
            throw new IOException(pge.getMessage() + System.getProperty("line.separator") + OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_CREAT_BASELOC_REASON"));
        }
        try {
            this.validateOraBase(oracleBasestring);
            oracleBasestring = OiixPathOps.getUnexpandedCanonicalPath(oracleBasestring);
            try {
                obVar.setValue(oracleBasestring, true);
            }
            catch (OiifbCancelException e) {
                e.printStackTrace();
            }
            catch (OiisVarSettingException e) {
                e.printStackTrace();
            }
        }
        catch (NullPointerException npe) {
            throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_OPEN_BASELOC"));
        }
    }

    private void updateLogLocation(String oracleHomeString) throws IOException {
        OiisVariable logLocVar = this.m_sessionContext.getVariable("LOG_LOCATION");
        try {
            logLocVar.setValue(oracleHomeString + File.separator + "cfgtoollogs", true);
            OiiolTextLogger.setConfigLogLoc(oracleHomeString);
        }
        catch (OiisVarSettingException vse) {
            vse.printStackTrace();
        }
        catch (OiifbCancelException ce) {
            ce.printStackTrace();
        }
    }

    private void validateOraBase(String oracleBasestring) throws IOException {
        File oracleBase = new File(oracleBasestring);
        oracleBasestring = OiixPathOps.getNativeCanonicalPath(oracleBasestring);
        if (!oracleBase.exists()) {
            if (!OiixFileOps.mkdirs(oracleBase)) {
                throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_CREAT_BASELOC_REASON"));
            }
        } else if (!oracleBase.isDirectory()) {
            throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_BASELOC_DIR"));
        }
    }

    private void validateDestination(String oracleHomeString) throws IOException {
        File oracleHome = new File(oracleHomeString);
        OiisVariable ohNameVar = this.m_sessionContext.getVariable("ORACLE_HOME_NAME");
        String oracleHomeNameStr = (String)ohNameVar.getValue();
        oracleHomeString = OiixPathOps.getNativeCanonicalPath(oracleHomeString);
        String[] ohInfo = new String[2];
        ohInfo[1] = oracleHomeNameStr;
        if (!oracleHome.exists()) {
            ohInfo[0] = OiixPathOps.getNativeCanonicalPath(OiixFileOps.getFirstDirToBeCreated(oracleHomeString));
            this.m_oOhLocName.put(oracleHomeString, ohInfo);
            if (!OiixFileOps.mkdirs(oracleHome)) {
                throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_CREAT_TOLOC"));
            }
        } else {
            if (this.m_bNewOraclHome) {
                ohInfo[0] = "";
                this.m_oOhLocName.put(oracleHomeString, ohInfo);
            }
            if (!oracleHome.isDirectory()) {
                throw new IOException(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_ERROR_TOLOC_DIR"));
            }
        }
    }

    public static int getCurPlatform() {
        return OiixPlatform.getCurrentPlatform();
    }

    public void saveUserActions(OiiiInstallInventory inv, int homeIndex) {
        String sTempLoc = System.getProperty("oracle.installer.scratchPath");
        sTempLoc = OiixPathOps.concatPath(sTempLoc, "UserActions");
        OiiiCompInstallID[] ci = this.getSelTopLevelCompIDs();
        for (int i = 0; i < ci.length; ++i) {
            String sSourceLoc = OiixPathOps.concatPath(sTempLoc, ci[i].getName());
            sSourceLoc = OiixPathOps.getNativeForm(sSourceLoc);
            OiiiInstallAreaControl iac = this.getInstallAreaControl();
            String sDestLoc = iac.getXMLCompFullLoc(ci[i], homeIndex);
            try {
                if (!new File(sSourceLoc).exists()) continue;
                OiixFileOps.copyDir(new File(sSourceLoc), new File(sDestLoc), true, true, false, "0640");
                continue;
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException(ioe);
            }
        }
    }

    public void saveBugListXML(OiiiInstallInventory inv, int homeIndex) {
        String filePath = null;
        String psBugList = System.getProperty("oracle.installer.patchsetBugListFile");
        String homeLoc = inv.getHomeLocation(homeIndex);
        homeLoc = OiixPathOps.concatPath(homeLoc, "buglist");
        if (psBugList != null) {
            filePath = psBugList;
            File path = new File(filePath);
            String fileName = path.getName();
            try {
                if (path.exists()) {
                    String dest = OiixPathOps.concatPath(homeLoc, fileName);
                    OiixFileOps.copyFile(filePath, dest, true, true);
                }
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException(ioe);
            }
            catch (OiifbCancelException ce) {
                OiiolTextLogger.appendException(ce);
            }
        } else {
            String sTempLoc = System.getProperty("oracle.installer.scratchPath");
            sTempLoc = OiixPathOps.concatPath(sTempLoc, "buglist");
            sTempLoc = OiixPathOps.getNativeForm(sTempLoc);
            try {
                if (new File(sTempLoc).exists()) {
                    OiixFileOps.copyDir(new File(sTempLoc), new File(homeLoc));
                }
            }
            catch (IOException ioe) {
                OiiolTextLogger.appendException(ioe);
            }
        }
    }

    public void saveWinActionsXML(OiiiInstallInventory inv) {
        if (!OiixFunctionOps.isPlatformWindows().booleanValue()) {
            return;
        }
        String sTmpLoc = OiixPathOps.getParentDir(this.getSourceAccess().getLocalStgInvLoc());
        String sWinXmlSrcLoc = OiilWinActions.getWinActionsFileName(sTmpLoc);
        if (!new File(sWinXmlSrcLoc).exists()) {
            return;
        }
        String sHomeInvLoc = OiixPathOps.concatPath(inv.getHomeLocation(this.getOHIndex()), "inventory");
        String sWinXmlTargetLoc = OiilWinActions.getWinActionsFileName(sHomeInvLoc);
        OiiiCompInstallID[] cidArray = this.getSessionPlan().getSelectedComps();
        OiilWinActions.saveWinActionsXml(cidArray, sWinXmlSrcLoc, sWinXmlTargetLoc, false);
    }

    public void saveInstantiateXML(OiiiInstallInventory inv) {
        String sTmpLoc = OiixPathOps.getParentDir(this.getSourceAccess().getLocalStgInvLoc());
        String sInstantiateSrcLoc = OiixPathOps.concatPath(sTmpLoc, "instantiate.xml");
        if (!new File(sInstantiateSrcLoc).exists()) {
            return;
        }
        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_SAVING_GLOBAL_INSTANTIATE"), OiiolTextLogger.LOG_BASIC);
        if (inv.getHomeLocation(this.getOHIndex()) == null) {
            return;
        }
        String sHomeInvLoc = OiixPathOps.concatPath(inv.getHomeLocation(this.getOHIndex()), "inventory");
        String sInstantiateHomeLoc = OiixPathOps.concatPath(sHomeInvLoc, "instantiate.xml");
        ArrayList listInst = this.getListInstantiates();
        if (listInst != null) {
            if (new File(sInstantiateHomeLoc).exists()) {
                OiisGenActionsReader genReader = new OiisGenActionsReader(sInstantiateHomeLoc, true);
                try {
                    genReader.loadFromFile();
                }
                catch (IOException e) {
                    OiiolTextLogger.appendText("Error in loading" + sInstantiateHomeLoc, 0);
                }
                listInst.addAll(genReader.getListInstantiates());
            }
            OiixInstantiateOps.saveInstantiates(sInstantiateHomeLoc, listInst);
        }
    }

    @Override
    public void saveInventoryWithUpdate() throws IOException, OiifbCancelException {
        int i;
        int i2;
        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_INIT_SAV_INV"), OiiolTextLogger.LOG_BASIC);
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        try {
            int idx = this.getOHIndex();
            this.saveBugListXML(instInv, idx);
            this.saveUserActions(instInv, idx);
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
        }
        Vector installIEs = this.m_sessionPlan.getSuccessfulAdditions(40, true);
        if (System.getProperty("oracle.installer.ouiApiMode", "false").equalsIgnoreCase("true")) {
            installIEs = this.m_sessionPlan.getSuccessfulAdditions(10, true);
        }
        instInv.saveExtFiles(this.getOHIndex());
        int nIds = installIEs.size();
        for (i2 = nIds - 1; i2 >= 0; --i2) {
            OiiiInstallCompInvEntry ie = (OiiiInstallCompInvEntry)installIEs.elementAt(i2);
            OiiiCompInstallID id = ie.getCompInstallID();
            int compOhIndex = this.getHomeIndex(id);
            instInv.addCompInvEntry(ie, compOhIndex);
            this.extractResources(ie, compOhIndex);
            if (!this.m_sessionPlan.isTopLevelComp(id) || id.getCompType() == 2) continue;
            ie.setTopLevel(true);
            ie.addReferencer(new OiiiCompIdOhPair(id, compOhIndex));
        }
        if (this.m_vInstalledTLComps != null && this.m_vInstalledTLComps.size() > 0) {
            try {
                for (i2 = 0; i2 < this.m_vInstalledTLComps.size(); ++i2) {
                    this.installInvUpdate(instInv, (OiiiInstallCompInvEntry)this.m_vInstalledTLComps.elementAt(i2), iac, true, false);
                }
                this.resetInstalledTLComps();
            }
            catch (Exception i3) {
                // empty catch block
            }
        }
        ArrayList addComps = this.m_depEngine.getaddComps();
        ArrayList<OiiiCompInstallID> cids = new ArrayList<OiiiCompInstallID>();
        for (i = 0; i < addComps.size(); ++i) {
            OiiodAdditionalComps ac = (OiiodAdditionalComps)addComps.get(i);
            cids.add(ac.getCID());
        }
        for (i = nIds - 1; i >= 0; --i) {
            OiiiInstallCompInvEntry ie = (OiiiInstallCompInvEntry)installIEs.elementAt(i);
            if (ie instanceof OiiiInstallPatchInvEntry) {
                OiiiInstallPatchInvEntry ipie = (OiiiInstallPatchInvEntry)ie;
                OiiiCompInstallID baseID = ipie.getBaseID();
                OiiiInstallCompInvEntry bcie = instInv.getInstallCompInvEntry(baseID, this.getHomeIndex(baseID));
                if (bcie != null) {
                    ipie.setBaseInvEntry(bcie);
                    bcie.setPatchInvEntry(ipie);
                    ipie.setProdHomeLoc(bcie.getProdHomeLoc());
                }
            } else {
                OiiiCompInstallID cid = ie.getCompInstallID();
                if (cids.indexOf(cid) != -1) {
                    this.installInvUpdate(instInv, ie, iac, false, true);
                } else {
                    this.installInvUpdate(instInv, ie, iac, false, false);
                }
            }
            this.m_sessionPlan.setAdditionPhase(ie.getCompInstallID(), 60);
        }
        Vector installIPSEs = this.m_sessionPlan.getPatchSets();
        int nPSIds = installIPSEs.size();
        for (int i4 = 0; i4 < nPSIds; ++i4) {
            OiiiInstallPatchSetInvEntry ie = (OiiiInstallPatchSetInvEntry)installIPSEs.elementAt(i4);
            OiiiPatchSetInstallID oPatchId = (OiiiPatchSetInstallID)ie.getCompInstallID();
            int patchSetOhIndex = this.getHomeIndex(oPatchId);
            Vector vPatches = ie.getPatches();
            OiiiInstallPatchSetInvEntry pSetIE = (OiiiInstallPatchSetInvEntry)instInv.getInstallCompInvEntry(ie.getCompInstallID(), patchSetOhIndex);
            if (pSetIE != null) {
                Vector v = pSetIE.getPatches();
                OiixVectorOps.unionInPlace(vPatches, v);
                instInv.removeCompInvEntry(pSetIE.getCompInstallID(), patchSetOhIndex);
            }
            for (int j = 0; j < vPatches.size(); ++j) {
                int patchOhIndex;
                OiiiCompInstallID pID = (OiiiCompInstallID)vPatches.elementAt(j);
                OiiiInstallPatchInvEntry pcie = (OiiiInstallPatchInvEntry)instInv.getInstallCompInvEntry(pID, patchOhIndex = this.getHomeIndex(pID));
                if (pcie != null) {
                    pcie.setPSetIDOH((OiiiPatchSetInstallID)ie.getCompInstallID(), patchSetOhIndex);
                    continue;
                }
                vPatches.removeElementAt(j);
                --j;
            }
            ie.setPatches(vPatches);
            instInv.addCompInvEntry(ie, patchSetOhIndex);
            this.extractResources(ie, patchSetOhIndex);
        }
        OiiiCompInstallID[] topLevelIDs = this.m_sessionPlan.getSelectedComps();
        Vector<OiiiInstallCompInvEntry> sessionIEs = new Vector<OiiiInstallCompInvEntry>();
        if (topLevelIDs != null) {
            for (int i5 = 0; i5 < topLevelIDs.length; ++i5) {
                int compOhIndex = this.getHomeIndex(topLevelIDs[i5]);
                OiiiInstallCompInvEntry selCompIE = instInv.getInstallCompInvEntry(topLevelIDs[i5], compOhIndex);
                if (selCompIE != null && selCompIE.wasCreatedInThisSession()) {
                    sessionIEs.addElement(selCompIE);
                }
                if (selCompIE == null || topLevelIDs[i5].getCompType() == 2) continue;
                selCompIE.setTopLevel(true);
                selCompIE.addReferencer(new OiiiCompIdOhPair(topLevelIDs[i5], compOhIndex));
            }
        }
        this.getSessionContext().writeGlobalVarsToInv();
        this.saveWinActionsXML(instInv);
        this.saveInstantiateXML(instInv);
        iac.saveInstallInventory();
        this.getTargetAreaControl().cleanUpInvDir(false);
        iac.releaseWriterLock();
    }

    public void removeInvEntry(OiiiCompIdOhPair deinstallIdOh, OiiiCompInstallID deinstallID) {
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        int deinstOhIndex = deinstallIdOh.getOHIndex();
        instInv.removeCompInvEntry(deinstallID, deinstOhIndex);
    }

    private void extractResources(OiiiInstallCompInvEntry icie, int ohIndex) throws OiifbCancelException {
        int nHomeIndex = this.getHomeIndex(icie.getCompInstallID());
        OiiiStageInventory stageInv = this.getStageInventory();
        if (stageInv != null) {
            OiiiInstallAreaControl iac = this.getInstallAreaControl();
            OiiiCompInstallID cid = icie.getCompInstallID();
            String prodJarLoc = this.m_sourceAccess.getLocalStgInvLoc();
            try {
                OiiiCompInvEntry stageEntry = stageInv.getCompatCompEntry(cid, 0, OiixPlatform.getCurrentPlatform());
                if (stageEntry != null && stageEntry instanceof OiiiStageCompInvEntry) {
                    OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)stageEntry;
                    String insLoc = iac.genLogLoc(icie.getLocation());
                    insLoc = insLoc.replace('\\', '/');
                    insLoc = insLoc.replace('/', File.separatorChar);
                    String sXMLResourcesLoc = OiixPathOps.concatPath(iac.getInventoryLocForHome(nHomeIndex), icie.getLocationInXMLInventory());
                    sXMLResourcesLoc = sXMLResourcesLoc.replace('\\', '/');
                    sXMLResourcesLoc = OiixPathOps.getNativeForm(sXMLResourcesLoc);
                    String xmlResourceDir = OiixPathOps.concatPath(sXMLResourcesLoc, "resources");
                    File fXMLResDir = new File(xmlResourceDir);
                    OiixFileOps.mkdirs(fXMLResDir);
                    Locale langCode = Locale.getDefault();
                    String fileName = "resources/CompID";
                    String ext = ".properties";
                    String sEnglishFileName = fileName + ext;
                    String sCurrLocaleFileName = fileName + "_" + langCode.toString() + ext;
                    if (langCode.equals(OiixLanguage.ENGLISH)) {
                        sCurrLocaleFileName = sEnglishFileName;
                    }
                    String sTargetEnglishFileName = insLoc + sEnglishFileName;
                    String sTargetCurrLocaleFileName = insLoc + sCurrLocaleFileName;
                    if (scie.isStageVersionPreX("2.0")) {
                        OiixJarClassLoader jcl = OiixJarClassLoader.createLoader(prodJarLoc);
                        String compResLoc = stageEntry.getLocation();
                        jcl.extractFile(compResLoc + sEnglishFileName, sTargetEnglishFileName, false);
                        if (!langCode.equals(OiixLanguage.ENGLISH)) {
                            jcl.extractFile(compResLoc + sCurrLocaleFileName, sTargetCurrLocaleFileName, false);
                        }
                    } else {
                        String sDescID = OiisGenericConstant.formDefaultName(scie.getDescResourceId());
                        Properties oProps = this.getCompConstantsAsProperties(scie, Locale.getDefault());
                        String sDesc = scie.getDescription();
                        oProps.put(sDescID, sDesc);
                        oProps.put("Name", scie.getName());
                        oProps.put("Description", sDesc);
                        String xmlCurrLocaleFileName = OiixPathOps.concatPath(sXMLResourcesLoc, sCurrLocaleFileName);
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(xmlCurrLocaleFileName));
                        oProps.store(bos, "");
                        bos.close();
                        if (!langCode.equals(OiixLanguage.ENGLISH)) {
                            oProps = this.getCompConstantsAsProperties(scie, OiixLanguage.DEFAULT_LOCALE);
                            sDesc = scie.getDescription(OiixLanguage.DEFAULT_LOCALE);
                            oProps.put(sDescID, sDesc);
                            oProps.put("Name", scie.getName());
                            oProps.put("Description", sDesc);
                            String xmlEnglishFileName = OiixPathOps.concatPath(sXMLResourcesLoc, sEnglishFileName);
                            bos = new BufferedOutputStream(new FileOutputStream(xmlEnglishFileName));
                            oProps.store(bos, "");
                            bos.close();
                        }
                    }
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
        }
    }

    private Properties getCompConstantsAsProperties(OiiiStageCompInvEntry scie, Locale l) {
        Properties oProps = new Properties();
        OiiiCompInstallID oCompID = scie.getCompInstallID();
        if (oCompID.getCompType() != 4) {
            OiisCompInstallation oCompInstall = this.getCompInstall(scie.getCompInstallID());
            OiisCompConstants oCompConstants = oCompInstall.getContext().getCompConstants();
            ResourceBundle rb = null;
            if (Locale.getDefault().equals(l)) {
                rb = scie.getResourceBundle();
                oProps = oCompConstants.getConstantsAsProperties();
            } else {
                rb = scie.getResourceBundle(l);
                oProps = oCompConstants.getConstantsAsProperties(rb);
            }
        }
        return oProps;
    }

    private void installInvUpdate(OiiiInstallInventory instInv, OiiiInstallCompInvEntry icie, OiiiInstallAreaControl iac, boolean bUpgradeComp, boolean bAdditionalComp) {
        OiiiCompInstallID depID;
        Vector<OiiiCompInstallID> TLs = new Vector<OiiiCompInstallID>();
        OiiiCompInstallID cid = icie.getCompInstallID();
        int ohIndex = this.getHomeIndex(cid);
        OiisCompInstallation ci = this.getCompInstall(cid);
        if (ci != null) {
            String sProdHome = ci.getContext().getProdHome();
            icie.setProdHomeLoc(sProdHome);
        }
        try {
            if (bAdditionalComp) {
                int iSize;
                TLs = instInv.getTopLevelComps(ohIndex);
                int n = iSize = TLs == null ? 0 : TLs.size();
                if (iSize == 0 && this.getSelTopLevelCompIDs() != null) {
                    iSize = this.getSelTopLevelCompIDs().length;
                    List<OiiiCompInstallID> list = Arrays.asList(this.getSelTopLevelCompIDs());
                    TLs = new Vector<OiiiCompInstallID>(list);
                }
                for (int i = 0; i < iSize; ++i) {
                    OiiiCompInstallID cID = (OiiiCompInstallID)TLs.elementAt(i);
                    if (cID.getCompType() == 4) continue;
                    OiiiCompIdOhPair cIdOh = new OiiiCompIdOhPair(cID, ohIndex);
                    icie.addReferencer(cIdOh);
                }
            }
        }
        catch (Exception e) {
            OiiolTextLogger.appendException(e);
        }
        Vector referencers = icie.getReferencers();
        Vector savedRefs = this.m_sessionPlan.getRefs(cid);
        referencers = OiixVectorOps.union(referencers, savedRefs);
        for (int i = 0; i < referencers.size(); ++i) {
            OiiiCompIdOhPair refIdOh = (OiiiCompIdOhPair)referencers.elementAt(i);
            OiiiInstallCompInvEntry rCie = (OiiiInstallCompInvEntry)instInv.getCompatCompEntry(refIdOh.getCompID(), refIdOh.getOHIndex());
            if (rCie != null) {
                if (rCie.getCompInstallID().equalsWithPlatInt(cid)) continue;
                OiiiCompIdOhPair cohpDep = new OiiiCompIdOhPair(cid, ohIndex);
                OiiiCompIdOhPair cohpRef = null;
                int refIndex = referencers.indexOf(new OiiiCompIdOhPair(refIdOh.getCompID(), refIdOh.getOHIndex()));
                if (refIndex != -1) {
                    cohpRef = (OiiiCompIdOhPair)referencers.elementAt(refIndex);
                }
                if (cohpRef != null) {
                    cohpDep.setDepType(cohpRef.getDepType());
                    cohpDep.setDepGroup(cohpRef.getDepGroup());
                }
                rCie.addDependee(cohpDep);
                if (!bAdditionalComp || TLs == null || TLs.indexOf(rCie.getCompInstallID()) == -1) continue;
                Vector<OiiiCompInstallID> deps = new Vector<OiiiCompInstallID>();
                Vector<OiisDepRule> depRules = new Vector<OiisDepRule>();
                String sOptional = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OPTIONAL_DEPS");
                cohpDep.setDepType(0);
                cohpDep.setDepGroup(sOptional);
                deps.addElement(cohpDep.getCompID());
                depRules.addElement(new OiisDepRule(sOptional, 0, sOptional, deps));
                OiisDeps dep = rCie.getDeps();
                if (dep == null) continue;
                Vector rules = dep.getDepRules();
                if (rules != null) {
                    rules.addAll(depRules);
                }
                dep.setDepRules(rules);
                continue;
            }
            referencers.removeElementAt(i);
            --i;
        }
        icie.setReferencers(referencers);
        Vector dependees = icie.getDependees();
        for (int i = 0; i < dependees.size(); ++i) {
            int depOhIndex;
            OiiiCompIdOhPair depIdOh = (OiiiCompIdOhPair)dependees.elementAt(i);
            depID = depIdOh.getCompID();
            OiiiInstallCompInvEntry dCie = (OiiiInstallCompInvEntry)instInv.getCompatCompEntry(depID, depOhIndex = depIdOh.getOHIndex());
            if (dCie != null) {
                dCie.addReferencer(new OiiiCompIdOhPair(cid, ohIndex));
                continue;
            }
            dependees.removeElement(depIdOh);
            --i;
        }
        if (bUpgradeComp) {
            Vector vAllDeps = icie.getDeps().getAllDependees();
            for (int i = 0; i < vAllDeps.size(); ++i) {
                depID = (OiiiCompInstallID)vAllDeps.elementAt(i);
                OiiiInstallCompInvEntry dCie = (OiiiInstallCompInvEntry)instInv.getCompatCompEntry(depID, ohIndex);
                if (dCie == null && depID.isNOHComp()) {
                    OiiiCompInstallID checkID = new OiiiCompInstallID(depID.getName(), depID.getVersion(), depID.getPlatforms(), depID.getReplaceVersion(), depID.getCompType(), 2, depID.getReleaseLevel(), false);
                    dCie = (OiiiInstallCompInvEntry)instInv.getCompatCompEntry(checkID, ohIndex);
                    depID = checkID;
                }
                if (dCie == null) continue;
                dCie.addReferencer(new OiiiCompIdOhPair(cid, ohIndex));
                dependees.addElement(new OiiiCompIdOhPair(depID, ohIndex));
            }
        }
        icie.setDependees(dependees);
        this.m_installInv.setModifiedHomesDirty(icie, ohIndex);
        this.m_installInv.setModifiedHomesDirty(icie, this.getAppltopIndex());
    }

    public void addInstalledTLComp(OiiiInstallCompInvEntry icie) {
        if (this.m_vInstalledTLComps == null) {
            this.m_vInstalledTLComps = new Vector();
        }
        this.m_vInstalledTLComps.addElement(icie);
    }

    public void resetInstalledTLComps() {
        if (this.m_vInstalledTLComps != null) {
            this.m_vInstalledTLComps.clear();
        } else {
            this.m_vInstalledTLComps = new Vector();
        }
    }

    public Vector getInstalledTLComps() {
        return this.m_vInstalledTLComps;
    }

    @Override
    public OiisLibraryLoader getLibLoader(OiiiLibraryID lid, int libType, int homeIndex) throws IOException, OiifbCancelException {
        OiiiInstallAreaControl installAreaControl = this.getInstallAreaControl();
        OiisLibraryLoader lLoader = null;
        lLoader = super.getLibLoader(lid, libType, homeIndex);
        if (lLoader == null) {
            OiiiVersion runInstVer = OiicInstVersion.getInstallerVersion();
            OiiiLibInvEntry remoteLib = this.getStageInventory().getCompatLibEntry(lid, libType, runInstVer);
            if (remoteLib != null) {
                OiiiLibraryID fetchLID = remoteLib.getLibraryID();
                String remoteLoc = remoteLib.getLocation();
                String relativeFileLoc = installAreaControl.getXMLLibRelativeLoc(fetchLID, libType, homeIndex);
                relativeFileLoc = OiixPathOps.concatPath(relativeFileLoc, OiixPathOps.getFileName(remoteLoc));
                String sInvLoc = installAreaControl.getInventoryLocForHome(homeIndex);
                String localFileLoc = OiixPathOps.concatPath(sInvLoc, relativeFileLoc);
                this.m_sourceAccess.fetchLibJar(fetchLID, localFileLoc, libType);
                Vector<String> oLibs = (Vector<String>)this.m_oCopiedLibs.get(new Integer(homeIndex));
                if (oLibs == null) {
                    oLibs = new Vector<String>();
                    this.m_oCopiedLibs.put(new Integer(homeIndex), oLibs);
                }
                oLibs.add(localFileLoc);
                OiiiLibInvEntry localLib = new OiiiLibInvEntry(fetchLID, relativeFileLoc);
                if (this.m_installInv != null) {
                    this.m_installInv.addLibInvEntry(localLib, libType, homeIndex);
                }
                OiiiLibraryID newLID = fetchLID;
                lLoader = (OiisLibraryLoader)this.m_IDsToLibLoaders[libType].get(fetchLID);
                if (lLoader != null) {
                    return lLoader;
                }
                switch (libType) {
                    case 0: {
                        lLoader = new OiisActionLibLoader(localFileLoc);
                        break;
                    }
                    case 1: {
                        lLoader = new OiisQueryLibLoader(localFileLoc);
                        break;
                    }
                    case 2: {
                        lLoader = new OiisDialogLibLoader(localFileLoc);
                    }
                }
                if (lLoader != null) {
                    this.m_IDsToLibLoaders[libType].put(newLID, lLoader);
                }
            }
        }
        return lLoader;
    }

    public static OiiiLibraryID getFileLibraryID() {
        Vector<Integer> plats = new Vector<Integer>();
        int[] nPlats = OiixPlatform.getPlatforms();
        for (int i = 0; i < nPlats.length; ++i) {
            plats.addElement(new Integer(nPlats[i]));
        }
        return new OiiiLibraryID("fileActions", new OiiiVersion("1.0"), plats, new OiiiVersion("0.0"));
    }

    public int getActionMode() {
        return 2;
    }

    public OiisVariable getSessionVariable(String varName) {
        if (this.m_sessionContext != null) {
            return this.m_sessionContext.getVariable(varName);
        }
        return null;
    }

    public OiicInstallActionsPhase getActionsPhase() {
        OiicInstallActionsPhase oActionsPhase = new OiicInstallActionsPhase(this.getActionsPhaseWCDE().getCurrentPhase());
        return oActionsPhase;
    }

    public void setCurrentDisk(OiiiCdLabel disk) {
        this.m_curDisk = disk;
    }

    public int getCurrentDiskNumber() {
        return this.m_curDisk.getNumber();
    }

    public String getDiskLabel() {
        return this.m_curDisk.getLabel();
    }

    public static String getLastDiskLocation() {
        return s_LastDiskLocation;
    }

    public static void setLastDiskLocation(String sLastDiskLocation) {
        s_LastDiskLocation = sLastDiskLocation;
    }

    public String ensureValidDisk(String sLabel, int diskNumber) throws OiiiDiskNotFoundException, IOException {
        String sCurrentLabel = this.getDiskLabel();
        if (sCurrentLabel == null || !sCurrentLabel.equals(sLabel) || this.getCurrentDiskNumber() != diskNumber) {
            OiisVariable fromLocationVar = this.getSessionVariable("FROM_LOCATION");
            String sRoot = null;
            if (OiicInstallSession.getLastDiskLocation() != null) {
                sRoot = OiicInstallSession.getLastDiskLocation();
                sRoot = OiixPathOps.getStandardForm(sRoot);
            } else {
                sRoot = (String)fromLocationVar.getValue();
                sRoot = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(sRoot));
            }
            OiisDiskLocator oDiskLocator = new OiisDiskLocator(this.getSessionContext());
            String sNewLoc = oDiskLocator.getDiskLocation(sRoot, sLabel, diskNumber);
            OiiiCdLabel labelFile = new OiiiCdLabel();
            labelFile.readLabelFile(sNewLoc);
            this.setCurrentDisk(labelFile);
            OiicInstallSession.setLastDiskLocation(sNewLoc);
            return sNewLoc;
        }
        return null;
    }

    @Override
    public void updateEnv(OiiiInstallInventory instInv) {
        Vector oHomes = instInv.getHomes();
        if (oHomes == null) {
            return;
        }
        OiisVariable homeKeyVar = this.getSessionVariable("ORACLE_HOME_KEY");
        if (homeKeyVar != null) {
            OiipgOracleHomes.setHomeCounters((String)homeKeyVar.getValue());
        }
    }

    public String[] getOuicaCommand() {
        String[] sCmd = null;
        String sOuicaScriptName = OiixOraparam.getOuicaScriptName();
        if (sOuicaScriptName == null || sOuicaScriptName.equals("")) {
            return sCmd;
        }
        OiicInstPostActionsPhase instPostActionsPhase = this.getInstPostActionsPhase();
        if (!instPostActionsPhase.checkConfigToolsRan()) {
            return sCmd;
        }
        OiiiInstallCompInvEntry ouiEntry = this.getInstallAreaControl().getInstallInventory().findCompInRange(this.getOHIndex(), "oracle.swd.oui", OiicInstVersion.getOUIVersionForOuica(), OiicInstVersion.getOUIVersionForOuica());
        if (ouiEntry == null) {
            return sCmd;
        }
        OiiiOracleHomeInfo ohInfo = this.getInstallAreaControl().getInstallInventory().getHomeInfo(this.getOHIndex());
        String ohLoc = ohInfo.getLocation();
        String sOUIHome = OiixPathOps.concatPath(ohLoc, "oui");
        String sOuicaLoc = OiixPathOps.concatPath(sOUIHome, "bin");
        sOuicaLoc = OiixPathOps.concatPath(sOuicaLoc, sOuicaScriptName);
        sOuicaLoc = OiixPathOps.getNativeCanonicalPath(sOuicaLoc);
        String sLogLoc = OiixPathOps.getNativeCanonicalPath(OiiolTextLogger.getLogDir());
        String sTimeStamp = OiixUtilityOps.getSessionTimeStamp();
        sCmd = new String[]{sOuicaLoc, sTimeStamp, sLogLoc};
        return sCmd;
    }

    public void runOuica(boolean bCheckExitCondition) {
        if (!bCheckExitCondition || !this.isRebootInfoSet() && this.isSuccessfullInstallation()) {
            this.executeOuica();
        }
    }

    private void executeOuica() {
        String[] sCmd = this.getOuicaCommand();
        if (sCmd != null) {
            Object[] sArgs = new String[]{sCmd[0]};
            OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_OUICA_COMMAND_LOCATION", sArgs));
            try {
                OiixSpawner oSpawn = new OiixSpawner();
                oSpawn.asyncRuntimeExec(sCmd);
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setFastMode(int nFastMode) {
        this.m_nFastMode = nFastMode;
    }

    public boolean isFastMode() {
        return this.m_nFastMode > 0 && this.m_nFastMode == 1;
    }

    public int getFastModeType() {
        return this.m_nFastMode;
    }

    public boolean isCurrentInstallHomeDirty() {
        boolean bDirty = false;
        int curOH = this.getOHIndex();
        OiiiInstallAreaControl iac = this.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        Vector vComps = instInv.getAllCompsVect(curOH);
        bDirty = vComps != null && vComps.size() != 0;
        return bDirty;
    }

    protected void prefetchFastCopyXml() {
        if (this.m_sourceAccess.isHttpStage()) {
            OiiolTextLogger.appendText("Install Mode : Non FastMode");
            return;
        }
        String sFastCopyXML = this.m_sourceAccess.fetchFastCopyXML();
        if (sFastCopyXML == null) {
            OiiolTextLogger.appendText("Install Mode : Non FastMode");
        } else {
            this.m_oFastCopyData = new OiijFastCopyData(sFastCopyXML);
        }
    }

    public OiijFastCopyData getFastCopyData() {
        return this.m_oFastCopyData;
    }

    private class OiicSelCompsInstall
    implements OiifbCondWizOperation {
        private OiicInstallSession m_instSession = null;
        private OiifbLinearIterator m_preStateChangeIter = null;
        private OiifbLinearIterator m_stateChangeIter = null;
        private OiifbLinearIterator m_postInstallIter = null;
        private int m_nextInd = -1;

        public OiicSelCompsInstall(OiicInstallSession instSession, int nextInd) {
            this.m_instSession = instSession;
            this.m_nextInd = nextInd;
        }

        public OiicInstallSession getInstSession() {
            return this.m_instSession;
        }

        @Override
        public void initialize() throws OiifbEndIterateException {
            this.m_preStateChangeIter = new OiifbLinearIterator(false);
            this.m_stateChangeIter = new OiifbLinearIterator(true);
            this.m_postInstallIter = new OiifbLinearIterator(true);
            this.addPreStateChangeEls(this.m_preStateChangeIter);
        }

        @Override
        public int doOperation(boolean back) throws OiifbEndIterateException {
            if (back) {
                return 0;
            }
            if (this.m_preStateChangeIter.iterate(back) == 1) {
                return 1;
            }
            this.m_preStateChangeIter.dispose();
            if (OiicPullSession.isSilentMode()) {
                OiicSilentInterfaceManager osim = (OiicSilentInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
                if (Boolean.getBoolean("oracle.installer.showVariables")) {
                    osim.logVarDetails();
                }
            }
            this.addStateChangeEls(this.m_stateChangeIter);
            this.m_stateChangeIter.iterate(back);
            this.m_stateChangeIter.dispose();
            this.getInstSession().saveEndOfInstallMessages();
            this.addPostInstallEls(this.m_postInstallIter);
            return this.m_postInstallIter.iterate(back);
        }

        private void addPreStateChangeEls(OiifbLinearIterator iter) {
            OiicSessionContext sessionContext = this.m_instSession.getSessionContext();
            OiicCompsWizEngine compsEngine = new OiicCompsWizEngine(this.m_instSession);
            iter.addElement(compsEngine);
            OiifwClusterSessionVarWCCE clusterSessionVar = new OiifwClusterSessionVarWCCE(sessionContext);
            iter.addElement(clusterSessionVar);
            OiicSessionSettingSaveWCCE savSettings = new OiicSessionSettingSaveWCCE(sessionContext);
            iter.addElement(savSettings);
            OiifwSummaryWCDE summary = new OiifwSummaryWCDE(sessionContext);
            iter.addElement(summary);
            OiifwValidateDiskSpaceWCCE vds = new OiifwValidateDiskSpaceWCCE(sessionContext);
            iter.addElement(vds);
        }

        private void addStateChangeEls(OiifbLinearIterator iter) {
            OiifwActionsPhaseWCDE actionsPhase = new OiifwActionsPhaseWCDE(this.m_instSession);
            this.m_instSession.setActionsPhaseWCDE(actionsPhase);
            iter.addElement(actionsPhase);
        }

        private void addPostInstallEls(OiifbLinearIterator iter) {
            OiicInstPostActionsPhase instPostActionsPhase = new OiicInstPostActionsPhase(this.m_instSession);
            iter.addElement(instPostActionsPhase);
            this.m_instSession.setInstPostActionsPhase(instPostActionsPhase);
        }

        @Override
        public void dispose() {
            if (this.m_preStateChangeIter != null) {
                this.m_preStateChangeIter.dispose();
                this.m_preStateChangeIter = null;
            }
            if (this.m_stateChangeIter != null) {
                this.m_stateChangeIter.dispose();
                this.m_stateChangeIter = null;
            }
            if (this.m_postInstallIter != null) {
                this.m_postInstallIter.dispose();
                this.m_postInstallIter = null;
            }
            this.m_instSession = null;
        }

        void disposePreStateObjects() {
            if (this.m_preStateChangeIter != null) {
                this.m_preStateChangeIter.dispose();
                this.m_preStateChangeIter = null;
            }
            OiicSessionInterfaceManager.getInterfaceManager().disposePreStateChangeElements();
        }

        public void finalize() {
            this.dispose();
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public int getNext() {
            return this.m_nextInd;
        }
    }
}

