/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAttachHome;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiic.OiicInstallAddOnException;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiic.OiicUpdateHomeDeps;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiii.OiiiAddOnProgressListener;
import oracle.sysman.oii.oiii.OiiiIAddOnProgressListener;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiInventoryUpdateException;
import oracle.sysman.oii.oiii.OiiiMissingDependeeException;
import oracle.sysman.oii.oiii.OiiiMultipleSOHException;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterException;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiis.OiisVarSettingException;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixJarOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawnOps;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiicInstallAddOn
extends OiicBaseApp {
    private static OiicInstallAddOn s_oiicInstallAddOn = null;
    private String invPtrLoc = System.getProperty("oracle.installer.invPtrLoc");
    private static OiicInstallAddOn oInstallAddOn = null;
    private OiiiInstallAreaControl iAreaControl = null;
    private static boolean ABORT_ATTACHHOME = false;
    private static boolean UPDATE_HOME_DEPS = false;
    private static OiicSessionContext m_oContext = null;
    private static OiicStandardInventorySession invSession = null;
    private static final String appName = "oui";
    private String m_sInvLocation = null;
    public static boolean PLUGIN_API_MODE = false;
    public static boolean PLUGIN_STATUS = false;
    private static OiiiIAddOnProgressListener m_listener = OiiiAddOnProgressListener.getAddOnProgressListenerInstance();
    private String addOnPropFileName = "addon.properties";
    private String ADDON_PROP = "oracle.addOn.postCopyScripts";
    private static int m_exitCode = 0;
    public static final int S_EXIT_SUCCESS = 0;
    public static final int S_INSTALL_ADDONS_ORACLE_HOME_MISSING = 1;
    public static final int S_INSTALL_ADDONS_ORACLE_HOME_EXISTS = 2;
    public static final int S_INSTALL_ADDONS_PLUGIN_JAR_LOCATION_MISSING = 3;
    public static final int S_INSTALL_ADDONS_PLUGIN_UNJAR_OPERATION_FAILED = -1;
    public static final int S_INSTALL_ADDONS_PLUGIN_UNABLE_TO_CREATE_DEST = -2;
    public static final int S_INSTALL_ADDONS_PLUGIN_LOCATION_DOESNT_EXISTS = -3;
    public static final int S_INSTALL_ADDONS_PLUGIN_NON_EMPTY_OH = -4;

    public OiicInstallAddOn() {
        super(appName);
        Properties props = System.getProperties();
        props.put("oracle.installer.installaddons", "true");
        props.put("oracle.installer.silent", "true");
    }

    public static int getExitCode() {
        return m_exitCode;
    }

    public static void setExitCode(int exitCode) {
        m_exitCode = exitCode;
    }

    @Override
    protected String getSystemPropertyPrefix() {
        return "oracle.installer.";
    }

    public boolean isAPIMode() {
        return PLUGIN_API_MODE;
    }

    public static OiicInstallAddOn getOiicInstallAddOnInstance() {
        if (s_oiicInstallAddOn == null) {
            s_oiicInstallAddOn = new OiicInstallAddOn();
        }
        return s_oiicInstallAddOn;
    }

    protected String getLogPrefix() {
        return "InstallAddOn";
    }

    public void doOperation(OiiiInstallAreaControl iac, OiicSessionContext oContext) throws OiifbCancelException, OiiiInventoryUpdateException, IOException, OiixException, OiiiMultipleSOHException, OiiiMissingDependeeException, Exception, OiisVarSettingException, OiipgClusterException {
    }

    public void doOperation() throws OiicInstallAddOnException {
        String oracleHome = (String)m_oContext.getVarValue("ORACLE_HOME");
        String compositeHome = (String)m_oContext.getVarValue("COMPOSITE_HOME");
        String oracleHomeName = (String)m_oContext.getVarValue("ORACLE_HOME_NAME");
        String addOnLoc = System.getProperty("oracle.installer.addonLoc");
        String dependeeHome = (String)m_oContext.getVarValue("DEPENDEE_HOME");
        if (dependeeHome != null) {
            UPDATE_HOME_DEPS = true;
        }
        try {
            m_listener.setStatus(0);
            m_listener.setPercentageDone(10L);
            this.unjarPlugin(oracleHome, addOnLoc);
            m_listener.setStatus(1);
            m_listener.setPercentageDone(60L);
        }
        catch (OiicInstallAddOnException oiae) {
            ABORT_ATTACHHOME = true;
            PLUGIN_STATUS = false;
            OiiolTextLogger.appendText(oiae.getMessage());
            OiicExitCode.setExitCode(-1);
        }
        if (!ABORT_ATTACHHOME) {
            this.postCopyOps(oracleHome);
        }
        invSession.endSession();
        if (ABORT_ATTACHHOME) {
            PLUGIN_STATUS = false;
            OiicExitCode.setExitCode(-1);
            String sMsg = OiixResourceBundle.getString("S_INSTALL_ADDONS_PLUGIN_UNJAR_OPERATION_FAILED");
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(sMsg);
        }
        m_listener.setStatus(2);
        m_listener.setPercentageDone(75L);
        this.attachPluginHome(oracleHome, oracleHomeName, compositeHome);
        m_listener.setStatus(3);
        m_listener.setPercentageDone(80L);
        if (UPDATE_HOME_DEPS) {
            m_listener.setStatus(4);
            m_listener.setPercentageDone(90L);
            this.updateHomeDeps(oracleHome, dependeeHome);
            m_listener.setStatus(4);
            m_listener.setPercentageDone(100L);
        } else {
            m_listener.setStatus(4);
            m_listener.setPercentageDone(100L);
        }
        invSession = null;
    }

    public void postCopyOps(String oracleHome) throws OiicInstallAddOnException {
        String postCopyScriptName;
        String addonPropFile = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHome, "inventory"));
        String s_execCmd = "chmod -R ug+rwx ";
        Properties prop = null;
        try {
            prop = this.loadAddonProperties(addonPropFile);
        }
        catch (IOException ioe) {
            prop = null;
        }
        if (prop != null && (postCopyScriptName = prop.getProperty(this.ADDON_PROP)) != null && postCopyScriptName.length() != 0) {
            postCopyScriptName = OiixPathOps.getNativeForm(OiixPathOps.concatPath(oracleHome, postCopyScriptName));
            s_execCmd = s_execCmd + postCopyScriptName;
            OiiolTextLogger.appendText("Executing: " + postCopyScriptName);
            try {
                if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
                    OiixSpawnOps.spawn(s_execCmd);
                }
                OiixEnvironmentOps.changeDir(oracleHome);
                OiixSpawnOps.spawn(postCopyScriptName);
            }
            catch (OiixSpawnException ose) {
                throw new OiicInstallAddOnException(ose.getMessage());
            }
        }
    }

    public Properties loadAddonProperties(String addonPropLoc) throws IOException {
        Properties retProp = null;
        try {
            if (addonPropLoc != null) {
                retProp = new Properties();
                if (!new File(addonPropLoc + File.separatorChar + this.addOnPropFileName).exists()) {
                    OiiolTextLogger.appendText(OiixResourceBundle.getString("S_INSTALL_POSTCOPY_FILE_MISSING"));
                    return null;
                }
                FileInputStream fis = new FileInputStream(addonPropLoc + File.separatorChar + this.addOnPropFileName);
                retProp.load(fis);
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            retProp = null;
        }
        return retProp;
    }

    public static void main(String[] args) throws OiicInstallAddOnException {
        oInstallAddOn = OiicInstallAddOn.getOiicInstallAddOnInstance();
        oInstallAddOn.main_helper(args);
    }

    @Override
    public void processCommandLine(String[] args) {
        this.processCmdLine(args);
        this.setAdditionalProperties();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unjarPlugin(String oracleHome, String addOnLoc) throws OiicInstallAddOnException {
        if (addOnLoc != null && !addOnLoc.equalsIgnoreCase("")) {
            if (oracleHome != null && !oracleHome.equalsIgnoreCase("")) {
                try {
                    OiiolTextLogger.appendText("Unjarring the addOn " + addOnLoc + " to " + oracleHome);
                    OiixJarOps.extractJar(addOnLoc, oracleHome);
                    return;
                }
                catch (OiicInstallAddOnException ioe) {
                    if (this.isAPIMode()) {
                        OiiolTextLogger.appendText("Plugin:" + ioe.getMessage());
                    } else {
                        OiiolTextLogger.writeToLogAndConsole("Plugin:" + ioe.getMessage());
                    }
                    Object[] args = new String[]{addOnLoc, oracleHome, ioe.getMessage()};
                    PLUGIN_STATUS = false;
                    OiicExitCode.setExitCode(-1);
                    throw new OiicInstallAddOnException(OiixResourceBundle.getString("S_INSTALL_ADDONS_PLUGIN_EXCEPTION", args));
                }
            }
            PLUGIN_STATUS = false;
            String sMsg = OiixResourceBundle.getString("S_INSTALL_ADDONS_ORACLE_HOME_MISSING");
            if (this.isAPIMode()) {
                OiiolTextLogger.appendText(sMsg);
            } else {
                OiiolTextLogger.writeToLogAndConsole(sMsg);
            }
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(sMsg);
        }
        PLUGIN_STATUS = false;
        String sMsg = OiixResourceBundle.getString("S_INSTALL_ADDONS_PLUGIN_JAR_LOCATION_MISSING");
        if (this.isAPIMode()) {
            OiiolTextLogger.appendText(sMsg);
        } else {
            OiiolTextLogger.writeToLogAndConsole(sMsg);
        }
        OiicExitCode.setExitCode(-1);
        throw new OiicInstallAddOnException(sMsg);
    }

    private void attachPluginHome(String oracleHome, String oracleHomeName, String compositeHome) {
        OiicAttachHome oAttachHome = OiicAttachHome.getOiicAttachHomeInstance();
        Vector<String> cmdArgs = new Vector<String>();
        cmdArgs.add(new String("-attachHome "));
        if (this.invPtrLoc != null && !this.invPtrLoc.equalsIgnoreCase("")) {
            cmdArgs.add(new String("-invPtrLoc "));
            cmdArgs.add(new String(this.invPtrLoc));
        }
        cmdArgs.add(new String(" ORACLE_HOME=" + oracleHome));
        cmdArgs.add(new String(" ORACLE_HOME_NAME=" + oracleHomeName));
        if (compositeHome != null && compositeHome.length() != 0) {
            cmdArgs.add(new String(" COMPOSITE_HOME=" + compositeHome));
        }
        OiiolTextLogger.appendText("Command used for attachHome is  " + cmdArgs);
        if (cmdArgs.size() > 0) {
            String[] sampleStringList = new String[cmdArgs.size()];
            String[] cmdStrList = cmdArgs.toArray(sampleStringList);
            oAttachHome.main_helper(cmdStrList);
        }
    }

    private void updateHomeDeps(String oracleHome, String dependeeHome) {
        OiicUpdateHomeDeps oUpdateDepHome = OiicUpdateHomeDeps.getOiicUpdateHomeDepsInstance();
        Vector<String> cmdArgs = new Vector<String>();
        if (this.invPtrLoc != null && !this.invPtrLoc.equalsIgnoreCase("")) {
            cmdArgs.add(new String("-invPtrLoc "));
            cmdArgs.add(new String(this.invPtrLoc));
        }
        if (dependeeHome != null && dependeeHome.length() != 0) {
            cmdArgs.add(" -updateHomeDeps ");
            cmdArgs.add(" HOME_DEPENDENCY_LIST={" + oracleHome + ":" + dependeeHome + "}");
        }
        OiiolTextLogger.appendText("Command used for updateHomeDeps is  " + cmdArgs);
        if (cmdArgs.size() > 0) {
            String[] sampleStringList = new String[cmdArgs.size()];
            String[] cmdStrList = cmdArgs.toArray(sampleStringList);
            oUpdateDepHome.main_helper(cmdStrList);
        }
    }

    public void main_helper(String[] args) throws OiicInstallAddOnException {
        OiixUtilityOps.displayStackTraceInformation(new Throwable());
        System.setProperty("oracle.installer.noGUI", "yes");
        OiicExitCode.setExitCode(0);
        this.processCommandLine(args);
        if (m_oContext == null) {
            m_oContext = new OiicSessionContext(this);
            try {
                m_oContext.setVariables();
            }
            catch (OiifbEndIterateException oeie) {
                PLUGIN_STATUS = false;
                OiicExitCode.setExitCode(-1);
                throw new OiicInstallAddOnException(oeie);
            }
        }
        try {
            m_oContext.setVariables();
        }
        catch (OiifbEndIterateException oeie) {
            PLUGIN_STATUS = false;
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(oeie);
        }
        this.setUpPluginProps();
        try {
            this.setUpLocalCI();
        }
        catch (OiitTargetLockNotAvailableException otae) {
            PLUGIN_STATUS = false;
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(otae);
        }
        catch (IOException io) {
            PLUGIN_STATUS = false;
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(io);
        }
        catch (OiifbEndIterateException oeie) {
            PLUGIN_STATUS = false;
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(oeie);
        }
        catch (OiiiInventoryDoesNotExistException oiee) {
            PLUGIN_STATUS = false;
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(oiee);
        }
        catch (OiisVarSettingException ovse) {
            PLUGIN_STATUS = false;
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(ovse);
        }
        catch (OiifbCancelException oce) {
            PLUGIN_STATUS = false;
            OiicExitCode.setExitCode(-1);
            throw new OiicInstallAddOnException(oce);
        }
        String message = OiixResourceBundle.getString("S_INSTALL_ADDONS_PLUGIN_BEGIN");
        OiiolTextLogger.appendText(message);
        this.doOperation();
    }

    private void setUpLocalCI() throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, OiifbEndIterateException, OiisVarSettingException, OiifbCancelException, OiicInstallAddOnException {
        if (invSession == null) {
            try {
                Object[] arg = new String[]{"ACCESSLEVEL READWRITE"};
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_INSTALL_ADDONS_PLUGIN_INV_SESSION_1"));
                invSession = new OiicStandardInventorySession(this.getLogPrefix(), OiicInstVersion.getVersionString());
                OiiolTextLogger.appendText(OiixResourceBundle.getString("S_INSTALL_ADDONS_PLUGIN_INV_SESSION_1", arg));
                invSession.initSession(1);
            }
            catch (OiiiInventoryDoesNotExistException e) {
                OiiolTextLogger.appendException(e);
                PLUGIN_STATUS = false;
            }
            this.iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
            if (this.iAreaControl == null) {
                throw new OiicInstallAddOnException(OiixResourceBundle.getString("S_INSTALL_ADDONS_INVENTORY_MISSING"));
            }
            m_oContext.setVarValue("INVENTORY_LOCATION", this.iAreaControl.getAreaRoot());
            this.verifyOracleHomeAndName();
            this.m_sInvLocation = this.iAreaControl.getAreaRoot();
            OiicPullSession.createDuplicateStreams(this.m_sInvLocation);
        }
    }

    private static boolean isDuplicateName(String name, String[] homeNames) {
        if (homeNames == null) {
            return false;
        }
        for (int i = 0; i < homeNames.length; ++i) {
            if (!homeNames[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private String getDefaultHomeName() {
        if (this.iAreaControl == null) {
            this.iAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
        }
        OiiiInstallInventory oInventory = this.iAreaControl.getInstallInventory();
        return oInventory.getDefaultHomeName(null);
    }

    private void verifyOracleHomeAndName() throws OiicInstallAddOnException {
        String[] homeNames = null;
        String home = (String)m_oContext.getVarValue("ORACLE_HOME_NAME");
        if (home == null || home.length() == 0) {
            home = this.getDefaultHomeName();
            System.setProperty("ORACLE_HOME_NAME", home);
            try {
                m_oContext.setVarValue("ORACLE_HOME_NAME", home);
            }
            catch (OiisVarSettingException oiisVarSettingException) {
            }
            catch (OiifbCancelException oiifbCancelException) {
                // empty catch block
            }
        }
        try {
            homeNames = OiipgOracleHomes.getAllOracleHomeNames();
        }
        catch (OiilNativeException oiilNativeException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (OiicInstallAddOn.isDuplicateName(home, homeNames)) {
            OiicExitCode.setExitCode(-1);
            PLUGIN_STATUS = false;
            throw new OiicInstallAddOnException(OiixResourceBundle.getString("S_INSTALL_ADDONS_ORACLE_HOME_HOMENAME_EXISTS"));
        }
    }

    private void setUpPluginProps() {
        try {
            String oracleHomeNameFromSys = System.getProperty("ORACLE_HOME_NAME");
            String oracleHomeFromSys = System.getProperty("ORACLE_HOME");
            String dependeeHomeFromSys = System.getProperty("DEPENDEE_HOME");
            String compositeHomeFromSys = System.getProperty("COMPOSITE_HOME");
            if (System.getProperty("ORACLE_HOME_NAME") != null) {
                m_oContext.setVarValue("ORACLE_HOME_NAME", oracleHomeNameFromSys);
            }
            if (System.getProperty("ORACLE_HOME") != null) {
                m_oContext.setVarValue("ORACLE_HOME", oracleHomeFromSys);
            }
            if (System.getProperty("COMPOSITE_HOME") != null) {
                m_oContext.setVarValue("COMPOSITE_HOME", compositeHomeFromSys);
            }
            if (System.getProperty("DEPENDEE_HOME") != null) {
                m_oContext.setVarValue("DEPENDEE_HOME", dependeeHomeFromSys);
            }
            if (dependeeHomeFromSys != null && oracleHomeFromSys != null) {
                String[] strArgArr = new String[]{"{", oracleHomeFromSys, ":", dependeeHomeFromSys + "}"};
                m_oContext.setVarValue("HOME_DEPENDENCY_LIST", strArgArr);
            }
        }
        catch (OiisVarSettingException oiisVarSettingException) {
        }
        catch (OiifbCancelException oiifbCancelException) {
            // empty catch block
        }
    }
}

