/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicAPISessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicCompsWizEngine;
import oracle.sysman.oii.oiic.OiicDepWizEngine;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicGlobalContext;
import oracle.sysman.oii.oiic.OiicGlobalContextReaderWriter;
import oracle.sysman.oii.oiic.OiicIOUIAPISession;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstSHSetupWCCE;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiic.OiicInstallCancelHandler;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstallTimeSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiic.OiicInvSetupWCCE;
import oracle.sysman.oii.oiic.OiicPickSelMethodWCCE;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiic.OiicSessionSettingSaveWCCE;
import oracle.sysman.oii.oiic.OiicSilentInterfaceManager;
import oracle.sysman.oii.oiic.OiicSummaryInformation;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbCondIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbCondWizOperation;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbIRetry;
import oracle.sysman.oii.oiif.oiifb.OiifbLinearIterator;
import oracle.sysman.oii.oiif.oiifb.OiifbSyncObject;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlertHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmDiskChangeHandler;
import oracle.sysman.oii.oiif.oiifm.OiifmIRootShInfo;
import oracle.sysman.oii.oiif.oiifr.OiifrAPIProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwClusterSessionVarWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwInstEndSessionWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwInstExitWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwInvLocWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwInvLocationUnixGroupWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwPubInvCompsSelWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwSHLocWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwSummaryWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwTopLevelSelWCDE;
import oracle.sysman.oii.oiif.oiifw.OiifwValidateDiskSpaceWCCE;
import oracle.sysman.oii.oiif.oiifw.OiifwValidateShipHomeVarsWCCE;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiio.oiiol.OiiolLogger;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiix.OiixProgressListener;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtilityOps;

public class OiicInstallAPISession
extends OiicInstallSession
implements OiicIOUIAPISession {
    private OiicSummaryInformation m_oSummaryInfo;
    private OiifrProgressActionListener m_oInstallProgressListener;
    private OiixProgressListener m_oIntwProgressListener;
    private OiicInstallCancelHandler m_oInstallCnclHandler;
    private OiifmDiskChangeHandler m_oDiskChangeHandler;
    private OiifmIRootShInfo[] m_oRootShList;
    private int INV_LOC_IND = OiicInstallAPISession.getNextIndex(0);
    private int UNIX_GRP_IND = OiicInstallAPISession.getNextIndex();
    private int INV_SETUP_IND = OiicInstallAPISession.getNextIndex();
    private int SH_LOC_IND = OiicInstallAPISession.getNextIndex();
    private int VALIDATE_SHIPHOME_IND = OiicInstallAPISession.getNextIndex();
    private int ACCESS_SETUP_IND = OiicInstallAPISession.getNextIndex();
    private int PICK_SELMTHD_IND = OiicInstallAPISession.getNextIndex();
    private int STG_PICK_COMP_IND = OiicInstallAPISession.getNextIndex();
    private int PUBINV_PICK_COMP_IND = OiicInstallAPISession.getNextIndex();
    private int DEP_ENGINE_IND = OiicInstallAPISession.getNextIndex();
    private int INSTALL_COMP_IND = OiicInstallAPISession.getNextIndex();
    private int MORE_COMP_IND = OiicInstallAPISession.getNextIndex();
    private int EXIT_SESSION_IND = OiicInstallAPISession.getNextIndex();
    private OiifbSyncObject m_syncObj = null;
    private OiicActionsThread m_oActionsThread = null;

    public OiicInstallAPISession(OiicAPIInstaller installer) throws OiifbEndIterateException {
        super(null);
    }

    public OiicInstallAPISession(OiicAPIInstaller installer, boolean silentmode) throws OiifbEndIterateException {
        super(null, silentmode);
    }

    public OiicInstallAPISession(OiicInstaller installer, boolean silentmode) throws OiifbEndIterateException {
        super(installer, silentmode);
    }

    @Override
    public Vector getIterElements() {
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>();
        OiifwInvLocWCCE invLoc = new OiifwInvLocWCCE(this.m_sessionContext, this.UNIX_GRP_IND, this.INV_SETUP_IND);
        OiiolTextLogger.appendText("Adding iterator " + invLoc.getClass().getName());
        iterEls.addElement(invLoc);
        OiifwInvLocationUnixGroupWCDE invLocUnixGrp = new OiifwInvLocationUnixGroupWCDE(this.m_sessionContext, this.INV_SETUP_IND);
        OiiolTextLogger.appendText("Adding iterator " + invLocUnixGrp.getClass().getName());
        iterEls.addElement(invLocUnixGrp);
        OiicInvSetupWCCE setupInv = new OiicInvSetupWCCE(this.m_sessionContext, this.SH_LOC_IND);
        OiiolTextLogger.appendText("Adding iterator " + setupInv.getClass().getName());
        iterEls.addElement(setupInv);
        OiifwSHLocWCDE SHLoc = new OiifwSHLocWCDE(this.m_sessionContext, this.VALIDATE_SHIPHOME_IND);
        OiiolTextLogger.appendText("Adding iterator " + SHLoc.getClass().getName());
        iterEls.addElement(SHLoc);
        OiifwValidateShipHomeVarsWCCE validateSH = new OiifwValidateShipHomeVarsWCCE(this.m_sessionContext, this.ACCESS_SETUP_IND);
        OiiolTextLogger.appendText("Adding iterator " + validateSH.getClass().getName());
        iterEls.addElement(validateSH);
        OiicInstSHSetupWCCE setupAccess = new OiicInstSHSetupWCCE(this.m_sessionContext, this.PICK_SELMTHD_IND);
        OiiolTextLogger.appendText("Adding iterator " + setupAccess.getClass().getName());
        iterEls.addElement(setupAccess);
        OiicPickSelMethodWCCE pickSelMthd = new OiicPickSelMethodWCCE(this, this.STG_PICK_COMP_IND, this.PUBINV_PICK_COMP_IND);
        OiiolTextLogger.appendText("Adding iterator " + pickSelMthd.getClass().getName());
        iterEls.addElement(pickSelMthd);
        OiifwTopLevelSelWCDE selTLComp = new OiifwTopLevelSelWCDE(this.m_sessionContext, this.DEP_ENGINE_IND);
        OiiolTextLogger.appendText("Adding iterator " + selTLComp.getClass().getName());
        iterEls.addElement(selTLComp);
        OiifwPubInvCompsSelWCDE selPIComps = new OiifwPubInvCompsSelWCDE(this.m_sessionContext, this.DEP_ENGINE_IND);
        OiiolTextLogger.appendText("Adding iterator " + selPIComps.getClass().getName());
        iterEls.addElement(selPIComps);
        OiicDepWizEngine depWEngine = new OiicDepWizEngine(this.m_sessionContext, this.INSTALL_COMP_IND);
        OiiolTextLogger.appendText("Adding iterator " + depWEngine.getClass().getName());
        iterEls.addElement(depWEngine);
        OiicAPISelCompsInstall m_selCompsInstall = new OiicAPISelCompsInstall(this, -1, true);
        OiiolTextLogger.appendText("Adding iterator " + m_selCompsInstall.getClass().getName());
        iterEls.addElement(m_selCompsInstall);
        return iterEls;
    }

    public void prepareForInstallOperations() throws OiicInstallAPIException, OiicIllegalStateException {
        try {
            OiiolTextLogger.appendText("Do the iterator execution till Summary");
            this.doOperationsTillSummary();
            this.m_oSummaryInfo = new OiicSummaryInformation(this);
        }
        catch (OiifbEndIterateException e) {
            throw new OiicInstallAPIException(e.getLocalizedMessage());
        }
    }

    @Override
    public String getFromLocation() {
        return super.getFromLocation();
    }

    public void suspend() {
        if (null != this.getActionsPhaseWCDE()) {
            this.getActionsPhaseWCDE().getProgressControl().suspend();
            OiixProgressListener listener = OiicAPISessionInterfaceManager.getInterfaceManager().getProgressListener();
            if (listener instanceof OiifrProgressActionListener) {
                ((OiifrProgressActionListener)listener).onSuspend();
            }
        }
    }

    @Override
    public OiicISession getISession() {
        return this;
    }

    @Override
    public String getEndOfInstallMessages() {
        return super.getEndMsgsText();
    }

    public void resume() {
        if (null != this.getActionsPhaseWCDE()) {
            this.getActionsPhaseWCDE().getProgressControl().resume();
            OiixProgressListener listener = OiicAPISessionInterfaceManager.getInterfaceManager().getProgressListener();
            if (listener instanceof OiifrProgressActionListener) {
                ((OiifrProgressActionListener)listener).onResume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelOperation() {
        OiifwActionsPhaseWCDE m_installStatus = this.getActionsPhaseWCDE();
        if (null != m_installStatus) {
            Object object = m_installStatus.getSynchObject();
            synchronized (object) {
                OiixProgressListener o = OiicSessionInterfaceManager.getInterfaceManager().getProgressListener();
                m_installStatus.setInstallInterrupted(true);
                m_installStatus.setInterruptedException(new OiifbEndIterateException(OiixResourceBundle.getString("S_USER_CANCEL_INS")));
                m_installStatus.setSessionCancelled(true);
                this.setSuccessfullInstallation(false);
                m_installStatus.getProgressControl().confirmCancel(new Boolean(true));
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.m_oInstallCnclHandler = null;
        this.m_oInstallProgressListener = null;
        this.m_oIntwProgressListener = null;
        this.m_syncObj = null;
        this.m_oSummaryInfo = null;
        this.m_oRootShList = null;
        this.m_oDiskChangeHandler = null;
        this.m_oActionsThread = null;
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getHandleToAPIInstaller();
        if (apiInstaller != null) {
            apiInstaller.disposeSession();
        }
    }

    public void doOperation(int iOperation, boolean back) throws OiifbEndIterateException {
        OiiolTextLogger.appendText("Does the pre installation setup");
        this.preInstallSetup(iOperation);
        this.m_syncObj = new OiifbSyncObject();
        this.m_oActionsThread = new OiicActionsThread(this);
        this.m_oActionsThread.start();
        if (!this.m_syncObj.signalHappenedBeforeSync()) {
            this.m_syncObj.sync();
        }
        if (null != this.m_oActionsThread && null != this.m_oActionsThread.getException()) {
            throw new OiifbEndIterateException(this.m_oActionsThread.getException());
        }
    }

    @Override
    public OiifrProgressActionListener getInstallProgressListener() {
        return this.m_oInstallProgressListener;
    }

    @Override
    public OiixProgressListener getInterviewProgressListener() {
        return this.m_oIntwProgressListener;
    }

    @Override
    public void setInterviewProgressListener(OiixProgressListener listener) {
        this.m_oIntwProgressListener = listener;
        OiicSessionInterfaceManager.getInterfaceManager().setProgressListener(this.m_oIntwProgressListener);
    }

    @Override
    public void addInstallCancelHandler(OiicInstallCancelHandler oCancelHandler) {
        this.m_oInstallCnclHandler = oCancelHandler;
        ((OiicAPISessionInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager()).setInstallCancelHandler(this.m_oInstallCnclHandler);
    }

    @Override
    public void addDiskChangeHandler(OiifmDiskChangeHandler oDiskHandler) {
        this.m_oDiskChangeHandler = oDiskHandler;
        ((OiicAPISessionInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager()).setDiskChangeHandler(this.m_oDiskChangeHandler);
    }

    @Override
    public void addAlertHandler(OiifmAlertHandler oAlertHandler) {
        ((OiicAPISessionInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager()).setAlertHandler(oAlertHandler);
    }

    @Override
    public void addRetryHandler(OiifbIRetry oRetryHandler) {
        ((OiicAPISessionInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager()).setRetryHandler(oRetryHandler);
    }

    @Override
    public void setInstallProgresListener(OiifrProgressActionListener listener) {
        this.m_oInstallProgressListener = listener;
        OiicSessionInterfaceManager.getInterfaceManager().setProgressListener(this.m_oInstallProgressListener);
    }

    @Override
    public OiicSummaryInformation getSessionSummary() {
        return this.m_oSummaryInfo;
    }

    public void setRootSHInfo(List rootShList) {
        if (null != rootShList && rootShList.size() > 0) {
            int iSize = rootShList.size();
            this.m_oRootShList = new OiifmIRootShInfo[iSize];
            int i = 0;
            Iterator itr = rootShList.iterator();
            while (itr.hasNext()) {
                this.m_oRootShList[i] = (OiifmIRootShInfo)itr.next();
                ++i;
            }
        }
    }

    @Override
    public OiifmIRootShInfo[] getRootShInfo() {
        return this.m_oRootShList;
    }

    private void doInstallAction(boolean bBack) throws OiifbEndIterateException {
        int retBack = 0;
        boolean bCancelSession = false;
        boolean bIsChainInstall = System.getProperty("oracle.installer.ouiApiChainInstall", "false").equalsIgnoreCase("true");
        if (!bBack) {
            OiicGlobalContext oGlobalContext;
            OiicGlobalContextReaderWriter oGCRW;
            block12: {
                oGCRW = null;
                oGlobalContext = null;
                if (this.isInstallMode() && bIsChainInstall) {
                    String sReadXMLPath;
                    oGCRW = OiicGlobalContextReaderWriter.getGlobalContextReaderWriter("oracle.sysman.oii.oiic.OiicGlobalContextXMLReaderWriter");
                    oGlobalContext = OiicGlobalContext.getGlobalContext();
                    if (oGlobalContext.getKey(0) == null && (sReadXMLPath = System.getProperty("oracle.installer.globalcontextxml")) != null) {
                        OiiolTextLogger.appendText("Reading the global context file");
                        oGCRW.readGlobalContextFile(oGlobalContext, sReadXMLPath);
                    }
                }
                try {
                    this.m_iter = new OiifbCondIterator(this.getIterElementsForInstall(), bBack);
                    retBack = this.m_iter.iterate(bBack);
                }
                catch (OiifbEndIterateException e) {
                    OiiolTextLogger.appendText(e.getMessage());
                    Exception tmpE = e.getException();
                    if (OiicExitCode.getExitCode() == -3 || OiicExitCode.getExitCode() == -2 || OiicExitCode.getExitCode() == -4 || OiicExitCode.getExitCode() == -5) {
                        if (OiicExitCode.getExitCode() == -2) {
                            Object[] objs = new String[]{OiiolTextLogger.getErrorLogFileName()};
                            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_SILENT_INSTALL_FAILURE"));
                            OiiolTextLogger.writeMessageToConsole(OiixResourceBundle.getString("S_SILENT_INSTALL_FAILURE"));
                            OiiolTextLogger.writeMessageToConsole(MessageFormat.format(OiixResourceBundle.getString("S_SILENT_INSTALL_DETAILS"), objs));
                        }
                        try {
                            this.onBackIntoLocations();
                            this.unAdviceSessionVariables();
                            this.resetPropertiesOnNextInstall(false);
                            this.resetSession();
                        }
                        catch (Exception ex) {
                            OiiolTextLogger.appendText(ex.getMessage());
                        }
                        throw e;
                    }
                    if (tmpE == null) break block12;
                    if (tmpE instanceof OiifbUserEndException || tmpE instanceof OiifbCancelException) {
                        bCancelSession = true;
                        OiixProgressListener o = OiicSessionInterfaceManager.getInterfaceManager().getProgressListener();
                        if (o instanceof OiifrAPIProgressActionListener) {
                            ((OiifrAPIProgressActionListener)o).onCancel();
                        }
                    }
                    throw e;
                }
            }
            if (!bCancelSession && this.isInstallMode() && retBack == 0 && bIsChainInstall) {
                OiiolTextLogger.appendText("Updating the global context");
                OiisVariable oOHNameVar = this.getSessionContext().getVariable("ORACLE_HOME_NAME");
                String sOHName = (String)oOHNameVar.getValue();
                OiiiCompInstallID currComp = (OiiiCompInstallID)this.getSessionContext().getVarValue("ToplevelComp");
                oGlobalContext.addLWVariableOwner(sOHName, currComp.getName(), this.getSessionContext());
                String sFirstKey = oGlobalContext.getKey(0);
                String sFirstOHLoc = oGlobalContext.getVariableValue(sFirstKey, "ORACLE_HOME");
                oGCRW.writeGlobalContextFile(oGlobalContext, sFirstOHLoc);
            }
        }
    }

    private void doOperationsTillSummary() throws OiifbEndIterateException {
        this.doOperation(false);
    }

    private void preInstallSetup(int iOperation) {
        boolean bAnyOperationSet = false;
        System.setProperty("oracle.installer.noLink", "true");
        System.setProperty("oracle.installer.noSetup", "true");
        if ((iOperation & 1) == 1) {
            bAnyOperationSet = true;
        }
        if ((iOperation & 2) == 2) {
            System.setProperty("oracle.installer.noLink", "false");
            bAnyOperationSet = true;
            OiiolTextLogger.appendText("Setting the property oracle.installer.noLink to false");
        }
        if ((iOperation & 4) == 4) {
            System.setProperty("oracle.installer.noSetup", "false");
            bAnyOperationSet = true;
            OiiolTextLogger.appendText("Setting the property oracle.installer.noSetup to false");
        }
        if (!bAnyOperationSet) {
            OiiolTextLogger.appendText("None of the operational options is specified. \nAssuming it as COPY|LINK|SETUP so setting oracle.installer.[noCopy,noLink,noSetup] to false");
            System.setProperty("oracle.installer.noLink", "false");
            System.setProperty("oracle.installer.noSetup", "false");
        }
    }

    private Vector getIterElementsForInstall() {
        Vector<OiifbWizOperation> iterEls = new Vector<OiifbWizOperation>();
        OiicAPISelCompsInstall m_selCompsInstall = new OiicAPISelCompsInstall(this, 1, false);
        OiiolTextLogger.appendText("Adding the iterator " + m_selCompsInstall.getClass().getName());
        iterEls.addElement(m_selCompsInstall);
        OiifwInstExitWCDE instExit = new OiifwInstExitWCDE(this.m_sessionContext);
        OiiolTextLogger.appendText("Adding the iterator " + instExit.getClass().getName());
        iterEls.addElement(instExit);
        return iterEls;
    }

    private void resetPropertiesOnNextInstall(boolean bResetLogs) {
        Properties props = System.getProperties();
        props.put("oracle.installer.timestamp", OiixUtilityOps.getTimeStamp());
        props.put("oracle.installer.welcome", "false");
        if (bResetLogs) {
            OiiolLogger.resetLoggers();
        }
        OiicAPIInstaller.getAPIInstallerInstance().resetCommandLineArgsTable();
    }

    private void resetSession() {
        OiicSessionInterfaceManager osim = OiicSessionInterfaceManager.getInterfaceManager();
        osim.initialize();
    }

    private void unAdviceSessionVariables() {
        OiicSessionContext ctx = this.getSessionContext();
        ArrayList<String> oListOfSessionVarsToBeUnAdviced = new ArrayList<String>();
        oListOfSessionVarsToBeUnAdviced.add("FROM_LOCATION");
        oListOfSessionVarsToBeUnAdviced.add("ORACLE_HOME_NAME");
        oListOfSessionVarsToBeUnAdviced.add("ORACLE_HOME");
        int iSize = oListOfSessionVarsToBeUnAdviced.size();
        for (int i = 0; i < iSize; ++i) {
            OiisVariable oVar = ctx.getVariable((String)oListOfSessionVarsToBeUnAdviced.get(i));
            if (oVar == null) continue;
            oVar.setAdvice(false);
        }
    }

    class OiicAPISelCompsInstall
    implements OiifbCondWizOperation {
        private OiicInstallSession m_instSession = null;
        private OiifbLinearIterator m_preStateChangeIter = null;
        private OiifbLinearIterator m_stateChangeIter = null;
        private OiifbLinearIterator m_postInstallIter = null;
        private int m_nextInd = -1;
        private boolean m_bTillSummary = false;

        public OiicAPISelCompsInstall(OiicInstallSession instSession, int nextInd, boolean bTillSummary) {
            this.m_instSession = instSession;
            this.m_nextInd = nextInd;
            this.m_bTillSummary = bTillSummary;
        }

        public OiicInstallSession getInstSession() {
            return this.m_instSession;
        }

        @Override
        public void initialize() throws OiifbEndIterateException {
            this.m_preStateChangeIter = new OiifbLinearIterator(false);
            this.m_stateChangeIter = new OiifbLinearIterator(true);
            this.m_postInstallIter = new OiifbLinearIterator(true);
            if (this.m_bTillSummary) {
                this.addPreStateChangeEls(this.m_preStateChangeIter);
            }
        }

        @Override
        public int doOperation(boolean back) throws OiifbEndIterateException {
            if (back) {
                return 0;
            }
            if (this.m_preStateChangeIter.iterate(back) == 1) {
                return 1;
            }
            this.m_preStateChangeIter.dispose();
            if (this.m_bTillSummary) {
                return 0;
            }
            if (OiicPullSession.isSilentMode()) {
                OiicSilentInterfaceManager osim = (OiicSilentInterfaceManager)OiicSessionInterfaceManager.getInterfaceManager();
                if (Boolean.getBoolean("oracle.installer.showVariables")) {
                    osim.logVarDetails();
                }
            }
            this.addStateChangeEls(this.m_stateChangeIter);
            this.m_stateChangeIter.iterate(back);
            this.m_stateChangeIter.dispose();
            this.getInstSession().saveEndOfInstallMessages();
            this.addPostInstallEls(this.m_postInstallIter);
            return this.m_postInstallIter.iterate(back);
        }

        private void addPreStateChangeEls(OiifbLinearIterator iter) {
            OiicSessionContext sessionContext = this.m_instSession.getSessionContext();
            OiicCompsWizEngine compsEngine = new OiicCompsWizEngine(this.m_instSession);
            OiiolTextLogger.appendText("Adding iterator " + compsEngine.getClass().getName());
            iter.addElement(compsEngine);
            OiifwClusterSessionVarWCCE clusterSessionVar = new OiifwClusterSessionVarWCCE(sessionContext);
            OiiolTextLogger.appendText("Adding iterator " + compsEngine.getClass().getName());
            iter.addElement(clusterSessionVar);
            OiicSessionSettingSaveWCCE savSettings = new OiicSessionSettingSaveWCCE(sessionContext);
            OiiolTextLogger.appendText("Adding iterator " + savSettings.getClass().getName());
            iter.addElement(savSettings);
            OiifwSummaryWCDE summary = new OiifwSummaryWCDE(sessionContext);
            OiiolTextLogger.appendText("Adding iterator " + summary.getClass().getName());
            iter.addElement(summary);
            OiifwValidateDiskSpaceWCCE vds = new OiifwValidateDiskSpaceWCCE(sessionContext);
            OiiolTextLogger.appendText("Adding iterator " + vds.getClass().getName());
            iter.addElement(vds);
        }

        private void addStateChangeEls(OiifbLinearIterator iter) {
            OiifwActionsPhaseWCDE actionsPhase = new OiifwActionsPhaseWCDE(this.m_instSession);
            this.m_instSession.setActionsPhaseWCDE(actionsPhase);
            OiiolTextLogger.appendText("Adding iterator " + actionsPhase.getClass().getName());
            iter.addElement(actionsPhase);
        }

        private void addPostInstallEls(OiifbLinearIterator iter) {
            boolean isGenSilentLogs;
            OiifbWizOperation wizOp = OiicInstallAPISession.this.getPgActionsPhase().getPrivelegedOps();
            if (wizOp != null) {
                OiiolTextLogger.appendText("Adding iterator " + wizOp.getClass().getName());
                iter.addElement(wizOp);
            }
            if (isGenSilentLogs = System.getProperty("oracle.installer.silentLogs", "false").equalsIgnoreCase("true")) {
                iter.addElement(new OiifwInstEndSessionWCDE(this.getInstSession().getContext(), null, null, null, false));
            }
        }

        @Override
        public void dispose() {
            if (this.m_preStateChangeIter != null) {
                this.m_preStateChangeIter.dispose();
                this.m_preStateChangeIter = null;
            }
            if (this.m_stateChangeIter != null) {
                this.m_stateChangeIter.dispose();
                this.m_stateChangeIter = null;
            }
            if (this.m_postInstallIter != null) {
                this.m_postInstallIter.dispose();
                this.m_postInstallIter = null;
            }
            this.m_instSession = null;
        }

        void disposePreStateObjects() {
            if (this.m_preStateChangeIter != null) {
                this.m_preStateChangeIter.dispose();
                this.m_preStateChangeIter = null;
            }
            OiicSessionInterfaceManager.getInterfaceManager().disposePreStateChangeElements();
        }

        public void finalize() {
            this.dispose();
        }

        @Override
        public String getName() {
            return this.getClass().getName();
        }

        @Override
        public int getNext() {
            return this.m_nextInd;
        }
    }

    private class OiicActionsThread
    extends Thread {
        OiicInstallTimeSession m_session;
        OiicSessionInterfaceManager interfaceManager;
        Exception installException;

        public OiicActionsThread(OiicInstallAPISession session) {
            super("Install API Thread");
            this.interfaceManager = null;
            this.installException = null;
            this.m_session = session;
        }

        public Exception getException() {
            return this.installException;
        }

        @Override
        public void run() {
            try {
                OiicInstallAPISession.this.doInstallAction(false);
            }
            catch (OiifbEndIterateException e) {
                this.installException = e;
            }
            if (OiicInstallAPISession.this.m_syncObj != null) {
                OiicInstallAPISession.this.m_syncObj.signal();
            }
        }
    }
}

