/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.util.ResourceBundle;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiicInstVersion {
    private static OiiiVersion s_oInstVersion = null;
    private static OiiiVersion s_oDeInstVersion = null;
    private static OiiiVersion s_oInvMinInstVersion = null;
    private static String s_sReleaseLevel = null;
    private static OiiiVersion s_oCompatibleInstVer = null;
    private static String s_oVersionString;
    private static String s_sOuiVersionForOuica;
    private static OiiiVersion s_oOuiConfigVariablesVersion;
    private static String s_sCopyrightCurrentYear;

    public static final OiiiVersion getInstallerVersion() {
        if (s_oInstVersion == null) {
            OiicInstVersion.loadVersion();
        }
        return s_oInstVersion;
    }

    public static final OiiiVersion getInstallerVersionForDeInstall() {
        if (s_oDeInstVersion == null) {
            OiicInstVersion.loadVersion();
        }
        return s_oDeInstVersion;
    }

    public static final String getReleaseLevel() {
        if (s_sReleaseLevel == null) {
            OiicInstVersion.loadVersion();
        }
        return s_sReleaseLevel;
    }

    public static final String getCopyrightCurrentYear() {
        if (s_sCopyrightCurrentYear == null) {
            OiicInstVersion.loadVersion();
        }
        return s_sCopyrightCurrentYear;
    }

    public static final OiiiVersion getInventoryMinInstVersion() {
        if (s_oInvMinInstVersion == null) {
            OiicInstVersion.loadVersion();
        }
        return s_oInvMinInstVersion;
    }

    public static OiiiVersion getCompatibleInstallerVersion() {
        if (s_oCompatibleInstVer == null) {
            OiicInstVersion.loadVersion();
        }
        return s_oCompatibleInstVer;
    }

    private static void loadVersion() {
        ResourceBundle oResBundle = ResourceBundle.getBundle("OUIVersion");
        s_oInstVersion = new OiiiVersion(oResBundle.getString("INSTALLER_VERSION"));
        s_oDeInstVersion = new OiiiVersion(oResBundle.getString("MIN_INSTALLER_VERSION_FOR_DEINSTALL"));
        s_oInvMinInstVersion = new OiiiVersion(oResBundle.getString("INVENTORY_MIN_OUI_VERSION"));
        s_oCompatibleInstVer = new OiiiVersion(oResBundle.getString("COMPATIBLE_OUI_VERSION"));
        s_sReleaseLevel = oResBundle.getString("RELEASE_LEVEL");
        s_sOuiVersionForOuica = oResBundle.getString("OUI_VERSION_FOR_OUICA");
        s_oOuiConfigVariablesVersion = new OiiiVersion(oResBundle.getString("OUI_CONFIG_VARIABLES_VERSION"));
        s_sCopyrightCurrentYear = oResBundle.getString("COPYRIGHT_CURRENT_YEAR");
    }

    public static String getVersionString() {
        if (s_oVersionString != null) {
            return s_oVersionString;
        }
        String sRelLevel = OiicInstVersion.getReleaseLevel();
        Object[] arr = new String[]{OiicInstVersion.getInstallerVersion().toString(), ""};
        String vstring = OiixResourceBundle.getString("S_OUI_VERSION");
        arr[1] = OiixResourceBundle.getString("S_RLEVEL_" + sRelLevel);
        s_oVersionString = OiixResourceBundle.getString(vstring, arr);
        return s_oVersionString;
    }

    public static String getOUIVersionForOuica() {
        if (s_sOuiVersionForOuica == null) {
            // empty if block
        }
        return s_sOuiVersionForOuica;
    }

    public static final OiiiVersion getOuiConfigVariablesVersion() {
        if (s_oOuiConfigVariablesVersion == null) {
            OiicInstVersion.loadVersion();
        }
        return s_oOuiConfigVariablesVersion;
    }

    static {
        s_sOuiVersionForOuica = null;
        s_oOuiConfigVariablesVersion = null;
        s_sCopyrightCurrentYear = null;
    }
}

