/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.File;
import java.io.IOException;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbProgressControl;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressActionListener;
import oracle.sysman.oii.oiif.oiifw.OiifwActionsPhaseWCDE;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixInstallUtil;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;

public class OiicInstSaveInvWCCE
implements OiifbWizOperation {
    private OiisVariableOwner m_vo;
    private OiifwActionsPhaseWCDE m_actionsPhaseWCDE;
    private OiicSessionInterfaceManager m_interfaceManager;

    public OiicInstSaveInvWCCE(OiisVariableOwner vo, OiifwActionsPhaseWCDE actionsPhaseWCDE) {
        this.m_vo = vo;
        this.m_actionsPhaseWCDE = actionsPhaseWCDE;
    }

    @Override
    public void initialize() throws OiifbEndIterateException {
        OiicPullSession oSession = this.m_vo.getSession();
        if (oSession != null) {
            try {
                boolean bIsNextSession;
                OiiiInstallInventory instInv;
                OiiiOracleHomeInfo oInfo;
                String progMessage = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_PHASE_INPROGRESS_SAVE_INVENTORY");
                this.m_interfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                OiifrProgressActionListener progressListener = (OiifrProgressActionListener)this.m_interfaceManager.getProgressListener();
                if (progressListener != null) {
                    progressListener.onStartPhase(16);
                    progressListener.setStatus(progMessage);
                }
                OiicSessionContext ctx = oSession.getSessionContext();
                String sOracleHomeLoc = (String)ctx.getVariable("ORACLE_HOME").getValue();
                String invDir = OiixPathOps.concatPath(sOracleHomeLoc, "inventory");
                String sCompsXML = OiixPathOps.concatPath(invDir, "ContentsXML");
                sCompsXML = OiixPathOps.concatPath(sCompsXML, "comps.xml");
                String sBakCompsXML = OiixPathOps.concatPath(invDir, "ContentsXML");
                sBakCompsXML = OiixPathOps.concatPath(sBakCompsXML, "comps.xml.bak");
                String sNewCompsXML = OiixPathOps.concatPath(invDir, "ContentsXML");
                sNewCompsXML = OiixPathOps.concatPath(sNewCompsXML, "comps.new.xml");
                String rootShLoc = (String)ctx.getVarValue("ROOTSH_LOCATION");
                try {
                    if (oSession instanceof OiicInstallSession) {
                        OiiolTextLogger.appendText("OiicSaveInvWCCE:Before saving the inventory. This is a install session.");
                        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
                            OiiolTextLogger.appendText("OiicSaveInvWCCE:Before saving the inventory. The platform is unix.");
                            if (rootShLoc != null && rootShLoc != "") {
                                OiiolTextLogger.appendText("OiicSaveInvWCCE:Before saving the inventory. The root.sh location is " + rootShLoc);
                                if (new File(rootShLoc).exists()) {
                                    OiiolTextLogger.appendText("OiicSaveInvWCCE:Before saving the inventory. The root.sh location exists.");
                                    if (Boolean.getBoolean("oracle.installer.saveInventoryOutsideInstall")) {
                                        File fCompsXML;
                                        OiiolTextLogger.appendText("OiicSaveInvWCCE:Before saving the inventory. The System property 'oracle.installer.saveInventoryOutsideInstall' is set.");
                                        if (sCompsXML != null && sCompsXML != "" && (fCompsXML = new File(sCompsXML)).exists()) {
                                            OiiolTextLogger.appendText("OiicSaveInvWCCE:Before saving the inventory. Copying file '" + sCompsXML + "' to '" + sBakCompsXML + "'.");
                                            OiixFileOps.copyFile(sCompsXML, sBakCompsXML, true);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    OiiolTextLogger.appendException(e);
                }
                OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
                iac.setSaveCloneXMLInfo(true);
                oSession.saveInventoryWithUpdate();
                iac.setSaveCloneXMLInfo(false);
                try {
                    if (oSession instanceof OiicInstallSession) {
                        OiiolTextLogger.appendText("OiicSaveInvWCCE:After saving the inventory. This is an Install session.");
                        if (OiixPlatform.isPlatInGroup(-1, OiixPlatform.getCurrentPlatform())) {
                            OiiolTextLogger.appendText("OiicSaveInvWCCE:After saving the inventory. The platform is unix.");
                            if (rootShLoc != null && rootShLoc != "") {
                                OiiolTextLogger.appendText("OiicSaveInvWCCE:After saving the inventory. The location of root.sh is " + rootShLoc);
                                if (new File(rootShLoc).exists()) {
                                    OiiolTextLogger.appendText("OiicSaveInvWCCE:After saving the inventory. The root.sh location exists");
                                    if (Boolean.getBoolean("oracle.installer.saveInventoryOutsideInstall")) {
                                        File fBakCompsXML;
                                        File fCompsXML;
                                        OiiolTextLogger.appendText("OiicSaveInvWCCE:After saving the inventory. The system property 'oracle.installer.saveInventoryOutsideInstall' is set.");
                                        if (sCompsXML != null && sCompsXML != "" && (fCompsXML = new File(sCompsXML)).exists() && sNewCompsXML != null && sNewCompsXML != "") {
                                            OiiolTextLogger.appendText("OiicSaveInvWCCE:After saving the inventory. Copying the saved " + sCompsXML + " to " + sNewCompsXML);
                                            OiixFileOps.copyFile(sCompsXML, sNewCompsXML, true);
                                        }
                                        if (sBakCompsXML != null && sBakCompsXML != "" && (fBakCompsXML = new File(sBakCompsXML)).exists() && sCompsXML != null && sCompsXML != "") {
                                            OiiolTextLogger.appendText("OiicSaveInvWCCE:After saving the inventory. Copying the backed up " + sBakCompsXML + " to " + sCompsXML);
                                            OiixFileOps.rename(sBakCompsXML, sCompsXML);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    OiiolTextLogger.appendException(e);
                }
                if (OiixInstallUtil.isUnix() && (oInfo = (instInv = iac.getInstallInventory()).getHomeWithLocation(sOracleHomeLoc)) != null) {
                    String sLoc = OiixPathOps.concatPath(sOracleHomeLoc, "inventory");
                    OiixFileOps.changeDirPermissionUnix(sLoc);
                    String scriptLoc = iac.getScriptsLoc(oInfo.getIndex());
                    if (OiixUtil.isFileExists(scriptLoc)) {
                        OiixFileOps.changeDirPermissionUnix(scriptLoc, "0750");
                    }
                }
                String sNextRspFile = (String)ctx.getVariable("NEXT_SESSION_RESPONSE").getValue();
                Boolean nextSessionVarValue = (Boolean)ctx.getVariable("NEXT_SESSION").getValue();
                boolean bNextRspFilePresent = sNextRspFile != null && sNextRspFile.length() > 0;
                boolean bNextSessionFlag = nextSessionVarValue == null ? false : nextSessionVarValue;
                boolean bl = bIsNextSession = bNextSessionFlag && bNextRspFilePresent;
                if (OiixInstallUtil.isAPIMode()) {
                    OiiiInstallInventory instInv2 = iac.getInstallInventory();
                    OiiiOracleHomeInfo oInfo2 = instInv2.getHomeWithLocation(sOracleHomeLoc);
                    iac.getInstallInventory().disposeCompsList(oInfo2.getIndex());
                }
                if (oSession instanceof OiicInstallSession && !bIsNextSession) {
                    ((OiicInstallSession)oSession).releaseReaderLock();
                }
                if (oSession.isSuccessDefaulted()) {
                    oSession.setSuccessfullInstallation(true);
                }
                this.checkInstallInterruption();
                if (progressListener != null) {
                    progressListener.addPercentage(1);
                    progressListener.onDonePhase(16);
                }
            }
            catch (IOException ie) {
                ie.printStackTrace();
                String sMsg = OiixResourceBundle.getString("S_INVENTORY_ERROR");
                if (ie.getMessage() != null) {
                    sMsg = sMsg + ie.getMessage();
                }
                OiifmAlert.displayError(sMsg);
                throw new OiifbEndIterateException(sMsg);
            }
            catch (OiifbCancelException ie) {
                throw new OiifbEndIterateException(ie.getMessage());
            }
            OiiolTextLogger.appendText("SaveInvWCCE JRE files in Scratch :" + OiixFileOps.countFiles(System.getProperties().getProperty("oracle.installer.scratchPath") + "/jre"));
        } else {
            OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
            iac.cleanUpInvDir(false);
        }
    }

    private void checkInstallInterruption() {
        OiifbProgressControl progressControl = this.m_actionsPhaseWCDE.getProgressControl();
        progressControl.canContinue();
    }

    @Override
    public int doOperation(boolean isBack) {
        if (isBack) {
            return 1;
        }
        return 0;
    }

    @Override
    public void dispose() {
    }
}

