/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiic;

import java.io.IOException;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicPullSession;
import oracle.sysman.oii.oiic.OiicSessionInterfaceManager;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiif.oiifb.OiifbUserEndException;
import oracle.sysman.oii.oiif.oiifb.OiifbWizOperation;
import oracle.sysman.oii.oiif.oiifm.OiifmAlert;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiSourceAccess;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisCompLoadingException;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixResourceBundle;

class OiicInstOHSetupWCCE
implements OiifbWizOperation {
    private OiisVariableOwner m_vo = null;
    private Exception m_errorOcc = null;
    private String m_errmsg = null;
    private int m_nextInd = -1;

    public OiicInstOHSetupWCCE(OiisVariableOwner vo, int nextInd) {
        this.m_vo = vo;
        this.m_nextInd = nextInd;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialize() {
        OiiolTextLogger.appendText(OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "S_TL_INSTACCESSSETUPWCCE_OH_INITIALIZE"));
        this.m_errorOcc = null;
        this.m_errmsg = null;
        String sErrorCode = null;
        try {
            OiicPullSession pSession = this.m_vo.getSession();
            pSession.setupOHAccessObjects();
        }
        catch (IOException e1) {
            this.m_errmsg = e1.getMessage();
            this.m_errorOcc = e1;
        }
        catch (ClassNotFoundException e2) {
            this.m_errmsg = e2.getMessage();
            this.m_errorOcc = e2;
            sErrorCode = "OUI-22003";
        }
        catch (OiisCompLoadingException e3) {
            this.m_errmsg = e3.getMessage();
            this.m_errorOcc = e3;
            sErrorCode = "OUI-22003";
        }
        catch (OiitTargetLockNotAvailableException e4) {
            this.m_errmsg = e4.getMessage();
            this.m_errorOcc = e4;
        }
        catch (Exception e) {
            this.m_errmsg = e.getMessage();
            this.m_errorOcc = e;
            sErrorCode = "OUI-22003";
        }
        if (this.m_errorOcc != null) {
            if (sErrorCode != null) {
                OiiolTextLogger.appendException(this.m_errorOcc);
                String sErrMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", sErrorCode);
                this.m_errmsg = this.m_errmsg != null && this.m_errmsg.length() > 0 ? sErrMsg + " (" + this.m_errmsg + ")" : sErrMsg;
            }
            if (this.m_errmsg != null && this.m_errmsg.length() > 0) {
                OiifmAlert.displayError(this.m_errmsg);
            }
        }
    }

    @Override
    public int doOperation(boolean isBack) throws OiifbEndIterateException {
        OiiolTextLogger.appendText(OiixResourceBundle.getString("S_TL_INSTACCESSSETUPWCCE_OH_DOOPERATION"));
        if (isBack) {
            return 1;
        }
        if (this.m_errorOcc == null && OiicPullSession.isLangAddonMode() && !this.isTLCIntersectionNonEmpty()) {
            String sMsg = OiixResourceBundle.getString("oracle.sysman.oii.oiir.OiirRuntimeRes", "OUI-25038");
            OiifmAlert.displayError(sMsg, OiixResourceBundle.getString("S_ERROR"), "OUI-25038");
            this.m_errorOcc = new Exception();
            this.m_errmsg = sMsg;
        }
        OiicPullSession pSession = this.m_vo.getSession();
        if (this.m_errorOcc != null) {
            if (pSession.isSilentMode() || pSession.isSuppressedSource()) {
                throw new OiifbEndIterateException(this.m_errmsg);
            }
            if (System.getProperty("oracle.installer.exitOnVarValidationFailure", "false").equals("true")) {
                OiicExitCode.setExitCode(-2);
                OiicSessionInterfaceManager sSessionInterfaceManager = OiicSessionInterfaceManager.getInterfaceManager();
                if (sSessionInterfaceManager != null) {
                    sSessionInterfaceManager.dispose();
                }
                throw new OiifbEndIterateException(new OiifbUserEndException(this.m_errmsg));
            }
        }
        if (pSession.isInstallMode()) {
            OiiodDepEngine oDepEngine = pSession.getDepEngine();
            try {
                oDepEngine.depBuild();
            }
            catch (OiiodDepException exp) {
                throw new OiifbEndIterateException(exp);
            }
        }
        return this.m_errorOcc != null ? 1 : 0;
    }

    private boolean isTLCIntersectionNonEmpty() {
        OiicPullSession pSession = this.m_vo.getSession();
        OiiiInstallAreaControl iac = pSession.getInstallAreaControl();
        OiiiSourceAccess srcAccess = pSession.getSourceAccess();
        OiiiStageInventory osi = srcAccess.getStageInventory();
        Vector stageTLCVector = osi.getTopLevelComps(0);
        OiiiInstallInventory oInventory = iac.getInstallInventory();
        Vector oHTLCVector = oInventory.getTopLevelComps(this.getHomeIndex());
        Vector tlcIntersectionVector = stageTLCVector;
        tlcIntersectionVector.retainAll(oHTLCVector);
        return tlcIntersectionVector.size() > 0;
    }

    private int getHomeIndex() {
        int homeIndex = -1;
        OiisVariable oHomeNameVar = this.m_vo.getVariable("ORACLE_HOME_NAME");
        OiisVariable oHomeLocVar = this.m_vo.getVariable("ORACLE_HOME");
        String sLoc = (String)oHomeLocVar.getValue();
        String sName = (String)oHomeNameVar.getValue();
        OiiiInstallAreaControl oAreaControl = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory oInventory = oAreaControl.getInstallInventory();
        if (null != oInventory) {
            Vector vHomes = oInventory.getHomes();
            int nHomeCount = vHomes != null ? vHomes.size() : 0;
            for (int i = 0; i < nHomeCount; ++i) {
                OiiiOracleHomeInfo oInfo = (OiiiOracleHomeInfo)vHomes.get(i);
                String sHomeName = oInfo.getName();
                boolean bSameHomeName = sHomeName.equalsIgnoreCase(sName);
                if (!bSameHomeName) continue;
                homeIndex = oInfo.getIndex();
                break;
            }
        }
        return homeIndex;
    }

    public int getNext() {
        return this.m_nextInd;
    }
}

